Imports System
Imports System.Management
Imports System.IO.ports

Public Class MD2xp

    'MD2xp - MD2 Dual Stepper Motor System for Windows XP.
    'Created using Micrsoft Visual Basic .Net Express 2005
    'By Roger Arrick - ArrickRobotics.com
    'See MD2xp.html for Help
    'Programmer: Roger Arrick
    'Revision history: 
    '  9/23/06 - V0.93 shipped up until ??/??/08 when C4 version came out.
    '  1/09    - V2.0.1 shipped a couple this way but had utilities menu turned on by accident
    '  1/29/09 - V2.0.2 turned off utilities menu
    '  4/22/09 - V2.0.3 Sent ESC to C4 to start bootloader in FormC4.vb, tweeked MD2ON with ESC,E,ESC
    '            fixed setting of velocity parameters in sequence.
    '  6/22/09 - V2.0.4 No more ESC during MD2ON to prevent flash trash.
    '            Added SENDC412,34,56 command to sequence
    '  7/10/09 - V2.0.5 Fixed MD2OFF to turn off 2nd motor.
    '            Fixed MD2HOLD in sequence run.

    Inherits System.Windows.Forms.Form

    'Variables.
    Public Vers As String = "V2.0.5"                'Version of this program.
    Public CleanedUp As Boolean = False             'For closing with [X]
    Public SequenceUnsaved As Boolean = False       'Keep track of unsaved sequence.
    Public ParametersUnsaved As Boolean = False
    Public PortAddress(3) As Integer                'Parallel Port addresses
    Public C4Port As New IO.Ports.SerialPort        'For FormC4.

    'Used to read keypress to stop motion
    Private Declare Function GetAsyncKeyState Lib "user32" (ByVal vKey As Long) As Integer



#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents buttonC4 As System.Windows.Forms.Button
    Friend WithEvents GroupBoxSequenceRun As System.Windows.Forms.GroupBox
    Friend WithEvents ButtonSequenceRunSelection As System.Windows.Forms.Button
    Friend WithEvents ButtonSequenceRunFrom As System.Windows.Forms.Button
    Friend WithEvents GroupBoxSequenceFile As System.Windows.Forms.GroupBox
    Friend WithEvents LabelCursor As System.Windows.Forms.Label
    Friend WithEvents LabelCursorLocation As System.Windows.Forms.Label
    Friend WithEvents ButtonHotKeyHelp As System.Windows.Forms.Button
    Friend WithEvents ButtonSequenceHelp As System.Windows.Forms.Button
    Friend WithEvents GroupBoxHelp As System.Windows.Forms.GroupBox
    Friend WithEvents ButtonQuickStart As System.Windows.Forms.Button
    Friend WithEvents GroupBoxQuickRun As System.Windows.Forms.GroupBox
    Friend WithEvents ButtonQuickRun1 As System.Windows.Forms.Button
    Friend WithEvents ButtonQuickRun11 As System.Windows.Forms.Button
    Friend WithEvents ButtonQuickRun10 As System.Windows.Forms.Button
    Friend WithEvents ButtonQuickRun9 As System.Windows.Forms.Button
    Friend WithEvents ButtonQuickRun8 As System.Windows.Forms.Button
    Friend WithEvents ButtonQuickRun7 As System.Windows.Forms.Button
    Friend WithEvents ButtonQuickRun6 As System.Windows.Forms.Button
    Friend WithEvents ButtonQuickRun5 As System.Windows.Forms.Button
    Friend WithEvents ButtonQuickRun4 As System.Windows.Forms.Button
    Friend WithEvents ButtonQuickRun3 As System.Windows.Forms.Button
    Friend WithEvents ButtonQuickRun2 As System.Windows.Forms.Button
    Friend WithEvents ButtonInfo As System.Windows.Forms.Button
    Friend WithEvents ButtonParametersHelp As System.Windows.Forms.Button
    Friend WithEvents ButtonFP As System.Windows.Forms.Button
    Friend WithEvents ButtonExit As System.Windows.Forms.Button
    Friend WithEvents TabParameters As System.Windows.Forms.TabPage
    Friend WithEvents TabIO As System.Windows.Forms.TabPage
    Friend WithEvents TabProgram As System.Windows.Forms.TabPage
    Friend WithEvents Tabs As System.Windows.Forms.TabControl
    Friend WithEvents TabControl As System.Windows.Forms.TabPage
    Friend WithEvents TextBoxSequence As System.Windows.Forms.TextBox
    Friend WithEvents LabelMotor1 As System.Windows.Forms.Label
    Friend WithEvents LabelMotor5 As System.Windows.Forms.Label
    Friend WithEvents LabelMotor4 As System.Windows.Forms.Label
    Friend WithEvents LabelMotor3 As System.Windows.Forms.Label
    Friend WithEvents LabelMotor2 As System.Windows.Forms.Label
    Friend WithEvents LabelMotor6 As System.Windows.Forms.Label
    Friend WithEvents LabelUnitValue As System.Windows.Forms.Label
    Friend WithEvents LabelUnitName As System.Windows.Forms.Label
    Friend WithEvents LabelPosition As System.Windows.Forms.Label
    Friend WithEvents LabelMotorName As System.Windows.Forms.Label
    Friend WithEvents LabelSlope As System.Windows.Forms.Label
    Friend WithEvents LabelMaxSpeed As System.Windows.Forms.Label
    Friend WithEvents LabelMinSpeed As System.Windows.Forms.Label
    Friend WithEvents LabelLimitReverse As System.Windows.Forms.Label
    Friend WithEvents LabelLimitForward As System.Windows.Forms.Label
    Friend WithEvents LabelHomeOffset As System.Windows.Forms.Label
    Friend WithEvents LabelHomeDirection As System.Windows.Forms.Label
    Friend WithEvents LabelBacklash As System.Windows.Forms.Label
    Friend WithEvents TextBoxMotorNameM1 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxUnitValueM1 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxUnitNameM1 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxPositionPM1 As System.Windows.Forms.TextBox
    Friend WithEvents ButtonSaveParameters As System.Windows.Forms.Button
    Friend WithEvents ButtonLoadParameters As System.Windows.Forms.Button
    Friend WithEvents TextBoxBacklashM1 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxSlopeM1 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxMaxSpeedM1 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxMinSpeedM1 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxLimitRM1 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxLimitFM1 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxHomeOffsetM1 As System.Windows.Forms.TextBox
    Friend WithEvents CheckBoxHomeDirM1 As System.Windows.Forms.CheckBox
    Friend WithEvents TextBoxMotorNameM6 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxMotorNameM5 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxMotorNameM4 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxMotorNameM3 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxMotorNameM2 As System.Windows.Forms.TextBox
    Friend WithEvents CheckBoxHold As System.Windows.Forms.CheckBox
    Friend WithEvents GroupBoxMoveType As System.Windows.Forms.GroupBox
    Friend WithEvents RadioButtonRelative As System.Windows.Forms.RadioButton
    Friend WithEvents RadioButtonAbsolute As System.Windows.Forms.RadioButton
    Friend WithEvents RadioButtonDouble As System.Windows.Forms.RadioButton
    Friend WithEvents GroupBoxStepType As System.Windows.Forms.GroupBox
    Friend WithEvents RadioButtonSingle As System.Windows.Forms.RadioButton
    Friend WithEvents RadioButtonHalf As System.Windows.Forms.RadioButton
    Friend WithEvents CheckBoxHomeDirM6 As System.Windows.Forms.CheckBox
    Friend WithEvents TextBoxBacklashM6 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxSlopeM6 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxMaxSpeedM6 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxMinSpeedM6 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxLimitRM6 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxLimitFM6 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxHomeOffsetM6 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxUnitValueM6 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxUnitNameM6 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxPositionPM6 As System.Windows.Forms.TextBox
    Friend WithEvents CheckBoxHomeDirM5 As System.Windows.Forms.CheckBox
    Friend WithEvents TextBoxBacklashM5 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxSlopeM5 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxMaxSpeedM5 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxMinSpeedM5 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxLimitRM5 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxLimitFM5 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxHomeOffsetM5 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxUnitValueM5 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxUnitNameM5 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxPositionPM5 As System.Windows.Forms.TextBox
    Friend WithEvents CheckBoxHomeDirM4 As System.Windows.Forms.CheckBox
    Friend WithEvents TextBoxBacklashM4 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxSlopeM4 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxMaxSpeedM4 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxMinSpeedM4 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxLimitRM4 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxLimitFM4 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxHomeOffsetM4 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxUnitValueM4 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxUnitNameM4 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxPositionPM4 As System.Windows.Forms.TextBox
    Friend WithEvents CheckBoxHomeDirM3 As System.Windows.Forms.CheckBox
    Friend WithEvents TextBoxBacklashM3 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxSlopeM3 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxMaxSpeedM3 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxMinSpeedM3 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxLimitRM3 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxLimitFM3 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxHomeOffsetM3 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxUnitValueM3 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxUnitNameM3 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxPositionPM3 As System.Windows.Forms.TextBox
    Friend WithEvents CheckBoxHomeDirM2 As System.Windows.Forms.CheckBox
    Friend WithEvents TextBoxBacklashM2 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxSlopeM2 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxMaxSpeedM2 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxMinSpeedM2 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxLimitRM2 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxLimitFM2 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxHomeOffsetM2 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxUnitValueM2 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxUnitNameM2 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxPositionPM2 As System.Windows.Forms.TextBox
    Friend WithEvents LabelPortAddress As System.Windows.Forms.Label
    Friend WithEvents GroupBoxMoveMotors As System.Windows.Forms.GroupBox
    Friend WithEvents LabelNameDisplayM1 As System.Windows.Forms.Label
    Friend WithEvents LabelPositions As System.Windows.Forms.Label
    Friend WithEvents LabelUnits As System.Windows.Forms.Label
    Friend WithEvents LabelDistance As System.Windows.Forms.Label
    Friend WithEvents LabelNameDisplayM4 As System.Windows.Forms.Label
    Friend WithEvents LabelNameDisplayM3 As System.Windows.Forms.Label
    Friend WithEvents LabelNameDisplayM2 As System.Windows.Forms.Label
    Friend WithEvents TextBoxPositionM4 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxPositionM3 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxPositionM2 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxPositionM1 As System.Windows.Forms.TextBox
    Friend WithEvents LabelUnitsDisplayM4 As System.Windows.Forms.Label
    Friend WithEvents LabelUnitsDisplayM3 As System.Windows.Forms.Label
    Friend WithEvents LabelUnitsDisplayM2 As System.Windows.Forms.Label
    Friend WithEvents LabelUnitsDisplayM1 As System.Windows.Forms.Label
    Friend WithEvents TextBoxDistanceM4 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxDistanceM3 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxDistanceM2 As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxDistanceM1 As System.Windows.Forms.TextBox
    Friend WithEvents LabelHome As System.Windows.Forms.Label
    Friend WithEvents LabelForward As System.Windows.Forms.Label
    Friend WithEvents LabelReverse As System.Windows.Forms.Label
    Friend WithEvents ButtonReverseM1 As System.Windows.Forms.Button
    Friend WithEvents ButtonHomeM1 As System.Windows.Forms.Button
    Friend WithEvents ButtonForwardM4 As System.Windows.Forms.Button
    Friend WithEvents ButtonForwardM3 As System.Windows.Forms.Button
    Friend WithEvents ButtonForwardM2 As System.Windows.Forms.Button
    Friend WithEvents ButtonReverseM4 As System.Windows.Forms.Button
    Friend WithEvents ButtonReverseM3 As System.Windows.Forms.Button
    Friend WithEvents ButtonReverseM2 As System.Windows.Forms.Button
    Friend WithEvents ButtonHomeM4 As System.Windows.Forms.Button
    Friend WithEvents ButtonHomeM3 As System.Windows.Forms.Button
    Friend WithEvents ButtonHomeM2 As System.Windows.Forms.Button
    Friend WithEvents ButtonForwardM1 As System.Windows.Forms.Button
    Friend WithEvents LabelMotorNumberM4 As System.Windows.Forms.Label
    Friend WithEvents LabelMotorNumberM3 As System.Windows.Forms.Label
    Friend WithEvents LabelMotorNumberM2 As System.Windows.Forms.Label
    Friend WithEvents LabelMotorNumberM1 As System.Windows.Forms.Label
    Friend WithEvents OpenFileDialog1 As System.Windows.Forms.OpenFileDialog
    Friend WithEvents LabelParameterFile As System.Windows.Forms.Label
    Friend WithEvents SaveFileDialog1 As System.Windows.Forms.SaveFileDialog
    Friend WithEvents LabelOutputs As System.Windows.Forms.Label
    Friend WithEvents CheckBoxOut12 As System.Windows.Forms.CheckBox
    Friend WithEvents CheckBoxOut11 As System.Windows.Forms.CheckBox
    Friend WithEvents CheckBoxOut21 As System.Windows.Forms.CheckBox
    Friend WithEvents CheckBoxOut22 As System.Windows.Forms.CheckBox
    Friend WithEvents CheckBoxEnabled12 As System.Windows.Forms.CheckBox
    Friend WithEvents CheckBoxEnabled34 As System.Windows.Forms.CheckBox
    Friend WithEvents LabelStatus As System.Windows.Forms.Label
    Friend WithEvents CheckBoxEnabled56 As System.Windows.Forms.CheckBox
    Friend WithEvents CheckBoxOut32 As System.Windows.Forms.CheckBox
    Friend WithEvents CheckBoxOut31 As System.Windows.Forms.CheckBox
    Friend WithEvents ButtonHomeM5 As System.Windows.Forms.Button
    Friend WithEvents LabelMotorNumberM6 As System.Windows.Forms.Label
    Friend WithEvents LabelNameDisplayM5 As System.Windows.Forms.Label
    Friend WithEvents LabelMotorNumberM5 As System.Windows.Forms.Label
    Friend WithEvents LabelNameDisplayM6 As System.Windows.Forms.Label
    Friend WithEvents ButtonForwardM6 As System.Windows.Forms.Button
    Friend WithEvents TextBoxDistanceM5 As System.Windows.Forms.TextBox
    Friend WithEvents ButtonForwardM5 As System.Windows.Forms.Button
    Friend WithEvents TextBoxDistanceM6 As System.Windows.Forms.TextBox
    Friend WithEvents ButtonReverseM6 As System.Windows.Forms.Button
    Friend WithEvents LabelUnitsDisplayM5 As System.Windows.Forms.Label
    Friend WithEvents TextBoxPositionM6 As System.Windows.Forms.TextBox
    Friend WithEvents ButtonReverseM5 As System.Windows.Forms.Button
    Friend WithEvents TextBoxPositionM5 As System.Windows.Forms.TextBox
    Friend WithEvents LabelUnitsDisplayM6 As System.Windows.Forms.Label
    Friend WithEvents ButtonHomeM6 As System.Windows.Forms.Button
    Friend WithEvents ButtonRunSequence As System.Windows.Forms.Button
    Friend WithEvents ButtonSaveSequence As System.Windows.Forms.Button
    Friend WithEvents ButtonLoadSequence As System.Windows.Forms.Button
    Friend WithEvents GroupBoxMD23 As System.Windows.Forms.GroupBox
    Friend WithEvents LabelInput33 As System.Windows.Forms.Label
    Friend WithEvents LabelInput32 As System.Windows.Forms.Label
    Friend WithEvents LabelInput31 As System.Windows.Forms.Label
    Friend WithEvents GroupBoxMD22 As System.Windows.Forms.GroupBox
    Friend WithEvents LabelInput23 As System.Windows.Forms.Label
    Friend WithEvents LabelInput22 As System.Windows.Forms.Label
    Friend WithEvents LabelInput21 As System.Windows.Forms.Label
    Friend WithEvents GroupBoxMD21 As System.Windows.Forms.GroupBox
    Friend WithEvents LabelInput13 As System.Windows.Forms.Label
    Friend WithEvents LabelInput12 As System.Windows.Forms.Label
    Friend WithEvents LabelInput11 As System.Windows.Forms.Label
    Friend WithEvents TimerIOScan As System.Windows.Forms.Timer
    Friend WithEvents LabelInput15 As System.Windows.Forms.Label
    Friend WithEvents LabelInput14 As System.Windows.Forms.Label
    Friend WithEvents Label24 As System.Windows.Forms.Label
    Friend WithEvents Label23 As System.Windows.Forms.Label
    Friend WithEvents Label22 As System.Windows.Forms.Label
    Friend WithEvents Label21 As System.Windows.Forms.Label
    Friend WithEvents Label20 As System.Windows.Forms.Label
    Friend WithEvents LabelInput35 As System.Windows.Forms.Label
    Friend WithEvents LabelInput34 As System.Windows.Forms.Label
    Friend WithEvents LabelInput25 As System.Windows.Forms.Label
    Friend WithEvents LabelInput24 As System.Windows.Forms.Label
    Friend WithEvents Label30 As System.Windows.Forms.Label
    Friend WithEvents Label31 As System.Windows.Forms.Label
    Friend WithEvents Label32 As System.Windows.Forms.Label
    Friend WithEvents Label33 As System.Windows.Forms.Label
    Friend WithEvents Label34 As System.Windows.Forms.Label
    Friend WithEvents Label25 As System.Windows.Forms.Label
    Friend WithEvents Label26 As System.Windows.Forms.Label
    Friend WithEvents Label27 As System.Windows.Forms.Label
    Friend WithEvents Label28 As System.Windows.Forms.Label
    Friend WithEvents Label29 As System.Windows.Forms.Label
    Friend WithEvents CheckBoxOutput32 As System.Windows.Forms.CheckBox
    Friend WithEvents CheckBoxOutput31 As System.Windows.Forms.CheckBox
    Friend WithEvents CheckBoxOutput22 As System.Windows.Forms.CheckBox
    Friend WithEvents CheckBoxOutput21 As System.Windows.Forms.CheckBox
    Friend WithEvents CheckBoxOutput12 As System.Windows.Forms.CheckBox
    Friend WithEvents CheckBoxOutput11 As System.Windows.Forms.CheckBox
    Friend WithEvents LabelPortMD212 As System.Windows.Forms.Label
    Friend WithEvents LabelPortMD256 As System.Windows.Forms.Label
    Friend WithEvents LabelPortMD234 As System.Windows.Forms.Label
    Friend WithEvents GroupBoxMove1 As System.Windows.Forms.GroupBox
    Friend WithEvents GroupBoxMove3 As System.Windows.Forms.GroupBox
    Friend WithEvents GroupBoxMove2 As System.Windows.Forms.GroupBox
    Friend WithEvents LabelSequenceFile As System.Windows.Forms.Label
    Friend WithEvents GroupBoxMove As System.Windows.Forms.GroupBox
    Friend WithEvents ButtonMoveGrid As System.Windows.Forms.Button
    Friend WithEvents ButtonMoveCircle As System.Windows.Forms.Button
    Friend WithEvents ButtonMoveLine As System.Windows.Forms.Button
    Friend WithEvents CheckBoxStandby56 As System.Windows.Forms.CheckBox
    Friend WithEvents CheckBoxStandby34 As System.Windows.Forms.CheckBox
    Friend WithEvents CheckBoxStandby12 As System.Windows.Forms.CheckBox
    Friend WithEvents ToolTip1 As System.Windows.Forms.ToolTip
    Friend WithEvents TabUtilities As System.Windows.Forms.TabPage
    Friend WithEvents GroupBoxCalibrate As System.Windows.Forms.GroupBox
    Friend WithEvents ButtonTestMove As System.Windows.Forms.Button
    Friend WithEvents ButtonShowCal As System.Windows.Forms.Button
    Friend WithEvents TextBoxUtilities As System.Windows.Forms.TextBox
    Friend WithEvents ButtonTweak As System.Windows.Forms.Button
    Friend WithEvents ButtonSaveAsParameters As System.Windows.Forms.Button
    Friend WithEvents ButtonSaveAsSequence As System.Windows.Forms.Button
    Friend WithEvents CheckBoxTeachMode As System.Windows.Forms.CheckBox
    Friend WithEvents GroupBoxProgram As System.Windows.Forms.GroupBox
    Friend WithEvents ButtonProgramEdit As System.Windows.Forms.Button
    Friend WithEvents ButtonProgramRun As System.Windows.Forms.Button
    Friend WithEvents ButtonIOHelp As System.Windows.Forms.Button
    Friend WithEvents ButtonControlCalibrate As System.Windows.Forms.Button
    Friend WithEvents ButtonControlHelp As System.Windows.Forms.Button
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container
        Dim resources As System.ComponentModel.ComponentResourceManager = New System.ComponentModel.ComponentResourceManager(GetType(MD2xp))
        Me.ButtonExit = New System.Windows.Forms.Button
        Me.Tabs = New System.Windows.Forms.TabControl
        Me.TabControl = New System.Windows.Forms.TabPage
        Me.buttonC4 = New System.Windows.Forms.Button
        Me.GroupBoxHelp = New System.Windows.Forms.GroupBox
        Me.ButtonQuickStart = New System.Windows.Forms.Button
        Me.ButtonControlHelp = New System.Windows.Forms.Button
        Me.ButtonHotKeyHelp = New System.Windows.Forms.Button
        Me.ButtonControlCalibrate = New System.Windows.Forms.Button
        Me.GroupBoxProgram = New System.Windows.Forms.GroupBox
        Me.ButtonProgramEdit = New System.Windows.Forms.Button
        Me.CheckBoxTeachMode = New System.Windows.Forms.CheckBox
        Me.ButtonProgramRun = New System.Windows.Forms.Button
        Me.GroupBoxMove = New System.Windows.Forms.GroupBox
        Me.ButtonMoveGrid = New System.Windows.Forms.Button
        Me.ButtonMoveCircle = New System.Windows.Forms.Button
        Me.ButtonMoveLine = New System.Windows.Forms.Button
        Me.LabelStatus = New System.Windows.Forms.Label
        Me.GroupBoxMoveMotors = New System.Windows.Forms.GroupBox
        Me.GroupBoxMove3 = New System.Windows.Forms.GroupBox
        Me.CheckBoxStandby56 = New System.Windows.Forms.CheckBox
        Me.LabelNameDisplayM5 = New System.Windows.Forms.Label
        Me.ButtonHomeM6 = New System.Windows.Forms.Button
        Me.LabelUnitsDisplayM6 = New System.Windows.Forms.Label
        Me.CheckBoxEnabled56 = New System.Windows.Forms.CheckBox
        Me.TextBoxPositionM5 = New System.Windows.Forms.TextBox
        Me.ButtonReverseM5 = New System.Windows.Forms.Button
        Me.CheckBoxOut32 = New System.Windows.Forms.CheckBox
        Me.TextBoxPositionM6 = New System.Windows.Forms.TextBox
        Me.CheckBoxOut31 = New System.Windows.Forms.CheckBox
        Me.LabelUnitsDisplayM5 = New System.Windows.Forms.Label
        Me.ButtonReverseM6 = New System.Windows.Forms.Button
        Me.ButtonHomeM5 = New System.Windows.Forms.Button
        Me.TextBoxDistanceM6 = New System.Windows.Forms.TextBox
        Me.LabelMotorNumberM6 = New System.Windows.Forms.Label
        Me.ButtonForwardM5 = New System.Windows.Forms.Button
        Me.TextBoxDistanceM5 = New System.Windows.Forms.TextBox
        Me.ButtonForwardM6 = New System.Windows.Forms.Button
        Me.LabelMotorNumberM5 = New System.Windows.Forms.Label
        Me.LabelNameDisplayM6 = New System.Windows.Forms.Label
        Me.GroupBoxMove2 = New System.Windows.Forms.GroupBox
        Me.CheckBoxStandby34 = New System.Windows.Forms.CheckBox
        Me.LabelNameDisplayM3 = New System.Windows.Forms.Label
        Me.ButtonReverseM4 = New System.Windows.Forms.Button
        Me.CheckBoxEnabled34 = New System.Windows.Forms.CheckBox
        Me.ButtonReverseM3 = New System.Windows.Forms.Button
        Me.ButtonHomeM4 = New System.Windows.Forms.Button
        Me.CheckBoxOut22 = New System.Windows.Forms.CheckBox
        Me.ButtonForwardM3 = New System.Windows.Forms.Button
        Me.TextBoxPositionM4 = New System.Windows.Forms.TextBox
        Me.CheckBoxOut21 = New System.Windows.Forms.CheckBox
        Me.ButtonForwardM4 = New System.Windows.Forms.Button
        Me.TextBoxPositionM3 = New System.Windows.Forms.TextBox
        Me.LabelUnitsDisplayM4 = New System.Windows.Forms.Label
        Me.LabelNameDisplayM4 = New System.Windows.Forms.Label
        Me.LabelUnitsDisplayM3 = New System.Windows.Forms.Label
        Me.ButtonHomeM3 = New System.Windows.Forms.Button
        Me.LabelMotorNumberM3 = New System.Windows.Forms.Label
        Me.TextBoxDistanceM4 = New System.Windows.Forms.TextBox
        Me.TextBoxDistanceM3 = New System.Windows.Forms.TextBox
        Me.LabelMotorNumberM4 = New System.Windows.Forms.Label
        Me.GroupBoxMove1 = New System.Windows.Forms.GroupBox
        Me.CheckBoxStandby12 = New System.Windows.Forms.CheckBox
        Me.LabelNameDisplayM1 = New System.Windows.Forms.Label
        Me.CheckBoxEnabled12 = New System.Windows.Forms.CheckBox
        Me.LabelNameDisplayM2 = New System.Windows.Forms.Label
        Me.ButtonForwardM2 = New System.Windows.Forms.Button
        Me.CheckBoxOut12 = New System.Windows.Forms.CheckBox
        Me.ButtonReverseM2 = New System.Windows.Forms.Button
        Me.ButtonForwardM1 = New System.Windows.Forms.Button
        Me.CheckBoxOut11 = New System.Windows.Forms.CheckBox
        Me.TextBoxPositionM2 = New System.Windows.Forms.TextBox
        Me.LabelMotorNumberM1 = New System.Windows.Forms.Label
        Me.ButtonHomeM2 = New System.Windows.Forms.Button
        Me.TextBoxPositionM1 = New System.Windows.Forms.TextBox
        Me.LabelMotorNumberM2 = New System.Windows.Forms.Label
        Me.ButtonHomeM1 = New System.Windows.Forms.Button
        Me.LabelUnitsDisplayM2 = New System.Windows.Forms.Label
        Me.LabelUnitsDisplayM1 = New System.Windows.Forms.Label
        Me.ButtonReverseM1 = New System.Windows.Forms.Button
        Me.TextBoxDistanceM2 = New System.Windows.Forms.TextBox
        Me.TextBoxDistanceM1 = New System.Windows.Forms.TextBox
        Me.LabelOutputs = New System.Windows.Forms.Label
        Me.LabelForward = New System.Windows.Forms.Label
        Me.LabelPositions = New System.Windows.Forms.Label
        Me.LabelReverse = New System.Windows.Forms.Label
        Me.LabelUnits = New System.Windows.Forms.Label
        Me.LabelDistance = New System.Windows.Forms.Label
        Me.LabelHome = New System.Windows.Forms.Label
        Me.TabParameters = New System.Windows.Forms.TabPage
        Me.ButtonParametersHelp = New System.Windows.Forms.Button
        Me.ButtonSaveAsParameters = New System.Windows.Forms.Button
        Me.LabelPortMD256 = New System.Windows.Forms.Label
        Me.LabelPortMD234 = New System.Windows.Forms.Label
        Me.LabelPortMD212 = New System.Windows.Forms.Label
        Me.LabelParameterFile = New System.Windows.Forms.Label
        Me.LabelPortAddress = New System.Windows.Forms.Label
        Me.CheckBoxHomeDirM6 = New System.Windows.Forms.CheckBox
        Me.TextBoxBacklashM6 = New System.Windows.Forms.TextBox
        Me.TextBoxSlopeM6 = New System.Windows.Forms.TextBox
        Me.TextBoxMaxSpeedM6 = New System.Windows.Forms.TextBox
        Me.TextBoxMinSpeedM6 = New System.Windows.Forms.TextBox
        Me.TextBoxLimitRM6 = New System.Windows.Forms.TextBox
        Me.TextBoxLimitFM6 = New System.Windows.Forms.TextBox
        Me.TextBoxHomeOffsetM6 = New System.Windows.Forms.TextBox
        Me.TextBoxUnitValueM6 = New System.Windows.Forms.TextBox
        Me.TextBoxUnitNameM6 = New System.Windows.Forms.TextBox
        Me.TextBoxPositionPM6 = New System.Windows.Forms.TextBox
        Me.CheckBoxHomeDirM5 = New System.Windows.Forms.CheckBox
        Me.TextBoxBacklashM5 = New System.Windows.Forms.TextBox
        Me.TextBoxSlopeM5 = New System.Windows.Forms.TextBox
        Me.TextBoxMaxSpeedM5 = New System.Windows.Forms.TextBox
        Me.TextBoxMinSpeedM5 = New System.Windows.Forms.TextBox
        Me.TextBoxLimitRM5 = New System.Windows.Forms.TextBox
        Me.TextBoxLimitFM5 = New System.Windows.Forms.TextBox
        Me.TextBoxHomeOffsetM5 = New System.Windows.Forms.TextBox
        Me.TextBoxUnitValueM5 = New System.Windows.Forms.TextBox
        Me.TextBoxUnitNameM5 = New System.Windows.Forms.TextBox
        Me.TextBoxPositionPM5 = New System.Windows.Forms.TextBox
        Me.CheckBoxHomeDirM4 = New System.Windows.Forms.CheckBox
        Me.TextBoxBacklashM4 = New System.Windows.Forms.TextBox
        Me.TextBoxSlopeM4 = New System.Windows.Forms.TextBox
        Me.TextBoxMaxSpeedM4 = New System.Windows.Forms.TextBox
        Me.TextBoxMinSpeedM4 = New System.Windows.Forms.TextBox
        Me.TextBoxLimitRM4 = New System.Windows.Forms.TextBox
        Me.TextBoxLimitFM4 = New System.Windows.Forms.TextBox
        Me.TextBoxHomeOffsetM4 = New System.Windows.Forms.TextBox
        Me.TextBoxUnitValueM4 = New System.Windows.Forms.TextBox
        Me.TextBoxUnitNameM4 = New System.Windows.Forms.TextBox
        Me.TextBoxPositionPM4 = New System.Windows.Forms.TextBox
        Me.CheckBoxHomeDirM3 = New System.Windows.Forms.CheckBox
        Me.TextBoxBacklashM3 = New System.Windows.Forms.TextBox
        Me.TextBoxSlopeM3 = New System.Windows.Forms.TextBox
        Me.TextBoxMaxSpeedM3 = New System.Windows.Forms.TextBox
        Me.TextBoxMinSpeedM3 = New System.Windows.Forms.TextBox
        Me.TextBoxLimitRM3 = New System.Windows.Forms.TextBox
        Me.TextBoxLimitFM3 = New System.Windows.Forms.TextBox
        Me.TextBoxHomeOffsetM3 = New System.Windows.Forms.TextBox
        Me.TextBoxUnitValueM3 = New System.Windows.Forms.TextBox
        Me.TextBoxUnitNameM3 = New System.Windows.Forms.TextBox
        Me.TextBoxPositionPM3 = New System.Windows.Forms.TextBox
        Me.CheckBoxHomeDirM2 = New System.Windows.Forms.CheckBox
        Me.TextBoxBacklashM2 = New System.Windows.Forms.TextBox
        Me.TextBoxSlopeM2 = New System.Windows.Forms.TextBox
        Me.TextBoxMaxSpeedM2 = New System.Windows.Forms.TextBox
        Me.TextBoxMinSpeedM2 = New System.Windows.Forms.TextBox
        Me.TextBoxLimitRM2 = New System.Windows.Forms.TextBox
        Me.TextBoxLimitFM2 = New System.Windows.Forms.TextBox
        Me.TextBoxHomeOffsetM2 = New System.Windows.Forms.TextBox
        Me.TextBoxUnitValueM2 = New System.Windows.Forms.TextBox
        Me.TextBoxUnitNameM2 = New System.Windows.Forms.TextBox
        Me.TextBoxPositionPM2 = New System.Windows.Forms.TextBox
        Me.GroupBoxStepType = New System.Windows.Forms.GroupBox
        Me.RadioButtonDouble = New System.Windows.Forms.RadioButton
        Me.RadioButtonSingle = New System.Windows.Forms.RadioButton
        Me.RadioButtonHalf = New System.Windows.Forms.RadioButton
        Me.GroupBoxMoveType = New System.Windows.Forms.GroupBox
        Me.RadioButtonRelative = New System.Windows.Forms.RadioButton
        Me.RadioButtonAbsolute = New System.Windows.Forms.RadioButton
        Me.CheckBoxHold = New System.Windows.Forms.CheckBox
        Me.CheckBoxHomeDirM1 = New System.Windows.Forms.CheckBox
        Me.TextBoxMotorNameM6 = New System.Windows.Forms.TextBox
        Me.TextBoxMotorNameM5 = New System.Windows.Forms.TextBox
        Me.TextBoxMotorNameM4 = New System.Windows.Forms.TextBox
        Me.TextBoxMotorNameM3 = New System.Windows.Forms.TextBox
        Me.TextBoxMotorNameM2 = New System.Windows.Forms.TextBox
        Me.ButtonSaveParameters = New System.Windows.Forms.Button
        Me.ButtonLoadParameters = New System.Windows.Forms.Button
        Me.TextBoxBacklashM1 = New System.Windows.Forms.TextBox
        Me.TextBoxSlopeM1 = New System.Windows.Forms.TextBox
        Me.TextBoxMaxSpeedM1 = New System.Windows.Forms.TextBox
        Me.TextBoxMinSpeedM1 = New System.Windows.Forms.TextBox
        Me.TextBoxLimitRM1 = New System.Windows.Forms.TextBox
        Me.TextBoxLimitFM1 = New System.Windows.Forms.TextBox
        Me.TextBoxHomeOffsetM1 = New System.Windows.Forms.TextBox
        Me.TextBoxUnitValueM1 = New System.Windows.Forms.TextBox
        Me.TextBoxUnitNameM1 = New System.Windows.Forms.TextBox
        Me.TextBoxPositionPM1 = New System.Windows.Forms.TextBox
        Me.TextBoxMotorNameM1 = New System.Windows.Forms.TextBox
        Me.LabelUnitValue = New System.Windows.Forms.Label
        Me.LabelUnitName = New System.Windows.Forms.Label
        Me.LabelPosition = New System.Windows.Forms.Label
        Me.LabelMotorName = New System.Windows.Forms.Label
        Me.LabelSlope = New System.Windows.Forms.Label
        Me.LabelMaxSpeed = New System.Windows.Forms.Label
        Me.LabelMinSpeed = New System.Windows.Forms.Label
        Me.LabelLimitReverse = New System.Windows.Forms.Label
        Me.LabelLimitForward = New System.Windows.Forms.Label
        Me.LabelHomeOffset = New System.Windows.Forms.Label
        Me.LabelHomeDirection = New System.Windows.Forms.Label
        Me.LabelBacklash = New System.Windows.Forms.Label
        Me.LabelMotor6 = New System.Windows.Forms.Label
        Me.LabelMotor5 = New System.Windows.Forms.Label
        Me.LabelMotor4 = New System.Windows.Forms.Label
        Me.LabelMotor3 = New System.Windows.Forms.Label
        Me.LabelMotor2 = New System.Windows.Forms.Label
        Me.LabelMotor1 = New System.Windows.Forms.Label
        Me.TabProgram = New System.Windows.Forms.TabPage
        Me.LabelCursor = New System.Windows.Forms.Label
        Me.GroupBoxSequenceRun = New System.Windows.Forms.GroupBox
        Me.ButtonSequenceRunSelection = New System.Windows.Forms.Button
        Me.ButtonRunSequence = New System.Windows.Forms.Button
        Me.ButtonSequenceRunFrom = New System.Windows.Forms.Button
        Me.GroupBoxSequenceFile = New System.Windows.Forms.GroupBox
        Me.ButtonLoadSequence = New System.Windows.Forms.Button
        Me.ButtonSaveSequence = New System.Windows.Forms.Button
        Me.ButtonSaveAsSequence = New System.Windows.Forms.Button
        Me.ButtonSequenceHelp = New System.Windows.Forms.Button
        Me.LabelCursorLocation = New System.Windows.Forms.Label
        Me.GroupBoxQuickRun = New System.Windows.Forms.GroupBox
        Me.ButtonQuickRun11 = New System.Windows.Forms.Button
        Me.ButtonQuickRun10 = New System.Windows.Forms.Button
        Me.ButtonQuickRun9 = New System.Windows.Forms.Button
        Me.ButtonQuickRun8 = New System.Windows.Forms.Button
        Me.ButtonQuickRun7 = New System.Windows.Forms.Button
        Me.ButtonQuickRun6 = New System.Windows.Forms.Button
        Me.ButtonQuickRun5 = New System.Windows.Forms.Button
        Me.ButtonQuickRun4 = New System.Windows.Forms.Button
        Me.ButtonQuickRun3 = New System.Windows.Forms.Button
        Me.ButtonQuickRun2 = New System.Windows.Forms.Button
        Me.ButtonQuickRun1 = New System.Windows.Forms.Button
        Me.LabelSequenceFile = New System.Windows.Forms.Label
        Me.TextBoxSequence = New System.Windows.Forms.TextBox
        Me.TabIO = New System.Windows.Forms.TabPage
        Me.ButtonIOHelp = New System.Windows.Forms.Button
        Me.GroupBoxMD23 = New System.Windows.Forms.GroupBox
        Me.CheckBoxOutput32 = New System.Windows.Forms.CheckBox
        Me.Label30 = New System.Windows.Forms.Label
        Me.CheckBoxOutput31 = New System.Windows.Forms.CheckBox
        Me.LabelInput35 = New System.Windows.Forms.Label
        Me.Label31 = New System.Windows.Forms.Label
        Me.LabelInput34 = New System.Windows.Forms.Label
        Me.Label32 = New System.Windows.Forms.Label
        Me.LabelInput33 = New System.Windows.Forms.Label
        Me.Label33 = New System.Windows.Forms.Label
        Me.LabelInput32 = New System.Windows.Forms.Label
        Me.Label34 = New System.Windows.Forms.Label
        Me.LabelInput31 = New System.Windows.Forms.Label
        Me.GroupBoxMD22 = New System.Windows.Forms.GroupBox
        Me.CheckBoxOutput22 = New System.Windows.Forms.CheckBox
        Me.Label25 = New System.Windows.Forms.Label
        Me.CheckBoxOutput21 = New System.Windows.Forms.CheckBox
        Me.LabelInput25 = New System.Windows.Forms.Label
        Me.Label26 = New System.Windows.Forms.Label
        Me.LabelInput24 = New System.Windows.Forms.Label
        Me.Label27 = New System.Windows.Forms.Label
        Me.LabelInput23 = New System.Windows.Forms.Label
        Me.Label28 = New System.Windows.Forms.Label
        Me.LabelInput22 = New System.Windows.Forms.Label
        Me.Label29 = New System.Windows.Forms.Label
        Me.LabelInput21 = New System.Windows.Forms.Label
        Me.GroupBoxMD21 = New System.Windows.Forms.GroupBox
        Me.CheckBoxOutput12 = New System.Windows.Forms.CheckBox
        Me.CheckBoxOutput11 = New System.Windows.Forms.CheckBox
        Me.Label24 = New System.Windows.Forms.Label
        Me.Label23 = New System.Windows.Forms.Label
        Me.Label22 = New System.Windows.Forms.Label
        Me.Label21 = New System.Windows.Forms.Label
        Me.Label20 = New System.Windows.Forms.Label
        Me.LabelInput15 = New System.Windows.Forms.Label
        Me.LabelInput14 = New System.Windows.Forms.Label
        Me.LabelInput13 = New System.Windows.Forms.Label
        Me.LabelInput12 = New System.Windows.Forms.Label
        Me.LabelInput11 = New System.Windows.Forms.Label
        Me.TabUtilities = New System.Windows.Forms.TabPage
        Me.ButtonInfo = New System.Windows.Forms.Button
        Me.ButtonFP = New System.Windows.Forms.Button
        Me.GroupBoxCalibrate = New System.Windows.Forms.GroupBox
        Me.ButtonTweak = New System.Windows.Forms.Button
        Me.ButtonTestMove = New System.Windows.Forms.Button
        Me.ButtonShowCal = New System.Windows.Forms.Button
        Me.TextBoxUtilities = New System.Windows.Forms.TextBox
        Me.OpenFileDialog1 = New System.Windows.Forms.OpenFileDialog
        Me.SaveFileDialog1 = New System.Windows.Forms.SaveFileDialog
        Me.TimerIOScan = New System.Windows.Forms.Timer(Me.components)
        Me.ToolTip1 = New System.Windows.Forms.ToolTip(Me.components)
        Me.Tabs.SuspendLayout()
        Me.TabControl.SuspendLayout()
        Me.GroupBoxHelp.SuspendLayout()
        Me.GroupBoxProgram.SuspendLayout()
        Me.GroupBoxMove.SuspendLayout()
        Me.GroupBoxMoveMotors.SuspendLayout()
        Me.GroupBoxMove3.SuspendLayout()
        Me.GroupBoxMove2.SuspendLayout()
        Me.GroupBoxMove1.SuspendLayout()
        Me.TabParameters.SuspendLayout()
        Me.GroupBoxStepType.SuspendLayout()
        Me.GroupBoxMoveType.SuspendLayout()
        Me.TabProgram.SuspendLayout()
        Me.GroupBoxSequenceRun.SuspendLayout()
        Me.GroupBoxSequenceFile.SuspendLayout()
        Me.GroupBoxQuickRun.SuspendLayout()
        Me.TabIO.SuspendLayout()
        Me.GroupBoxMD23.SuspendLayout()
        Me.GroupBoxMD22.SuspendLayout()
        Me.GroupBoxMD21.SuspendLayout()
        Me.TabUtilities.SuspendLayout()
        Me.GroupBoxCalibrate.SuspendLayout()
        Me.SuspendLayout()
        '
        'ButtonExit
        '
        Me.ButtonExit.DialogResult = System.Windows.Forms.DialogResult.Cancel
        Me.ButtonExit.Location = New System.Drawing.Point(416, 384)
        Me.ButtonExit.Name = "ButtonExit"
        Me.ButtonExit.Size = New System.Drawing.Size(64, 23)
        Me.ButtonExit.TabIndex = 100
        Me.ButtonExit.Text = "E&xit"
        Me.ToolTip1.SetToolTip(Me.ButtonExit, "Exit the MD2xp program")
        '
        'Tabs
        '
        Me.Tabs.Controls.Add(Me.TabControl)
        Me.Tabs.Controls.Add(Me.TabParameters)
        Me.Tabs.Controls.Add(Me.TabProgram)
        Me.Tabs.Controls.Add(Me.TabIO)
        Me.Tabs.Controls.Add(Me.TabUtilities)
        Me.Tabs.Location = New System.Drawing.Point(8, 8)
        Me.Tabs.Margin = New System.Windows.Forms.Padding(0)
        Me.Tabs.Name = "Tabs"
        Me.Tabs.SelectedIndex = 0
        Me.Tabs.Size = New System.Drawing.Size(728, 456)
        Me.Tabs.TabIndex = 30
        Me.Tabs.TabStop = False
        '
        'TabControl
        '
        Me.TabControl.Controls.Add(Me.buttonC4)
        Me.TabControl.Controls.Add(Me.GroupBoxHelp)
        Me.TabControl.Controls.Add(Me.ButtonControlCalibrate)
        Me.TabControl.Controls.Add(Me.GroupBoxProgram)
        Me.TabControl.Controls.Add(Me.GroupBoxMove)
        Me.TabControl.Controls.Add(Me.LabelStatus)
        Me.TabControl.Controls.Add(Me.GroupBoxMoveMotors)
        Me.TabControl.Controls.Add(Me.ButtonExit)
        Me.TabControl.Location = New System.Drawing.Point(4, 22)
        Me.TabControl.Margin = New System.Windows.Forms.Padding(0)
        Me.TabControl.Name = "TabControl"
        Me.TabControl.Size = New System.Drawing.Size(720, 430)
        Me.TabControl.TabIndex = 0
        Me.TabControl.Text = "    Control    "
        Me.TabControl.ToolTipText = "Control Motors"
        Me.TabControl.UseVisualStyleBackColor = True
        '
        'buttonC4
        '
        Me.buttonC4.Location = New System.Drawing.Point(648, 384)
        Me.buttonC4.Name = "buttonC4"
        Me.buttonC4.Size = New System.Drawing.Size(59, 23)
        Me.buttonC4.TabIndex = 112
        Me.buttonC4.Text = "C4 Test"
        Me.buttonC4.UseVisualStyleBackColor = True
        Me.buttonC4.Visible = False
        '
        'GroupBoxHelp
        '
        Me.GroupBoxHelp.Controls.Add(Me.ButtonQuickStart)
        Me.GroupBoxHelp.Controls.Add(Me.ButtonControlHelp)
        Me.GroupBoxHelp.Controls.Add(Me.ButtonHotKeyHelp)
        Me.GroupBoxHelp.Location = New System.Drawing.Point(488, 272)
        Me.GroupBoxHelp.Name = "GroupBoxHelp"
        Me.GroupBoxHelp.Size = New System.Drawing.Size(216, 48)
        Me.GroupBoxHelp.TabIndex = 111
        Me.GroupBoxHelp.TabStop = False
        Me.GroupBoxHelp.Text = "Help"
        '
        'ButtonQuickStart
        '
        Me.ButtonQuickStart.Location = New System.Drawing.Point(136, 16)
        Me.ButtonQuickStart.Name = "ButtonQuickStart"
        Me.ButtonQuickStart.Size = New System.Drawing.Size(72, 23)
        Me.ButtonQuickStart.TabIndex = 111
        Me.ButtonQuickStart.Text = "Quick Start"
        Me.ButtonQuickStart.UseVisualStyleBackColor = True
        '
        'ButtonControlHelp
        '
        Me.ButtonControlHelp.Location = New System.Drawing.Point(8, 16)
        Me.ButtonControlHelp.Name = "ButtonControlHelp"
        Me.ButtonControlHelp.Size = New System.Drawing.Size(48, 23)
        Me.ButtonControlHelp.TabIndex = 84
        Me.ButtonControlHelp.Text = "Index"
        Me.ToolTip1.SetToolTip(Me.ButtonControlHelp, "View Help")
        Me.ButtonControlHelp.UseVisualStyleBackColor = True
        '
        'ButtonHotKeyHelp
        '
        Me.ButtonHotKeyHelp.Location = New System.Drawing.Point(64, 16)
        Me.ButtonHotKeyHelp.Name = "ButtonHotKeyHelp"
        Me.ButtonHotKeyHelp.Size = New System.Drawing.Size(64, 23)
        Me.ButtonHotKeyHelp.TabIndex = 110
        Me.ButtonHotKeyHelp.Text = "Hot Keys"
        Me.ToolTip1.SetToolTip(Me.ButtonHotKeyHelp, "Show Hot Key Help")
        Me.ButtonHotKeyHelp.UseVisualStyleBackColor = True
        '
        'ButtonControlCalibrate
        '
        Me.ButtonControlCalibrate.ForeColor = System.Drawing.SystemColors.ControlText
        Me.ButtonControlCalibrate.Location = New System.Drawing.Point(232, 384)
        Me.ButtonControlCalibrate.Name = "ButtonControlCalibrate"
        Me.ButtonControlCalibrate.Size = New System.Drawing.Size(67, 23)
        Me.ButtonControlCalibrate.TabIndex = 0
        Me.ButtonControlCalibrate.Text = "Calibrate"
        Me.ToolTip1.SetToolTip(Me.ButtonControlCalibrate, resources.GetString("ButtonControlCalibrate.ToolTip"))
        Me.ButtonControlCalibrate.UseVisualStyleBackColor = True
        '
        'GroupBoxProgram
        '
        Me.GroupBoxProgram.Controls.Add(Me.ButtonProgramEdit)
        Me.GroupBoxProgram.Controls.Add(Me.CheckBoxTeachMode)
        Me.GroupBoxProgram.Controls.Add(Me.ButtonProgramRun)
        Me.GroupBoxProgram.Location = New System.Drawing.Point(232, 272)
        Me.GroupBoxProgram.Name = "GroupBoxProgram"
        Me.GroupBoxProgram.Size = New System.Drawing.Size(216, 48)
        Me.GroupBoxProgram.TabIndex = 109
        Me.GroupBoxProgram.TabStop = False
        Me.GroupBoxProgram.Text = "Sequence"
        '
        'ButtonProgramEdit
        '
        Me.ButtonProgramEdit.Location = New System.Drawing.Point(160, 16)
        Me.ButtonProgramEdit.Name = "ButtonProgramEdit"
        Me.ButtonProgramEdit.Size = New System.Drawing.Size(48, 24)
        Me.ButtonProgramEdit.TabIndex = 82
        Me.ButtonProgramEdit.Text = "&Edit"
        Me.ToolTip1.SetToolTip(Me.ButtonProgramEdit, "Switch to the Sequence Tab to" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "edit the currently loaded sequence.")
        Me.ButtonProgramEdit.UseVisualStyleBackColor = True
        '
        'CheckBoxTeachMode
        '
        Me.CheckBoxTeachMode.ForeColor = System.Drawing.Color.Black
        Me.CheckBoxTeachMode.Location = New System.Drawing.Point(8, 16)
        Me.CheckBoxTeachMode.Name = "CheckBoxTeachMode"
        Me.CheckBoxTeachMode.Size = New System.Drawing.Size(88, 24)
        Me.CheckBoxTeachMode.TabIndex = 80
        Me.CheckBoxTeachMode.Text = "Teach &Mode"
        Me.ToolTip1.SetToolTip(Me.CheckBoxTeachMode, "When Teach Mode is ON, every movement and " & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "output done will be recorded into the" & _
                " sequence editor.")
        Me.CheckBoxTeachMode.UseVisualStyleBackColor = True
        '
        'ButtonProgramRun
        '
        Me.ButtonProgramRun.Location = New System.Drawing.Point(104, 16)
        Me.ButtonProgramRun.Name = "ButtonProgramRun"
        Me.ButtonProgramRun.Size = New System.Drawing.Size(48, 23)
        Me.ButtonProgramRun.TabIndex = 81
        Me.ButtonProgramRun.Text = "&Run"
        Me.ToolTip1.SetToolTip(Me.ButtonProgramRun, "Run the motion sequence.")
        Me.ButtonProgramRun.UseVisualStyleBackColor = True
        '
        'GroupBoxMove
        '
        Me.GroupBoxMove.Controls.Add(Me.ButtonMoveGrid)
        Me.GroupBoxMove.Controls.Add(Me.ButtonMoveCircle)
        Me.GroupBoxMove.Controls.Add(Me.ButtonMoveLine)
        Me.GroupBoxMove.Location = New System.Drawing.Point(16, 272)
        Me.GroupBoxMove.Name = "GroupBoxMove"
        Me.GroupBoxMove.Size = New System.Drawing.Size(176, 48)
        Me.GroupBoxMove.TabIndex = 107
        Me.GroupBoxMove.TabStop = False
        Me.GroupBoxMove.Text = "Move"
        '
        'ButtonMoveGrid
        '
        Me.ButtonMoveGrid.Location = New System.Drawing.Point(120, 16)
        Me.ButtonMoveGrid.Name = "ButtonMoveGrid"
        Me.ButtonMoveGrid.Size = New System.Drawing.Size(48, 23)
        Me.ButtonMoveGrid.TabIndex = 72
        Me.ButtonMoveGrid.Text = "&Grid"
        Me.ToolTip1.SetToolTip(Me.ButtonMoveGrid, "Move 2 motors to a row and column" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "number of a user-defined grid.")
        Me.ButtonMoveGrid.UseVisualStyleBackColor = True
        '
        'ButtonMoveCircle
        '
        Me.ButtonMoveCircle.Location = New System.Drawing.Point(64, 16)
        Me.ButtonMoveCircle.Name = "ButtonMoveCircle"
        Me.ButtonMoveCircle.Size = New System.Drawing.Size(48, 23)
        Me.ButtonMoveCircle.TabIndex = 71
        Me.ButtonMoveCircle.Text = "&Circle"
        Me.ToolTip1.SetToolTip(Me.ButtonMoveCircle, "Move 2 motors in a circular pattern" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "on an XY positioning table.")
        Me.ButtonMoveCircle.UseVisualStyleBackColor = True
        '
        'ButtonMoveLine
        '
        Me.ButtonMoveLine.Location = New System.Drawing.Point(8, 16)
        Me.ButtonMoveLine.Name = "ButtonMoveLine"
        Me.ButtonMoveLine.Size = New System.Drawing.Size(48, 23)
        Me.ButtonMoveLine.TabIndex = 70
        Me.ButtonMoveLine.Text = "&Line"
        Me.ToolTip1.SetToolTip(Me.ButtonMoveLine, "Move 2 motors in a straight line" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "on an XY positioning table.")
        Me.ButtonMoveLine.UseVisualStyleBackColor = True
        '
        'LabelStatus
        '
        Me.LabelStatus.Font = New System.Drawing.Font("Microsoft Sans Serif", 12.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LabelStatus.ForeColor = System.Drawing.Color.Red
        Me.LabelStatus.Location = New System.Drawing.Point(9, 334)
        Me.LabelStatus.Name = "LabelStatus"
        Me.LabelStatus.Size = New System.Drawing.Size(695, 32)
        Me.LabelStatus.TabIndex = 8
        Me.LabelStatus.Text = "Status"
        Me.LabelStatus.TextAlign = System.Drawing.ContentAlignment.TopCenter
        '
        'GroupBoxMoveMotors
        '
        Me.GroupBoxMoveMotors.Controls.Add(Me.GroupBoxMove3)
        Me.GroupBoxMoveMotors.Controls.Add(Me.GroupBoxMove2)
        Me.GroupBoxMoveMotors.Controls.Add(Me.GroupBoxMove1)
        Me.GroupBoxMoveMotors.Controls.Add(Me.LabelOutputs)
        Me.GroupBoxMoveMotors.Controls.Add(Me.LabelForward)
        Me.GroupBoxMoveMotors.Controls.Add(Me.LabelPositions)
        Me.GroupBoxMoveMotors.Controls.Add(Me.LabelReverse)
        Me.GroupBoxMoveMotors.Controls.Add(Me.LabelUnits)
        Me.GroupBoxMoveMotors.Controls.Add(Me.LabelDistance)
        Me.GroupBoxMoveMotors.Controls.Add(Me.LabelHome)
        Me.GroupBoxMoveMotors.Location = New System.Drawing.Point(16, 8)
        Me.GroupBoxMoveMotors.Name = "GroupBoxMoveMotors"
        Me.GroupBoxMoveMotors.Size = New System.Drawing.Size(688, 248)
        Me.GroupBoxMoveMotors.TabIndex = 3
        Me.GroupBoxMoveMotors.TabStop = False
        Me.GroupBoxMoveMotors.Text = "Move Motors"
        Me.ToolTip1.SetToolTip(Me.GroupBoxMoveMotors, "These controls allow you to move motors and control" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "outputs easily.")
        '
        'GroupBoxMove3
        '
        Me.GroupBoxMove3.Controls.Add(Me.CheckBoxStandby56)
        Me.GroupBoxMove3.Controls.Add(Me.LabelNameDisplayM5)
        Me.GroupBoxMove3.Controls.Add(Me.ButtonHomeM6)
        Me.GroupBoxMove3.Controls.Add(Me.LabelUnitsDisplayM6)
        Me.GroupBoxMove3.Controls.Add(Me.CheckBoxEnabled56)
        Me.GroupBoxMove3.Controls.Add(Me.TextBoxPositionM5)
        Me.GroupBoxMove3.Controls.Add(Me.ButtonReverseM5)
        Me.GroupBoxMove3.Controls.Add(Me.CheckBoxOut32)
        Me.GroupBoxMove3.Controls.Add(Me.TextBoxPositionM6)
        Me.GroupBoxMove3.Controls.Add(Me.CheckBoxOut31)
        Me.GroupBoxMove3.Controls.Add(Me.LabelUnitsDisplayM5)
        Me.GroupBoxMove3.Controls.Add(Me.ButtonReverseM6)
        Me.GroupBoxMove3.Controls.Add(Me.ButtonHomeM5)
        Me.GroupBoxMove3.Controls.Add(Me.TextBoxDistanceM6)
        Me.GroupBoxMove3.Controls.Add(Me.LabelMotorNumberM6)
        Me.GroupBoxMove3.Controls.Add(Me.ButtonForwardM5)
        Me.GroupBoxMove3.Controls.Add(Me.TextBoxDistanceM5)
        Me.GroupBoxMove3.Controls.Add(Me.ButtonForwardM6)
        Me.GroupBoxMove3.Controls.Add(Me.LabelMotorNumberM5)
        Me.GroupBoxMove3.Controls.Add(Me.LabelNameDisplayM6)
        Me.GroupBoxMove3.Location = New System.Drawing.Point(8, 176)
        Me.GroupBoxMove3.Name = "GroupBoxMove3"
        Me.GroupBoxMove3.Size = New System.Drawing.Size(672, 64)
        Me.GroupBoxMove3.TabIndex = 90
        Me.GroupBoxMove3.TabStop = False
        Me.GroupBoxMove3.Text = "MD2 #3"
        Me.ToolTip1.SetToolTip(Me.GroupBoxMove3, "This software can control up to 3 MD2 systems on a" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "single computer.  Each MD2 us" & _
                "es one parallel printer" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "port.  The port must be configured correctly to operate" & _
                "." & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10))
        '
        'CheckBoxStandby56
        '
        Me.CheckBoxStandby56.AutoSize = True
        Me.CheckBoxStandby56.Location = New System.Drawing.Point(96, 40)
        Me.CheckBoxStandby56.Name = "CheckBoxStandby56"
        Me.CheckBoxStandby56.Size = New System.Drawing.Size(65, 17)
        Me.CheckBoxStandby56.TabIndex = 52
        Me.CheckBoxStandby56.Text = "Standby"
        Me.ToolTip1.SetToolTip(Me.CheckBoxStandby56, "Standby mode cuts motor current in half " & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "to reduce motor heat while still mainta" & _
                "ining " & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "partial holding torque")
        Me.CheckBoxStandby56.UseVisualStyleBackColor = True
        '
        'LabelNameDisplayM5
        '
        Me.LabelNameDisplayM5.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LabelNameDisplayM5.ForeColor = System.Drawing.Color.Maroon
        Me.LabelNameDisplayM5.Location = New System.Drawing.Point(24, 16)
        Me.LabelNameDisplayM5.Name = "LabelNameDisplayM5"
        Me.LabelNameDisplayM5.Size = New System.Drawing.Size(50, 18)
        Me.LabelNameDisplayM5.TabIndex = 4
        Me.LabelNameDisplayM5.Text = "Motor 5"
        Me.LabelNameDisplayM5.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        Me.ToolTip1.SetToolTip(Me.LabelNameDisplayM5, "Motor names are set on the Parameter" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "screen and used for display purposes only.")
        '
        'ButtonHomeM6
        '
        Me.ButtonHomeM6.Image = CType(resources.GetObject("ButtonHomeM6.Image"), System.Drawing.Image)
        Me.ButtonHomeM6.Location = New System.Drawing.Point(176, 40)
        Me.ButtonHomeM6.Name = "ButtonHomeM6"
        Me.ButtonHomeM6.Size = New System.Drawing.Size(32, 20)
        Me.ButtonHomeM6.TabIndex = 60
        Me.ToolTip1.SetToolTip(Me.ButtonHomeM6, "Alt 6 - Home motor 6")
        Me.ButtonHomeM6.UseVisualStyleBackColor = True
        '
        'LabelUnitsDisplayM6
        '
        Me.LabelUnitsDisplayM6.Location = New System.Drawing.Point(432, 40)
        Me.LabelUnitsDisplayM6.Name = "LabelUnitsDisplayM6"
        Me.LabelUnitsDisplayM6.Size = New System.Drawing.Size(50, 18)
        Me.LabelUnitsDisplayM6.TabIndex = 42
        Me.LabelUnitsDisplayM6.Text = "Steps"
        Me.LabelUnitsDisplayM6.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'CheckBoxEnabled56
        '
        Me.CheckBoxEnabled56.AutoSize = True
        Me.CheckBoxEnabled56.Location = New System.Drawing.Point(96, 16)
        Me.CheckBoxEnabled56.Name = "CheckBoxEnabled56"
        Me.CheckBoxEnabled56.Size = New System.Drawing.Size(65, 17)
        Me.CheckBoxEnabled56.TabIndex = 51
        Me.CheckBoxEnabled56.Text = "Enabled"
        Me.ToolTip1.SetToolTip(Me.CheckBoxEnabled56, "Enables/Disables the MD2 system." & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "Motors and outputs only operate when " & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "the MD2 " & _
                "is Enabled.")
        Me.CheckBoxEnabled56.UseVisualStyleBackColor = True
        '
        'TextBoxPositionM5
        '
        Me.TextBoxPositionM5.Location = New System.Drawing.Point(496, 16)
        Me.TextBoxPositionM5.Name = "TextBoxPositionM5"
        Me.TextBoxPositionM5.Size = New System.Drawing.Size(88, 20)
        Me.TextBoxPositionM5.TabIndex = 57
        '
        'ButtonReverseM5
        '
        Me.ButtonReverseM5.Image = CType(resources.GetObject("ButtonReverseM5.Image"), System.Drawing.Image)
        Me.ButtonReverseM5.Location = New System.Drawing.Point(232, 16)
        Me.ButtonReverseM5.Name = "ButtonReverseM5"
        Me.ButtonReverseM5.Size = New System.Drawing.Size(32, 20)
        Me.ButtonReverseM5.TabIndex = 54
        Me.ToolTip1.SetToolTip(Me.ButtonReverseM5, "F9 - Motor 5 reverse")
        Me.ButtonReverseM5.UseVisualStyleBackColor = True
        '
        'CheckBoxOut32
        '
        Me.CheckBoxOut32.AutoSize = True
        Me.CheckBoxOut32.Location = New System.Drawing.Point(640, 32)
        Me.CheckBoxOut32.Name = "CheckBoxOut32"
        Me.CheckBoxOut32.Size = New System.Drawing.Size(32, 17)
        Me.CheckBoxOut32.TabIndex = 59
        Me.CheckBoxOut32.Text = "2"
        Me.CheckBoxOut32.UseVisualStyleBackColor = True
        '
        'TextBoxPositionM6
        '
        Me.TextBoxPositionM6.Location = New System.Drawing.Point(496, 40)
        Me.TextBoxPositionM6.Name = "TextBoxPositionM6"
        Me.TextBoxPositionM6.Size = New System.Drawing.Size(88, 20)
        Me.TextBoxPositionM6.TabIndex = 64
        '
        'CheckBoxOut31
        '
        Me.CheckBoxOut31.AutoSize = True
        Me.CheckBoxOut31.Location = New System.Drawing.Point(600, 32)
        Me.CheckBoxOut31.Name = "CheckBoxOut31"
        Me.CheckBoxOut31.Size = New System.Drawing.Size(32, 17)
        Me.CheckBoxOut31.TabIndex = 58
        Me.CheckBoxOut31.Text = "1"
        Me.CheckBoxOut31.UseVisualStyleBackColor = True
        '
        'LabelUnitsDisplayM5
        '
        Me.LabelUnitsDisplayM5.Location = New System.Drawing.Point(432, 16)
        Me.LabelUnitsDisplayM5.Name = "LabelUnitsDisplayM5"
        Me.LabelUnitsDisplayM5.Size = New System.Drawing.Size(50, 18)
        Me.LabelUnitsDisplayM5.TabIndex = 41
        Me.LabelUnitsDisplayM5.Text = "Steps"
        Me.LabelUnitsDisplayM5.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'ButtonReverseM6
        '
        Me.ButtonReverseM6.Image = CType(resources.GetObject("ButtonReverseM6.Image"), System.Drawing.Image)
        Me.ButtonReverseM6.Location = New System.Drawing.Point(232, 40)
        Me.ButtonReverseM6.Name = "ButtonReverseM6"
        Me.ButtonReverseM6.Size = New System.Drawing.Size(32, 20)
        Me.ButtonReverseM6.TabIndex = 61
        Me.ToolTip1.SetToolTip(Me.ButtonReverseM6, "F11 - Motor 6 reverse")
        Me.ButtonReverseM6.UseVisualStyleBackColor = True
        '
        'ButtonHomeM5
        '
        Me.ButtonHomeM5.Image = CType(resources.GetObject("ButtonHomeM5.Image"), System.Drawing.Image)
        Me.ButtonHomeM5.Location = New System.Drawing.Point(176, 16)
        Me.ButtonHomeM5.Name = "ButtonHomeM5"
        Me.ButtonHomeM5.Size = New System.Drawing.Size(32, 20)
        Me.ButtonHomeM5.TabIndex = 53
        Me.ToolTip1.SetToolTip(Me.ButtonHomeM5, "Alt 5 - Home motor 5")
        Me.ButtonHomeM5.UseVisualStyleBackColor = True
        '
        'TextBoxDistanceM6
        '
        Me.TextBoxDistanceM6.Location = New System.Drawing.Point(344, 40)
        Me.TextBoxDistanceM6.Name = "TextBoxDistanceM6"
        Me.TextBoxDistanceM6.Size = New System.Drawing.Size(72, 20)
        Me.TextBoxDistanceM6.TabIndex = 63
        '
        'LabelMotorNumberM6
        '
        Me.LabelMotorNumberM6.Location = New System.Drawing.Point(8, 40)
        Me.LabelMotorNumberM6.Name = "LabelMotorNumberM6"
        Me.LabelMotorNumberM6.Size = New System.Drawing.Size(13, 18)
        Me.LabelMotorNumberM6.TabIndex = 80
        Me.LabelMotorNumberM6.Text = "6"
        Me.LabelMotorNumberM6.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'ButtonForwardM5
        '
        Me.ButtonForwardM5.Image = CType(resources.GetObject("ButtonForwardM5.Image"), System.Drawing.Image)
        Me.ButtonForwardM5.Location = New System.Drawing.Point(288, 16)
        Me.ButtonForwardM5.Name = "ButtonForwardM5"
        Me.ButtonForwardM5.Size = New System.Drawing.Size(32, 20)
        Me.ButtonForwardM5.TabIndex = 55
        Me.ToolTip1.SetToolTip(Me.ButtonForwardM5, "F10 - Motor 5 forward")
        Me.ButtonForwardM5.UseVisualStyleBackColor = True
        '
        'TextBoxDistanceM5
        '
        Me.TextBoxDistanceM5.Location = New System.Drawing.Point(344, 16)
        Me.TextBoxDistanceM5.Name = "TextBoxDistanceM5"
        Me.TextBoxDistanceM5.Size = New System.Drawing.Size(72, 20)
        Me.TextBoxDistanceM5.TabIndex = 56
        '
        'ButtonForwardM6
        '
        Me.ButtonForwardM6.Image = CType(resources.GetObject("ButtonForwardM6.Image"), System.Drawing.Image)
        Me.ButtonForwardM6.Location = New System.Drawing.Point(288, 40)
        Me.ButtonForwardM6.Name = "ButtonForwardM6"
        Me.ButtonForwardM6.Size = New System.Drawing.Size(32, 20)
        Me.ButtonForwardM6.TabIndex = 62
        Me.ToolTip1.SetToolTip(Me.ButtonForwardM6, "F12 - Motor 6 forward")
        Me.ButtonForwardM6.UseVisualStyleBackColor = True
        '
        'LabelMotorNumberM5
        '
        Me.LabelMotorNumberM5.Location = New System.Drawing.Point(8, 16)
        Me.LabelMotorNumberM5.Name = "LabelMotorNumberM5"
        Me.LabelMotorNumberM5.Size = New System.Drawing.Size(13, 18)
        Me.LabelMotorNumberM5.TabIndex = 79
        Me.LabelMotorNumberM5.Text = "5"
        Me.LabelMotorNumberM5.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'LabelNameDisplayM6
        '
        Me.LabelNameDisplayM6.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LabelNameDisplayM6.ForeColor = System.Drawing.Color.Maroon
        Me.LabelNameDisplayM6.Location = New System.Drawing.Point(24, 40)
        Me.LabelNameDisplayM6.Name = "LabelNameDisplayM6"
        Me.LabelNameDisplayM6.Size = New System.Drawing.Size(50, 18)
        Me.LabelNameDisplayM6.TabIndex = 5
        Me.LabelNameDisplayM6.Text = "Motor 6"
        Me.LabelNameDisplayM6.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        Me.ToolTip1.SetToolTip(Me.LabelNameDisplayM6, "Motor names are set on the Parameter" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "screen and used for display purposes only.")
        '
        'GroupBoxMove2
        '
        Me.GroupBoxMove2.Controls.Add(Me.CheckBoxStandby34)
        Me.GroupBoxMove2.Controls.Add(Me.LabelNameDisplayM3)
        Me.GroupBoxMove2.Controls.Add(Me.ButtonReverseM4)
        Me.GroupBoxMove2.Controls.Add(Me.CheckBoxEnabled34)
        Me.GroupBoxMove2.Controls.Add(Me.ButtonReverseM3)
        Me.GroupBoxMove2.Controls.Add(Me.ButtonHomeM4)
        Me.GroupBoxMove2.Controls.Add(Me.CheckBoxOut22)
        Me.GroupBoxMove2.Controls.Add(Me.ButtonForwardM3)
        Me.GroupBoxMove2.Controls.Add(Me.TextBoxPositionM4)
        Me.GroupBoxMove2.Controls.Add(Me.CheckBoxOut21)
        Me.GroupBoxMove2.Controls.Add(Me.ButtonForwardM4)
        Me.GroupBoxMove2.Controls.Add(Me.TextBoxPositionM3)
        Me.GroupBoxMove2.Controls.Add(Me.LabelUnitsDisplayM4)
        Me.GroupBoxMove2.Controls.Add(Me.LabelNameDisplayM4)
        Me.GroupBoxMove2.Controls.Add(Me.LabelUnitsDisplayM3)
        Me.GroupBoxMove2.Controls.Add(Me.ButtonHomeM3)
        Me.GroupBoxMove2.Controls.Add(Me.LabelMotorNumberM3)
        Me.GroupBoxMove2.Controls.Add(Me.TextBoxDistanceM4)
        Me.GroupBoxMove2.Controls.Add(Me.TextBoxDistanceM3)
        Me.GroupBoxMove2.Controls.Add(Me.LabelMotorNumberM4)
        Me.GroupBoxMove2.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.GroupBoxMove2.Location = New System.Drawing.Point(8, 104)
        Me.GroupBoxMove2.Name = "GroupBoxMove2"
        Me.GroupBoxMove2.Size = New System.Drawing.Size(672, 64)
        Me.GroupBoxMove2.TabIndex = 89
        Me.GroupBoxMove2.TabStop = False
        Me.GroupBoxMove2.Text = "MD2 #2"
        Me.ToolTip1.SetToolTip(Me.GroupBoxMove2, "This software can control up to 3 MD2 systems on a" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "single computer.  Each MD2 us" & _
                "es one parallel printer" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "port.  The port must be configured correctly to operate" & _
                "." & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10))
        '
        'CheckBoxStandby34
        '
        Me.CheckBoxStandby34.AutoSize = True
        Me.CheckBoxStandby34.Location = New System.Drawing.Point(96, 40)
        Me.CheckBoxStandby34.Name = "CheckBoxStandby34"
        Me.CheckBoxStandby34.Size = New System.Drawing.Size(65, 17)
        Me.CheckBoxStandby34.TabIndex = 22
        Me.CheckBoxStandby34.Text = "Standby"
        Me.ToolTip1.SetToolTip(Me.CheckBoxStandby34, "Standby mode cuts motor current in half " & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "to reduce motor heat while still mainta" & _
                "ining " & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "partial holding torque")
        Me.CheckBoxStandby34.UseVisualStyleBackColor = True
        '
        'LabelNameDisplayM3
        '
        Me.LabelNameDisplayM3.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LabelNameDisplayM3.ForeColor = System.Drawing.Color.Maroon
        Me.LabelNameDisplayM3.Location = New System.Drawing.Point(24, 16)
        Me.LabelNameDisplayM3.Name = "LabelNameDisplayM3"
        Me.LabelNameDisplayM3.Size = New System.Drawing.Size(50, 18)
        Me.LabelNameDisplayM3.TabIndex = 2
        Me.LabelNameDisplayM3.Text = "Motor 3"
        Me.LabelNameDisplayM3.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        Me.ToolTip1.SetToolTip(Me.LabelNameDisplayM3, "Motor names are set on the Parameter" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "screen and used for display purposes only.")
        '
        'ButtonReverseM4
        '
        Me.ButtonReverseM4.Image = CType(resources.GetObject("ButtonReverseM4.Image"), System.Drawing.Image)
        Me.ButtonReverseM4.Location = New System.Drawing.Point(232, 40)
        Me.ButtonReverseM4.Name = "ButtonReverseM4"
        Me.ButtonReverseM4.Size = New System.Drawing.Size(32, 20)
        Me.ButtonReverseM4.TabIndex = 31
        Me.ToolTip1.SetToolTip(Me.ButtonReverseM4, "F7 - Motor 4 reverse")
        Me.ButtonReverseM4.UseVisualStyleBackColor = True
        '
        'CheckBoxEnabled34
        '
        Me.CheckBoxEnabled34.AutoSize = True
        Me.CheckBoxEnabled34.Location = New System.Drawing.Point(96, 16)
        Me.CheckBoxEnabled34.Name = "CheckBoxEnabled34"
        Me.CheckBoxEnabled34.Size = New System.Drawing.Size(65, 17)
        Me.CheckBoxEnabled34.TabIndex = 21
        Me.CheckBoxEnabled34.Text = "Enabled"
        Me.ToolTip1.SetToolTip(Me.CheckBoxEnabled34, "Enables/Disables the MD2 system." & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "Motors and outputs only operate when " & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "the MD2 " & _
                "is Enabled.")
        Me.CheckBoxEnabled34.UseVisualStyleBackColor = True
        '
        'ButtonReverseM3
        '
        Me.ButtonReverseM3.Image = CType(resources.GetObject("ButtonReverseM3.Image"), System.Drawing.Image)
        Me.ButtonReverseM3.Location = New System.Drawing.Point(232, 16)
        Me.ButtonReverseM3.Name = "ButtonReverseM3"
        Me.ButtonReverseM3.Size = New System.Drawing.Size(32, 20)
        Me.ButtonReverseM3.TabIndex = 24
        Me.ToolTip1.SetToolTip(Me.ButtonReverseM3, "F5 - Motor 3 reverse")
        Me.ButtonReverseM3.UseVisualStyleBackColor = True
        '
        'ButtonHomeM4
        '
        Me.ButtonHomeM4.Image = CType(resources.GetObject("ButtonHomeM4.Image"), System.Drawing.Image)
        Me.ButtonHomeM4.Location = New System.Drawing.Point(176, 40)
        Me.ButtonHomeM4.Name = "ButtonHomeM4"
        Me.ButtonHomeM4.Size = New System.Drawing.Size(32, 20)
        Me.ButtonHomeM4.TabIndex = 30
        Me.ToolTip1.SetToolTip(Me.ButtonHomeM4, "Alt 4 - Home motor 4")
        Me.ButtonHomeM4.UseVisualStyleBackColor = True
        '
        'CheckBoxOut22
        '
        Me.CheckBoxOut22.AutoSize = True
        Me.CheckBoxOut22.Location = New System.Drawing.Point(640, 32)
        Me.CheckBoxOut22.Name = "CheckBoxOut22"
        Me.CheckBoxOut22.Size = New System.Drawing.Size(32, 17)
        Me.CheckBoxOut22.TabIndex = 29
        Me.CheckBoxOut22.Text = "2"
        Me.CheckBoxOut22.UseVisualStyleBackColor = True
        '
        'ButtonForwardM3
        '
        Me.ButtonForwardM3.Image = CType(resources.GetObject("ButtonForwardM3.Image"), System.Drawing.Image)
        Me.ButtonForwardM3.Location = New System.Drawing.Point(288, 16)
        Me.ButtonForwardM3.Name = "ButtonForwardM3"
        Me.ButtonForwardM3.Size = New System.Drawing.Size(32, 20)
        Me.ButtonForwardM3.TabIndex = 25
        Me.ToolTip1.SetToolTip(Me.ButtonForwardM3, "F6 - Motor 3 forward")
        Me.ButtonForwardM3.UseVisualStyleBackColor = True
        '
        'TextBoxPositionM4
        '
        Me.TextBoxPositionM4.Location = New System.Drawing.Point(496, 40)
        Me.TextBoxPositionM4.Name = "TextBoxPositionM4"
        Me.TextBoxPositionM4.Size = New System.Drawing.Size(88, 20)
        Me.TextBoxPositionM4.TabIndex = 34
        '
        'CheckBoxOut21
        '
        Me.CheckBoxOut21.AutoSize = True
        Me.CheckBoxOut21.Location = New System.Drawing.Point(600, 32)
        Me.CheckBoxOut21.Name = "CheckBoxOut21"
        Me.CheckBoxOut21.Size = New System.Drawing.Size(32, 17)
        Me.CheckBoxOut21.TabIndex = 28
        Me.CheckBoxOut21.Text = "1"
        Me.CheckBoxOut21.UseVisualStyleBackColor = True
        '
        'ButtonForwardM4
        '
        Me.ButtonForwardM4.Image = CType(resources.GetObject("ButtonForwardM4.Image"), System.Drawing.Image)
        Me.ButtonForwardM4.Location = New System.Drawing.Point(288, 40)
        Me.ButtonForwardM4.Name = "ButtonForwardM4"
        Me.ButtonForwardM4.Size = New System.Drawing.Size(32, 20)
        Me.ButtonForwardM4.TabIndex = 32
        Me.ToolTip1.SetToolTip(Me.ButtonForwardM4, "F8 - Motor 4 forward")
        Me.ButtonForwardM4.UseVisualStyleBackColor = True
        '
        'TextBoxPositionM3
        '
        Me.TextBoxPositionM3.Location = New System.Drawing.Point(496, 16)
        Me.TextBoxPositionM3.Name = "TextBoxPositionM3"
        Me.TextBoxPositionM3.Size = New System.Drawing.Size(88, 20)
        Me.TextBoxPositionM3.TabIndex = 27
        '
        'LabelUnitsDisplayM4
        '
        Me.LabelUnitsDisplayM4.Location = New System.Drawing.Point(432, 40)
        Me.LabelUnitsDisplayM4.Name = "LabelUnitsDisplayM4"
        Me.LabelUnitsDisplayM4.Size = New System.Drawing.Size(50, 18)
        Me.LabelUnitsDisplayM4.TabIndex = 40
        Me.LabelUnitsDisplayM4.Text = "Steps"
        Me.LabelUnitsDisplayM4.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'LabelNameDisplayM4
        '
        Me.LabelNameDisplayM4.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LabelNameDisplayM4.ForeColor = System.Drawing.Color.Maroon
        Me.LabelNameDisplayM4.Location = New System.Drawing.Point(24, 40)
        Me.LabelNameDisplayM4.Name = "LabelNameDisplayM4"
        Me.LabelNameDisplayM4.Size = New System.Drawing.Size(50, 18)
        Me.LabelNameDisplayM4.TabIndex = 3
        Me.LabelNameDisplayM4.Text = "Motor 4"
        Me.LabelNameDisplayM4.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'LabelUnitsDisplayM3
        '
        Me.LabelUnitsDisplayM3.Location = New System.Drawing.Point(432, 16)
        Me.LabelUnitsDisplayM3.Name = "LabelUnitsDisplayM3"
        Me.LabelUnitsDisplayM3.Size = New System.Drawing.Size(50, 18)
        Me.LabelUnitsDisplayM3.TabIndex = 39
        Me.LabelUnitsDisplayM3.Text = "Steps"
        Me.LabelUnitsDisplayM3.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'ButtonHomeM3
        '
        Me.ButtonHomeM3.Image = CType(resources.GetObject("ButtonHomeM3.Image"), System.Drawing.Image)
        Me.ButtonHomeM3.Location = New System.Drawing.Point(176, 16)
        Me.ButtonHomeM3.Name = "ButtonHomeM3"
        Me.ButtonHomeM3.Size = New System.Drawing.Size(32, 20)
        Me.ButtonHomeM3.TabIndex = 23
        Me.ToolTip1.SetToolTip(Me.ButtonHomeM3, "Alt 3 - Home motor 3")
        Me.ButtonHomeM3.UseVisualStyleBackColor = True
        '
        'LabelMotorNumberM3
        '
        Me.LabelMotorNumberM3.Location = New System.Drawing.Point(8, 16)
        Me.LabelMotorNumberM3.Name = "LabelMotorNumberM3"
        Me.LabelMotorNumberM3.Size = New System.Drawing.Size(13, 18)
        Me.LabelMotorNumberM3.TabIndex = 77
        Me.LabelMotorNumberM3.Text = "3"
        Me.LabelMotorNumberM3.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'TextBoxDistanceM4
        '
        Me.TextBoxDistanceM4.Location = New System.Drawing.Point(344, 40)
        Me.TextBoxDistanceM4.Name = "TextBoxDistanceM4"
        Me.TextBoxDistanceM4.Size = New System.Drawing.Size(72, 20)
        Me.TextBoxDistanceM4.TabIndex = 33
        '
        'TextBoxDistanceM3
        '
        Me.TextBoxDistanceM3.Location = New System.Drawing.Point(344, 16)
        Me.TextBoxDistanceM3.Name = "TextBoxDistanceM3"
        Me.TextBoxDistanceM3.Size = New System.Drawing.Size(72, 20)
        Me.TextBoxDistanceM3.TabIndex = 26
        '
        'LabelMotorNumberM4
        '
        Me.LabelMotorNumberM4.Location = New System.Drawing.Point(8, 40)
        Me.LabelMotorNumberM4.Name = "LabelMotorNumberM4"
        Me.LabelMotorNumberM4.Size = New System.Drawing.Size(13, 18)
        Me.LabelMotorNumberM4.TabIndex = 78
        Me.LabelMotorNumberM4.Text = "4"
        Me.LabelMotorNumberM4.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'GroupBoxMove1
        '
        Me.GroupBoxMove1.Controls.Add(Me.CheckBoxStandby12)
        Me.GroupBoxMove1.Controls.Add(Me.LabelNameDisplayM1)
        Me.GroupBoxMove1.Controls.Add(Me.CheckBoxEnabled12)
        Me.GroupBoxMove1.Controls.Add(Me.LabelNameDisplayM2)
        Me.GroupBoxMove1.Controls.Add(Me.ButtonForwardM2)
        Me.GroupBoxMove1.Controls.Add(Me.CheckBoxOut12)
        Me.GroupBoxMove1.Controls.Add(Me.ButtonReverseM2)
        Me.GroupBoxMove1.Controls.Add(Me.ButtonForwardM1)
        Me.GroupBoxMove1.Controls.Add(Me.CheckBoxOut11)
        Me.GroupBoxMove1.Controls.Add(Me.TextBoxPositionM2)
        Me.GroupBoxMove1.Controls.Add(Me.LabelMotorNumberM1)
        Me.GroupBoxMove1.Controls.Add(Me.ButtonHomeM2)
        Me.GroupBoxMove1.Controls.Add(Me.TextBoxPositionM1)
        Me.GroupBoxMove1.Controls.Add(Me.LabelMotorNumberM2)
        Me.GroupBoxMove1.Controls.Add(Me.ButtonHomeM1)
        Me.GroupBoxMove1.Controls.Add(Me.LabelUnitsDisplayM2)
        Me.GroupBoxMove1.Controls.Add(Me.LabelUnitsDisplayM1)
        Me.GroupBoxMove1.Controls.Add(Me.ButtonReverseM1)
        Me.GroupBoxMove1.Controls.Add(Me.TextBoxDistanceM2)
        Me.GroupBoxMove1.Controls.Add(Me.TextBoxDistanceM1)
        Me.GroupBoxMove1.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.GroupBoxMove1.Location = New System.Drawing.Point(8, 32)
        Me.GroupBoxMove1.Name = "GroupBoxMove1"
        Me.GroupBoxMove1.Size = New System.Drawing.Size(672, 64)
        Me.GroupBoxMove1.TabIndex = 88
        Me.GroupBoxMove1.TabStop = False
        Me.GroupBoxMove1.Text = "MD2 #1"
        Me.ToolTip1.SetToolTip(Me.GroupBoxMove1, "This software can control up to 3 MD2 systems on a" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "single computer.  Each MD2 us" & _
                "es one parallel printer" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "port.  The port must be configured correctly to operate" & _
                ".")
        '
        'CheckBoxStandby12
        '
        Me.CheckBoxStandby12.AutoSize = True
        Me.CheckBoxStandby12.Location = New System.Drawing.Point(96, 40)
        Me.CheckBoxStandby12.Name = "CheckBoxStandby12"
        Me.CheckBoxStandby12.Size = New System.Drawing.Size(65, 17)
        Me.CheckBoxStandby12.TabIndex = 2
        Me.CheckBoxStandby12.Text = "Standby"
        Me.ToolTip1.SetToolTip(Me.CheckBoxStandby12, "Standby mode cuts motor current in half " & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "to reduce motor heat while still mainta" & _
                "ining " & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "partial holding torque")
        Me.CheckBoxStandby12.UseVisualStyleBackColor = True
        '
        'LabelNameDisplayM1
        '
        Me.LabelNameDisplayM1.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LabelNameDisplayM1.ForeColor = System.Drawing.Color.Maroon
        Me.LabelNameDisplayM1.Location = New System.Drawing.Point(24, 16)
        Me.LabelNameDisplayM1.Name = "LabelNameDisplayM1"
        Me.LabelNameDisplayM1.Size = New System.Drawing.Size(50, 18)
        Me.LabelNameDisplayM1.TabIndex = 0
        Me.LabelNameDisplayM1.Text = "Motor 1"
        Me.LabelNameDisplayM1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        Me.ToolTip1.SetToolTip(Me.LabelNameDisplayM1, "Motor names are set on the Parameter" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "screen and used for display purposes only.")
        '
        'CheckBoxEnabled12
        '
        Me.CheckBoxEnabled12.AutoSize = True
        Me.CheckBoxEnabled12.Location = New System.Drawing.Point(96, 16)
        Me.CheckBoxEnabled12.Name = "CheckBoxEnabled12"
        Me.CheckBoxEnabled12.Size = New System.Drawing.Size(65, 17)
        Me.CheckBoxEnabled12.TabIndex = 1
        Me.CheckBoxEnabled12.Text = "Enabled"
        Me.ToolTip1.SetToolTip(Me.CheckBoxEnabled12, "Enables/Disables the MD2 system." & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "Motors and outputs only operate when " & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "the MD2 " & _
                "is Enabled.")
        Me.CheckBoxEnabled12.UseVisualStyleBackColor = True
        '
        'LabelNameDisplayM2
        '
        Me.LabelNameDisplayM2.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LabelNameDisplayM2.ForeColor = System.Drawing.Color.Maroon
        Me.LabelNameDisplayM2.Location = New System.Drawing.Point(24, 40)
        Me.LabelNameDisplayM2.Name = "LabelNameDisplayM2"
        Me.LabelNameDisplayM2.Size = New System.Drawing.Size(50, 18)
        Me.LabelNameDisplayM2.TabIndex = 1
        Me.LabelNameDisplayM2.Text = "Motor 2"
        Me.LabelNameDisplayM2.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        Me.ToolTip1.SetToolTip(Me.LabelNameDisplayM2, "Motor names are set on the Parameter" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "screen and used for display purposes only.")
        '
        'ButtonForwardM2
        '
        Me.ButtonForwardM2.Image = CType(resources.GetObject("ButtonForwardM2.Image"), System.Drawing.Image)
        Me.ButtonForwardM2.Location = New System.Drawing.Point(288, 40)
        Me.ButtonForwardM2.Name = "ButtonForwardM2"
        Me.ButtonForwardM2.Size = New System.Drawing.Size(32, 20)
        Me.ButtonForwardM2.TabIndex = 12
        Me.ToolTip1.SetToolTip(Me.ButtonForwardM2, "F4 - Motor 2 forward")
        Me.ButtonForwardM2.UseVisualStyleBackColor = True
        '
        'CheckBoxOut12
        '
        Me.CheckBoxOut12.AutoSize = True
        Me.CheckBoxOut12.Location = New System.Drawing.Point(640, 32)
        Me.CheckBoxOut12.Name = "CheckBoxOut12"
        Me.CheckBoxOut12.Size = New System.Drawing.Size(32, 17)
        Me.CheckBoxOut12.TabIndex = 9
        Me.CheckBoxOut12.Text = "2"
        Me.CheckBoxOut12.UseVisualStyleBackColor = True
        '
        'ButtonReverseM2
        '
        Me.ButtonReverseM2.Image = CType(resources.GetObject("ButtonReverseM2.Image"), System.Drawing.Image)
        Me.ButtonReverseM2.Location = New System.Drawing.Point(232, 40)
        Me.ButtonReverseM2.Name = "ButtonReverseM2"
        Me.ButtonReverseM2.Size = New System.Drawing.Size(32, 20)
        Me.ButtonReverseM2.TabIndex = 11
        Me.ToolTip1.SetToolTip(Me.ButtonReverseM2, "F3 - Motor 2 reverse")
        Me.ButtonReverseM2.UseVisualStyleBackColor = True
        '
        'ButtonForwardM1
        '
        Me.ButtonForwardM1.Image = CType(resources.GetObject("ButtonForwardM1.Image"), System.Drawing.Image)
        Me.ButtonForwardM1.Location = New System.Drawing.Point(288, 16)
        Me.ButtonForwardM1.Name = "ButtonForwardM1"
        Me.ButtonForwardM1.Size = New System.Drawing.Size(32, 20)
        Me.ButtonForwardM1.TabIndex = 5
        Me.ToolTip1.SetToolTip(Me.ButtonForwardM1, "F2 - Motor 1 forward")
        Me.ButtonForwardM1.UseVisualStyleBackColor = True
        '
        'CheckBoxOut11
        '
        Me.CheckBoxOut11.AutoSize = True
        Me.CheckBoxOut11.Location = New System.Drawing.Point(600, 32)
        Me.CheckBoxOut11.Name = "CheckBoxOut11"
        Me.CheckBoxOut11.Size = New System.Drawing.Size(32, 17)
        Me.CheckBoxOut11.TabIndex = 8
        Me.CheckBoxOut11.Text = "1"
        Me.CheckBoxOut11.UseVisualStyleBackColor = True
        '
        'TextBoxPositionM2
        '
        Me.TextBoxPositionM2.Location = New System.Drawing.Point(496, 40)
        Me.TextBoxPositionM2.Name = "TextBoxPositionM2"
        Me.TextBoxPositionM2.Size = New System.Drawing.Size(88, 20)
        Me.TextBoxPositionM2.TabIndex = 14
        '
        'LabelMotorNumberM1
        '
        Me.LabelMotorNumberM1.Location = New System.Drawing.Point(8, 16)
        Me.LabelMotorNumberM1.Name = "LabelMotorNumberM1"
        Me.LabelMotorNumberM1.Size = New System.Drawing.Size(13, 18)
        Me.LabelMotorNumberM1.TabIndex = 75
        Me.LabelMotorNumberM1.Text = "1"
        Me.LabelMotorNumberM1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'ButtonHomeM2
        '
        Me.ButtonHomeM2.Image = CType(resources.GetObject("ButtonHomeM2.Image"), System.Drawing.Image)
        Me.ButtonHomeM2.Location = New System.Drawing.Point(176, 40)
        Me.ButtonHomeM2.Name = "ButtonHomeM2"
        Me.ButtonHomeM2.Size = New System.Drawing.Size(32, 20)
        Me.ButtonHomeM2.TabIndex = 10
        Me.ToolTip1.SetToolTip(Me.ButtonHomeM2, "Alt 2 - Home motor 2")
        Me.ButtonHomeM2.UseVisualStyleBackColor = True
        '
        'TextBoxPositionM1
        '
        Me.TextBoxPositionM1.Location = New System.Drawing.Point(496, 16)
        Me.TextBoxPositionM1.Name = "TextBoxPositionM1"
        Me.TextBoxPositionM1.Size = New System.Drawing.Size(88, 20)
        Me.TextBoxPositionM1.TabIndex = 7
        '
        'LabelMotorNumberM2
        '
        Me.LabelMotorNumberM2.Location = New System.Drawing.Point(8, 40)
        Me.LabelMotorNumberM2.Name = "LabelMotorNumberM2"
        Me.LabelMotorNumberM2.Size = New System.Drawing.Size(13, 18)
        Me.LabelMotorNumberM2.TabIndex = 76
        Me.LabelMotorNumberM2.Text = "2"
        Me.LabelMotorNumberM2.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'ButtonHomeM1
        '
        Me.ButtonHomeM1.BackColor = System.Drawing.Color.Transparent
        Me.ButtonHomeM1.ForeColor = System.Drawing.SystemColors.ControlText
        Me.ButtonHomeM1.Image = CType(resources.GetObject("ButtonHomeM1.Image"), System.Drawing.Image)
        Me.ButtonHomeM1.Location = New System.Drawing.Point(176, 16)
        Me.ButtonHomeM1.Name = "ButtonHomeM1"
        Me.ButtonHomeM1.Size = New System.Drawing.Size(32, 20)
        Me.ButtonHomeM1.TabIndex = 3
        Me.ToolTip1.SetToolTip(Me.ButtonHomeM1, "Alt 1 - Home motor 1")
        Me.ButtonHomeM1.UseVisualStyleBackColor = False
        '
        'LabelUnitsDisplayM2
        '
        Me.LabelUnitsDisplayM2.Location = New System.Drawing.Point(432, 40)
        Me.LabelUnitsDisplayM2.Name = "LabelUnitsDisplayM2"
        Me.LabelUnitsDisplayM2.Size = New System.Drawing.Size(50, 18)
        Me.LabelUnitsDisplayM2.TabIndex = 38
        Me.LabelUnitsDisplayM2.Text = "Steps"
        Me.LabelUnitsDisplayM2.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'LabelUnitsDisplayM1
        '
        Me.LabelUnitsDisplayM1.Location = New System.Drawing.Point(432, 16)
        Me.LabelUnitsDisplayM1.Name = "LabelUnitsDisplayM1"
        Me.LabelUnitsDisplayM1.Size = New System.Drawing.Size(50, 18)
        Me.LabelUnitsDisplayM1.TabIndex = 37
        Me.LabelUnitsDisplayM1.Text = "Steps"
        Me.LabelUnitsDisplayM1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'ButtonReverseM1
        '
        Me.ButtonReverseM1.Image = CType(resources.GetObject("ButtonReverseM1.Image"), System.Drawing.Image)
        Me.ButtonReverseM1.Location = New System.Drawing.Point(232, 16)
        Me.ButtonReverseM1.Name = "ButtonReverseM1"
        Me.ButtonReverseM1.Size = New System.Drawing.Size(32, 20)
        Me.ButtonReverseM1.TabIndex = 4
        Me.ToolTip1.SetToolTip(Me.ButtonReverseM1, "F1 - Motor 1 reverse")
        Me.ButtonReverseM1.UseVisualStyleBackColor = True
        '
        'TextBoxDistanceM2
        '
        Me.TextBoxDistanceM2.Location = New System.Drawing.Point(344, 40)
        Me.TextBoxDistanceM2.Name = "TextBoxDistanceM2"
        Me.TextBoxDistanceM2.Size = New System.Drawing.Size(72, 20)
        Me.TextBoxDistanceM2.TabIndex = 13
        '
        'TextBoxDistanceM1
        '
        Me.TextBoxDistanceM1.Location = New System.Drawing.Point(344, 16)
        Me.TextBoxDistanceM1.Name = "TextBoxDistanceM1"
        Me.TextBoxDistanceM1.Size = New System.Drawing.Size(72, 20)
        Me.TextBoxDistanceM1.TabIndex = 6
        '
        'LabelOutputs
        '
        Me.LabelOutputs.AutoSize = True
        Me.LabelOutputs.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LabelOutputs.Location = New System.Drawing.Point(608, 16)
        Me.LabelOutputs.Name = "LabelOutputs"
        Me.LabelOutputs.Size = New System.Drawing.Size(51, 13)
        Me.LabelOutputs.TabIndex = 84
        Me.LabelOutputs.Text = "Outputs"
        Me.ToolTip1.SetToolTip(Me.LabelOutputs, resources.GetString("LabelOutputs.ToolTip"))
        '
        'LabelForward
        '
        Me.LabelForward.AutoSize = True
        Me.LabelForward.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LabelForward.Location = New System.Drawing.Point(288, 16)
        Me.LabelForward.Name = "LabelForward"
        Me.LabelForward.Size = New System.Drawing.Size(52, 13)
        Me.LabelForward.TabIndex = 56
        Me.LabelForward.Text = "Forward"
        Me.ToolTip1.SetToolTip(Me.LabelForward, resources.GetString("LabelForward.ToolTip"))
        '
        'LabelPositions
        '
        Me.LabelPositions.AutoSize = True
        Me.LabelPositions.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LabelPositions.Location = New System.Drawing.Point(520, 16)
        Me.LabelPositions.Name = "LabelPositions"
        Me.LabelPositions.Size = New System.Drawing.Size(52, 13)
        Me.LabelPositions.TabIndex = 12
        Me.LabelPositions.Text = "Position"
        Me.ToolTip1.SetToolTip(Me.LabelPositions, "The current motor position in Units.")
        '
        'LabelReverse
        '
        Me.LabelReverse.AutoSize = True
        Me.LabelReverse.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LabelReverse.Location = New System.Drawing.Point(232, 16)
        Me.LabelReverse.Name = "LabelReverse"
        Me.LabelReverse.Size = New System.Drawing.Size(54, 13)
        Me.LabelReverse.TabIndex = 55
        Me.LabelReverse.Text = "Reverse"
        Me.ToolTip1.SetToolTip(Me.LabelReverse, resources.GetString("LabelReverse.ToolTip"))
        '
        'LabelUnits
        '
        Me.LabelUnits.AutoSize = True
        Me.LabelUnits.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LabelUnits.Location = New System.Drawing.Point(440, 16)
        Me.LabelUnits.Name = "LabelUnits"
        Me.LabelUnits.Size = New System.Drawing.Size(36, 13)
        Me.LabelUnits.TabIndex = 11
        Me.LabelUnits.Text = "Units"
        Me.ToolTip1.SetToolTip(Me.LabelUnits, resources.GetString("LabelUnits.ToolTip"))
        '
        'LabelDistance
        '
        Me.LabelDistance.AutoSize = True
        Me.LabelDistance.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LabelDistance.Location = New System.Drawing.Point(360, 16)
        Me.LabelDistance.Name = "LabelDistance"
        Me.LabelDistance.Size = New System.Drawing.Size(57, 13)
        Me.LabelDistance.TabIndex = 10
        Me.LabelDistance.Text = "Distance"
        Me.ToolTip1.SetToolTip(Me.LabelDistance, "The distance in Units that a motor will move each" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "time the Forward or Reverse ar" & _
                "row buttons are" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "clicked.")
        '
        'LabelHome
        '
        Me.LabelHome.AutoSize = True
        Me.LabelHome.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LabelHome.Location = New System.Drawing.Point(184, 16)
        Me.LabelHome.Name = "LabelHome"
        Me.LabelHome.Size = New System.Drawing.Size(39, 13)
        Me.LabelHome.TabIndex = 49
        Me.LabelHome.Text = "Home"
        Me.ToolTip1.SetToolTip(Me.LabelHome, resources.GetString("LabelHome.ToolTip"))
        '
        'TabParameters
        '
        Me.TabParameters.Controls.Add(Me.ButtonParametersHelp)
        Me.TabParameters.Controls.Add(Me.ButtonSaveAsParameters)
        Me.TabParameters.Controls.Add(Me.LabelPortMD256)
        Me.TabParameters.Controls.Add(Me.LabelPortMD234)
        Me.TabParameters.Controls.Add(Me.LabelPortMD212)
        Me.TabParameters.Controls.Add(Me.LabelParameterFile)
        Me.TabParameters.Controls.Add(Me.LabelPortAddress)
        Me.TabParameters.Controls.Add(Me.CheckBoxHomeDirM6)
        Me.TabParameters.Controls.Add(Me.TextBoxBacklashM6)
        Me.TabParameters.Controls.Add(Me.TextBoxSlopeM6)
        Me.TabParameters.Controls.Add(Me.TextBoxMaxSpeedM6)
        Me.TabParameters.Controls.Add(Me.TextBoxMinSpeedM6)
        Me.TabParameters.Controls.Add(Me.TextBoxLimitRM6)
        Me.TabParameters.Controls.Add(Me.TextBoxLimitFM6)
        Me.TabParameters.Controls.Add(Me.TextBoxHomeOffsetM6)
        Me.TabParameters.Controls.Add(Me.TextBoxUnitValueM6)
        Me.TabParameters.Controls.Add(Me.TextBoxUnitNameM6)
        Me.TabParameters.Controls.Add(Me.TextBoxPositionPM6)
        Me.TabParameters.Controls.Add(Me.CheckBoxHomeDirM5)
        Me.TabParameters.Controls.Add(Me.TextBoxBacklashM5)
        Me.TabParameters.Controls.Add(Me.TextBoxSlopeM5)
        Me.TabParameters.Controls.Add(Me.TextBoxMaxSpeedM5)
        Me.TabParameters.Controls.Add(Me.TextBoxMinSpeedM5)
        Me.TabParameters.Controls.Add(Me.TextBoxLimitRM5)
        Me.TabParameters.Controls.Add(Me.TextBoxLimitFM5)
        Me.TabParameters.Controls.Add(Me.TextBoxHomeOffsetM5)
        Me.TabParameters.Controls.Add(Me.TextBoxUnitValueM5)
        Me.TabParameters.Controls.Add(Me.TextBoxUnitNameM5)
        Me.TabParameters.Controls.Add(Me.TextBoxPositionPM5)
        Me.TabParameters.Controls.Add(Me.CheckBoxHomeDirM4)
        Me.TabParameters.Controls.Add(Me.TextBoxBacklashM4)
        Me.TabParameters.Controls.Add(Me.TextBoxSlopeM4)
        Me.TabParameters.Controls.Add(Me.TextBoxMaxSpeedM4)
        Me.TabParameters.Controls.Add(Me.TextBoxMinSpeedM4)
        Me.TabParameters.Controls.Add(Me.TextBoxLimitRM4)
        Me.TabParameters.Controls.Add(Me.TextBoxLimitFM4)
        Me.TabParameters.Controls.Add(Me.TextBoxHomeOffsetM4)
        Me.TabParameters.Controls.Add(Me.TextBoxUnitValueM4)
        Me.TabParameters.Controls.Add(Me.TextBoxUnitNameM4)
        Me.TabParameters.Controls.Add(Me.TextBoxPositionPM4)
        Me.TabParameters.Controls.Add(Me.CheckBoxHomeDirM3)
        Me.TabParameters.Controls.Add(Me.TextBoxBacklashM3)
        Me.TabParameters.Controls.Add(Me.TextBoxSlopeM3)
        Me.TabParameters.Controls.Add(Me.TextBoxMaxSpeedM3)
        Me.TabParameters.Controls.Add(Me.TextBoxMinSpeedM3)
        Me.TabParameters.Controls.Add(Me.TextBoxLimitRM3)
        Me.TabParameters.Controls.Add(Me.TextBoxLimitFM3)
        Me.TabParameters.Controls.Add(Me.TextBoxHomeOffsetM3)
        Me.TabParameters.Controls.Add(Me.TextBoxUnitValueM3)
        Me.TabParameters.Controls.Add(Me.TextBoxUnitNameM3)
        Me.TabParameters.Controls.Add(Me.TextBoxPositionPM3)
        Me.TabParameters.Controls.Add(Me.CheckBoxHomeDirM2)
        Me.TabParameters.Controls.Add(Me.TextBoxBacklashM2)
        Me.TabParameters.Controls.Add(Me.TextBoxSlopeM2)
        Me.TabParameters.Controls.Add(Me.TextBoxMaxSpeedM2)
        Me.TabParameters.Controls.Add(Me.TextBoxMinSpeedM2)
        Me.TabParameters.Controls.Add(Me.TextBoxLimitRM2)
        Me.TabParameters.Controls.Add(Me.TextBoxLimitFM2)
        Me.TabParameters.Controls.Add(Me.TextBoxHomeOffsetM2)
        Me.TabParameters.Controls.Add(Me.TextBoxUnitValueM2)
        Me.TabParameters.Controls.Add(Me.TextBoxUnitNameM2)
        Me.TabParameters.Controls.Add(Me.TextBoxPositionPM2)
        Me.TabParameters.Controls.Add(Me.GroupBoxStepType)
        Me.TabParameters.Controls.Add(Me.GroupBoxMoveType)
        Me.TabParameters.Controls.Add(Me.CheckBoxHold)
        Me.TabParameters.Controls.Add(Me.CheckBoxHomeDirM1)
        Me.TabParameters.Controls.Add(Me.TextBoxMotorNameM6)
        Me.TabParameters.Controls.Add(Me.TextBoxMotorNameM5)
        Me.TabParameters.Controls.Add(Me.TextBoxMotorNameM4)
        Me.TabParameters.Controls.Add(Me.TextBoxMotorNameM3)
        Me.TabParameters.Controls.Add(Me.TextBoxMotorNameM2)
        Me.TabParameters.Controls.Add(Me.ButtonSaveParameters)
        Me.TabParameters.Controls.Add(Me.ButtonLoadParameters)
        Me.TabParameters.Controls.Add(Me.TextBoxBacklashM1)
        Me.TabParameters.Controls.Add(Me.TextBoxSlopeM1)
        Me.TabParameters.Controls.Add(Me.TextBoxMaxSpeedM1)
        Me.TabParameters.Controls.Add(Me.TextBoxMinSpeedM1)
        Me.TabParameters.Controls.Add(Me.TextBoxLimitRM1)
        Me.TabParameters.Controls.Add(Me.TextBoxLimitFM1)
        Me.TabParameters.Controls.Add(Me.TextBoxHomeOffsetM1)
        Me.TabParameters.Controls.Add(Me.TextBoxUnitValueM1)
        Me.TabParameters.Controls.Add(Me.TextBoxUnitNameM1)
        Me.TabParameters.Controls.Add(Me.TextBoxPositionPM1)
        Me.TabParameters.Controls.Add(Me.TextBoxMotorNameM1)
        Me.TabParameters.Controls.Add(Me.LabelUnitValue)
        Me.TabParameters.Controls.Add(Me.LabelUnitName)
        Me.TabParameters.Controls.Add(Me.LabelPosition)
        Me.TabParameters.Controls.Add(Me.LabelMotorName)
        Me.TabParameters.Controls.Add(Me.LabelSlope)
        Me.TabParameters.Controls.Add(Me.LabelMaxSpeed)
        Me.TabParameters.Controls.Add(Me.LabelMinSpeed)
        Me.TabParameters.Controls.Add(Me.LabelLimitReverse)
        Me.TabParameters.Controls.Add(Me.LabelLimitForward)
        Me.TabParameters.Controls.Add(Me.LabelHomeOffset)
        Me.TabParameters.Controls.Add(Me.LabelHomeDirection)
        Me.TabParameters.Controls.Add(Me.LabelBacklash)
        Me.TabParameters.Controls.Add(Me.LabelMotor6)
        Me.TabParameters.Controls.Add(Me.LabelMotor5)
        Me.TabParameters.Controls.Add(Me.LabelMotor4)
        Me.TabParameters.Controls.Add(Me.LabelMotor3)
        Me.TabParameters.Controls.Add(Me.LabelMotor2)
        Me.TabParameters.Controls.Add(Me.LabelMotor1)
        Me.TabParameters.Location = New System.Drawing.Point(4, 22)
        Me.TabParameters.Name = "TabParameters"
        Me.TabParameters.Size = New System.Drawing.Size(720, 430)
        Me.TabParameters.TabIndex = 1
        Me.TabParameters.Text = "    Parameters    "
        Me.TabParameters.UseVisualStyleBackColor = True
        '
        'ButtonParametersHelp
        '
        Me.ButtonParametersHelp.Location = New System.Drawing.Point(16, 392)
        Me.ButtonParametersHelp.Name = "ButtonParametersHelp"
        Me.ButtonParametersHelp.Size = New System.Drawing.Size(40, 23)
        Me.ButtonParametersHelp.TabIndex = 363
        Me.ButtonParametersHelp.Text = "&Help"
        Me.ButtonParametersHelp.UseVisualStyleBackColor = True
        '
        'ButtonSaveAsParameters
        '
        Me.ButtonSaveAsParameters.Location = New System.Drawing.Point(120, 8)
        Me.ButtonSaveAsParameters.Name = "ButtonSaveAsParameters"
        Me.ButtonSaveAsParameters.Size = New System.Drawing.Size(56, 24)
        Me.ButtonSaveAsParameters.TabIndex = 361
        Me.ButtonSaveAsParameters.Text = "Save As"
        Me.ButtonSaveAsParameters.UseVisualStyleBackColor = True
        '
        'LabelPortMD256
        '
        Me.LabelPortMD256.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
        Me.LabelPortMD256.Location = New System.Drawing.Point(576, 355)
        Me.LabelPortMD256.Name = "LabelPortMD256"
        Me.LabelPortMD256.Size = New System.Drawing.Size(88, 16)
        Me.LabelPortMD256.TabIndex = 106
        Me.LabelPortMD256.Text = "Port not set"
        Me.LabelPortMD256.TextAlign = System.Drawing.ContentAlignment.BottomCenter
        Me.ToolTip1.SetToolTip(Me.LabelPortMD256, "Click to set Port")
        '
        'LabelPortMD234
        '
        Me.LabelPortMD234.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
        Me.LabelPortMD234.Location = New System.Drawing.Point(360, 355)
        Me.LabelPortMD234.Name = "LabelPortMD234"
        Me.LabelPortMD234.Size = New System.Drawing.Size(88, 16)
        Me.LabelPortMD234.TabIndex = 105
        Me.LabelPortMD234.Text = "Port not set"
        Me.LabelPortMD234.TextAlign = System.Drawing.ContentAlignment.BottomCenter
        Me.ToolTip1.SetToolTip(Me.LabelPortMD234, "Click to set Port")
        '
        'LabelPortMD212
        '
        Me.LabelPortMD212.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
        Me.LabelPortMD212.Location = New System.Drawing.Point(153, 356)
        Me.LabelPortMD212.Name = "LabelPortMD212"
        Me.LabelPortMD212.Size = New System.Drawing.Size(88, 16)
        Me.LabelPortMD212.TabIndex = 104
        Me.LabelPortMD212.Text = "Port not set"
        Me.LabelPortMD212.TextAlign = System.Drawing.ContentAlignment.BottomCenter
        Me.ToolTip1.SetToolTip(Me.LabelPortMD212, "Click to set Port")
        '
        'LabelParameterFile
        '
        Me.LabelParameterFile.AutoEllipsis = True
        Me.LabelParameterFile.AutoSize = True
        Me.LabelParameterFile.ImageAlign = System.Drawing.ContentAlignment.MiddleRight
        Me.LabelParameterFile.Location = New System.Drawing.Point(184, 16)
        Me.LabelParameterFile.Name = "LabelParameterFile"
        Me.LabelParameterFile.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.LabelParameterFile.Size = New System.Drawing.Size(79, 13)
        Me.LabelParameterFile.TabIndex = 103
        Me.LabelParameterFile.Text = "No File Loaded"
        Me.LabelParameterFile.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'LabelPortAddress
        '
        Me.LabelPortAddress.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LabelPortAddress.Location = New System.Drawing.Point(8, 352)
        Me.LabelPortAddress.Name = "LabelPortAddress"
        Me.LabelPortAddress.Size = New System.Drawing.Size(85, 20)
        Me.LabelPortAddress.TabIndex = 102
        Me.LabelPortAddress.Text = "Connection"
        Me.LabelPortAddress.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        Me.ToolTip1.SetToolTip(Me.LabelPortAddress, resources.GetString("LabelPortAddress.ToolTip"))
        '
        'CheckBoxHomeDirM6
        '
        Me.CheckBoxHomeDirM6.AutoSize = True
        Me.CheckBoxHomeDirM6.Checked = True
        Me.CheckBoxHomeDirM6.CheckState = System.Windows.Forms.CheckState.Checked
        Me.CheckBoxHomeDirM6.Location = New System.Drawing.Point(632, 160)
        Me.CheckBoxHomeDirM6.Name = "CheckBoxHomeDirM6"
        Me.CheckBoxHomeDirM6.Size = New System.Drawing.Size(66, 17)
        Me.CheckBoxHomeDirM6.TabIndex = 315
        Me.CheckBoxHomeDirM6.Text = "Reverse"
        Me.CheckBoxHomeDirM6.UseVisualStyleBackColor = True
        '
        'TextBoxBacklashM6
        '
        Me.TextBoxBacklashM6.Location = New System.Drawing.Point(616, 328)
        Me.TextBoxBacklashM6.Name = "TextBoxBacklashM6"
        Me.TextBoxBacklashM6.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxBacklashM6.TabIndex = 323
        '
        'TextBoxSlopeM6
        '
        Me.TextBoxSlopeM6.Location = New System.Drawing.Point(616, 304)
        Me.TextBoxSlopeM6.Name = "TextBoxSlopeM6"
        Me.TextBoxSlopeM6.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxSlopeM6.TabIndex = 321
        '
        'TextBoxMaxSpeedM6
        '
        Me.TextBoxMaxSpeedM6.Location = New System.Drawing.Point(616, 280)
        Me.TextBoxMaxSpeedM6.Name = "TextBoxMaxSpeedM6"
        Me.TextBoxMaxSpeedM6.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxMaxSpeedM6.TabIndex = 320
        '
        'TextBoxMinSpeedM6
        '
        Me.TextBoxMinSpeedM6.Location = New System.Drawing.Point(616, 256)
        Me.TextBoxMinSpeedM6.Name = "TextBoxMinSpeedM6"
        Me.TextBoxMinSpeedM6.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxMinSpeedM6.TabIndex = 319
        '
        'TextBoxLimitRM6
        '
        Me.TextBoxLimitRM6.Location = New System.Drawing.Point(616, 232)
        Me.TextBoxLimitRM6.Name = "TextBoxLimitRM6"
        Me.TextBoxLimitRM6.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxLimitRM6.TabIndex = 318
        '
        'TextBoxLimitFM6
        '
        Me.TextBoxLimitFM6.Location = New System.Drawing.Point(616, 208)
        Me.TextBoxLimitFM6.Name = "TextBoxLimitFM6"
        Me.TextBoxLimitFM6.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxLimitFM6.TabIndex = 317
        '
        'TextBoxHomeOffsetM6
        '
        Me.TextBoxHomeOffsetM6.Location = New System.Drawing.Point(616, 184)
        Me.TextBoxHomeOffsetM6.Name = "TextBoxHomeOffsetM6"
        Me.TextBoxHomeOffsetM6.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxHomeOffsetM6.TabIndex = 316
        '
        'TextBoxUnitValueM6
        '
        Me.TextBoxUnitValueM6.Location = New System.Drawing.Point(616, 136)
        Me.TextBoxUnitValueM6.Name = "TextBoxUnitValueM6"
        Me.TextBoxUnitValueM6.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxUnitValueM6.TabIndex = 314
        '
        'TextBoxUnitNameM6
        '
        Me.TextBoxUnitNameM6.Location = New System.Drawing.Point(616, 112)
        Me.TextBoxUnitNameM6.Name = "TextBoxUnitNameM6"
        Me.TextBoxUnitNameM6.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxUnitNameM6.TabIndex = 313
        '
        'TextBoxPositionPM6
        '
        Me.TextBoxPositionPM6.Location = New System.Drawing.Point(616, 88)
        Me.TextBoxPositionPM6.Name = "TextBoxPositionPM6"
        Me.TextBoxPositionPM6.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxPositionPM6.TabIndex = 312
        '
        'CheckBoxHomeDirM5
        '
        Me.CheckBoxHomeDirM5.AutoSize = True
        Me.CheckBoxHomeDirM5.Checked = True
        Me.CheckBoxHomeDirM5.CheckState = System.Windows.Forms.CheckState.Checked
        Me.CheckBoxHomeDirM5.Location = New System.Drawing.Point(528, 160)
        Me.CheckBoxHomeDirM5.Name = "CheckBoxHomeDirM5"
        Me.CheckBoxHomeDirM5.Size = New System.Drawing.Size(66, 17)
        Me.CheckBoxHomeDirM5.TabIndex = 295
        Me.CheckBoxHomeDirM5.Text = "Reverse"
        Me.CheckBoxHomeDirM5.UseVisualStyleBackColor = True
        '
        'TextBoxBacklashM5
        '
        Me.TextBoxBacklashM5.Location = New System.Drawing.Point(512, 328)
        Me.TextBoxBacklashM5.Name = "TextBoxBacklashM5"
        Me.TextBoxBacklashM5.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxBacklashM5.TabIndex = 302
        '
        'TextBoxSlopeM5
        '
        Me.TextBoxSlopeM5.Location = New System.Drawing.Point(512, 304)
        Me.TextBoxSlopeM5.Name = "TextBoxSlopeM5"
        Me.TextBoxSlopeM5.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxSlopeM5.TabIndex = 301
        '
        'TextBoxMaxSpeedM5
        '
        Me.TextBoxMaxSpeedM5.Location = New System.Drawing.Point(512, 280)
        Me.TextBoxMaxSpeedM5.Name = "TextBoxMaxSpeedM5"
        Me.TextBoxMaxSpeedM5.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxMaxSpeedM5.TabIndex = 300
        '
        'TextBoxMinSpeedM5
        '
        Me.TextBoxMinSpeedM5.Location = New System.Drawing.Point(512, 256)
        Me.TextBoxMinSpeedM5.Name = "TextBoxMinSpeedM5"
        Me.TextBoxMinSpeedM5.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxMinSpeedM5.TabIndex = 299
        '
        'TextBoxLimitRM5
        '
        Me.TextBoxLimitRM5.Location = New System.Drawing.Point(512, 232)
        Me.TextBoxLimitRM5.Name = "TextBoxLimitRM5"
        Me.TextBoxLimitRM5.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxLimitRM5.TabIndex = 298
        '
        'TextBoxLimitFM5
        '
        Me.TextBoxLimitFM5.Location = New System.Drawing.Point(512, 208)
        Me.TextBoxLimitFM5.Name = "TextBoxLimitFM5"
        Me.TextBoxLimitFM5.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxLimitFM5.TabIndex = 297
        '
        'TextBoxHomeOffsetM5
        '
        Me.TextBoxHomeOffsetM5.Location = New System.Drawing.Point(512, 184)
        Me.TextBoxHomeOffsetM5.Name = "TextBoxHomeOffsetM5"
        Me.TextBoxHomeOffsetM5.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxHomeOffsetM5.TabIndex = 296
        '
        'TextBoxUnitValueM5
        '
        Me.TextBoxUnitValueM5.Location = New System.Drawing.Point(512, 136)
        Me.TextBoxUnitValueM5.Name = "TextBoxUnitValueM5"
        Me.TextBoxUnitValueM5.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxUnitValueM5.TabIndex = 294
        '
        'TextBoxUnitNameM5
        '
        Me.TextBoxUnitNameM5.Location = New System.Drawing.Point(512, 112)
        Me.TextBoxUnitNameM5.Name = "TextBoxUnitNameM5"
        Me.TextBoxUnitNameM5.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxUnitNameM5.TabIndex = 293
        '
        'TextBoxPositionPM5
        '
        Me.TextBoxPositionPM5.Location = New System.Drawing.Point(512, 88)
        Me.TextBoxPositionPM5.Name = "TextBoxPositionPM5"
        Me.TextBoxPositionPM5.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxPositionPM5.TabIndex = 292
        '
        'CheckBoxHomeDirM4
        '
        Me.CheckBoxHomeDirM4.AutoSize = True
        Me.CheckBoxHomeDirM4.Checked = True
        Me.CheckBoxHomeDirM4.CheckState = System.Windows.Forms.CheckState.Checked
        Me.CheckBoxHomeDirM4.Location = New System.Drawing.Point(424, 160)
        Me.CheckBoxHomeDirM4.Name = "CheckBoxHomeDirM4"
        Me.CheckBoxHomeDirM4.Size = New System.Drawing.Size(66, 17)
        Me.CheckBoxHomeDirM4.TabIndex = 275
        Me.CheckBoxHomeDirM4.Text = "Reverse"
        Me.CheckBoxHomeDirM4.UseVisualStyleBackColor = True
        '
        'TextBoxBacklashM4
        '
        Me.TextBoxBacklashM4.Location = New System.Drawing.Point(408, 328)
        Me.TextBoxBacklashM4.Name = "TextBoxBacklashM4"
        Me.TextBoxBacklashM4.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxBacklashM4.TabIndex = 282
        '
        'TextBoxSlopeM4
        '
        Me.TextBoxSlopeM4.Location = New System.Drawing.Point(408, 304)
        Me.TextBoxSlopeM4.Name = "TextBoxSlopeM4"
        Me.TextBoxSlopeM4.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxSlopeM4.TabIndex = 281
        '
        'TextBoxMaxSpeedM4
        '
        Me.TextBoxMaxSpeedM4.Location = New System.Drawing.Point(408, 280)
        Me.TextBoxMaxSpeedM4.Name = "TextBoxMaxSpeedM4"
        Me.TextBoxMaxSpeedM4.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxMaxSpeedM4.TabIndex = 280
        '
        'TextBoxMinSpeedM4
        '
        Me.TextBoxMinSpeedM4.Location = New System.Drawing.Point(408, 256)
        Me.TextBoxMinSpeedM4.Name = "TextBoxMinSpeedM4"
        Me.TextBoxMinSpeedM4.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxMinSpeedM4.TabIndex = 279
        '
        'TextBoxLimitRM4
        '
        Me.TextBoxLimitRM4.Location = New System.Drawing.Point(408, 232)
        Me.TextBoxLimitRM4.Name = "TextBoxLimitRM4"
        Me.TextBoxLimitRM4.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxLimitRM4.TabIndex = 278
        '
        'TextBoxLimitFM4
        '
        Me.TextBoxLimitFM4.Location = New System.Drawing.Point(408, 208)
        Me.TextBoxLimitFM4.Name = "TextBoxLimitFM4"
        Me.TextBoxLimitFM4.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxLimitFM4.TabIndex = 277
        '
        'TextBoxHomeOffsetM4
        '
        Me.TextBoxHomeOffsetM4.Location = New System.Drawing.Point(408, 184)
        Me.TextBoxHomeOffsetM4.Name = "TextBoxHomeOffsetM4"
        Me.TextBoxHomeOffsetM4.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxHomeOffsetM4.TabIndex = 276
        '
        'TextBoxUnitValueM4
        '
        Me.TextBoxUnitValueM4.Location = New System.Drawing.Point(408, 136)
        Me.TextBoxUnitValueM4.Name = "TextBoxUnitValueM4"
        Me.TextBoxUnitValueM4.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxUnitValueM4.TabIndex = 274
        '
        'TextBoxUnitNameM4
        '
        Me.TextBoxUnitNameM4.Location = New System.Drawing.Point(408, 112)
        Me.TextBoxUnitNameM4.Name = "TextBoxUnitNameM4"
        Me.TextBoxUnitNameM4.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxUnitNameM4.TabIndex = 273
        '
        'TextBoxPositionPM4
        '
        Me.TextBoxPositionPM4.Location = New System.Drawing.Point(408, 88)
        Me.TextBoxPositionPM4.Name = "TextBoxPositionPM4"
        Me.TextBoxPositionPM4.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxPositionPM4.TabIndex = 272
        '
        'CheckBoxHomeDirM3
        '
        Me.CheckBoxHomeDirM3.AutoSize = True
        Me.CheckBoxHomeDirM3.Checked = True
        Me.CheckBoxHomeDirM3.CheckState = System.Windows.Forms.CheckState.Checked
        Me.CheckBoxHomeDirM3.Location = New System.Drawing.Point(320, 160)
        Me.CheckBoxHomeDirM3.Name = "CheckBoxHomeDirM3"
        Me.CheckBoxHomeDirM3.Size = New System.Drawing.Size(66, 17)
        Me.CheckBoxHomeDirM3.TabIndex = 255
        Me.CheckBoxHomeDirM3.Text = "Reverse"
        Me.CheckBoxHomeDirM3.UseVisualStyleBackColor = True
        '
        'TextBoxBacklashM3
        '
        Me.TextBoxBacklashM3.Location = New System.Drawing.Point(304, 328)
        Me.TextBoxBacklashM3.Name = "TextBoxBacklashM3"
        Me.TextBoxBacklashM3.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxBacklashM3.TabIndex = 262
        '
        'TextBoxSlopeM3
        '
        Me.TextBoxSlopeM3.Location = New System.Drawing.Point(304, 304)
        Me.TextBoxSlopeM3.Name = "TextBoxSlopeM3"
        Me.TextBoxSlopeM3.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxSlopeM3.TabIndex = 261
        '
        'TextBoxMaxSpeedM3
        '
        Me.TextBoxMaxSpeedM3.Location = New System.Drawing.Point(304, 280)
        Me.TextBoxMaxSpeedM3.Name = "TextBoxMaxSpeedM3"
        Me.TextBoxMaxSpeedM3.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxMaxSpeedM3.TabIndex = 260
        '
        'TextBoxMinSpeedM3
        '
        Me.TextBoxMinSpeedM3.Location = New System.Drawing.Point(304, 256)
        Me.TextBoxMinSpeedM3.Name = "TextBoxMinSpeedM3"
        Me.TextBoxMinSpeedM3.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxMinSpeedM3.TabIndex = 259
        '
        'TextBoxLimitRM3
        '
        Me.TextBoxLimitRM3.Location = New System.Drawing.Point(304, 232)
        Me.TextBoxLimitRM3.Name = "TextBoxLimitRM3"
        Me.TextBoxLimitRM3.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxLimitRM3.TabIndex = 258
        '
        'TextBoxLimitFM3
        '
        Me.TextBoxLimitFM3.Location = New System.Drawing.Point(304, 208)
        Me.TextBoxLimitFM3.Name = "TextBoxLimitFM3"
        Me.TextBoxLimitFM3.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxLimitFM3.TabIndex = 257
        '
        'TextBoxHomeOffsetM3
        '
        Me.TextBoxHomeOffsetM3.Location = New System.Drawing.Point(304, 184)
        Me.TextBoxHomeOffsetM3.Name = "TextBoxHomeOffsetM3"
        Me.TextBoxHomeOffsetM3.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxHomeOffsetM3.TabIndex = 256
        '
        'TextBoxUnitValueM3
        '
        Me.TextBoxUnitValueM3.Location = New System.Drawing.Point(304, 136)
        Me.TextBoxUnitValueM3.Name = "TextBoxUnitValueM3"
        Me.TextBoxUnitValueM3.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxUnitValueM3.TabIndex = 254
        '
        'TextBoxUnitNameM3
        '
        Me.TextBoxUnitNameM3.Location = New System.Drawing.Point(304, 112)
        Me.TextBoxUnitNameM3.Name = "TextBoxUnitNameM3"
        Me.TextBoxUnitNameM3.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxUnitNameM3.TabIndex = 253
        '
        'TextBoxPositionPM3
        '
        Me.TextBoxPositionPM3.Location = New System.Drawing.Point(304, 88)
        Me.TextBoxPositionPM3.Name = "TextBoxPositionPM3"
        Me.TextBoxPositionPM3.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxPositionPM3.TabIndex = 252
        '
        'CheckBoxHomeDirM2
        '
        Me.CheckBoxHomeDirM2.AutoSize = True
        Me.CheckBoxHomeDirM2.Checked = True
        Me.CheckBoxHomeDirM2.CheckState = System.Windows.Forms.CheckState.Checked
        Me.CheckBoxHomeDirM2.Location = New System.Drawing.Point(216, 160)
        Me.CheckBoxHomeDirM2.Name = "CheckBoxHomeDirM2"
        Me.CheckBoxHomeDirM2.Size = New System.Drawing.Size(66, 17)
        Me.CheckBoxHomeDirM2.TabIndex = 236
        Me.CheckBoxHomeDirM2.Text = "Reverse"
        Me.CheckBoxHomeDirM2.UseVisualStyleBackColor = True
        '
        'TextBoxBacklashM2
        '
        Me.TextBoxBacklashM2.Location = New System.Drawing.Point(200, 328)
        Me.TextBoxBacklashM2.Name = "TextBoxBacklashM2"
        Me.TextBoxBacklashM2.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxBacklashM2.TabIndex = 243
        '
        'TextBoxSlopeM2
        '
        Me.TextBoxSlopeM2.Location = New System.Drawing.Point(200, 304)
        Me.TextBoxSlopeM2.Name = "TextBoxSlopeM2"
        Me.TextBoxSlopeM2.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxSlopeM2.TabIndex = 242
        '
        'TextBoxMaxSpeedM2
        '
        Me.TextBoxMaxSpeedM2.Location = New System.Drawing.Point(200, 280)
        Me.TextBoxMaxSpeedM2.Name = "TextBoxMaxSpeedM2"
        Me.TextBoxMaxSpeedM2.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxMaxSpeedM2.TabIndex = 241
        '
        'TextBoxMinSpeedM2
        '
        Me.TextBoxMinSpeedM2.Location = New System.Drawing.Point(200, 256)
        Me.TextBoxMinSpeedM2.Name = "TextBoxMinSpeedM2"
        Me.TextBoxMinSpeedM2.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxMinSpeedM2.TabIndex = 240
        '
        'TextBoxLimitRM2
        '
        Me.TextBoxLimitRM2.Location = New System.Drawing.Point(200, 232)
        Me.TextBoxLimitRM2.Name = "TextBoxLimitRM2"
        Me.TextBoxLimitRM2.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxLimitRM2.TabIndex = 239
        '
        'TextBoxLimitFM2
        '
        Me.TextBoxLimitFM2.Location = New System.Drawing.Point(200, 208)
        Me.TextBoxLimitFM2.Name = "TextBoxLimitFM2"
        Me.TextBoxLimitFM2.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxLimitFM2.TabIndex = 238
        '
        'TextBoxHomeOffsetM2
        '
        Me.TextBoxHomeOffsetM2.Location = New System.Drawing.Point(200, 184)
        Me.TextBoxHomeOffsetM2.Name = "TextBoxHomeOffsetM2"
        Me.TextBoxHomeOffsetM2.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxHomeOffsetM2.TabIndex = 237
        '
        'TextBoxUnitValueM2
        '
        Me.TextBoxUnitValueM2.Location = New System.Drawing.Point(200, 136)
        Me.TextBoxUnitValueM2.Name = "TextBoxUnitValueM2"
        Me.TextBoxUnitValueM2.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxUnitValueM2.TabIndex = 235
        '
        'TextBoxUnitNameM2
        '
        Me.TextBoxUnitNameM2.Location = New System.Drawing.Point(200, 113)
        Me.TextBoxUnitNameM2.Name = "TextBoxUnitNameM2"
        Me.TextBoxUnitNameM2.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxUnitNameM2.TabIndex = 234
        '
        'TextBoxPositionPM2
        '
        Me.TextBoxPositionPM2.Location = New System.Drawing.Point(200, 88)
        Me.TextBoxPositionPM2.Name = "TextBoxPositionPM2"
        Me.TextBoxPositionPM2.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxPositionPM2.TabIndex = 232
        '
        'GroupBoxStepType
        '
        Me.GroupBoxStepType.Controls.Add(Me.RadioButtonDouble)
        Me.GroupBoxStepType.Controls.Add(Me.RadioButtonSingle)
        Me.GroupBoxStepType.Controls.Add(Me.RadioButtonHalf)
        Me.GroupBoxStepType.Location = New System.Drawing.Point(448, 384)
        Me.GroupBoxStepType.Name = "GroupBoxStepType"
        Me.GroupBoxStepType.Size = New System.Drawing.Size(264, 40)
        Me.GroupBoxStepType.TabIndex = 43
        Me.GroupBoxStepType.TabStop = False
        Me.GroupBoxStepType.Text = "Step Type"
        Me.ToolTip1.SetToolTip(Me.GroupBoxStepType, "Motor phase energization pattern." & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "Use Half for normal operation." & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "Full step mode" & _
                "s will result in larger step angles.")
        '
        'RadioButtonDouble
        '
        Me.RadioButtonDouble.AutoSize = True
        Me.RadioButtonDouble.Location = New System.Drawing.Point(176, 16)
        Me.RadioButtonDouble.Name = "RadioButtonDouble"
        Me.RadioButtonDouble.Size = New System.Drawing.Size(78, 17)
        Me.RadioButtonDouble.TabIndex = 365
        Me.RadioButtonDouble.TabStop = True
        Me.RadioButtonDouble.Text = "Full Double"
        Me.RadioButtonDouble.UseVisualStyleBackColor = True
        '
        'RadioButtonSingle
        '
        Me.RadioButtonSingle.AutoSize = True
        Me.RadioButtonSingle.Location = New System.Drawing.Point(80, 16)
        Me.RadioButtonSingle.Name = "RadioButtonSingle"
        Me.RadioButtonSingle.Size = New System.Drawing.Size(73, 17)
        Me.RadioButtonSingle.TabIndex = 364
        Me.RadioButtonSingle.TabStop = True
        Me.RadioButtonSingle.Text = "Full Single"
        Me.RadioButtonSingle.UseVisualStyleBackColor = True
        '
        'RadioButtonHalf
        '
        Me.RadioButtonHalf.AutoSize = True
        Me.RadioButtonHalf.Location = New System.Drawing.Point(16, 16)
        Me.RadioButtonHalf.Name = "RadioButtonHalf"
        Me.RadioButtonHalf.Size = New System.Drawing.Size(44, 17)
        Me.RadioButtonHalf.TabIndex = 363
        Me.RadioButtonHalf.TabStop = True
        Me.RadioButtonHalf.Text = "Half"
        Me.RadioButtonHalf.UseVisualStyleBackColor = True
        '
        'GroupBoxMoveType
        '
        Me.GroupBoxMoveType.Controls.Add(Me.RadioButtonRelative)
        Me.GroupBoxMoveType.Controls.Add(Me.RadioButtonAbsolute)
        Me.GroupBoxMoveType.Location = New System.Drawing.Point(256, 384)
        Me.GroupBoxMoveType.Name = "GroupBoxMoveType"
        Me.GroupBoxMoveType.Size = New System.Drawing.Size(176, 40)
        Me.GroupBoxMoveType.TabIndex = 42
        Me.GroupBoxMoveType.TabStop = False
        Me.GroupBoxMoveType.Text = "Move Type"
        Me.ToolTip1.SetToolTip(Me.GroupBoxMoveType, "Determines if target position is relative to the" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "current position or an absolute" & _
                " position.")
        '
        'RadioButtonRelative
        '
        Me.RadioButtonRelative.AutoSize = True
        Me.RadioButtonRelative.Location = New System.Drawing.Point(104, 16)
        Me.RadioButtonRelative.Name = "RadioButtonRelative"
        Me.RadioButtonRelative.Size = New System.Drawing.Size(64, 17)
        Me.RadioButtonRelative.TabIndex = 362
        Me.RadioButtonRelative.TabStop = True
        Me.RadioButtonRelative.Text = "Relative"
        Me.RadioButtonRelative.UseVisualStyleBackColor = True
        '
        'RadioButtonAbsolute
        '
        Me.RadioButtonAbsolute.AutoSize = True
        Me.RadioButtonAbsolute.Location = New System.Drawing.Point(8, 16)
        Me.RadioButtonAbsolute.Name = "RadioButtonAbsolute"
        Me.RadioButtonAbsolute.Size = New System.Drawing.Size(66, 17)
        Me.RadioButtonAbsolute.TabIndex = 361
        Me.RadioButtonAbsolute.TabStop = True
        Me.RadioButtonAbsolute.Text = "Absolute"
        Me.RadioButtonAbsolute.UseVisualStyleBackColor = True
        '
        'CheckBoxHold
        '
        Me.CheckBoxHold.AutoSize = True
        Me.CheckBoxHold.Location = New System.Drawing.Point(96, 400)
        Me.CheckBoxHold.Name = "CheckBoxHold"
        Me.CheckBoxHold.Size = New System.Drawing.Size(143, 17)
        Me.CheckBoxHold.TabIndex = 360
        Me.CheckBoxHold.Text = "Hold Motors After Moves"
        Me.ToolTip1.SetToolTip(Me.CheckBoxHold, "Set to hold power on motor after motion is done." & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "Will retain holding torque but " & _
                "cause heat." & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "See also Standby Mode.")
        Me.CheckBoxHold.UseVisualStyleBackColor = True
        '
        'CheckBoxHomeDirM1
        '
        Me.CheckBoxHomeDirM1.AutoSize = True
        Me.CheckBoxHomeDirM1.Checked = True
        Me.CheckBoxHomeDirM1.CheckState = System.Windows.Forms.CheckState.Checked
        Me.CheckBoxHomeDirM1.Location = New System.Drawing.Point(112, 160)
        Me.CheckBoxHomeDirM1.Name = "CheckBoxHomeDirM1"
        Me.CheckBoxHomeDirM1.Size = New System.Drawing.Size(66, 17)
        Me.CheckBoxHomeDirM1.TabIndex = 214
        Me.CheckBoxHomeDirM1.Text = "Reverse"
        Me.CheckBoxHomeDirM1.UseVisualStyleBackColor = True
        '
        'TextBoxMotorNameM6
        '
        Me.TextBoxMotorNameM6.Location = New System.Drawing.Point(616, 64)
        Me.TextBoxMotorNameM6.Name = "TextBoxMotorNameM6"
        Me.TextBoxMotorNameM6.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxMotorNameM6.TabIndex = 311
        '
        'TextBoxMotorNameM5
        '
        Me.TextBoxMotorNameM5.Location = New System.Drawing.Point(512, 64)
        Me.TextBoxMotorNameM5.Name = "TextBoxMotorNameM5"
        Me.TextBoxMotorNameM5.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxMotorNameM5.TabIndex = 291
        '
        'TextBoxMotorNameM4
        '
        Me.TextBoxMotorNameM4.Location = New System.Drawing.Point(408, 64)
        Me.TextBoxMotorNameM4.Name = "TextBoxMotorNameM4"
        Me.TextBoxMotorNameM4.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxMotorNameM4.TabIndex = 271
        '
        'TextBoxMotorNameM3
        '
        Me.TextBoxMotorNameM3.Location = New System.Drawing.Point(304, 64)
        Me.TextBoxMotorNameM3.Name = "TextBoxMotorNameM3"
        Me.TextBoxMotorNameM3.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxMotorNameM3.TabIndex = 251
        '
        'TextBoxMotorNameM2
        '
        Me.TextBoxMotorNameM2.Location = New System.Drawing.Point(200, 64)
        Me.TextBoxMotorNameM2.Name = "TextBoxMotorNameM2"
        Me.TextBoxMotorNameM2.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxMotorNameM2.TabIndex = 231
        '
        'ButtonSaveParameters
        '
        Me.ButtonSaveParameters.Location = New System.Drawing.Point(64, 8)
        Me.ButtonSaveParameters.Name = "ButtonSaveParameters"
        Me.ButtonSaveParameters.Size = New System.Drawing.Size(48, 23)
        Me.ButtonSaveParameters.TabIndex = 202
        Me.ButtonSaveParameters.Text = "Save"
        Me.ButtonSaveParameters.UseVisualStyleBackColor = True
        '
        'ButtonLoadParameters
        '
        Me.ButtonLoadParameters.Location = New System.Drawing.Point(8, 8)
        Me.ButtonLoadParameters.Name = "ButtonLoadParameters"
        Me.ButtonLoadParameters.Size = New System.Drawing.Size(48, 23)
        Me.ButtonLoadParameters.TabIndex = 201
        Me.ButtonLoadParameters.Text = "Load"
        Me.ButtonLoadParameters.UseVisualStyleBackColor = True
        '
        'TextBoxBacklashM1
        '
        Me.TextBoxBacklashM1.Location = New System.Drawing.Point(96, 328)
        Me.TextBoxBacklashM1.Name = "TextBoxBacklashM1"
        Me.TextBoxBacklashM1.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxBacklashM1.TabIndex = 221
        '
        'TextBoxSlopeM1
        '
        Me.TextBoxSlopeM1.Location = New System.Drawing.Point(96, 304)
        Me.TextBoxSlopeM1.Name = "TextBoxSlopeM1"
        Me.TextBoxSlopeM1.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxSlopeM1.TabIndex = 220
        '
        'TextBoxMaxSpeedM1
        '
        Me.TextBoxMaxSpeedM1.Location = New System.Drawing.Point(96, 280)
        Me.TextBoxMaxSpeedM1.Name = "TextBoxMaxSpeedM1"
        Me.TextBoxMaxSpeedM1.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxMaxSpeedM1.TabIndex = 219
        '
        'TextBoxMinSpeedM1
        '
        Me.TextBoxMinSpeedM1.Location = New System.Drawing.Point(96, 256)
        Me.TextBoxMinSpeedM1.Name = "TextBoxMinSpeedM1"
        Me.TextBoxMinSpeedM1.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxMinSpeedM1.TabIndex = 218
        '
        'TextBoxLimitRM1
        '
        Me.TextBoxLimitRM1.Location = New System.Drawing.Point(96, 232)
        Me.TextBoxLimitRM1.Name = "TextBoxLimitRM1"
        Me.TextBoxLimitRM1.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxLimitRM1.TabIndex = 217
        '
        'TextBoxLimitFM1
        '
        Me.TextBoxLimitFM1.Location = New System.Drawing.Point(96, 208)
        Me.TextBoxLimitFM1.Name = "TextBoxLimitFM1"
        Me.TextBoxLimitFM1.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxLimitFM1.TabIndex = 216
        '
        'TextBoxHomeOffsetM1
        '
        Me.TextBoxHomeOffsetM1.Location = New System.Drawing.Point(96, 184)
        Me.TextBoxHomeOffsetM1.Name = "TextBoxHomeOffsetM1"
        Me.TextBoxHomeOffsetM1.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxHomeOffsetM1.TabIndex = 215
        '
        'TextBoxUnitValueM1
        '
        Me.TextBoxUnitValueM1.Location = New System.Drawing.Point(96, 136)
        Me.TextBoxUnitValueM1.Name = "TextBoxUnitValueM1"
        Me.TextBoxUnitValueM1.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxUnitValueM1.TabIndex = 213
        '
        'TextBoxUnitNameM1
        '
        Me.TextBoxUnitNameM1.Location = New System.Drawing.Point(96, 112)
        Me.TextBoxUnitNameM1.Name = "TextBoxUnitNameM1"
        Me.TextBoxUnitNameM1.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxUnitNameM1.TabIndex = 212
        '
        'TextBoxPositionPM1
        '
        Me.TextBoxPositionPM1.Location = New System.Drawing.Point(96, 88)
        Me.TextBoxPositionPM1.Name = "TextBoxPositionPM1"
        Me.TextBoxPositionPM1.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxPositionPM1.TabIndex = 211
        '
        'TextBoxMotorNameM1
        '
        Me.TextBoxMotorNameM1.Location = New System.Drawing.Point(96, 64)
        Me.TextBoxMotorNameM1.Name = "TextBoxMotorNameM1"
        Me.TextBoxMotorNameM1.Size = New System.Drawing.Size(100, 20)
        Me.TextBoxMotorNameM1.TabIndex = 210
        '
        'LabelUnitValue
        '
        Me.LabelUnitValue.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LabelUnitValue.ForeColor = System.Drawing.Color.FromArgb(CType(CType(0, Byte), Integer), CType(CType(0, Byte), Integer), CType(CType(192, Byte), Integer))
        Me.LabelUnitValue.Location = New System.Drawing.Point(8, 136)
        Me.LabelUnitValue.Name = "LabelUnitValue"
        Me.LabelUnitValue.Size = New System.Drawing.Size(85, 20)
        Me.LabelUnitValue.TabIndex = 17
        Me.LabelUnitValue.Text = "Unit Value"
        Me.LabelUnitValue.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        Me.ToolTip1.SetToolTip(Me.LabelUnitValue, resources.GetString("LabelUnitValue.ToolTip"))
        '
        'LabelUnitName
        '
        Me.LabelUnitName.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LabelUnitName.ForeColor = System.Drawing.Color.FromArgb(CType(CType(0, Byte), Integer), CType(CType(0, Byte), Integer), CType(CType(192, Byte), Integer))
        Me.LabelUnitName.Location = New System.Drawing.Point(8, 112)
        Me.LabelUnitName.Name = "LabelUnitName"
        Me.LabelUnitName.Size = New System.Drawing.Size(85, 20)
        Me.LabelUnitName.TabIndex = 16
        Me.LabelUnitName.Text = "Unit Name"
        Me.LabelUnitName.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        Me.ToolTip1.SetToolTip(Me.LabelUnitName, "Name of the positioning units set in" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "Unit Value." & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "Only used for display purposes" & _
                ".")
        '
        'LabelPosition
        '
        Me.LabelPosition.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LabelPosition.Location = New System.Drawing.Point(8, 88)
        Me.LabelPosition.Name = "LabelPosition"
        Me.LabelPosition.Size = New System.Drawing.Size(85, 20)
        Me.LabelPosition.TabIndex = 15
        Me.LabelPosition.Text = "Position"
        Me.LabelPosition.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        Me.ToolTip1.SetToolTip(Me.LabelPosition, "The current position of the motor in Units." & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "If Unit Value is set to 1, then posi" & _
                "tion is in motor steps.")
        '
        'LabelMotorName
        '
        Me.LabelMotorName.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LabelMotorName.Location = New System.Drawing.Point(8, 64)
        Me.LabelMotorName.Name = "LabelMotorName"
        Me.LabelMotorName.Size = New System.Drawing.Size(85, 20)
        Me.LabelMotorName.TabIndex = 14
        Me.LabelMotorName.Text = "Motor Name"
        Me.LabelMotorName.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        Me.ToolTip1.SetToolTip(Me.LabelMotorName, "User-defined motor name." & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "Used for display purposes only.")
        '
        'LabelSlope
        '
        Me.LabelSlope.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LabelSlope.ForeColor = System.Drawing.Color.Green
        Me.LabelSlope.Location = New System.Drawing.Point(8, 304)
        Me.LabelSlope.Name = "LabelSlope"
        Me.LabelSlope.Size = New System.Drawing.Size(85, 20)
        Me.LabelSlope.TabIndex = 13
        Me.LabelSlope.Text = "Slope"
        Me.LabelSlope.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        Me.ToolTip1.SetToolTip(Me.LabelSlope, resources.GetString("LabelSlope.ToolTip"))
        '
        'LabelMaxSpeed
        '
        Me.LabelMaxSpeed.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LabelMaxSpeed.ForeColor = System.Drawing.Color.Green
        Me.LabelMaxSpeed.Location = New System.Drawing.Point(8, 280)
        Me.LabelMaxSpeed.Name = "LabelMaxSpeed"
        Me.LabelMaxSpeed.Size = New System.Drawing.Size(85, 20)
        Me.LabelMaxSpeed.TabIndex = 12
        Me.LabelMaxSpeed.Text = "Max Speed"
        Me.LabelMaxSpeed.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        Me.ToolTip1.SetToolTip(Me.LabelMaxSpeed, resources.GetString("LabelMaxSpeed.ToolTip"))
        '
        'LabelMinSpeed
        '
        Me.LabelMinSpeed.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LabelMinSpeed.ForeColor = System.Drawing.Color.Green
        Me.LabelMinSpeed.Location = New System.Drawing.Point(8, 256)
        Me.LabelMinSpeed.Name = "LabelMinSpeed"
        Me.LabelMinSpeed.Size = New System.Drawing.Size(85, 20)
        Me.LabelMinSpeed.TabIndex = 11
        Me.LabelMinSpeed.Text = "Min Speed"
        Me.LabelMinSpeed.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        Me.ToolTip1.SetToolTip(Me.LabelMinSpeed, resources.GetString("LabelMinSpeed.ToolTip"))
        '
        'LabelLimitReverse
        '
        Me.LabelLimitReverse.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LabelLimitReverse.ForeColor = System.Drawing.Color.Purple
        Me.LabelLimitReverse.Location = New System.Drawing.Point(8, 232)
        Me.LabelLimitReverse.Name = "LabelLimitReverse"
        Me.LabelLimitReverse.Size = New System.Drawing.Size(85, 20)
        Me.LabelLimitReverse.TabIndex = 10
        Me.LabelLimitReverse.Text = "Limit Reverse"
        Me.LabelLimitReverse.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        Me.ToolTip1.SetToolTip(Me.LabelLimitReverse, "This is a software limit imposed on every move " & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "command.  The value is in Units." & _
                "  Useful for " & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "preventing mechanics from hitting their stop" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "due to incorrect mo" & _
                "vements.")
        '
        'LabelLimitForward
        '
        Me.LabelLimitForward.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LabelLimitForward.ForeColor = System.Drawing.Color.Purple
        Me.LabelLimitForward.Location = New System.Drawing.Point(8, 208)
        Me.LabelLimitForward.Name = "LabelLimitForward"
        Me.LabelLimitForward.Size = New System.Drawing.Size(85, 20)
        Me.LabelLimitForward.TabIndex = 9
        Me.LabelLimitForward.Text = "Limit Forward"
        Me.LabelLimitForward.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        Me.ToolTip1.SetToolTip(Me.LabelLimitForward, "This is a software limit imposed on every move " & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "command.  The value is in Units." & _
                "  Useful for " & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "preventing mechanics from hitting their stop" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "due to incorrect mo" & _
                "vements.")
        '
        'LabelHomeOffset
        '
        Me.LabelHomeOffset.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LabelHomeOffset.ForeColor = System.Drawing.Color.FromArgb(CType(CType(64, Byte), Integer), CType(CType(64, Byte), Integer), CType(CType(64, Byte), Integer))
        Me.LabelHomeOffset.Location = New System.Drawing.Point(8, 184)
        Me.LabelHomeOffset.Name = "LabelHomeOffset"
        Me.LabelHomeOffset.Size = New System.Drawing.Size(85, 20)
        Me.LabelHomeOffset.TabIndex = 8
        Me.LabelHomeOffset.Text = "Home Offset"
        Me.LabelHomeOffset.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        Me.ToolTip1.SetToolTip(Me.LabelHomeOffset, resources.GetString("LabelHomeOffset.ToolTip"))
        '
        'LabelHomeDirection
        '
        Me.LabelHomeDirection.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LabelHomeDirection.ForeColor = System.Drawing.Color.FromArgb(CType(CType(64, Byte), Integer), CType(CType(64, Byte), Integer), CType(CType(64, Byte), Integer))
        Me.LabelHomeDirection.Location = New System.Drawing.Point(8, 160)
        Me.LabelHomeDirection.Name = "LabelHomeDirection"
        Me.LabelHomeDirection.Size = New System.Drawing.Size(85, 20)
        Me.LabelHomeDirection.TabIndex = 7
        Me.LabelHomeDirection.Text = "Home Direction"
        Me.LabelHomeDirection.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        Me.ToolTip1.SetToolTip(Me.LabelHomeDirection, resources.GetString("LabelHomeDirection.ToolTip"))
        '
        'LabelBacklash
        '
        Me.LabelBacklash.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LabelBacklash.Location = New System.Drawing.Point(8, 328)
        Me.LabelBacklash.Name = "LabelBacklash"
        Me.LabelBacklash.Size = New System.Drawing.Size(85, 20)
        Me.LabelBacklash.TabIndex = 6
        Me.LabelBacklash.Text = "Backlash"
        Me.LabelBacklash.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        Me.ToolTip1.SetToolTip(Me.LabelBacklash, "The distance that is added to motor moves" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "when direction is changed to compensat" & _
                "e for" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "looseness in the mechanical system.")
        '
        'LabelMotor6
        '
        Me.LabelMotor6.AutoSize = True
        Me.LabelMotor6.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LabelMotor6.ForeColor = System.Drawing.Color.Maroon
        Me.LabelMotor6.Location = New System.Drawing.Point(640, 48)
        Me.LabelMotor6.Name = "LabelMotor6"
        Me.LabelMotor6.Size = New System.Drawing.Size(50, 13)
        Me.LabelMotor6.TabIndex = 5
        Me.LabelMotor6.Text = "Motor 6"
        Me.LabelMotor6.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'LabelMotor5
        '
        Me.LabelMotor5.AutoSize = True
        Me.LabelMotor5.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LabelMotor5.ForeColor = System.Drawing.Color.Maroon
        Me.LabelMotor5.Location = New System.Drawing.Point(536, 48)
        Me.LabelMotor5.Name = "LabelMotor5"
        Me.LabelMotor5.Size = New System.Drawing.Size(50, 13)
        Me.LabelMotor5.TabIndex = 4
        Me.LabelMotor5.Text = "Motor 5"
        Me.LabelMotor5.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'LabelMotor4
        '
        Me.LabelMotor4.AutoSize = True
        Me.LabelMotor4.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LabelMotor4.ForeColor = System.Drawing.Color.Maroon
        Me.LabelMotor4.Location = New System.Drawing.Point(432, 48)
        Me.LabelMotor4.Name = "LabelMotor4"
        Me.LabelMotor4.Size = New System.Drawing.Size(50, 13)
        Me.LabelMotor4.TabIndex = 3
        Me.LabelMotor4.Text = "Motor 4"
        Me.LabelMotor4.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'LabelMotor3
        '
        Me.LabelMotor3.AutoSize = True
        Me.LabelMotor3.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LabelMotor3.ForeColor = System.Drawing.Color.Maroon
        Me.LabelMotor3.Location = New System.Drawing.Point(328, 48)
        Me.LabelMotor3.Name = "LabelMotor3"
        Me.LabelMotor3.Size = New System.Drawing.Size(50, 13)
        Me.LabelMotor3.TabIndex = 2
        Me.LabelMotor3.Text = "Motor 3"
        Me.LabelMotor3.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'LabelMotor2
        '
        Me.LabelMotor2.AutoSize = True
        Me.LabelMotor2.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LabelMotor2.ForeColor = System.Drawing.Color.Maroon
        Me.LabelMotor2.Location = New System.Drawing.Point(224, 48)
        Me.LabelMotor2.Name = "LabelMotor2"
        Me.LabelMotor2.Size = New System.Drawing.Size(50, 13)
        Me.LabelMotor2.TabIndex = 1
        Me.LabelMotor2.Text = "Motor 2"
        Me.LabelMotor2.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'LabelMotor1
        '
        Me.LabelMotor1.AutoSize = True
        Me.LabelMotor1.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.LabelMotor1.ForeColor = System.Drawing.Color.Maroon
        Me.LabelMotor1.Location = New System.Drawing.Point(120, 48)
        Me.LabelMotor1.Name = "LabelMotor1"
        Me.LabelMotor1.Size = New System.Drawing.Size(50, 13)
        Me.LabelMotor1.TabIndex = 0
        Me.LabelMotor1.Text = "Motor 1"
        Me.LabelMotor1.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'TabProgram
        '
        Me.TabProgram.Controls.Add(Me.LabelCursor)
        Me.TabProgram.Controls.Add(Me.GroupBoxSequenceRun)
        Me.TabProgram.Controls.Add(Me.GroupBoxSequenceFile)
        Me.TabProgram.Controls.Add(Me.ButtonSequenceHelp)
        Me.TabProgram.Controls.Add(Me.LabelCursorLocation)
        Me.TabProgram.Controls.Add(Me.GroupBoxQuickRun)
        Me.TabProgram.Controls.Add(Me.LabelSequenceFile)
        Me.TabProgram.Controls.Add(Me.TextBoxSequence)
        Me.TabProgram.Location = New System.Drawing.Point(4, 22)
        Me.TabProgram.Name = "TabProgram"
        Me.TabProgram.Size = New System.Drawing.Size(720, 430)
        Me.TabProgram.TabIndex = 3
        Me.TabProgram.Text = "    Sequence    "
        Me.TabProgram.ToolTipText = "Edit a Program"
        Me.TabProgram.UseVisualStyleBackColor = True
        '
        'LabelCursor
        '
        Me.LabelCursor.Location = New System.Drawing.Point(24, 176)
        Me.LabelCursor.Name = "LabelCursor"
        Me.LabelCursor.Size = New System.Drawing.Size(48, 13)
        Me.LabelCursor.TabIndex = 0
        Me.LabelCursor.Text = "Cursor"
        Me.LabelCursor.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'GroupBoxSequenceRun
        '
        Me.GroupBoxSequenceRun.Controls.Add(Me.ButtonSequenceRunSelection)
        Me.GroupBoxSequenceRun.Controls.Add(Me.ButtonRunSequence)
        Me.GroupBoxSequenceRun.Controls.Add(Me.ButtonSequenceRunFrom)
        Me.GroupBoxSequenceRun.Location = New System.Drawing.Point(8, 40)
        Me.GroupBoxSequenceRun.Name = "GroupBoxSequenceRun"
        Me.GroupBoxSequenceRun.Size = New System.Drawing.Size(80, 120)
        Me.GroupBoxSequenceRun.TabIndex = 0
        Me.GroupBoxSequenceRun.TabStop = False
        Me.GroupBoxSequenceRun.Text = "Run"
        '
        'ButtonSequenceRunSelection
        '
        Me.ButtonSequenceRunSelection.Location = New System.Drawing.Point(8, 56)
        Me.ButtonSequenceRunSelection.Name = "ButtonSequenceRunSelection"
        Me.ButtonSequenceRunSelection.Size = New System.Drawing.Size(64, 23)
        Me.ButtonSequenceRunSelection.TabIndex = 2
        Me.ButtonSequenceRunSelection.Text = "Selection"
        Me.ToolTip1.SetToolTip(Me.ButtonSequenceRunSelection, "Run highlighted selection")
        Me.ButtonSequenceRunSelection.UseVisualStyleBackColor = True
        '
        'ButtonRunSequence
        '
        Me.ButtonRunSequence.BackColor = System.Drawing.Color.Transparent
        Me.ButtonRunSequence.Location = New System.Drawing.Point(8, 24)
        Me.ButtonRunSequence.Name = "ButtonRunSequence"
        Me.ButtonRunSequence.Size = New System.Drawing.Size(64, 23)
        Me.ButtonRunSequence.TabIndex = 1
        Me.ButtonRunSequence.Text = "Run"
        Me.ToolTip1.SetToolTip(Me.ButtonRunSequence, "Run from beginning")
        Me.ButtonRunSequence.UseVisualStyleBackColor = False
        '
        'ButtonSequenceRunFrom
        '
        Me.ButtonSequenceRunFrom.Location = New System.Drawing.Point(8, 88)
        Me.ButtonSequenceRunFrom.Name = "ButtonSequenceRunFrom"
        Me.ButtonSequenceRunFrom.Size = New System.Drawing.Size(64, 23)
        Me.ButtonSequenceRunFrom.TabIndex = 3
        Me.ButtonSequenceRunFrom.Text = "From"
        Me.ToolTip1.SetToolTip(Me.ButtonSequenceRunFrom, "Run from cursor location")
        Me.ButtonSequenceRunFrom.UseVisualStyleBackColor = True
        '
        'GroupBoxSequenceFile
        '
        Me.GroupBoxSequenceFile.Controls.Add(Me.ButtonLoadSequence)
        Me.GroupBoxSequenceFile.Controls.Add(Me.ButtonSaveSequence)
        Me.GroupBoxSequenceFile.Controls.Add(Me.ButtonSaveAsSequence)
        Me.GroupBoxSequenceFile.Location = New System.Drawing.Point(8, 232)
        Me.GroupBoxSequenceFile.Name = "GroupBoxSequenceFile"
        Me.GroupBoxSequenceFile.Size = New System.Drawing.Size(80, 120)
        Me.GroupBoxSequenceFile.TabIndex = 0
        Me.GroupBoxSequenceFile.TabStop = False
        Me.GroupBoxSequenceFile.Text = "File"
        '
        'ButtonLoadSequence
        '
        Me.ButtonLoadSequence.Location = New System.Drawing.Point(8, 24)
        Me.ButtonLoadSequence.Name = "ButtonLoadSequence"
        Me.ButtonLoadSequence.Size = New System.Drawing.Size(64, 24)
        Me.ButtonLoadSequence.TabIndex = 4
        Me.ButtonLoadSequence.Text = "Load"
        Me.ToolTip1.SetToolTip(Me.ButtonLoadSequence, "Load a sequence from disk")
        Me.ButtonLoadSequence.UseVisualStyleBackColor = True
        '
        'ButtonSaveSequence
        '
        Me.ButtonSaveSequence.BackColor = System.Drawing.Color.LightCoral
        Me.ButtonSaveSequence.ForeColor = System.Drawing.SystemColors.ControlText
        Me.ButtonSaveSequence.Location = New System.Drawing.Point(8, 56)
        Me.ButtonSaveSequence.Name = "ButtonSaveSequence"
        Me.ButtonSaveSequence.Size = New System.Drawing.Size(64, 23)
        Me.ButtonSaveSequence.TabIndex = 5
        Me.ButtonSaveSequence.Text = "Save"
        Me.ToolTip1.SetToolTip(Me.ButtonSaveSequence, "Save this sequence to disk" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "This button will be highlighted" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "if the sequence has " & _
                "been changed" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "and needs to be saved.")
        Me.ButtonSaveSequence.UseVisualStyleBackColor = False
        '
        'ButtonSaveAsSequence
        '
        Me.ButtonSaveAsSequence.Location = New System.Drawing.Point(8, 88)
        Me.ButtonSaveAsSequence.Name = "ButtonSaveAsSequence"
        Me.ButtonSaveAsSequence.Size = New System.Drawing.Size(64, 24)
        Me.ButtonSaveAsSequence.TabIndex = 6
        Me.ButtonSaveAsSequence.Text = "Save As"
        Me.ToolTip1.SetToolTip(Me.ButtonSaveAsSequence, "Save this sequence to disk As another name" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10))
        Me.ButtonSaveAsSequence.UseVisualStyleBackColor = True
        '
        'ButtonSequenceHelp
        '
        Me.ButtonSequenceHelp.Location = New System.Drawing.Point(16, 384)
        Me.ButtonSequenceHelp.Name = "ButtonSequenceHelp"
        Me.ButtonSequenceHelp.Size = New System.Drawing.Size(64, 23)
        Me.ButtonSequenceHelp.TabIndex = 7
        Me.ButtonSequenceHelp.Text = "Help"
        Me.ButtonSequenceHelp.UseVisualStyleBackColor = True
        '
        'LabelCursorLocation
        '
        Me.LabelCursorLocation.Location = New System.Drawing.Point(24, 192)
        Me.LabelCursorLocation.Name = "LabelCursorLocation"
        Me.LabelCursorLocation.Size = New System.Drawing.Size(48, 13)
        Me.LabelCursorLocation.TabIndex = 0
        Me.LabelCursorLocation.Text = "Location"
        Me.LabelCursorLocation.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        Me.ToolTip1.SetToolTip(Me.LabelCursorLocation, "Cursor Location")
        '
        'GroupBoxQuickRun
        '
        Me.GroupBoxQuickRun.Controls.Add(Me.ButtonQuickRun11)
        Me.GroupBoxQuickRun.Controls.Add(Me.ButtonQuickRun10)
        Me.GroupBoxQuickRun.Controls.Add(Me.ButtonQuickRun9)
        Me.GroupBoxQuickRun.Controls.Add(Me.ButtonQuickRun8)
        Me.GroupBoxQuickRun.Controls.Add(Me.ButtonQuickRun7)
        Me.GroupBoxQuickRun.Controls.Add(Me.ButtonQuickRun6)
        Me.GroupBoxQuickRun.Controls.Add(Me.ButtonQuickRun5)
        Me.GroupBoxQuickRun.Controls.Add(Me.ButtonQuickRun4)
        Me.GroupBoxQuickRun.Controls.Add(Me.ButtonQuickRun3)
        Me.GroupBoxQuickRun.Controls.Add(Me.ButtonQuickRun2)
        Me.GroupBoxQuickRun.Controls.Add(Me.ButtonQuickRun1)
        Me.GroupBoxQuickRun.Location = New System.Drawing.Point(632, 40)
        Me.GroupBoxQuickRun.Name = "GroupBoxQuickRun"
        Me.GroupBoxQuickRun.Size = New System.Drawing.Size(80, 385)
        Me.GroupBoxQuickRun.TabIndex = 0
        Me.GroupBoxQuickRun.TabStop = False
        Me.GroupBoxQuickRun.Text = "Quick Run"
        Me.ToolTip1.SetToolTip(Me.GroupBoxQuickRun, "Load and run a sequence.")
        '
        'ButtonQuickRun11
        '
        Me.ButtonQuickRun11.Location = New System.Drawing.Point(16, 344)
        Me.ButtonQuickRun11.Name = "ButtonQuickRun11"
        Me.ButtonQuickRun11.Size = New System.Drawing.Size(48, 23)
        Me.ButtonQuickRun11.TabIndex = 31
        Me.ButtonQuickRun11.Text = "11"
        Me.ToolTip1.SetToolTip(Me.ButtonQuickRun11, "Alt-F11 - Load and run md2xp11.bas")
        Me.ButtonQuickRun11.UseVisualStyleBackColor = True
        '
        'ButtonQuickRun10
        '
        Me.ButtonQuickRun10.Location = New System.Drawing.Point(16, 312)
        Me.ButtonQuickRun10.Name = "ButtonQuickRun10"
        Me.ButtonQuickRun10.Size = New System.Drawing.Size(48, 23)
        Me.ButtonQuickRun10.TabIndex = 30
        Me.ButtonQuickRun10.Text = "10"
        Me.ToolTip1.SetToolTip(Me.ButtonQuickRun10, "Alt-F10 - Load and run md2xp10.bas")
        Me.ButtonQuickRun10.UseVisualStyleBackColor = True
        '
        'ButtonQuickRun9
        '
        Me.ButtonQuickRun9.Location = New System.Drawing.Point(16, 280)
        Me.ButtonQuickRun9.Name = "ButtonQuickRun9"
        Me.ButtonQuickRun9.Size = New System.Drawing.Size(48, 23)
        Me.ButtonQuickRun9.TabIndex = 29
        Me.ButtonQuickRun9.Text = "9"
        Me.ToolTip1.SetToolTip(Me.ButtonQuickRun9, "Alt-F9 - Load and run md2xp9.bas")
        Me.ButtonQuickRun9.UseVisualStyleBackColor = True
        '
        'ButtonQuickRun8
        '
        Me.ButtonQuickRun8.Location = New System.Drawing.Point(16, 248)
        Me.ButtonQuickRun8.Name = "ButtonQuickRun8"
        Me.ButtonQuickRun8.Size = New System.Drawing.Size(48, 23)
        Me.ButtonQuickRun8.TabIndex = 28
        Me.ButtonQuickRun8.Text = "8"
        Me.ToolTip1.SetToolTip(Me.ButtonQuickRun8, "Alt-F8 - Load and run md2xp8.bas")
        Me.ButtonQuickRun8.UseVisualStyleBackColor = True
        '
        'ButtonQuickRun7
        '
        Me.ButtonQuickRun7.Location = New System.Drawing.Point(16, 216)
        Me.ButtonQuickRun7.Name = "ButtonQuickRun7"
        Me.ButtonQuickRun7.Size = New System.Drawing.Size(48, 23)
        Me.ButtonQuickRun7.TabIndex = 27
        Me.ButtonQuickRun7.Text = "7"
        Me.ToolTip1.SetToolTip(Me.ButtonQuickRun7, "Alt-F7 - Load and run md2xp7.bas")
        Me.ButtonQuickRun7.UseVisualStyleBackColor = True
        '
        'ButtonQuickRun6
        '
        Me.ButtonQuickRun6.Location = New System.Drawing.Point(16, 184)
        Me.ButtonQuickRun6.Name = "ButtonQuickRun6"
        Me.ButtonQuickRun6.Size = New System.Drawing.Size(48, 23)
        Me.ButtonQuickRun6.TabIndex = 26
        Me.ButtonQuickRun6.Text = "6"
        Me.ToolTip1.SetToolTip(Me.ButtonQuickRun6, "Alt-F6 - Load and run md2xp6.bas")
        Me.ButtonQuickRun6.UseVisualStyleBackColor = True
        '
        'ButtonQuickRun5
        '
        Me.ButtonQuickRun5.Location = New System.Drawing.Point(16, 152)
        Me.ButtonQuickRun5.Name = "ButtonQuickRun5"
        Me.ButtonQuickRun5.Size = New System.Drawing.Size(48, 23)
        Me.ButtonQuickRun5.TabIndex = 25
        Me.ButtonQuickRun5.Text = "5"
        Me.ToolTip1.SetToolTip(Me.ButtonQuickRun5, "Alt-F5 - Load and run md2xp5.bas")
        Me.ButtonQuickRun5.UseVisualStyleBackColor = True
        '
        'ButtonQuickRun4
        '
        Me.ButtonQuickRun4.Location = New System.Drawing.Point(16, 120)
        Me.ButtonQuickRun4.Name = "ButtonQuickRun4"
        Me.ButtonQuickRun4.Size = New System.Drawing.Size(48, 24)
        Me.ButtonQuickRun4.TabIndex = 24
        Me.ButtonQuickRun4.Text = "4"
        Me.ToolTip1.SetToolTip(Me.ButtonQuickRun4, "Alt-F4 - Load and run md2xp4.bas")
        Me.ButtonQuickRun4.UseVisualStyleBackColor = True
        '
        'ButtonQuickRun3
        '
        Me.ButtonQuickRun3.Location = New System.Drawing.Point(16, 88)
        Me.ButtonQuickRun3.Name = "ButtonQuickRun3"
        Me.ButtonQuickRun3.Size = New System.Drawing.Size(48, 23)
        Me.ButtonQuickRun3.TabIndex = 23
        Me.ButtonQuickRun3.Text = "3"
        Me.ToolTip1.SetToolTip(Me.ButtonQuickRun3, "Alt-F3 - Load and run md2xp3.bas")
        Me.ButtonQuickRun3.UseVisualStyleBackColor = True
        '
        'ButtonQuickRun2
        '
        Me.ButtonQuickRun2.Location = New System.Drawing.Point(16, 56)
        Me.ButtonQuickRun2.Name = "ButtonQuickRun2"
        Me.ButtonQuickRun2.Size = New System.Drawing.Size(48, 23)
        Me.ButtonQuickRun2.TabIndex = 22
        Me.ButtonQuickRun2.Text = "2"
        Me.ToolTip1.SetToolTip(Me.ButtonQuickRun2, "Alt-F2 - Load and run md2xp2.bas")
        Me.ButtonQuickRun2.UseVisualStyleBackColor = True
        '
        'ButtonQuickRun1
        '
        Me.ButtonQuickRun1.BackColor = System.Drawing.Color.SkyBlue
        Me.ButtonQuickRun1.Location = New System.Drawing.Point(16, 24)
        Me.ButtonQuickRun1.Name = "ButtonQuickRun1"
        Me.ButtonQuickRun1.Size = New System.Drawing.Size(48, 23)
        Me.ButtonQuickRun1.TabIndex = 21
        Me.ButtonQuickRun1.Text = "1"
        Me.ToolTip1.SetToolTip(Me.ButtonQuickRun1, "Alt-F1 - Load and run md2xp1.bas" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "This is the default sequence" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "loaded at start-u" & _
                "p")
        Me.ButtonQuickRun1.UseVisualStyleBackColor = False
        '
        'LabelSequenceFile
        '
        Me.LabelSequenceFile.Location = New System.Drawing.Point(8, 8)
        Me.LabelSequenceFile.Name = "LabelSequenceFile"
        Me.LabelSequenceFile.Size = New System.Drawing.Size(704, 24)
        Me.LabelSequenceFile.TabIndex = 0
        Me.LabelSequenceFile.Text = "No File Loaded" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & " "
        '
        'TextBoxSequence
        '
        Me.TextBoxSequence.Location = New System.Drawing.Point(96, 40)
        Me.TextBoxSequence.Multiline = True
        Me.TextBoxSequence.Name = "TextBoxSequence"
        Me.TextBoxSequence.ScrollBars = System.Windows.Forms.ScrollBars.Both
        Me.TextBoxSequence.Size = New System.Drawing.Size(531, 384)
        Me.TextBoxSequence.TabIndex = 8
        '
        'TabIO
        '
        Me.TabIO.Controls.Add(Me.ButtonIOHelp)
        Me.TabIO.Controls.Add(Me.GroupBoxMD23)
        Me.TabIO.Controls.Add(Me.GroupBoxMD22)
        Me.TabIO.Controls.Add(Me.GroupBoxMD21)
        Me.TabIO.Location = New System.Drawing.Point(4, 22)
        Me.TabIO.Name = "TabIO"
        Me.TabIO.Size = New System.Drawing.Size(720, 430)
        Me.TabIO.TabIndex = 2
        Me.TabIO.Text = "    I/O    "
        Me.TabIO.ToolTipText = "Control Inputs and Outputs"
        Me.TabIO.UseVisualStyleBackColor = True
        '
        'ButtonIOHelp
        '
        Me.ButtonIOHelp.Location = New System.Drawing.Point(336, 392)
        Me.ButtonIOHelp.Name = "ButtonIOHelp"
        Me.ButtonIOHelp.Size = New System.Drawing.Size(64, 24)
        Me.ButtonIOHelp.TabIndex = 5
        Me.ButtonIOHelp.Text = "&Help"
        Me.ButtonIOHelp.UseVisualStyleBackColor = True
        '
        'GroupBoxMD23
        '
        Me.GroupBoxMD23.Controls.Add(Me.CheckBoxOutput32)
        Me.GroupBoxMD23.Controls.Add(Me.Label30)
        Me.GroupBoxMD23.Controls.Add(Me.CheckBoxOutput31)
        Me.GroupBoxMD23.Controls.Add(Me.LabelInput35)
        Me.GroupBoxMD23.Controls.Add(Me.Label31)
        Me.GroupBoxMD23.Controls.Add(Me.LabelInput34)
        Me.GroupBoxMD23.Controls.Add(Me.Label32)
        Me.GroupBoxMD23.Controls.Add(Me.LabelInput33)
        Me.GroupBoxMD23.Controls.Add(Me.Label33)
        Me.GroupBoxMD23.Controls.Add(Me.LabelInput32)
        Me.GroupBoxMD23.Controls.Add(Me.Label34)
        Me.GroupBoxMD23.Controls.Add(Me.LabelInput31)
        Me.GroupBoxMD23.Location = New System.Drawing.Point(488, 32)
        Me.GroupBoxMD23.Name = "GroupBoxMD23"
        Me.GroupBoxMD23.Size = New System.Drawing.Size(160, 200)
        Me.GroupBoxMD23.TabIndex = 4
        Me.GroupBoxMD23.TabStop = False
        Me.GroupBoxMD23.Text = "MD2 #3"
        '
        'CheckBoxOutput32
        '
        Me.CheckBoxOutput32.AutoSize = True
        Me.CheckBoxOutput32.CheckAlign = System.Drawing.ContentAlignment.MiddleRight
        Me.CheckBoxOutput32.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.CheckBoxOutput32.Location = New System.Drawing.Point(48, 168)
        Me.CheckBoxOutput32.Name = "CheckBoxOutput32"
        Me.CheckBoxOutput32.Size = New System.Drawing.Size(87, 17)
        Me.CheckBoxOutput32.TabIndex = 16
        Me.CheckBoxOutput32.Text = "Output #2:"
        Me.CheckBoxOutput32.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        Me.CheckBoxOutput32.UseVisualStyleBackColor = True
        '
        'Label30
        '
        Me.Label30.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label30.Location = New System.Drawing.Point(8, 120)
        Me.Label30.Name = "Label30"
        Me.Label30.Size = New System.Drawing.Size(110, 13)
        Me.Label30.TabIndex = 19
        Me.Label30.Text = "Input #3:"
        Me.Label30.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'CheckBoxOutput31
        '
        Me.CheckBoxOutput31.AutoSize = True
        Me.CheckBoxOutput31.CheckAlign = System.Drawing.ContentAlignment.MiddleRight
        Me.CheckBoxOutput31.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.CheckBoxOutput31.Location = New System.Drawing.Point(48, 144)
        Me.CheckBoxOutput31.Name = "CheckBoxOutput31"
        Me.CheckBoxOutput31.Size = New System.Drawing.Size(87, 17)
        Me.CheckBoxOutput31.TabIndex = 15
        Me.CheckBoxOutput31.Text = "Output #1:"
        Me.CheckBoxOutput31.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        Me.CheckBoxOutput31.UseVisualStyleBackColor = True
        '
        'LabelInput35
        '
        Me.LabelInput35.AutoSize = True
        Me.LabelInput35.Location = New System.Drawing.Point(120, 120)
        Me.LabelInput35.Name = "LabelInput35"
        Me.LabelInput35.Size = New System.Drawing.Size(21, 13)
        Me.LabelInput35.TabIndex = 4
        Me.LabelInput35.Text = "Off"
        Me.LabelInput35.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'Label31
        '
        Me.Label31.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label31.Location = New System.Drawing.Point(8, 96)
        Me.Label31.Name = "Label31"
        Me.Label31.Size = New System.Drawing.Size(110, 13)
        Me.Label31.TabIndex = 18
        Me.Label31.Text = "Input #2:"
        Me.Label31.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'LabelInput34
        '
        Me.LabelInput34.AutoSize = True
        Me.LabelInput34.Location = New System.Drawing.Point(120, 96)
        Me.LabelInput34.Name = "LabelInput34"
        Me.LabelInput34.Size = New System.Drawing.Size(21, 13)
        Me.LabelInput34.TabIndex = 3
        Me.LabelInput34.Text = "Off"
        Me.LabelInput34.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'Label32
        '
        Me.Label32.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label32.Location = New System.Drawing.Point(8, 72)
        Me.Label32.Name = "Label32"
        Me.Label32.Size = New System.Drawing.Size(110, 13)
        Me.Label32.TabIndex = 17
        Me.Label32.Text = "Input #1:"
        Me.Label32.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'LabelInput33
        '
        Me.LabelInput33.AutoSize = True
        Me.LabelInput33.Location = New System.Drawing.Point(120, 72)
        Me.LabelInput33.Name = "LabelInput33"
        Me.LabelInput33.Size = New System.Drawing.Size(21, 13)
        Me.LabelInput33.TabIndex = 2
        Me.LabelInput33.Text = "Off"
        Me.LabelInput33.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'Label33
        '
        Me.Label33.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label33.Location = New System.Drawing.Point(8, 48)
        Me.Label33.Name = "Label33"
        Me.Label33.Size = New System.Drawing.Size(110, 13)
        Me.Label33.TabIndex = 16
        Me.Label33.Text = "Home Switch #2:"
        Me.Label33.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'LabelInput32
        '
        Me.LabelInput32.AutoSize = True
        Me.LabelInput32.Location = New System.Drawing.Point(120, 48)
        Me.LabelInput32.Name = "LabelInput32"
        Me.LabelInput32.Size = New System.Drawing.Size(21, 13)
        Me.LabelInput32.TabIndex = 1
        Me.LabelInput32.Text = "Off"
        Me.LabelInput32.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'Label34
        '
        Me.Label34.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label34.Location = New System.Drawing.Point(8, 24)
        Me.Label34.Name = "Label34"
        Me.Label34.Size = New System.Drawing.Size(110, 13)
        Me.Label34.TabIndex = 15
        Me.Label34.Text = "Home Switch #1:"
        Me.Label34.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'LabelInput31
        '
        Me.LabelInput31.AutoSize = True
        Me.LabelInput31.Location = New System.Drawing.Point(120, 24)
        Me.LabelInput31.Name = "LabelInput31"
        Me.LabelInput31.Size = New System.Drawing.Size(21, 13)
        Me.LabelInput31.TabIndex = 0
        Me.LabelInput31.Text = "Off"
        Me.LabelInput31.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'GroupBoxMD22
        '
        Me.GroupBoxMD22.Controls.Add(Me.CheckBoxOutput22)
        Me.GroupBoxMD22.Controls.Add(Me.Label25)
        Me.GroupBoxMD22.Controls.Add(Me.CheckBoxOutput21)
        Me.GroupBoxMD22.Controls.Add(Me.LabelInput25)
        Me.GroupBoxMD22.Controls.Add(Me.Label26)
        Me.GroupBoxMD22.Controls.Add(Me.LabelInput24)
        Me.GroupBoxMD22.Controls.Add(Me.Label27)
        Me.GroupBoxMD22.Controls.Add(Me.LabelInput23)
        Me.GroupBoxMD22.Controls.Add(Me.Label28)
        Me.GroupBoxMD22.Controls.Add(Me.LabelInput22)
        Me.GroupBoxMD22.Controls.Add(Me.Label29)
        Me.GroupBoxMD22.Controls.Add(Me.LabelInput21)
        Me.GroupBoxMD22.Location = New System.Drawing.Point(280, 32)
        Me.GroupBoxMD22.Name = "GroupBoxMD22"
        Me.GroupBoxMD22.Size = New System.Drawing.Size(160, 200)
        Me.GroupBoxMD22.TabIndex = 3
        Me.GroupBoxMD22.TabStop = False
        Me.GroupBoxMD22.Text = "MD2 #2"
        '
        'CheckBoxOutput22
        '
        Me.CheckBoxOutput22.AutoSize = True
        Me.CheckBoxOutput22.CheckAlign = System.Drawing.ContentAlignment.MiddleRight
        Me.CheckBoxOutput22.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.CheckBoxOutput22.Location = New System.Drawing.Point(48, 168)
        Me.CheckBoxOutput22.Name = "CheckBoxOutput22"
        Me.CheckBoxOutput22.Size = New System.Drawing.Size(87, 17)
        Me.CheckBoxOutput22.TabIndex = 12
        Me.CheckBoxOutput22.Text = "Output #2:"
        Me.CheckBoxOutput22.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        Me.CheckBoxOutput22.UseVisualStyleBackColor = True
        '
        'Label25
        '
        Me.Label25.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label25.Location = New System.Drawing.Point(8, 120)
        Me.Label25.Name = "Label25"
        Me.Label25.Size = New System.Drawing.Size(110, 13)
        Me.Label25.TabIndex = 14
        Me.Label25.Text = "Input #3:"
        Me.Label25.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'CheckBoxOutput21
        '
        Me.CheckBoxOutput21.AutoSize = True
        Me.CheckBoxOutput21.CheckAlign = System.Drawing.ContentAlignment.MiddleRight
        Me.CheckBoxOutput21.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.CheckBoxOutput21.Location = New System.Drawing.Point(48, 144)
        Me.CheckBoxOutput21.Name = "CheckBoxOutput21"
        Me.CheckBoxOutput21.Size = New System.Drawing.Size(87, 17)
        Me.CheckBoxOutput21.TabIndex = 11
        Me.CheckBoxOutput21.Text = "Output #1:"
        Me.CheckBoxOutput21.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        Me.CheckBoxOutput21.UseVisualStyleBackColor = True
        '
        'LabelInput25
        '
        Me.LabelInput25.AutoSize = True
        Me.LabelInput25.Location = New System.Drawing.Point(120, 120)
        Me.LabelInput25.Name = "LabelInput25"
        Me.LabelInput25.Size = New System.Drawing.Size(21, 13)
        Me.LabelInput25.TabIndex = 4
        Me.LabelInput25.Text = "Off"
        Me.LabelInput25.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'Label26
        '
        Me.Label26.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label26.Location = New System.Drawing.Point(8, 96)
        Me.Label26.Name = "Label26"
        Me.Label26.Size = New System.Drawing.Size(110, 13)
        Me.Label26.TabIndex = 13
        Me.Label26.Text = "Input #2:"
        Me.Label26.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'LabelInput24
        '
        Me.LabelInput24.AutoSize = True
        Me.LabelInput24.Location = New System.Drawing.Point(120, 96)
        Me.LabelInput24.Name = "LabelInput24"
        Me.LabelInput24.Size = New System.Drawing.Size(21, 13)
        Me.LabelInput24.TabIndex = 3
        Me.LabelInput24.Text = "Off"
        Me.LabelInput24.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'Label27
        '
        Me.Label27.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label27.Location = New System.Drawing.Point(8, 72)
        Me.Label27.Name = "Label27"
        Me.Label27.Size = New System.Drawing.Size(110, 13)
        Me.Label27.TabIndex = 12
        Me.Label27.Text = "Input #1:"
        Me.Label27.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'LabelInput23
        '
        Me.LabelInput23.AutoSize = True
        Me.LabelInput23.Location = New System.Drawing.Point(120, 72)
        Me.LabelInput23.Name = "LabelInput23"
        Me.LabelInput23.Size = New System.Drawing.Size(21, 13)
        Me.LabelInput23.TabIndex = 2
        Me.LabelInput23.Text = "Off"
        Me.LabelInput23.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'Label28
        '
        Me.Label28.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label28.Location = New System.Drawing.Point(8, 48)
        Me.Label28.Name = "Label28"
        Me.Label28.Size = New System.Drawing.Size(110, 13)
        Me.Label28.TabIndex = 11
        Me.Label28.Text = "Home Switch #2:"
        Me.Label28.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'LabelInput22
        '
        Me.LabelInput22.AutoSize = True
        Me.LabelInput22.Location = New System.Drawing.Point(120, 48)
        Me.LabelInput22.Name = "LabelInput22"
        Me.LabelInput22.Size = New System.Drawing.Size(21, 13)
        Me.LabelInput22.TabIndex = 1
        Me.LabelInput22.Text = "Off"
        Me.LabelInput22.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'Label29
        '
        Me.Label29.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label29.ImageAlign = System.Drawing.ContentAlignment.MiddleRight
        Me.Label29.Location = New System.Drawing.Point(8, 24)
        Me.Label29.Name = "Label29"
        Me.Label29.Size = New System.Drawing.Size(110, 13)
        Me.Label29.TabIndex = 10
        Me.Label29.Text = "Home Switch #1:"
        Me.Label29.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'LabelInput21
        '
        Me.LabelInput21.AutoSize = True
        Me.LabelInput21.Location = New System.Drawing.Point(120, 24)
        Me.LabelInput21.Name = "LabelInput21"
        Me.LabelInput21.Size = New System.Drawing.Size(21, 13)
        Me.LabelInput21.TabIndex = 0
        Me.LabelInput21.Text = "Off"
        Me.LabelInput21.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'GroupBoxMD21
        '
        Me.GroupBoxMD21.Controls.Add(Me.CheckBoxOutput12)
        Me.GroupBoxMD21.Controls.Add(Me.CheckBoxOutput11)
        Me.GroupBoxMD21.Controls.Add(Me.Label24)
        Me.GroupBoxMD21.Controls.Add(Me.Label23)
        Me.GroupBoxMD21.Controls.Add(Me.Label22)
        Me.GroupBoxMD21.Controls.Add(Me.Label21)
        Me.GroupBoxMD21.Controls.Add(Me.Label20)
        Me.GroupBoxMD21.Controls.Add(Me.LabelInput15)
        Me.GroupBoxMD21.Controls.Add(Me.LabelInput14)
        Me.GroupBoxMD21.Controls.Add(Me.LabelInput13)
        Me.GroupBoxMD21.Controls.Add(Me.LabelInput12)
        Me.GroupBoxMD21.Controls.Add(Me.LabelInput11)
        Me.GroupBoxMD21.Location = New System.Drawing.Point(72, 32)
        Me.GroupBoxMD21.Name = "GroupBoxMD21"
        Me.GroupBoxMD21.Size = New System.Drawing.Size(160, 200)
        Me.GroupBoxMD21.TabIndex = 1
        Me.GroupBoxMD21.TabStop = False
        Me.GroupBoxMD21.Text = "MD2 #1"
        '
        'CheckBoxOutput12
        '
        Me.CheckBoxOutput12.AutoSize = True
        Me.CheckBoxOutput12.CheckAlign = System.Drawing.ContentAlignment.MiddleRight
        Me.CheckBoxOutput12.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.CheckBoxOutput12.Location = New System.Drawing.Point(48, 168)
        Me.CheckBoxOutput12.Name = "CheckBoxOutput12"
        Me.CheckBoxOutput12.Size = New System.Drawing.Size(87, 17)
        Me.CheckBoxOutput12.TabIndex = 10
        Me.CheckBoxOutput12.Text = "Output #2:"
        Me.CheckBoxOutput12.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        Me.CheckBoxOutput12.UseVisualStyleBackColor = True
        '
        'CheckBoxOutput11
        '
        Me.CheckBoxOutput11.AutoSize = True
        Me.CheckBoxOutput11.CheckAlign = System.Drawing.ContentAlignment.MiddleRight
        Me.CheckBoxOutput11.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.CheckBoxOutput11.Location = New System.Drawing.Point(48, 144)
        Me.CheckBoxOutput11.Name = "CheckBoxOutput11"
        Me.CheckBoxOutput11.Size = New System.Drawing.Size(87, 17)
        Me.CheckBoxOutput11.TabIndex = 5
        Me.CheckBoxOutput11.Text = "Output #1:"
        Me.CheckBoxOutput11.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        Me.CheckBoxOutput11.UseVisualStyleBackColor = True
        '
        'Label24
        '
        Me.Label24.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label24.Location = New System.Drawing.Point(8, 120)
        Me.Label24.Name = "Label24"
        Me.Label24.Size = New System.Drawing.Size(110, 13)
        Me.Label24.TabIndex = 9
        Me.Label24.Text = "Input #3:"
        Me.Label24.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'Label23
        '
        Me.Label23.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label23.Location = New System.Drawing.Point(8, 96)
        Me.Label23.Name = "Label23"
        Me.Label23.Size = New System.Drawing.Size(110, 13)
        Me.Label23.TabIndex = 8
        Me.Label23.Text = "Input #2:"
        Me.Label23.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'Label22
        '
        Me.Label22.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label22.Location = New System.Drawing.Point(8, 72)
        Me.Label22.Name = "Label22"
        Me.Label22.Size = New System.Drawing.Size(110, 13)
        Me.Label22.TabIndex = 7
        Me.Label22.Text = "Input #1:"
        Me.Label22.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'Label21
        '
        Me.Label21.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label21.Location = New System.Drawing.Point(8, 48)
        Me.Label21.Name = "Label21"
        Me.Label21.Size = New System.Drawing.Size(110, 13)
        Me.Label21.TabIndex = 6
        Me.Label21.Text = "Home Switch #2:"
        Me.Label21.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'Label20
        '
        Me.Label20.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label20.Location = New System.Drawing.Point(8, 24)
        Me.Label20.Name = "Label20"
        Me.Label20.Size = New System.Drawing.Size(110, 13)
        Me.Label20.TabIndex = 5
        Me.Label20.Text = "Home Switch #1:"
        Me.Label20.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'LabelInput15
        '
        Me.LabelInput15.AutoSize = True
        Me.LabelInput15.Location = New System.Drawing.Point(120, 120)
        Me.LabelInput15.Name = "LabelInput15"
        Me.LabelInput15.Size = New System.Drawing.Size(21, 13)
        Me.LabelInput15.TabIndex = 4
        Me.LabelInput15.Text = "Off"
        Me.LabelInput15.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'LabelInput14
        '
        Me.LabelInput14.AutoSize = True
        Me.LabelInput14.Location = New System.Drawing.Point(120, 96)
        Me.LabelInput14.Name = "LabelInput14"
        Me.LabelInput14.Size = New System.Drawing.Size(21, 13)
        Me.LabelInput14.TabIndex = 3
        Me.LabelInput14.Text = "Off"
        Me.LabelInput14.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'LabelInput13
        '
        Me.LabelInput13.AutoSize = True
        Me.LabelInput13.Location = New System.Drawing.Point(120, 72)
        Me.LabelInput13.Name = "LabelInput13"
        Me.LabelInput13.Size = New System.Drawing.Size(21, 13)
        Me.LabelInput13.TabIndex = 2
        Me.LabelInput13.Text = "Off"
        Me.LabelInput13.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'LabelInput12
        '
        Me.LabelInput12.AutoSize = True
        Me.LabelInput12.Location = New System.Drawing.Point(120, 48)
        Me.LabelInput12.Name = "LabelInput12"
        Me.LabelInput12.Size = New System.Drawing.Size(21, 13)
        Me.LabelInput12.TabIndex = 1
        Me.LabelInput12.Text = "Off"
        Me.LabelInput12.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'LabelInput11
        '
        Me.LabelInput11.AutoSize = True
        Me.LabelInput11.Location = New System.Drawing.Point(120, 24)
        Me.LabelInput11.Name = "LabelInput11"
        Me.LabelInput11.Size = New System.Drawing.Size(21, 13)
        Me.LabelInput11.TabIndex = 0
        Me.LabelInput11.Text = "Off"
        Me.LabelInput11.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'TabUtilities
        '
        Me.TabUtilities.Controls.Add(Me.ButtonInfo)
        Me.TabUtilities.Controls.Add(Me.ButtonFP)
        Me.TabUtilities.Controls.Add(Me.GroupBoxCalibrate)
        Me.TabUtilities.Controls.Add(Me.TextBoxUtilities)
        Me.TabUtilities.Location = New System.Drawing.Point(4, 22)
        Me.TabUtilities.Name = "TabUtilities"
        Me.TabUtilities.Size = New System.Drawing.Size(720, 430)
        Me.TabUtilities.TabIndex = 5
        Me.TabUtilities.Text = "    Utilities    "
        Me.TabUtilities.UseVisualStyleBackColor = True
        '
        'ButtonInfo
        '
        Me.ButtonInfo.Location = New System.Drawing.Point(632, 232)
        Me.ButtonInfo.Name = "ButtonInfo"
        Me.ButtonInfo.Size = New System.Drawing.Size(72, 23)
        Me.ButtonInfo.TabIndex = 7
        Me.ButtonInfo.Text = "Info"
        Me.ToolTip1.SetToolTip(Me.ButtonInfo, "Show Information about the" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "system and program.")
        Me.ButtonInfo.UseVisualStyleBackColor = True
        '
        'ButtonFP
        '
        Me.ButtonFP.Location = New System.Drawing.Point(632, 200)
        Me.ButtonFP.Name = "ButtonFP"
        Me.ButtonFP.Size = New System.Drawing.Size(72, 23)
        Me.ButtonFP.TabIndex = 6
        Me.ButtonFP.Text = "Find Ports"
        Me.ToolTip1.SetToolTip(Me.ButtonFP, "Attempt to locate parallel ports using" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "WMI, and display results.")
        Me.ButtonFP.UseVisualStyleBackColor = True
        '
        'GroupBoxCalibrate
        '
        Me.GroupBoxCalibrate.Controls.Add(Me.ButtonTweak)
        Me.GroupBoxCalibrate.Controls.Add(Me.ButtonTestMove)
        Me.GroupBoxCalibrate.Controls.Add(Me.ButtonShowCal)
        Me.GroupBoxCalibrate.Location = New System.Drawing.Point(624, 24)
        Me.GroupBoxCalibrate.Name = "GroupBoxCalibrate"
        Me.GroupBoxCalibrate.Size = New System.Drawing.Size(88, 120)
        Me.GroupBoxCalibrate.TabIndex = 4
        Me.GroupBoxCalibrate.TabStop = False
        Me.GroupBoxCalibrate.Text = "Calibration"
        '
        'ButtonTweak
        '
        Me.ButtonTweak.Location = New System.Drawing.Point(8, 88)
        Me.ButtonTweak.Name = "ButtonTweak"
        Me.ButtonTweak.Size = New System.Drawing.Size(72, 23)
        Me.ButtonTweak.TabIndex = 5
        Me.ButtonTweak.Text = "Tweak"
        Me.ToolTip1.SetToolTip(Me.ButtonTweak, "Experimental fine-tuning of calibration array.")
        Me.ButtonTweak.UseVisualStyleBackColor = True
        '
        'ButtonTestMove
        '
        Me.ButtonTestMove.Location = New System.Drawing.Point(8, 56)
        Me.ButtonTestMove.Name = "ButtonTestMove"
        Me.ButtonTestMove.Size = New System.Drawing.Size(72, 23)
        Me.ButtonTestMove.TabIndex = 3
        Me.ButtonTestMove.Text = "&Test"
        Me.ToolTip1.SetToolTip(Me.ButtonTestMove, "Tests motor speeds and shows accuracy." & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "A port address must be specified for moto" & _
                "r 1,2.")
        Me.ButtonTestMove.UseVisualStyleBackColor = True
        '
        'ButtonShowCal
        '
        Me.ButtonShowCal.Location = New System.Drawing.Point(8, 24)
        Me.ButtonShowCal.Name = "ButtonShowCal"
        Me.ButtonShowCal.Size = New System.Drawing.Size(72, 23)
        Me.ButtonShowCal.TabIndex = 2
        Me.ButtonShowCal.Text = "&Show"
        Me.ToolTip1.SetToolTip(Me.ButtonShowCal, "Show the calibration array used to" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "select software delay loops for" & Global.Microsoft.VisualBasic.ChrW(13) & Global.Microsoft.VisualBasic.ChrW(10) & "motor speed " & _
                "control.")
        Me.ButtonShowCal.UseVisualStyleBackColor = True
        '
        'TextBoxUtilities
        '
        Me.TextBoxUtilities.Location = New System.Drawing.Point(16, 16)
        Me.TextBoxUtilities.Multiline = True
        Me.TextBoxUtilities.Name = "TextBoxUtilities"
        Me.TextBoxUtilities.ScrollBars = System.Windows.Forms.ScrollBars.Both
        Me.TextBoxUtilities.Size = New System.Drawing.Size(600, 408)
        Me.TextBoxUtilities.TabIndex = 0
        '
        'OpenFileDialog1
        '
        Me.OpenFileDialog1.FileName = "OpenFileDialog1"
        '
        'TimerIOScan
        '
        '
        'MD2xp
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.BackColor = System.Drawing.SystemColors.Control
        Me.ClientSize = New System.Drawing.Size(742, 466)
        Me.Controls.Add(Me.Tabs)
        Me.Icon = CType(resources.GetObject("$this.Icon"), System.Drawing.Icon)
        Me.KeyPreview = True
        Me.MaximizeBox = False
        Me.MaximumSize = New System.Drawing.Size(750, 500)
        Me.MinimumSize = New System.Drawing.Size(750, 500)
        Me.Name = "MD2xp"
        Me.Text = "MD2xp Motor Control System"
        Me.Tabs.ResumeLayout(False)
        Me.TabControl.ResumeLayout(False)
        Me.GroupBoxHelp.ResumeLayout(False)
        Me.GroupBoxProgram.ResumeLayout(False)
        Me.GroupBoxMove.ResumeLayout(False)
        Me.GroupBoxMoveMotors.ResumeLayout(False)
        Me.GroupBoxMoveMotors.PerformLayout()
        Me.GroupBoxMove3.ResumeLayout(False)
        Me.GroupBoxMove3.PerformLayout()
        Me.GroupBoxMove2.ResumeLayout(False)
        Me.GroupBoxMove2.PerformLayout()
        Me.GroupBoxMove1.ResumeLayout(False)
        Me.GroupBoxMove1.PerformLayout()
        Me.TabParameters.ResumeLayout(False)
        Me.TabParameters.PerformLayout()
        Me.GroupBoxStepType.ResumeLayout(False)
        Me.GroupBoxStepType.PerformLayout()
        Me.GroupBoxMoveType.ResumeLayout(False)
        Me.GroupBoxMoveType.PerformLayout()
        Me.TabProgram.ResumeLayout(False)
        Me.TabProgram.PerformLayout()
        Me.GroupBoxSequenceRun.ResumeLayout(False)
        Me.GroupBoxSequenceFile.ResumeLayout(False)
        Me.GroupBoxQuickRun.ResumeLayout(False)
        Me.TabIO.ResumeLayout(False)
        Me.GroupBoxMD23.ResumeLayout(False)
        Me.GroupBoxMD23.PerformLayout()
        Me.GroupBoxMD22.ResumeLayout(False)
        Me.GroupBoxMD22.PerformLayout()
        Me.GroupBoxMD21.ResumeLayout(False)
        Me.GroupBoxMD21.PerformLayout()
        Me.TabUtilities.ResumeLayout(False)
        Me.TabUtilities.PerformLayout()
        Me.GroupBoxCalibrate.ResumeLayout(False)
        Me.ResumeLayout(False)

    End Sub

#End Region
    Private Sub MD2xp_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        'This happens before the main form is displayed.

        'Only allow one MD2xp program.
        If UBound(Diagnostics.Process.GetProcessesByName(Diagnostics.Process.GetCurrentProcess.ProcessName)) > 0 Then
            MessageBox.Show("MD2xp Already Running" & vbCrLf & vbCrLf & _
            "If another instance of MD2xp is locked up, " & vbCrLf & _
            "access the windows task manager by pressing" & vbCrLf & _
            "ctrl-alt-delete and end the MD2xp process." _
            , "MD2xp Already Running" _
            )
            End
        End If

        'Command line argument handling.
        'cla(0) = path of executable, cla(1)=first argument, cla(2)=second, etc.
        'Dim cla As [String]() = Environment.GetCommandLineArgs()
        'If cla.Length > 1 Then
        'TextBoxResult.Text = "len:" & cla.Length
        'TextBoxResult.Text = "command line = " & cla(0) & vbCrLf & cla(1)
        'End If

    End Sub
    Private Sub MD2xp_Shown(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Shown

        'This happens after the main form is displayed.

        'Show version in status line and form title.
        Me.Text += " -- " & Vers
        ShowStatus(Me.Text)

        'Setup MD-2 systems, default parameters, and load calibration file.
        MD2CALFILE = "MD2xp.cal"
        MD2SETUP()

        'Load parameter file if available.
        MD2PARFILE = Application.StartupPath & "\MD2xp.par"
        MD2PARLOAD()
        SetForms()              'Update forms with motor parameters.
        SetDistances()          'Set distance text boxes from target parameters.
        ParametersUnsaved = False

        'Load sequence file if available.
        MD2SEQFILE = Application.StartupPath & "\MD2xp1.bas"    'Default sequence file.
        MD2SEQLOAD()
        If MD2STATUS = "O" Then
            HighlightSequenceButton(1)          'Highlight sequence button if it loaded.
        Else
            HighlightSequenceButton(0)          'Highlight no buttons.
        End If
        TextBoxSequence.Text = MD2SEQUENCE      'Set editor text.
        SequenceUnsaved = False                 'Initialize unsaved flag.
        ButtonSaveSequence.BackColor = Color.Transparent

        'Hide Utilities tab. 
        Me.Tabs.TabPages.Remove(Me.TabUtilities)

        'Select a specific tab.
        Me.Tabs.SelectedIndex = Me.Tabs.TabPages.IndexOf(Me.TabControl)
        'Me.Tabs.SelectedIndex = Me.Tabs.TabPages.IndexOf(Me.TabUtilities)

        'Turned this off to prevent auto setting of parallel port with C4
        'If port addresses are not loaded from parmater file then 
        'find ports and set first port if there is only one, otherwise do nothing.
        'If MD2PORT12 = 0 And MD2PORT34 = 0 And MD2PORT56 = 0 Then
        'Me.Cursor = Cursors.WaitCursor          'HourGlass Cursor.
        'FindPorts()                             'Find ports, put in PortAddress(0,1,2)
        'Me.Cursor = Cursors.Default             'Normal Cursor.
        'If only one port found then set MD2PORT12.
        'If PortAddress(0) <> 0 And PortAddress(1) = 0 And PortAddress(2) = 0 Then
        'MD2PORT12 = PortAddress(0)          'Set address.
        'SetForms()                          'Update forms.
        'MessageBox.Show("One Parallel Port Found and Set", "Finding Ports - ", MessageBoxButtons.OK, MessageBoxIcon.Information)
        'End If
        'End If

        'Calibrate if Needed.
        If MD2VELOCITY(0) = 0 Then
            ButtonControlCalibrate.ForeColor = Color.Gray
            ButtonControlCalibrate.PerformClick()
        End If

        'Display messages - port addresses, calibration, parameter file, in that order of importance.
        If MD2PORT12 = 0 And MD2PORT34 = 0 And MD2PORT56 = 0 Then
            'debug           PortMessage()
        Else
            'Need calibration done?
            If MD2VELOCITY(0) = 0 Then
                CalibrationMessage()
            Else
                'No parameter file loaded?
                If MD2PARFILE = "" Then
                    ParFileMessage()
                End If
            End If
        End If

        'Start home switch display timer.
        TimerIOScan.Enabled = True

    End Sub
    Private Sub MD2xp_KeyUp(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyEventArgs) Handles Me.KeyUp

        'Removed because this interferes with use of arrows and +/- for field navigation.

        'Capture Arrow keys to control motors.
        'Arrow keys only work in KeyUp.
        'Make sure KeyPreview = True

        'Motor Control - left/right arrows = M1,  up/down arrows = M2, +/- = M3
        'If e.KeyCode = Keys.Left Then MoveMotor(ButtonReverseM1, e)
        'If e.KeyCode = Keys.Right Then MoveMotor(ButtonForwardM1, e)
        'If e.KeyCode = Keys.Up Then MoveMotor(ButtonReverseM2, e)
        'If e.KeyCode = Keys.Down Then MoveMotor(ButtonForwardM2, e)
        'If e.KeyCode = Keys.Add Then MoveMotor(ButtonReverseM3, e)
        'If e.KeyCode = Keys.Subtract Then MoveMotor(ButtonForwardM3, e)

    End Sub
    Public Sub MD2xp_KeyDown(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyEventArgs) Handles Me.KeyDown

        'Respond to keypresses.

        Dim d As String        'Save distance.

        'Shift F keys - Move motors 1 step.
        If e.Shift And Not e.Alt And Not e.Control Then
            If e.KeyCode = Keys.F1 Then
                d = TextBoxDistanceM1.Text
                TextBoxDistanceM1.Text = "1"
                MoveMotor(ButtonReverseM1, e)
                TextBoxDistanceM1.Text = d
            End If
            If e.KeyCode = Keys.F2 Then
                d = TextBoxDistanceM1.Text
                TextBoxDistanceM1.Text = "1"
                MoveMotor(ButtonForwardM1, e)
                TextBoxDistanceM1.Text = d
            End If
            If e.KeyCode = Keys.F3 Then
                d = TextBoxDistanceM2.Text
                TextBoxDistanceM2.Text = "1"
                MoveMotor(ButtonReverseM2, e)
                TextBoxDistanceM2.Text = d
            End If
            If e.KeyCode = Keys.F4 Then
                d = TextBoxDistanceM2.Text
                TextBoxDistanceM2.Text = "1"
                MoveMotor(ButtonForwardM2, e)
                TextBoxDistanceM2.Text = d
            End If
            If e.KeyCode = Keys.F5 Then
                d = TextBoxDistanceM3.Text
                TextBoxDistanceM3.Text = "1"
                MoveMotor(ButtonReverseM3, e)
                TextBoxDistanceM3.Text = d
            End If
            If e.KeyCode = Keys.F6 Then
                d = TextBoxDistanceM3.Text
                TextBoxDistanceM3.Text = "1"
                MoveMotor(ButtonForwardM3, e)
                TextBoxDistanceM3.Text = d
            End If
            If e.KeyCode = Keys.F7 Then
                d = TextBoxDistanceM4.Text
                TextBoxDistanceM4.Text = "1"
                MoveMotor(ButtonReverseM4, e)
                TextBoxDistanceM4.Text = d
            End If
            If e.KeyCode = Keys.F8 Then
                d = TextBoxDistanceM4.Text
                TextBoxDistanceM4.Text = "1"
                MoveMotor(ButtonForwardM4, e)
                TextBoxDistanceM4.Text = d
            End If
            If e.KeyCode = Keys.F9 Then
                d = TextBoxDistanceM5.Text
                TextBoxDistanceM5.Text = "1"
                MoveMotor(ButtonReverseM5, e)
                TextBoxDistanceM5.Text = d
            End If
            If e.KeyCode = Keys.F10 Then
                d = TextBoxDistanceM5.Text
                TextBoxDistanceM5.Text = "1"
                MoveMotor(ButtonForwardM5, e)
                TextBoxDistanceM5.Text = d
            End If
            If e.KeyCode = Keys.F11 Then
                d = TextBoxDistanceM6.Text
                TextBoxDistanceM6.Text = "1"
                MoveMotor(ButtonReverseM6, e)
                TextBoxDistanceM6.Text = d
            End If
            If e.KeyCode = Keys.F12 Then
                d = TextBoxDistanceM6.Text
                TextBoxDistanceM6.Text = "1"
                MoveMotor(ButtonForwardM6, e)
                TextBoxDistanceM6.Text = d
            End If
        End If

        'F keys move motors according to distance.
        If Not e.Shift And Not e.Alt And Not e.Control Then   'Non-shift, non-alt, non-ctrl
            If e.KeyCode = Keys.F1 Then MoveMotor(ButtonReverseM1, e)
            If e.KeyCode = Keys.F2 Then MoveMotor(ButtonForwardM1, e)
            If e.KeyCode = Keys.F3 Then MoveMotor(ButtonReverseM2, e)
            If e.KeyCode = Keys.F4 Then MoveMotor(ButtonForwardM2, e)
            If e.KeyCode = Keys.F5 Then MoveMotor(ButtonReverseM3, e)
            If e.KeyCode = Keys.F6 Then MoveMotor(ButtonForwardM3, e)
            If e.KeyCode = Keys.F7 Then MoveMotor(ButtonReverseM4, e)
            If e.KeyCode = Keys.F8 Then MoveMotor(ButtonForwardM4, e)
            If e.KeyCode = Keys.F9 Then MoveMotor(ButtonReverseM5, e)
            If e.KeyCode = Keys.F10 Then MoveMotor(ButtonForwardM5, e)
            If e.KeyCode = Keys.F11 Then MoveMotor(ButtonReverseM6, e)
            If e.KeyCode = Keys.F12 Then MoveMotor(ButtonForwardM6, e)
        End If

        'Toggle Utility Tab - Ctrl/Alt-U
        If e.Control And e.Alt And Not e.Shift And (e.KeyCode = Keys.U) Then
            If Me.Tabs.TabPages.Contains(Me.TabUtilities) Then
                'Hide tab and select first tab
                Me.Tabs.TabPages.Remove(Me.TabUtilities)
                Me.Tabs.SelectedIndex = 0
            Else
                'Show tab and switch to it.
                Me.Tabs.TabPages.Add(Me.TabUtilities)
                Me.Tabs.SelectedIndex = Me.Tabs.TabPages.IndexOf(Me.TabUtilities)
            End If
        End If

        'About - Ctrl/Alt-A
        If e.Control And e.Alt And Not e.Shift And (e.KeyCode = Keys.A) Then
            MessageBox.Show("The MD2 Dual Stepper Motor System" & vbCrLf & _
            "and the MD2xp program were created" & vbCrLf & _
            "by Roger Arrick  --  ArrickRobotics.com." & vbCrLf & _
            "Version: " & Vers _
            , "About" _
            )
        End If

        'Tab selection via Alt-T.
        If e.KeyCode = Keys.T And e.Alt And Not e.Control And Not e.Shift Then
            If Me.Tabs.SelectedIndex = Me.Tabs.TabCount - 1 Then Me.Tabs.SelectedIndex = 0 Else Me.Tabs.SelectedIndex += 1
        End If

        'Alt-number keys home motors.
        If Not e.Shift And e.Alt And Not e.Control Then
            If e.KeyCode = Keys.D1 Then ButtonHome_Click(ButtonHomeM1, e)
            If e.KeyCode = Keys.D2 Then ButtonHome_Click(ButtonHomeM2, e)
            If e.KeyCode = Keys.D3 Then ButtonHome_Click(ButtonHomeM3, e)
            If e.KeyCode = Keys.D4 Then ButtonHome_Click(ButtonHomeM4, e)
            If e.KeyCode = Keys.D5 Then ButtonHome_Click(ButtonHomeM5, e)
            If e.KeyCode = Keys.D6 Then ButtonHome_Click(ButtonHomeM6, e)
            If e.KeyCode = Keys.D7 Then
                ButtonHome_Click(ButtonHomeM1, e)
                ButtonHome_Click(ButtonHomeM2, e)
            End If
            If e.KeyCode = Keys.D8 Then
                ButtonHome_Click(ButtonHomeM3, e)
                ButtonHome_Click(ButtonHomeM4, e)
            End If
            If e.KeyCode = Keys.D9 Then
                ButtonHome_Click(ButtonHomeM5, e)
                ButtonHome_Click(ButtonHomeM6, e)
            End If
        End If

        'Parameter Tab Keys.
        If Me.Tabs.SelectedIndex = Me.Tabs.TabPages.IndexOf(Me.TabParameters) Then
            'Ctrl-S = Save
            If Not e.Shift And Not e.Alt And e.Control And e.KeyCode = Keys.S Then ButtonSaveParameters.PerformClick()
            'Ctrl-L = Load
            If Not e.Shift And Not e.Alt And e.Control And e.KeyCode = Keys.L Then ButtonLoadParameters.PerformClick()
        End If

        'Sequence Tab Keys.
        If Me.Tabs.SelectedIndex = Me.Tabs.TabPages.IndexOf(Me.TabProgram) Then
            'Ctrl-S = Save
            If Not e.Shift And Not e.Alt And e.Control And e.KeyCode = Keys.S Then ButtonSaveSequence.PerformClick()
            'Ctrl-L = Load
            If Not e.Shift And Not e.Alt And e.Control And e.KeyCode = Keys.L Then ButtonLoadSequence.PerformClick()
            'Alt-R = Run from beginning
            If Not e.Shift And e.Alt And Not e.Control And e.KeyCode = Keys.R Then ButtonRunSequence.PerformClick()
            'Alt-F = Run from cursor
            If Not e.Shift And e.Alt And Not e.Control And e.KeyCode = Keys.F Then ButtonSequenceRunFrom.PerformClick()
            'Alt-S = Run selection
            If Not e.Shift And e.Alt And Not e.Control And e.KeyCode = Keys.S Then ButtonSequenceRunSelection.PerformClick()
        End If

        'Alt-F keys load and runs sequence MD2xp1.bas, etc.
        If Not e.Shift And e.Alt And Not e.Control Then
            ShowStatus("")
            If e.KeyCode = Keys.F1 Then ButtonQuickRun1_Click(ButtonQuickRun1, e)
            If e.KeyCode = Keys.F2 Then ButtonQuickRun2_Click(ButtonQuickRun2, e)
            If e.KeyCode = Keys.F3 Then ButtonQuickRun3_Click(ButtonQuickRun3, e)
            'If e.KeyCode = Keys.F4 Then ButtonQuickRun4_Click(ButtonQuickRun4, e) 'Alt-f4 causes program exit.
            If e.KeyCode = Keys.F5 Then ButtonQuickRun5_Click(ButtonQuickRun5, e)
            If e.KeyCode = Keys.F6 Then ButtonQuickRun6_Click(ButtonQuickRun6, e)
            If e.KeyCode = Keys.F7 Then ButtonQuickRun7_Click(ButtonQuickRun7, e)
            If e.KeyCode = Keys.F8 Then ButtonQuickRun8_Click(ButtonQuickRun8, e)
            If e.KeyCode = Keys.F9 Then ButtonQuickRun9_Click(ButtonQuickRun9, e)
            If e.KeyCode = Keys.F10 Then ButtonQuickRun10_Click(ButtonQuickRun10, e)
            If e.KeyCode = Keys.F11 Then ButtonQuickRun11_Click(ButtonQuickRun11, e)
        End If

    End Sub
    Private Sub PortMessage()

        MessageBox.Show("Parallel port addresses need to be set." & vbCrLf & _
        vbCrLf & _
        "Set addresses in the parameter tab." & vbCrLf & _
         vbCrLf & _
        "Use the Find button to help locate ports." & vbCrLf & _
         vbCrLf & _
        "Each MD2 system operates 2 motors and requires" & vbCrLf & _
        "one parallel printer port (LPT port)." & vbCrLf & _
        "Up to 3 MD2 systems can be used with this program." & vbCrLf & _
        vbCrLf & _
        "To find addresses manually in Windows XP - " & vbCrLf & _
        "  Windows Start button, Control Panel, System icon," & vbCrLf & _
        "  Hardware Tab, Device Manager button, COM & LPT ports," & vbCrLf & _
        "  Select LPT ports, resources tab. " & vbCrLf & _
        "  Use the first address shown.  Example: 378 or DD80" & vbCrLf & _
        "  Enter the address into the Port field." & vbCrLf & _
        vbCrLf & _
        "See Help for details." & vbCrLf & _
        vbCrLf & _
        "Incorrect addresses may cause computer lock-up." _
        , "Port Addresses Need to be Set" _
        )

    End Sub
    Private Sub ParFileMessage()

        'Show status line.
        ShowStatus("No parameter file loaded")

        MessageBox.Show("No Parameter File Loaded." & vbCrLf & _
        vbCrLf & _
        "The MD2xp.par motor parameter file" & vbCrLf & _
        "was not found." & vbCrLf & _
        "Parameters are set to defaults." _
        , "No Parameter File Loaded" _
        )

    End Sub
    Private Sub CalibrationMessage()

        MessageBox.Show("No calibration file found." & vbCrLf & _
        vbCrLf & _
        "A calibration file is needed to control motor speeds." & vbCrLf & _
        "Click the Calibrate button on the Control Tab Screen." _
        , "Calibration Needed" _
        )

    End Sub
    Private Sub MoveMotor(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonReverseM1.Click, ButtonReverseM2.Click, ButtonReverseM3.Click, ButtonReverseM4.Click, ButtonReverseM5.Click, ButtonReverseM6.Click, ButtonForwardM1.Click, ButtonForwardM2.Click, ButtonForwardM3.Click, ButtonForwardM4.Click, ButtonForwardM5.Click, ButtonForwardM6.Click

        'Move forward or reverse buttons.

        'Save values.
        Dim MT As String = MD2MOVETYPE

        'Set parameters based on form.
        SetParameters()

        'Set motor # and target value for move.
        If sender.name = "ButtonReverseM1" Then
            MD2MOTOR = 1
            MD2TARGET(MD2MOTOR) = Math.Abs(Val(TextBoxDistanceM1.Text)) * -1
        End If
        If sender.name = "ButtonForwardM1" Then
            MD2MOTOR = 1
            MD2TARGET(MD2MOTOR) = Math.Abs(Val(TextBoxDistanceM1.Text))
        End If
        If sender.name = "ButtonReverseM2" Then
            MD2MOTOR = 2
            MD2TARGET(MD2MOTOR) = Math.Abs(Val(TextBoxDistanceM2.Text)) * -1
        End If
        If sender.name = "ButtonForwardM2" Then
            MD2MOTOR = 2
            MD2TARGET(MD2MOTOR) = Math.Abs(Val(TextBoxDistanceM2.Text))
        End If
        If sender.name = "ButtonReverseM3" Then
            MD2MOTOR = 3
            MD2TARGET(MD2MOTOR) = Math.Abs(Val(TextBoxDistanceM3.Text)) * -1
        End If
        If sender.name = "ButtonForwardM3" Then
            MD2MOTOR = 3
            MD2TARGET(MD2MOTOR) = Math.Abs(Val(TextBoxDistanceM3.Text))
        End If
        If sender.name = "ButtonReverseM4" Then
            MD2MOTOR = 4
            MD2TARGET(MD2MOTOR) = Math.Abs(Val(TextBoxDistanceM4.Text)) * -1
        End If
        If sender.name = "ButtonForwardM4" Then
            MD2MOTOR = 4
            MD2TARGET(MD2MOTOR) = Math.Abs(Val(TextBoxDistanceM4.Text))
        End If
        If sender.name = "ButtonReverseM5" Then
            MD2MOTOR = 5
            MD2TARGET(MD2MOTOR) = Math.Abs(Val(TextBoxDistanceM5.Text)) * -1
        End If
        If sender.name = "ButtonForwardM5" Then
            MD2MOTOR = 5
            MD2TARGET(MD2MOTOR) = Math.Abs(Val(TextBoxDistanceM5.Text))
        End If
        If sender.name = "ButtonReverseM6" Then
            MD2MOTOR = 6
            MD2TARGET(MD2MOTOR) = Math.Abs(Val(TextBoxDistanceM6.Text)) * -1
        End If
        If sender.name = "ButtonForwardM6" Then
            MD2MOTOR = 6
            MD2TARGET(MD2MOTOR) = Math.Abs(Val(TextBoxDistanceM6.Text))
        End If

        'Prepair for move.
        Me.Cursor = Cursors.WaitCursor      'HourGlass Cursor.
        TimerIOScan.Enabled = False         'Turn off I/O Scanner.
        ShowStatus("M")                     'Moving message.
        Application.DoEvents()              'Finish up events.
        MD2MOVETYPE = "R"                   'Relative.
        MD2MOVE()                           'Do the move.

        'Done with move.
        Me.Cursor = Cursors.Default         'Normal Cursor.
        TimerIOScan.Enabled = True          'Turn on I/O Scanner.
        SetForms()                          'Update forms.
        ShowStatus(MD2STATUS)               'Show status.

        'If Teach Mode and move was successful (OK) then write code.
        'Code example:  MD2MOTOR=1 : MD2TARGET(1)=400 : MD2MOVETYPE="R" : MD2MOVE
        If CheckBoxTeachMode.Checked And MD2STATUS = "O" Then
            TextBoxSequence.Text = TextBoxSequence.Text + _
            "MD2MOTOR=" & CStr(MD2MOTOR) & " : " & _
            "MD2TARGET(" & CStr(MD2MOTOR) & ")=" & CStr(MD2TARGET(MD2MOTOR)) & " : " & _
            "MD2MOVETYPE=" & Chr(34) & "R" & Chr(34) & " : " & _
            "MD2MOVE" & vbCrLf
        End If

        'Restore values.
        MD2MOVETYPE = MT
        MD2TARGET(1) = Math.Abs(MD2TARGET(1))    'Restore positive distances.
        MD2TARGET(2) = Math.Abs(MD2TARGET(2))
        MD2TARGET(3) = Math.Abs(MD2TARGET(3))
        MD2TARGET(4) = Math.Abs(MD2TARGET(4))
        MD2TARGET(5) = Math.Abs(MD2TARGET(5))
        MD2TARGET(6) = Math.Abs(MD2TARGET(6))

    End Sub
    Private Sub ButtonHome_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonHomeM1.Click, ButtonHomeM2.Click, ButtonHomeM3.Click, ButtonHomeM4.Click, ButtonHomeM5.Click, ButtonHomeM6.Click

        'Home motor buttons.

        'Extract motor number from last character of button name.
        MD2MOTOR = Val(Microsoft.VisualBasic.Right(sender.name, 1))

        'Set parameters based on form.
        SetParameters()

        'Prepair for home move.
        Me.Cursor = Cursors.WaitCursor      'HourGlass Cursor.
        TimerIOScan.Enabled = False         'Turn off I/O Scanner.
        ShowStatus("M")                     'Moving message.
        Application.DoEvents()              'Finish up events.

        MD2HOME()                           'Do the move.

        'Done with home move.
        Me.Cursor = Cursors.Default         'Normal Cursor.
        TimerIOScan.Enabled = True          'Turn on I/O Scanner.
        SetForms()                          'Update forms.
        ShowStatus(MD2STATUS)               'Show status from md2home.

        'If Teach Mode and move was successful (OK) then write code.
        'Code example:  MD2MOTOR=1 : MD2HOME
        If CheckBoxTeachMode.Checked And MD2STATUS = "O" Then
            TextBoxSequence.Text = TextBoxSequence.Text + _
            "MD2MOTOR=" & CStr(MD2MOTOR) & " : " & _
            "MD2HOME" & vbCrLf
        End If

    End Sub
    Public Sub SetDistances()

        'Set Distance text boxes.
        TextBoxDistanceM1.Text = CStr(MD2TARGET(1))
        TextBoxDistanceM2.Text = CStr(MD2TARGET(2))
        TextBoxDistanceM3.Text = CStr(MD2TARGET(3))
        TextBoxDistanceM4.Text = CStr(MD2TARGET(4))
        TextBoxDistanceM5.Text = CStr(MD2TARGET(5))
        TextBoxDistanceM6.Text = CStr(MD2TARGET(6))

    End Sub
    Public Sub SetForms()

        'Set form objects according to parameters.
        'Except distances which are set at beginning of program (form_shown).

        'Update objects on parameter form --------------------------------------------------------

        TextBoxMotorNameM1.Text = MD2MOTORNAME(1)
        TextBoxMotorNameM2.Text = MD2MOTORNAME(2)
        TextBoxMotorNameM3.Text = MD2MOTORNAME(3)
        TextBoxMotorNameM4.Text = MD2MOTORNAME(4)
        TextBoxMotorNameM5.Text = MD2MOTORNAME(5)
        TextBoxMotorNameM6.Text = MD2MOTORNAME(6)

        TextBoxPositionPM1.Text = CStr(MD2POSITION(1))
        TextBoxPositionPM2.Text = CStr(MD2POSITION(2))
        TextBoxPositionPM3.Text = CStr(MD2POSITION(3))
        TextBoxPositionPM4.Text = CStr(MD2POSITION(4))
        TextBoxPositionPM5.Text = CStr(MD2POSITION(5))
        TextBoxPositionPM6.Text = CStr(MD2POSITION(6))

        TextBoxUnitNameM1.Text = MD2UNITNAME(1)
        TextBoxUnitNameM2.Text = MD2UNITNAME(2)
        TextBoxUnitNameM3.Text = MD2UNITNAME(3)
        TextBoxUnitNameM4.Text = MD2UNITNAME(4)
        TextBoxUnitNameM5.Text = MD2UNITNAME(5)
        TextBoxUnitNameM6.Text = MD2UNITNAME(6)

        TextBoxUnitValueM1.Text = CStr(MD2UNITS(1))
        TextBoxUnitValueM2.Text = CStr(MD2UNITS(2))
        TextBoxUnitValueM3.Text = CStr(MD2UNITS(3))
        TextBoxUnitValueM4.Text = CStr(MD2UNITS(4))
        TextBoxUnitValueM5.Text = CStr(MD2UNITS(5))
        TextBoxUnitValueM6.Text = CStr(MD2UNITS(6))

        TextBoxHomeOffsetM1.Text = CStr(MD2HOMEOFFSET(1))
        TextBoxHomeOffsetM2.Text = CStr(MD2HOMEOFFSET(2))
        TextBoxHomeOffsetM3.Text = CStr(MD2HOMEOFFSET(3))
        TextBoxHomeOffsetM4.Text = CStr(MD2HOMEOFFSET(4))
        TextBoxHomeOffsetM5.Text = CStr(MD2HOMEOFFSET(5))
        TextBoxHomeOffsetM6.Text = CStr(MD2HOMEOFFSET(6))

        TextBoxLimitRM1.Text = CStr(MD2LIMITR(1))
        TextBoxLimitRM2.Text = CStr(MD2LIMITR(2))
        TextBoxLimitRM3.Text = CStr(MD2LIMITR(3))
        TextBoxLimitRM4.Text = CStr(MD2LIMITR(4))
        TextBoxLimitRM5.Text = CStr(MD2LIMITR(5))
        TextBoxLimitRM6.Text = CStr(MD2LIMITR(6))

        TextBoxLimitFM1.Text = CStr(MD2LIMITF(1))
        TextBoxLimitFM2.Text = CStr(MD2LIMITF(2))
        TextBoxLimitFM3.Text = CStr(MD2LIMITF(3))
        TextBoxLimitFM4.Text = CStr(MD2LIMITF(4))
        TextBoxLimitFM5.Text = CStr(MD2LIMITF(5))
        TextBoxLimitFM6.Text = CStr(MD2LIMITF(6))

        TextBoxMinSpeedM1.Text = CStr(MD2MINSPEED(1))
        TextBoxMinSpeedM2.Text = CStr(MD2MINSPEED(2))
        TextBoxMinSpeedM3.Text = CStr(MD2MINSPEED(3))
        TextBoxMinSpeedM4.Text = CStr(MD2MINSPEED(4))
        TextBoxMinSpeedM5.Text = CStr(MD2MINSPEED(5))
        TextBoxMinSpeedM6.Text = CStr(MD2MINSPEED(6))

        TextBoxMaxSpeedM1.Text = CStr(MD2MAXSPEED(1))
        TextBoxMaxSpeedM2.Text = CStr(MD2MAXSPEED(2))
        TextBoxMaxSpeedM3.Text = CStr(MD2MAXSPEED(3))
        TextBoxMaxSpeedM4.Text = CStr(MD2MAXSPEED(4))
        TextBoxMaxSpeedM5.Text = CStr(MD2MAXSPEED(5))
        TextBoxMaxSpeedM6.Text = CStr(MD2MAXSPEED(6))

        TextBoxSlopeM1.Text = CStr(MD2SLOPE(1))
        TextBoxSlopeM2.Text = CStr(MD2SLOPE(2))
        TextBoxSlopeM3.Text = CStr(MD2SLOPE(3))
        TextBoxSlopeM4.Text = CStr(MD2SLOPE(4))
        TextBoxSlopeM5.Text = CStr(MD2SLOPE(5))
        TextBoxSlopeM6.Text = CStr(MD2SLOPE(6))

        TextBoxBacklashM1.Text = CStr(MD2BACKLASH(1))
        TextBoxBacklashM2.Text = CStr(MD2BACKLASH(2))
        TextBoxBacklashM3.Text = CStr(MD2BACKLASH(3))
        TextBoxBacklashM4.Text = CStr(MD2BACKLASH(4))
        TextBoxBacklashM5.Text = CStr(MD2BACKLASH(5))
        TextBoxBacklashM6.Text = CStr(MD2BACKLASH(6))

        If MD2HOMEDIR(1) = 0 Then CheckBoxHomeDirM1.Checked = True Else CheckBoxHomeDirM1.Checked = False
        If MD2HOMEDIR(2) = 0 Then CheckBoxHomeDirM2.Checked = True Else CheckBoxHomeDirM2.Checked = False
        If MD2HOMEDIR(3) = 0 Then CheckBoxHomeDirM3.Checked = True Else CheckBoxHomeDirM3.Checked = False
        If MD2HOMEDIR(4) = 0 Then CheckBoxHomeDirM4.Checked = True Else CheckBoxHomeDirM4.Checked = False
        If MD2HOMEDIR(5) = 0 Then CheckBoxHomeDirM5.Checked = True Else CheckBoxHomeDirM5.Checked = False
        If MD2HOMEDIR(6) = 0 Then CheckBoxHomeDirM6.Checked = True Else CheckBoxHomeDirM6.Checked = False

        'Step type.
        If MD2STEPTYPE = "H" Then RadioButtonHalf.Checked = True
        If MD2STEPTYPE = "S" Then RadioButtonSingle.Checked = True
        If MD2STEPTYPE = "D" Then RadioButtonDouble.Checked = True

        'Move type.
        If MD2MOVETYPE = "A" Then RadioButtonAbsolute.Checked = True
        If MD2MOVETYPE = "R" Then RadioButtonRelative.Checked = True

        'Hold.
        If MD2HOLD = -1 Then CheckBoxHold.Checked = True Else CheckBoxHold.Checked = False

        'Display port
        'If PP addr = 0 and C4 port "", then set message
        'Motors 1&2
        LabelPortMD212.Text = "Click to set port"     'Default message.
        If MD2PORT12 <> 0 Then LabelPortMD212.Text = "Port " & Hex(Val(MD2PORT12)) & " Hex"
        If MD2C4PORT12 <> "" Then LabelPortMD212.Text = "C4 " & MD2C4PORT12 & "," & MD2C4ID12 & "," & MD2C4CONNECTOR12
        'Motors 3&4
        LabelPortMD234.Text = "Click to set port"     'Default message.
        If MD2PORT34 <> 0 Then LabelPortMD234.Text = "Port " & Hex(Val(MD2PORT34)) & " Hex"
        If MD2C4PORT34 <> "" Then LabelPortMD234.Text = "C4 " & MD2C4PORT34 & "," & MD2C4ID34 & "," & MD2C4CONNECTOR34
        'Motors 5&6
        LabelPortMD256.Text = "Click to set port"     'Default message.
        If MD2PORT56 <> 0 Then LabelPortMD256.Text = "Port " & Hex(Val(MD2PORT56)) & " Hex"
        If MD2C4PORT56 <> "" Then LabelPortMD256.Text = "C4 " & MD2C4PORT56 & "," & MD2C4ID56 & "," & MD2C4CONNECTOR56

        'Parameter File Name.
        LabelParameterFile.Text = MD2PARFILE

        'Sequence file name.
        LabelSequenceFile.Text = MD2SEQFILE

        'Update objects on control form --------------------------------------------------------

        'Motor names.
        LabelNameDisplayM1.Text = MD2MOTORNAME(1)
        LabelNameDisplayM2.Text = MD2MOTORNAME(2)
        LabelNameDisplayM3.Text = MD2MOTORNAME(3)
        LabelNameDisplayM4.Text = MD2MOTORNAME(4)
        LabelNameDisplayM5.Text = MD2MOTORNAME(5)
        LabelNameDisplayM6.Text = MD2MOTORNAME(6)

        'Distances.
        'TextBoxDistanceM1.Text = CStr(MD2TARGET(1))
        'TextBoxDistanceM2.Text = CStr(MD2TARGET(2))
        'TextBoxDistanceM3.Text = CStr(MD2TARGET(3))
        'TextBoxDistanceM4.Text = CStr(MD2TARGET(4))
        'TextBoxDistanceM5.Text = CStr(MD2TARGET(5))
        'TextBoxDistanceM6.Text = CStr(MD2TARGET(6))

        'Units labels.
        LabelUnitsDisplayM1.Text = MD2UNITNAME(1)
        LabelUnitsDisplayM2.Text = MD2UNITNAME(2)
        LabelUnitsDisplayM3.Text = MD2UNITNAME(3)
        LabelUnitsDisplayM4.Text = MD2UNITNAME(4)
        LabelUnitsDisplayM5.Text = MD2UNITNAME(5)
        LabelUnitsDisplayM6.Text = MD2UNITNAME(6)

        'Positions.
        TextBoxPositionM1.Text = CStr(MD2POSITION(1))
        TextBoxPositionM2.Text = CStr(MD2POSITION(2))
        TextBoxPositionM3.Text = CStr(MD2POSITION(3))
        TextBoxPositionM4.Text = CStr(MD2POSITION(4))
        TextBoxPositionM5.Text = CStr(MD2POSITION(5))
        TextBoxPositionM6.Text = CStr(MD2POSITION(6))

        'Circle parameters.
        FormCircle.TextBoxCircleCenterX.Text() = CStr(MD2CIRCLECENTERX)
        FormCircle.TextBoxCircleCenterY.Text() = CStr(MD2CIRCLECENTERY)
        FormCircle.TextBoxCircleRadiusX.Text() = CStr(MD2CIRCLERADIUSX)
        FormCircle.TextBoxCircleRadiusY.Text() = CStr(MD2CIRCLERADIUSY)
        FormCircle.TextBoxCircleStart.Text() = CStr(MD2CIRCLESTART)
        FormCircle.TextBoxCircleArc.Text() = CStr(MD2CIRCLEARC)
        FormCircle.TextBoxCircleChord.Text() = CStr(MD2CIRCLECHORD)

        'Grid parameters.
        FormGrid.TextBoxGridBeginX.Text() = CStr(MD2GRIDBEGINX)
        FormGrid.TextBoxGridBeginY.Text() = CStr(MD2GRIDBEGINY)
        FormGrid.TextBoxGridSpacingX.Text() = CStr(MD2GRIDSPACEX)
        FormGrid.TextBoxGridSpacingY.Text() = CStr(MD2GRIDSPACEY)
        FormGrid.TextBoxGridTargetX.Text() = CStr(MD2GRIDTARGETX)
        FormGrid.TextBoxGridTargetY.Text() = CStr(MD2GRIDTARGETY)

        'If no port address set then disable move box.
        If MD2PORT12 <> 0 Or MD2C4PORT12 <> "" Then GroupBoxMove1.Enabled = True Else GroupBoxMove1.Enabled = False
        If MD2PORT34 <> 0 Or MD2C4PORT34 <> "" Then GroupBoxMove2.Enabled = True Else GroupBoxMove2.Enabled = False
        If MD2PORT56 <> 0 Or MD2C4PORT56 <> "" Then GroupBoxMove3.Enabled = True Else GroupBoxMove3.Enabled = False

        'Clear status.
        ShowStatus("")

        'If calibration needed then show message, highlight button
        If MD2VELOCITY(0) = 0 Then
            ShowStatus("Calibration needs to be done before moving motors")
            ButtonControlCalibrate.ForeColor = Color.Red
        Else
            ButtonControlCalibrate.ForeColor = Color.Gray
        End If

        'If no port addresses set then show message, make label red.
        'More important than calibration.
        If MD2PORT12 = 0 And MD2PORT34 = 0 And MD2PORT56 = 0 And MD2C4PORT12 = "" And MD2C4PORT34 = "" And MD2C4PORT56 = "" Then
            ShowStatus("MD2 connection types need to be set on the Parameter screen")
            LabelPortAddress.ForeColor = Color.Red
        Else
            LabelPortAddress.ForeColor = Color.Black
        End If

        'Ensure Standby and Outputs are off if MD2 disabled.
        'There's not a way to display if outputs or standby are on.
        If Not MD2ENABLED12 Then
            CheckBoxEnabled12.Checked = False
            CheckBoxStandby12.Checked = False
            CheckBoxOut11.Checked = False
            CheckBoxOut12.Checked = False
        Else
            CheckBoxEnabled12.Checked = True
        End If
        If Not MD2ENABLED34 Then
            CheckBoxEnabled34.Checked = False
            CheckBoxStandby34.Checked = False
            CheckBoxOut21.Checked = False
            CheckBoxOut22.Checked = False
        Else
            CheckBoxEnabled34.Checked = True
        End If
        If Not MD2ENABLED56 Then
            CheckBoxEnabled56.Checked = False
            CheckBoxStandby56.Checked = False
            CheckBoxOut31.Checked = False
            CheckBoxOut32.Checked = False
        Else
            CheckBoxEnabled56.Checked = True
        End If

    End Sub
    Public Sub SetParameters()

        'Set parameter variables from form values.

        Dim Msg As String       'USED TO CONSTRUCT C4 COMMANDS.

        MD2MOTORNAME(1) = TextBoxMotorNameM1.Text
        MD2MOTORNAME(2) = TextBoxMotorNameM2.Text
        MD2MOTORNAME(3) = TextBoxMotorNameM3.Text
        MD2MOTORNAME(4) = TextBoxMotorNameM4.Text
        MD2MOTORNAME(5) = TextBoxMotorNameM5.Text
        MD2MOTORNAME(6) = TextBoxMotorNameM6.Text

        MD2POSITION(1) = Val(TextBoxPositionPM1.Text)
        MD2POSITION(2) = Val(TextBoxPositionPM2.Text)
        MD2POSITION(3) = Val(TextBoxPositionPM3.Text)
        MD2POSITION(4) = Val(TextBoxPositionPM4.Text)
        MD2POSITION(5) = Val(TextBoxPositionPM5.Text)
        MD2POSITION(6) = Val(TextBoxPositionPM6.Text)

        MD2TARGET(1) = Val(TextBoxDistanceM1.Text)
        MD2TARGET(2) = Val(TextBoxDistanceM2.Text)
        MD2TARGET(3) = Val(TextBoxDistanceM3.Text)
        MD2TARGET(4) = Val(TextBoxDistanceM4.Text)
        MD2TARGET(5) = Val(TextBoxDistanceM5.Text)
        MD2TARGET(6) = Val(TextBoxDistanceM6.Text)

        MD2UNITNAME(1) = TextBoxUnitNameM1.Text
        MD2UNITNAME(2) = TextBoxUnitNameM2.Text
        MD2UNITNAME(3) = TextBoxUnitNameM3.Text
        MD2UNITNAME(4) = TextBoxUnitNameM4.Text
        MD2UNITNAME(5) = TextBoxUnitNameM5.Text
        MD2UNITNAME(6) = TextBoxUnitNameM6.Text

        MD2UNITS(1) = Val(TextBoxUnitValueM1.Text)
        MD2UNITS(2) = Val(TextBoxUnitValueM2.Text)
        MD2UNITS(3) = Val(TextBoxUnitValueM3.Text)
        MD2UNITS(4) = Val(TextBoxUnitValueM4.Text)
        MD2UNITS(5) = Val(TextBoxUnitValueM5.Text)
        MD2UNITS(6) = Val(TextBoxUnitValueM6.Text)

        MD2HOMEOFFSET(1) = Val(TextBoxHomeOffsetM1.Text)
        MD2HOMEOFFSET(2) = Val(TextBoxHomeOffsetM2.Text)
        MD2HOMEOFFSET(3) = Val(TextBoxHomeOffsetM3.Text)
        MD2HOMEOFFSET(4) = Val(TextBoxHomeOffsetM4.Text)
        MD2HOMEOFFSET(5) = Val(TextBoxHomeOffsetM5.Text)
        MD2HOMEOFFSET(6) = Val(TextBoxHomeOffsetM6.Text)

        'Home direction.
        If CheckBoxHomeDirM1.Checked Then MD2HOMEDIR(1) = 0 Else MD2HOMEDIR(1) = -1
        If CheckBoxHomeDirM2.Checked Then MD2HOMEDIR(2) = 0 Else MD2HOMEDIR(2) = -1
        If CheckBoxHomeDirM3.Checked Then MD2HOMEDIR(3) = 0 Else MD2HOMEDIR(3) = -1
        If CheckBoxHomeDirM4.Checked Then MD2HOMEDIR(4) = 0 Else MD2HOMEDIR(4) = -1
        If CheckBoxHomeDirM5.Checked Then MD2HOMEDIR(5) = 0 Else MD2HOMEDIR(5) = -1
        If CheckBoxHomeDirM6.Checked Then MD2HOMEDIR(6) = 0 Else MD2HOMEDIR(6) = -1

        'C4 HOME DIRECTION AND OFFSET.
        Try
            If MD2C4PORT12 <> "" Then
                Msg = "!" & MD2C4ID12 & "wh"        'PREFIX, ID, COMMAND.
                If MD2C4CONNECTOR12 = "a" Then Msg += "1," Else Msg += "3," 'ADJUST FOR CONNECTORS.
                If CheckBoxHomeDirM1.Checked Then Msg += "r" Else Msg += "f" 'DIRECTION.
                Msg += "," & Val(TextBoxHomeOffsetM1.Text) & vbCr                 'OFFSET.
                MD2C4COM12.Write(Msg)               'SEND COMMAND.
                MD2C4COM12.ReadTo("a")              'WAIT FOR a

                Msg = "!" & MD2C4ID12 & "wh"        'PREFIX, ID, COMMAND.
                If MD2C4CONNECTOR12 = "a" Then Msg += "2," Else Msg += "4," 'ADJUST FOR CONNECTORS.
                If CheckBoxHomeDirM2.Checked Then Msg += "r" Else Msg += "f" 'DIRECTION.
                Msg += "," & Val(TextBoxHomeOffsetM2.Text) & vbCr                 'OFFSET.
                MD2C4COM12.Write(Msg)               'SEND COMMAND.
                MD2C4COM12.ReadTo("a")              'WAIT FOR a
            End If
            If MD2C4PORT34 <> "" Then
                Msg = "!" & MD2C4ID34 & "wh"        'PREFIX, ID, COMMAND.
                If MD2C4CONNECTOR34 = "a" Then Msg += "1," Else Msg += "3," 'ADJUST FOR CONNECTORS.
                If CheckBoxHomeDirM3.Checked Then Msg += "r" Else Msg += "f" 'DIRECTION.
                Msg += "," & Val(TextBoxHomeOffsetM3.Text) & vbCr                 'OFFSET.
                MD2C4COM34.Write(Msg)               'SEND COMMAND.
                MD2C4COM34.ReadTo("a")              'WAIT FOR a

                Msg = "!" & MD2C4ID34 & "wh"        'PREFIX, ID, COMMAND.
                If MD2C4CONNECTOR34 = "a" Then Msg += "2," Else Msg += "4," 'ADJUST FOR CONNECTORS.
                If CheckBoxHomeDirM4.Checked Then Msg += "r" Else Msg += "f" 'DIRECTION.
                Msg += "," & Val(TextBoxHomeOffsetM4.Text) & vbCr                 'OFFSET.
                MD2C4COM34.Write(Msg)               'SEND COMMAND.
                MD2C4COM34.ReadTo("a")              'WAIT FOR a
            End If
            If MD2C4PORT56 <> "" Then
                Msg = "!" & MD2C4ID56 & "wh"        'PREFIX, ID, COMMAND.
                If MD2C4CONNECTOR56 = "a" Then Msg += "1," Else Msg += "3," 'ADJUST FOR CONNECTORS.
                If CheckBoxHomeDirM5.Checked Then Msg += "r" Else Msg += "f" 'DIRECTION.
                Msg += "," & Val(TextBoxHomeOffsetM5.Text) & vbCr                 'OFFSET.
                MD2C4COM56.Write(Msg)               'SEND COMMAND.
                MD2C4COM56.ReadTo("a")              'WAIT FOR a

                Msg = "!" & MD2C4ID56 & "wh"        'PREFIX, ID, COMMAND.
                If MD2C4CONNECTOR56 = "a" Then Msg += "2," Else Msg += "4," 'ADJUST FOR CONNECTORS.
                If CheckBoxHomeDirM6.Checked Then Msg += "r" Else Msg += "f" 'DIRECTION.
                Msg += "," & Val(TextBoxHomeOffsetM6.Text) & vbCr                 'OFFSET.
                MD2C4COM56.Write(Msg)               'SEND COMMAND.
                MD2C4COM56.ReadTo("a")              'WAIT FOR a
            End If
        Catch
            'NO ERROR RESPONSE.
        End Try

        MD2LIMITR(1) = Val(TextBoxLimitRM1.Text)
        MD2LIMITR(2) = Val(TextBoxLimitRM2.Text)
        MD2LIMITR(3) = Val(TextBoxLimitRM3.Text)
        MD2LIMITR(4) = Val(TextBoxLimitRM4.Text)
        MD2LIMITR(5) = Val(TextBoxLimitRM5.Text)
        MD2LIMITR(6) = Val(TextBoxLimitRM6.Text)

        MD2LIMITF(1) = Val(TextBoxLimitFM1.Text)
        MD2LIMITF(2) = Val(TextBoxLimitFM2.Text)
        MD2LIMITF(3) = Val(TextBoxLimitFM3.Text)
        MD2LIMITF(4) = Val(TextBoxLimitFM4.Text)
        MD2LIMITF(5) = Val(TextBoxLimitFM5.Text)
        MD2LIMITF(6) = Val(TextBoxLimitFM6.Text)

        MD2MINSPEED(1) = Val(TextBoxMinSpeedM1.Text)
        MD2MINSPEED(2) = Val(TextBoxMinSpeedM2.Text)
        MD2MINSPEED(3) = Val(TextBoxMinSpeedM3.Text)
        MD2MINSPEED(4) = Val(TextBoxMinSpeedM4.Text)
        MD2MINSPEED(5) = Val(TextBoxMinSpeedM5.Text)
        MD2MINSPEED(6) = Val(TextBoxMinSpeedM6.Text)

        MD2MAXSPEED(1) = Val(TextBoxMaxSpeedM1.Text)
        MD2MAXSPEED(2) = Val(TextBoxMaxSpeedM2.Text)
        MD2MAXSPEED(3) = Val(TextBoxMaxSpeedM3.Text)
        MD2MAXSPEED(4) = Val(TextBoxMaxSpeedM4.Text)
        MD2MAXSPEED(5) = Val(TextBoxMaxSpeedM5.Text)
        MD2MAXSPEED(6) = Val(TextBoxMaxSpeedM6.Text)

        MD2SLOPE(1) = Val(TextBoxSlopeM1.Text)
        MD2SLOPE(2) = Val(TextBoxSlopeM2.Text)
        MD2SLOPE(3) = Val(TextBoxSlopeM3.Text)
        MD2SLOPE(4) = Val(TextBoxSlopeM4.Text)
        MD2SLOPE(5) = Val(TextBoxSlopeM5.Text)
        MD2SLOPE(6) = Val(TextBoxSlopeM6.Text)

        'C4 VELOCITY PARAMETERS.
        Try
            If MD2C4PORT12 <> "" Then
                Msg = "!" & MD2C4ID12 & "wv"                'PREFIX, ID, COMMAND.
                If MD2C4CONNECTOR12 = "a" Then Msg += "1" Else Msg += "3" 'ADJUST FOR CONNECTORS.
                Msg += "," & Val(TextBoxMinSpeedM1.Text)    'MIN SPEED.
                Msg += "," & Val(TextBoxMaxSpeedM1.Text)    'MAX SPEED.
                Msg += "," & Val(TextBoxSlopeM1.Text)       'SLOPE.
                Msg += vbCr
                MD2C4COM12.Write(Msg)                       'SEND COMMAND.
                MD2C4COM12.ReadTo("a")                      'WAIT FOR a

                Msg = "!" & MD2C4ID12 & "wv"                'PREFIX, ID, COMMAND.
                If MD2C4CONNECTOR12 = "a" Then Msg += "2" Else Msg += "4" 'ADJUST FOR CONNECTORS.
                Msg += "," & Val(TextBoxMinSpeedM2.Text)    'MIN SPEED.
                Msg += "," & Val(TextBoxMaxSpeedM2.Text)    'MAX SPEED.
                Msg += "," & Val(TextBoxSlopeM2.Text)       'SLOPE.
                Msg += vbCr
                MD2C4COM12.Write(Msg)                       'SEND COMMAND.
                MD2C4COM12.ReadTo("a")                      'WAIT FOR a
            End If
            If MD2C4PORT34 <> "" Then
                Msg = "!" & MD2C4ID34 & "wv"                'PREFIX, ID, COMMAND.
                If MD2C4CONNECTOR34 = "a" Then Msg += "1" Else Msg += "3" 'ADJUST FOR CONNECTORS.
                Msg += "," & Val(TextBoxMinSpeedM3.Text)    'MIN SPEED.
                Msg += "," & Val(TextBoxMaxSpeedM3.Text)    'MAX SPEED.
                Msg += "," & Val(TextBoxSlopeM3.Text)       'SLOPE.
                Msg += vbCr
                MD2C4COM34.Write(Msg)                       'SEND COMMAND.
                MD2C4COM34.ReadTo("a")                      'WAIT FOR a

                Msg = "!" & MD2C4ID34 & "wv"                'PREFIX, ID, COMMAND.
                If MD2C4CONNECTOR34 = "a" Then Msg += "2" Else Msg += "4" 'ADJUST FOR CONNECTORS.
                Msg += "," & Val(TextBoxMinSpeedM4.Text)    'MIN SPEED.
                Msg += "," & Val(TextBoxMaxSpeedM4.Text)    'MAX SPEED.
                Msg += "," & Val(TextBoxSlopeM4.Text)       'SLOPE.
                Msg += vbCr
                MD2C4COM34.Write(Msg)                       'SEND COMMAND.
                MD2C4COM34.ReadTo("a")                      'WAIT FOR a
            End If
            If MD2C4PORT56 <> "" Then
                Msg = "!" & MD2C4ID56 & "wv"                'PREFIX, ID, COMMAND.
                If MD2C4CONNECTOR56 = "a" Then Msg += "1" Else Msg += "3" 'ADJUST FOR CONNECTORS.
                Msg += "," & Val(TextBoxMinSpeedM5.Text)    'MIN SPEED.
                Msg += "," & Val(TextBoxMaxSpeedM5.Text)    'MAX SPEED.
                Msg += "," & Val(TextBoxSlopeM5.Text)       'SLOPE.
                Msg += vbCr
                MD2C4COM56.Write(Msg)                       'SEND COMMAND.
                MD2C4COM56.ReadTo("a")                      'WAIT FOR a

                Msg = "!" & MD2C4ID56 & "wv"                'PREFIX, ID, COMMAND.
                If MD2C4CONNECTOR56 = "a" Then Msg += "2" Else Msg += "4" 'ADJUST FOR CONNECTORS.
                Msg += "," & Val(TextBoxMinSpeedM6.Text)    'MIN SPEED.
                Msg += "," & Val(TextBoxMaxSpeedM6.Text)    'MAX SPEED.
                Msg += "," & Val(TextBoxSlopeM6.Text)       'SLOPE.
                Msg += vbCr
                MD2C4COM56.Write(Msg)                       'SEND COMMAND.
                MD2C4COM56.ReadTo("a")                      'WAIT FOR a
            End If
        Catch
            'NO ERROR RESPONSE.
        End Try

        MD2BACKLASH(1) = Val(TextBoxBacklashM1.Text)
        MD2BACKLASH(2) = Val(TextBoxBacklashM2.Text)
        MD2BACKLASH(3) = Val(TextBoxBacklashM3.Text)
        MD2BACKLASH(4) = Val(TextBoxBacklashM4.Text)
        MD2BACKLASH(5) = Val(TextBoxBacklashM5.Text)
        MD2BACKLASH(6) = Val(TextBoxBacklashM6.Text)

        'Step type.
        If RadioButtonHalf.Checked Then MD2STEPTYPE = "H"
        If RadioButtonSingle.Checked Then MD2STEPTYPE = "S"
        If RadioButtonDouble.Checked Then MD2STEPTYPE = "D"

        'Move type.
        If RadioButtonAbsolute.Checked Then MD2MOVETYPE = "A"
        If RadioButtonRelative.Checked Then MD2MOVETYPE = "R"

        'Hold
        If CheckBoxHold.Checked Then MD2HOLD = -1 Else MD2HOLD = 0
        Try
            If MD2C4PORT12 <> "" Then
                Msg = "!" & MD2C4ID12 & "wk"                'PREFIX, ID, COMMAND.
                If MD2HOLD = 0 Then
                    Msg = Msg & "0,5"                       'OFF AFTER 5 SECONDS.
                Else
                    Msg = Msg & "1,5"                       'ON FOREVER.
                End If
                Msg += vbCr
                MD2C4COM12.Write(Msg)                       'SEND COMMAND.
                MD2C4COM12.ReadTo("a")                      'WAIT FOR a
            End If
            If MD2C4PORT34 <> "" Then
                Msg = "!" & MD2C4ID34 & "wk"                'PREFIX, ID, COMMAND.
                If MD2HOLD = 0 Then
                    Msg = Msg & "0,5"                       'OFF AFTER 5 SECONDS.
                Else
                    Msg = Msg & "1,5"                       'ON FOREVER.
                End If
                Msg += vbCr
                MD2C4COM34.Write(Msg)                       'SEND COMMAND.
                MD2C4COM34.ReadTo("a")                      'WAIT FOR a
            End If
            If MD2C4PORT56 <> "" Then
                Msg = "!" & MD2C4ID56 & "wk"                'PREFIX, ID, COMMAND.
                If MD2HOLD = 0 Then
                    Msg = Msg & "0,5"                       'OFF AFTER 5 SECONDS.
                Else
                    Msg = Msg & "1,5"                       'ON FOREVER.
                End If
                Msg += vbCr
                MD2C4COM56.Write(Msg)                       'SEND COMMAND.
                MD2C4COM56.ReadTo("a")                      'WAIT FOR a
            End If
        Catch
            'NO ERROR RESPONSE.
        End Try

        MD2INTERRUPTS = True 'force this due to dead mouse and locking up in xp

        'Pre-C4 code
        'Port addresses.  Display as hex, save as integer.
        'Try
        'Convert text box which contains a hex value into an integer.
        'MD2PORT12 = Convert.ToInt32(TextBoxPortM12.Text, 16)
        'Catch
        'If invalid hex value then set to zero
        'TextBoxPortM12.Text = 0
        'MD2PORT12 = 0
        'End Try
        'Try
        'Convert text box which contains a hex value into an integer.
        'MD2PORT34 = Convert.ToInt32(TextBoxPortM34.Text, 16)
        'Catch
        'If invalid hex value then set to zero
        'TextBoxPortM34.Text = 0
        'MD2PORT34 = 0
        'End Try
        'Try
        'Convert text box which contains a hex value into an integer.
        'MD2PORT56 = Convert.ToInt32(TextBoxPortM56.Text, 16)
        'Catch
        'If invalid hex value then set to zero
        'TextBoxPortM56.Text = 0
        'MD2PORT56 = 0
        'End Try

        'Circle parameters.
        MD2CIRCLECENTERX = Val(FormCircle.TextBoxCircleCenterX.Text)
        MD2CIRCLECENTERY = Val(FormCircle.TextBoxCircleCenterY.Text)
        MD2CIRCLERADIUSX = Val(FormCircle.TextBoxCircleRadiusX.Text)
        MD2CIRCLERADIUSY = Val(FormCircle.TextBoxCircleRadiusY.Text)
        MD2CIRCLESTART = Val(FormCircle.TextBoxCircleStart.Text)
        MD2CIRCLEARC = Val(FormCircle.TextBoxCircleArc.Text)
        MD2CIRCLECHORD = Val(FormCircle.TextBoxCircleChord.Text)

        'Grid parameters.
        MD2GRIDBEGINX = Val(FormGrid.TextBoxGridBeginX.Text)
        MD2GRIDBEGINY = Val(FormGrid.TextBoxGridBeginY.Text)
        MD2GRIDSPACEX = Val(FormGrid.TextBoxGridSpacingX.Text)
        MD2GRIDSPACEY = Val(FormGrid.TextBoxGridSpacingY.Text)
        MD2GRIDTARGETX = Val(FormGrid.TextBoxGridTargetX.Text)
        MD2GRIDTARGETY = Val(FormGrid.TextBoxGridTargetY.Text)

    End Sub
    Private Sub Tabs_SelectedIndexChanged(ByVal sender As Object, ByVal e As EventArgs) Handles Tabs.SelectedIndexChanged

        'If tabs change then set motor parameters to match forms
        SetParameters()

        'Update forms
        SetForms()

        'leave this on all the time now, except for moves.
        'Turn IO scanning timer on when in IO tab.
        'If Tabs.SelectedTab.Name = "TabIO" Then TimerIOScan.Enabled = True Else TimerIOScan.Enabled = False

    End Sub
    Private Sub TimerIOScan_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TimerIOScan.Tick

        'Repeatedly update status of inputs on I/O tab.
        'And Home LEDs on control tab.
        'And sequence cursor location

        'Update cursor location on sequence screen.
        LabelCursorLocation.Text = TextBoxSequence.SelectionStart + 1

        'Read inputs.
        MD2INPUTS()

        'If MD2 #1 available then...
        If MD2ENABLED12 <> 0 Then
            'Update screen with status of inputs.
            If MD2INPUT(11) Then
                LabelInput11.Text = "On"
                ButtonHomeM1.BackColor = Color.PaleGreen
            Else
                LabelInput11.Text = "Off"
                ButtonHomeM1.BackColor = Color.Transparent
            End If
            If MD2INPUT(12) Then
                LabelInput12.Text = "On"
                ButtonHomeM2.BackColor = Color.PaleGreen
            Else
                LabelInput12.Text = "Off"
                ButtonHomeM2.BackColor = Color.Transparent
            End If
            If MD2INPUT(13) Then LabelInput13.Text = "On" Else LabelInput13.Text = "Off"
            If MD2INPUT(14) Then LabelInput14.Text = "On" Else LabelInput14.Text = "Off"
            If MD2INPUT(15) Then LabelInput15.Text = "On" Else LabelInput15.Text = "Off"
            'Control Outputs by changing checking boxes on control form.
            If CheckBoxOutput11.Checked Then CheckBoxOut11.Checked = True Else CheckBoxOut11.Checked = False
            If CheckBoxOutput12.Checked Then CheckBoxOut12.Checked = True Else CheckBoxOut12.Checked = False
        End If

        'If MD2 #2 available then...
        If MD2ENABLED34 <> 0 Then
            If MD2INPUT(21) Then
                LabelInput21.Text = "On"
                ButtonHomeM3.BackColor = Color.PaleGreen
            Else
                LabelInput21.Text = "Off"
                ButtonHomeM3.BackColor = Color.Transparent
            End If
            If MD2INPUT(22) Then
                LabelInput22.Text = "On"
                ButtonHomeM4.BackColor = Color.PaleGreen
            Else
                LabelInput22.Text = "Off"
                ButtonHomeM4.BackColor = Color.Transparent
            End If
            If MD2INPUT(23) Then LabelInput23.Text = "On" Else LabelInput23.Text = "Off"
            If MD2INPUT(24) Then LabelInput24.Text = "On" Else LabelInput24.Text = "Off"
            If MD2INPUT(25) Then LabelInput25.Text = "On" Else LabelInput25.Text = "Off"
            'Control Outputs by changing checking boxes on control form.
            If CheckBoxOutput21.Checked Then CheckBoxOut21.Checked = True Else CheckBoxOut21.Checked = False
            If CheckBoxOutput22.Checked Then CheckBoxOut22.Checked = True Else CheckBoxOut22.Checked = False
        End If

        'If MD2 #3 available then...
        If MD2ENABLED56 <> 0 Then
            'Update screen with status of inputs.
            If MD2INPUT(31) Then
                LabelInput31.Text = "On"
                ButtonHomeM5.BackColor = Color.PaleGreen
            Else
                LabelInput31.Text = "Off"
                ButtonHomeM5.BackColor = Color.Transparent
            End If
            If MD2INPUT(32) Then
                LabelInput32.Text = "On"
                ButtonHomeM6.BackColor = Color.PaleGreen
            Else
                LabelInput32.Text = "Off"
                ButtonHomeM6.BackColor = Color.Transparent
            End If
            If MD2INPUT(33) Then LabelInput33.Text = "On" Else LabelInput33.Text = "Off"
            If MD2INPUT(34) Then LabelInput34.Text = "On" Else LabelInput34.Text = "Off"
            If MD2INPUT(35) Then LabelInput35.Text = "On" Else LabelInput35.Text = "Off"
            'Control Outputs by changing checking boxes on control form.
            If CheckBoxOutput31.Checked Then CheckBoxOut31.Checked = True Else CheckBoxOut31.Checked = False
            If CheckBoxOutput32.Checked Then CheckBoxOut32.Checked = True Else CheckBoxOut32.Checked = False
        End If

    End Sub
    Private Sub CheckBoxOut11_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBoxOut11.CheckedChanged

        'Create output code based on check box status.
        If CheckBoxOut11.Checked Then
            CheckBoxOutput11.Checked = True     'Adjust check box on I/O form too.
            MD2OUTPUTCODE = 111
        Else
            CheckBoxOutput11.Checked = False    'Adjust check box on I/O form too.
            MD2OUTPUTCODE = 110
        End If

        'Turn on/off the output
        MD2OUTPUTS()

        'If unsuccesful doing output, turn off check boxes.
        If MD2STATUS <> "O" Then
            CheckBoxOut11.Checked = False       'Adjust check box on Control form.
            CheckBoxOutput11.Checked = False    'Adjust check box on I/O form.
        Else
            'Teach Mode.
            If CheckBoxTeachMode.Checked Then
                TextBoxSequence.Text += "MD2OUTPUTCODE=" & CStr(MD2OUTPUTCODE) & " : MD2OUTPUTS" & vbCrLf
            End If
        End If

        'Display status.
        ShowStatus(MD2STATUS)

    End Sub
    Private Sub CheckBoxOut12_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBoxOut12.CheckedChanged

        'Create output code based on check box status.
        If CheckBoxOut12.Checked Then
            CheckBoxOutput12.Checked = True     'Adjust check box on I/O form too.
            MD2OUTPUTCODE = 121
        Else
            CheckBoxOutput12.Checked = False    'Adjust check box on I/O form too.
            MD2OUTPUTCODE = 120
        End If

        'Turn on/off the output
        MD2OUTPUTS()

        'If unsuccesful doing output, turn off check boxes.
        If MD2STATUS <> "O" Then
            CheckBoxOut12.Checked = False       'Adjust check box on Control form.
            CheckBoxOutput12.Checked = False    'Adjust check box on I/O form.
        Else
            'Teach Mode.
            If CheckBoxTeachMode.Checked Then
                TextBoxSequence.Text += "MD2OUTPUTCODE=" & CStr(MD2OUTPUTCODE) & " : MD2OUTPUTS" & vbCrLf
            End If
        End If

        'Display status.
        ShowStatus(MD2STATUS)

    End Sub
    Private Sub CheckBoxOut21_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBoxOut21.CheckedChanged

        'Create output code based on check box status.
        If CheckBoxOut21.Checked Then
            CheckBoxOutput21.Checked = True     'Adjust check box on I/O form too.
            MD2OUTPUTCODE = 211
        Else
            CheckBoxOutput21.Checked = False    'Adjust check box on I/O form too.
            MD2OUTPUTCODE = 210
        End If

        'Turn on/off the output
        MD2OUTPUTS()

        'If unsuccesful doing output, turn off check boxes.
        If MD2STATUS <> "O" Then
            CheckBoxOut21.Checked = False       'Adjust check box on Control form.
            CheckBoxOutput21.Checked = False    'Adjust check box on I/O form.
        Else
            'Teach Mode.
            If CheckBoxTeachMode.Checked Then
                TextBoxSequence.Text += "MD2OUTPUTCODE=" & CStr(MD2OUTPUTCODE) & " : MD2OUTPUTS" & vbCrLf
            End If
        End If

        'Display status.
        ShowStatus(MD2STATUS)

    End Sub
    Private Sub CheckBoxOut22_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBoxOut22.CheckedChanged

        'Create output code based on check box status.
        If CheckBoxOut22.Checked Then
            CheckBoxOutput22.Checked = True     'Adjust check box on I/O form too.
            MD2OUTPUTCODE = 221
        Else
            CheckBoxOutput22.Checked = False    'Adjust check box on I/O form too.
            MD2OUTPUTCODE = 220
        End If

        'Turn on/off the output
        MD2OUTPUTS()

        'If unsuccesful doing output, turn off check boxes.
        If MD2STATUS <> "O" Then
            CheckBoxOut22.Checked = False       'Adjust check box on Control form.
            CheckBoxOutput22.Checked = False    'Adjust check box on I/O form.
        Else
            'Teach Mode.
            If CheckBoxTeachMode.Checked Then
                TextBoxSequence.Text += "MD2OUTPUTCODE=" & CStr(MD2OUTPUTCODE) & " : MD2OUTPUTS" & vbCrLf
            End If
        End If

        'Display status.
        ShowStatus(MD2STATUS)

    End Sub
    Private Sub CheckBoxOut31_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBoxOut31.CheckedChanged

        'Create output code based on check box status.
        If CheckBoxOut31.Checked Then
            CheckBoxOutput31.Checked = True     'Adjust check box on I/O form too.
            MD2OUTPUTCODE = 311
        Else
            CheckBoxOutput31.Checked = False    'Adjust check box on I/O form too.
            MD2OUTPUTCODE = 310
        End If

        'Turn on/off the output
        MD2OUTPUTS()

        'If unsuccesful doing output, turn off check boxes.
        If MD2STATUS <> "O" Then
            CheckBoxOut31.Checked = False       'Adjust check box on Control form.
            CheckBoxOutput31.Checked = False    'Adjust check box on I/O form.
        Else
            'Teach Mode.
            If CheckBoxTeachMode.Checked Then
                TextBoxSequence.Text += "MD2OUTPUTCODE=" & CStr(MD2OUTPUTCODE) & " : MD2OUTPUTS" & vbCrLf
            End If
        End If

        'Display status.
        ShowStatus(MD2STATUS)

    End Sub
    Private Sub CheckBoxOut32_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBoxOut32.CheckedChanged

        'Create output code based on check box status.
        If CheckBoxOut32.Checked Then
            CheckBoxOutput32.Checked = True     'Adjust check box on I/O form too.
            MD2OUTPUTCODE = 321
        Else
            CheckBoxOutput32.Checked = False    'Adjust check box on I/O form too.
            MD2OUTPUTCODE = 320
        End If

        'Turn on/off the output
        MD2OUTPUTS()

        'If unsuccesful doing output, turn off check boxes.
        If MD2STATUS <> "O" Then
            CheckBoxOut32.Checked = False       'Adjust check box on Control form.
            CheckBoxOutput32.Checked = False    'Adjust check box on I/O form.
        Else
            'Teach Mode.
            If CheckBoxTeachMode.Checked Then
                TextBoxSequence.Text += "MD2OUTPUTCODE=" & CStr(MD2OUTPUTCODE) & " : MD2OUTPUTS" & vbCrLf
            End If
        End If

        'Display status.
        ShowStatus(MD2STATUS)

    End Sub
    Public Sub ShowStatus(ByVal StatusCode As String)

        'Displays status message on control tab.
        If StatusCode = "" Then LabelStatus.Text = "" 'No text.
        If StatusCode = "O" Then LabelStatus.Text = "" 'If OK then show nothing.
        If StatusCode = "B" Then LabelStatus.Text = "Bad Parameter"
        If StatusCode = "L" Then LabelStatus.Text = "Soft Limit Exceeded or Limit Switch ON.  Manually resolve limit switch condition."
        If StatusCode = "K" Then LabelStatus.Text = "Motion Cancelled by Keypress.  Position may be Inaccurate."
        If StatusCode = "P" Then LabelStatus.Text = "Port Not Available"
        If StatusCode = "S" Then LabelStatus.Text = "Setup Not Performed"
        If StatusCode = "E" Then LabelStatus.Text = "MD2 Not Enabled"
        If StatusCode = "C" Then LabelStatus.Text = "Calibration Needed"
        If StatusCode = "M" Then LabelStatus.Text = "Moving....    Press CTRL to Cancel."
        If StatusCode.Length > 1 Then LabelStatus.Text = StatusCode 'User-defined text.

    End Sub
    Private Sub CheckBoxStandby12_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBoxStandby12.CheckedChanged

        'MD2MOTOR used by MD2STANDBYON and MD2STANDBYOFF.
        MD2MOTOR = 12

        'If checked then turn on standby mode, else turn off.
        If CheckBoxStandby12.Checked Then MD2STANDBYON() Else MD2STANDBYOFF()

        'If not successful, don't allow.
        If MD2STATUS <> "O" Then CheckBoxStandby12.Checked = False

        'Display status.
        ShowStatus(MD2STATUS)

        'Teach Mode.
        If CheckBoxTeachMode.Checked And MD2STATUS = "O" Then
            TextBoxSequence.Text += "MD2MOTOR=" & CStr(MD2MOTOR) & " : MD2STANDBY"
            If CheckBoxStandby12.Checked Then TextBoxSequence.Text += "ON" & vbCrLf Else TextBoxSequence.Text += "OFF" & vbCrLf
        End If

    End Sub
    Private Sub CheckBoxStandby34_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBoxStandby34.CheckedChanged

        'MD2MOTOR used by MD2STANDBYON and MD2STANDBYOFF.
        MD2MOTOR = 34

        'If checked then turn on standby mode, else turn off.
        If CheckBoxStandby34.Checked Then MD2STANDBYON() Else MD2STANDBYOFF()

        'If not successful, don't allow.
        If MD2STATUS <> "O" Then CheckBoxStandby34.Checked = False

        'Display status.
        ShowStatus(MD2STATUS)

        'Teach Mode.
        If CheckBoxTeachMode.Checked And MD2STATUS = "O" Then
            TextBoxSequence.Text += "MD2MOTOR=" & CStr(MD2MOTOR) & " : MD2STANDBY"
            If CheckBoxStandby34.Checked Then TextBoxSequence.Text += "ON" & vbCrLf Else TextBoxSequence.Text += "OFF" & vbCrLf
        End If

    End Sub
    Private Sub CheckBoxStandby56_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBoxStandby56.CheckedChanged

        'MD2MOTOR used by MD2STANDBYON and MD2STANDBYOFF.
        MD2MOTOR = 56

        'If checked then turn on standby mode, else turn off.
        If CheckBoxStandby56.Checked Then MD2STANDBYON() Else MD2STANDBYOFF()

        'If not successful, don't allow.
        If MD2STATUS <> "O" Then CheckBoxStandby56.Checked = False

        'Display status.
        ShowStatus(MD2STATUS)

        'Teach Mode.
        If CheckBoxTeachMode.Checked And MD2STATUS = "O" Then
            TextBoxSequence.Text += "MD2MOTOR=" & CStr(MD2MOTOR) & " : MD2STANDBY"
            If CheckBoxStandby56.Checked Then TextBoxSequence.Text += "ON" & vbCrLf Else TextBoxSequence.Text += "OFF" & vbCrLf
        End If

    End Sub
    Private Sub CheckBoxEnabled12_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBoxEnabled12.CheckedChanged

        'Prevents event from firing again.
        Static Dim working As Boolean
        If working Then Exit Sub

        'MD2MOTOR used by MD2ON and MD2OFF.
        MD2MOTOR = 12

        'Either way, turn off check boxes for outputs and standby mode.
        CheckBoxOutput11.Checked = False    'Adjust check box on I/O form.
        CheckBoxOutput12.Checked = False    'Adjust check box on I/O form.
        CheckBoxOut11.Checked = False       'Adjust check box on control form.
        CheckBoxOut12.Checked = False       'Adjust check box on control form.
        CheckBoxStandby12.Checked = False   'Adjust check box for standby mode.

        'If checked then enable, else disable.
        If CheckBoxEnabled12.Checked Then
            MD2ON()
        Else
            MD2OFF()
        End If

        If MD2STATUS <> "O" Then
            working = True                      'Prevents refiring.
            CheckBoxEnabled12.Checked = False   'Uncheck.
            working = False
        End If

        ShowStatus(MD2STATUS)                   'Display status.

        'Teach Mode.
        If CheckBoxTeachMode.Checked And MD2STATUS = "O" Then
            TextBoxSequence.Text += "MD2MOTOR=" & CStr(MD2MOTOR) & " : "
            If CheckBoxEnabled12.Checked Then TextBoxSequence.Text += "MD2ON" & vbCrLf Else TextBoxSequence.Text += "MD2OFF" & vbCrLf
        End If

    End Sub
    Private Sub CheckBoxEnabled34_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBoxEnabled34.CheckedChanged

        'Prevents event from firing again.
        Static Dim working As Boolean
        If working Then Exit Sub

        'MD2MOTOR used by MD2ON and MD2OFF.
        MD2MOTOR = 34

        'Either way, turn off check boxes for outputs and standby mode.
        CheckBoxOutput21.Checked = False    'Adjust check box on I/O form.
        CheckBoxOutput22.Checked = False    'Adjust check box on I/O form.
        CheckBoxOut21.Checked = False       'Adjust check box on control form.
        CheckBoxOut22.Checked = False       'Adjust check box on control form.
        CheckBoxStandby34.Checked = False   'Adjust check box for standby mode.

        'If checked then enable, else disable.
        If CheckBoxEnabled34.Checked Then
            MD2ON()
        Else
            MD2OFF()
        End If

        If MD2STATUS <> "O" Then
            working = True                      'Prevents refiring.
            CheckBoxEnabled34.Checked = False   'Uncheck.
            working = False
        End If

        ShowStatus(MD2STATUS)                    'Display status.

        'Teach Mode.
        If CheckBoxTeachMode.Checked And MD2STATUS = "O" Then
            TextBoxSequence.Text += "MD2MOTOR=" & CStr(MD2MOTOR) & " : "
            If CheckBoxEnabled34.Checked Then TextBoxSequence.Text += "MD2ON" & vbCrLf Else TextBoxSequence.Text += "MD2OFF" & vbCrLf
        End If

    End Sub
    Private Sub CheckBoxEnabled56_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBoxEnabled56.CheckedChanged

        'Prevents event from firing again.
        Static Dim working As Boolean
        If working Then Exit Sub

        'MD2MOTOR used by MD2ON and MD2OFF.
        MD2MOTOR = 56

        'Either way, turn off check boxes for outputs and standby mode.
        CheckBoxOutput31.Checked = False    'Adjust check box on I/O form.
        CheckBoxOutput32.Checked = False    'Adjust check box on I/O form.
        CheckBoxOut31.Checked = False       'Adjust check box on control form.
        CheckBoxOut32.Checked = False       'Adjust check box on control form.
        CheckBoxStandby56.Checked = False   'Adjust check box for standby mode.

        'If checked then enable, else disable.
        If CheckBoxEnabled56.Checked Then
            MD2ON()
        Else
            MD2OFF()
        End If

        If MD2STATUS <> "O" Then
            working = True                      'Prevents refiring.
            CheckBoxEnabled56.Checked = False   'Uncheck.
            working = False
        End If

        ShowStatus(MD2STATUS)                   'Display status.

        'Teach Mode.
        If CheckBoxTeachMode.Checked And MD2STATUS = "O" Then
            TextBoxSequence.Text += "MD2MOTOR=" & CStr(MD2MOTOR) & " : "
            If CheckBoxEnabled56.Checked Then TextBoxSequence.Text += "MD2ON" & vbCrLf Else TextBoxSequence.Text += "MD2OFF" & vbCrLf
        End If

    End Sub
    Private Sub ButtonLoadParameters_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonLoadParameters.Click

        'Setup the open file dialog box
        OpenFileDialog1.InitialDirectory = Application.StartupPath
        OpenFileDialog1.Title = "Load a Parameter File"
        OpenFileDialog1.FileName = ""       'Must be cleared or will return object name!
        OpenFileDialog1.Filter = "MD2xp Parameter File (*.par)|*.par|All files (*.*)|*.*"
        OpenFileDialog1.FilterIndex = 1     'Default filter.

        'Display the open file dialog box.
        OpenFileDialog1.ShowDialog()

        'Load.
        If OpenFileDialog1.FileName <> "" Then
            MD2PARFILE = OpenFileDialog1.FileName       'Set file name.
            MD2PARLOAD()                                'Load parameters.
            SetForms()                                  'Update forms with parameters.
            SetDistances()                              'Update forms with parameters.
            LabelParameterFile.Text = MD2PARFILE        'Update the file name label.
            ParametersUnsaved = False                   'Unsaved flag.
        End If

    End Sub
    Private Sub ButtonSaveParameters_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonSaveParameters.Click

        'Save if there is a file name, else give message.
        If MD2PARFILE <> "" Then
            SetParameters()                         'Set all parameters from forms.
            MD2PARSAVE()                            'Save.
            LabelParameterFile.Text = MD2PARFILE    'Update the file name label.
            ParametersUnsaved = False               'Unsaved flag
        Else
            'Do a Save-As.                
            ButtonSaveAsParameters.PerformClick()
        End If

    End Sub
    Private Sub ButtonSaveAsParameters_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonSaveAsParameters.Click

        'Set all parameters from forms.
        SetParameters()

        'Get file name.
        SaveFileDialog1.InitialDirectory = Application.StartupPath
        SaveFileDialog1.Title = "Save a Parameter File"
        SaveFileDialog1.FileName = ""       'Must be cleared or will return object name!
        SaveFileDialog1.Filter = "Parameter Files (*.par)|*.par|All Files (*.*)|*.*"
        SaveFileDialog1.FilterIndex = 1     'Default filter.

        'Display the save file dialog box.
        SaveFileDialog1.ShowDialog()

        'Save.
        If SaveFileDialog1.FileName <> "" Then
            MD2PARFILE = SaveFileDialog1.FileName   'Get file name from user.
            MD2PARSAVE()                            'Save.
            LabelParameterFile.Text = MD2PARFILE    'Update the file name label.
            ParametersUnsaved = False               'Unsaved flag
        End If

    End Sub
    Private Sub ButtonLoadSequence_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonLoadSequence.Click

        'Setup the open file dialog box
        OpenFileDialog1.InitialDirectory = Application.StartupPath
        OpenFileDialog1.Title = "Load a Sequence File"
        OpenFileDialog1.FileName = ""       'Must be cleared or will return object name!
        OpenFileDialog1.Filter = "Sequence Files (*.bas)|*.bas|All files (*.*)|*.*"
        OpenFileDialog1.FilterIndex = 1     'Default filter.

        'Overwrite unsaved sequence?
        If SequenceUnsaved Then
            If SequenceUnsavedMessage() = Windows.Forms.DialogResult.No Then Exit Sub
        End If

        'Display the open file dialog box.
        OpenFileDialog1.ShowDialog()

        'Load.
        If OpenFileDialog1.FileName <> "" Then
            MD2SEQFILE = OpenFileDialog1.FileName   'Set file name from user.
            MD2SEQLOAD()                            'Load file.
            TextBoxSequence.Text = MD2SEQUENCE      'Update the text box.
            LabelSequenceFile.Text = MD2SEQFILE     'Update the file name label.
            SequenceUnsaved = False                 'Unsaved flag
            ButtonSaveSequence.BackColor = Color.Transparent
            'Un-highlight quick run buttons
            HighlightSequenceButton(0)
            TextBoxSequence.SelectionStart = 0      'Cursor at beginning.
        End If

    End Sub
    Private Sub ButtonSaveSequence_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonSaveSequence.Click

        'If there is a file name then save else give message.
        If MD2SEQFILE <> "" Then
            MD2SEQUENCE = TextBoxSequence.Text      'Set file contents.
            MD2SEQSAVE()                            'Save file.
            LabelSequenceFile.Text = MD2SEQFILE     'Update the file name label.
            SequenceUnsaved = False                 'Unsaved flag
            ButtonSaveSequence.BackColor = Color.Transparent
        Else
            'Do Save-As.
            ButtonSaveAsSequence.PerformClick()
        End If

    End Sub
    Private Sub ButtonSaveAsSequence_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonSaveAsSequence.Click

        'Get file name.
        SaveFileDialog1.InitialDirectory = Application.StartupPath
        SaveFileDialog1.Title = "Save a Sequence File"
        SaveFileDialog1.FileName = ""       'Must be cleared or will return object name!
        SaveFileDialog1.Filter = "Sequence Files (*.bas)|*.bas|All Files (*.*)|*.*"
        SaveFileDialog1.FilterIndex = 1     'Default filter.

        'Display the save file dialog box.
        SaveFileDialog1.ShowDialog()

        'Save.
        If SaveFileDialog1.FileName <> "" Then
            MD2SEQFILE = SaveFileDialog1.FileName
            MD2SEQUENCE = TextBoxSequence.Text
            MD2SEQSAVE()                            'Save.
            LabelSequenceFile.Text = MD2PARFILE     'Update the file name label.
            SequenceUnsaved = False                 'Unsaved flag
            ButtonSaveSequence.BackColor = Color.Transparent
        End If

    End Sub
    Private Sub ButtonRunSequence_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonRunSequence.Click, ButtonProgramRun.Click

        'Run Sequence from beginning.

        'Prepair for run.
        Me.Cursor = Cursors.WaitCursor          'HourGlass Cursor.
        TimerIOScan.Enabled = True              'Turn on I/O Scanner.
        MD2SEQUENCE = TextBoxSequence.Text      'Set text.
        MD2POINTER = 1                          'Start running sequence at beginning.

        GetAsyncKeyState(17)                    'This clears out a buffer or something prevents early abort.

        MD2SEQRUN()                             'Run.
        ShowStatus(MD2STATUS)

        If MD2STATUS <> "O" Then
            MessageBox.Show("Sequence Aborted" & vbCrLf & _
                LabelStatus.Text & vbCrLf & _
                "Location: " & CStr(MD2POINTER) & vbCrLf & _
                "Command: " & MD2COMMAND _
                , "Sequence Aborted" _
                , MessageBoxButtons.OK _
                , MessageBoxIcon.Exclamation _
            )
            TextBoxSequence.SelectionStart = MD2POINTER     'Set cursor position to where abort occured.
        End If

        Me.Cursor = Cursors.Default                 'Normal Cursor.

    End Sub
    Private Sub ButtonSequenceRunSelection_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonSequenceRunSelection.Click

        'Run highlighted section of sequence.

        'Prepair for run.
        Me.Cursor = Cursors.WaitCursor          'HourGlass Cursor.
        TimerIOScan.Enabled = True              'Turn on I/O Scanner.
        MD2SEQUENCE = TextBoxSequence.SelectedText      'Set text.
        MD2POINTER = 1                         'Start running sequence at beginning.

        MD2SEQRUN()                             'Run
        ShowStatus(MD2STATUS)

        If MD2STATUS <> "O" Then
            MessageBox.Show("Sequence Aborted" & vbCrLf & _
                LabelStatus.Text & vbCrLf & _
                "Location: " & CStr(MD2POINTER) & vbCrLf & _
                "Command: " & MD2COMMAND _
                , "Sequence Aborted" _
                , MessageBoxButtons.OK _
                , MessageBoxIcon.Exclamation _
            )
            TextBoxSequence.SelectionStart = MD2POINTER     'Set cursor position to where abort occured.
        End If

        Me.Cursor = Cursors.Default                 'Normal Cursor.

    End Sub
    Private Sub ButtonSequenceRunFrom_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonSequenceRunFrom.Click

        'Run sequence from cursor location.

        'Prepair for run.
        Me.Cursor = Cursors.WaitCursor          'HourGlass Cursor.
        TimerIOScan.Enabled = True              'Turn on I/O Scanner.
        MD2SEQUENCE = TextBoxSequence.Text      'Set text.
        MD2POINTER = TextBoxSequence.SelectionStart + 1   'Start running sequence at cursor location.

        MD2SEQRUN()                             'Run
        ShowStatus(MD2STATUS)

        If MD2STATUS <> "O" Then
            MessageBox.Show("Sequence Aborted" & vbCrLf & _
                LabelStatus.Text & vbCrLf & _
                "Sequence Aborted" & vbCrLf & _
                "Location: " & CStr(MD2POINTER) & vbCrLf & _
                "Command: " & MD2COMMAND _
                , "Sequence Aborted" _
                , MessageBoxButtons.OK _
                , MessageBoxIcon.Exclamation _
            )
            TextBoxSequence.SelectionStart = MD2POINTER     'Set cursor position to where abort occured.
        End If

        Me.Cursor = Cursors.Default                 'Normal Cursor.

    End Sub
    Private Sub ButtonMoveLine_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonMoveLine.Click

        'Open Line move form.
        FormLine.Show()
        FormLine.Focus()

    End Sub
    Private Sub ButtonMoveCircle_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonMoveCircle.Click

        'Open circle move form.
        FormCircle.Show()
        FormCircle.Focus()

    End Sub
    Private Sub ButtonMoveGrid_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonMoveGrid.Click

        'Open grid move form.
        FormGrid.Show()
        FormGrid.Focus()

    End Sub
    Private Sub ButtonShowCal_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonShowCal.Click

        'Show calibration array.

        Dim i As Integer = 0
        Dim c As String = ""

        c = c & "  #                  Delay Loop      Velocity (SPS)" & vbCrLf
        For i = 0 To 62
            c = c & Microsoft.VisualBasic.Right("     " & Str(i), 4)
            c = c & Microsoft.VisualBasic.Right("                                     " & Str(MD2DELAY(i)), 25)
            c = c & Microsoft.VisualBasic.Right("                                     " & Str(MD2VELOCITY(i)), 25)
            c = c & vbCrLf
            TextBoxUtilities.Text = c
        Next

    End Sub
    Private Sub ButtonTestMove_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonTestMove.Click

        'Test move speeds.
        Dim i As Integer

        MD2MOTOR = 1
        MD2ON()

        TextBoxUtilities.Text = ""

        For i = 0 To 62
            If MD2VELOCITY(i) > 0.5 And MD2VELOCITY(i) < 12000 Then
                MD2MINSPEED(1) = MD2VELOCITY(i)
                MoveSpeedCheck()
            End If
        Next
        MD2OFF()
        Exit Sub

        MD2MINSPEED(1) = 1
        MoveSpeedCheck()

        MD2MINSPEED(1) = 10
        'MoveSpeedCheck()

        MD2MINSPEED(1) = 100
        MoveSpeedCheck()

        MD2MINSPEED(1) = 500
        'MoveSpeedCheck()

        MD2MINSPEED(1) = 1000
        MoveSpeedCheck()

        MD2MINSPEED(1) = 2500
        MoveSpeedCheck()

        MD2MINSPEED(1) = 5000
        'MoveSpeedCheck()

        MD2MINSPEED(1) = 10000
        MoveSpeedCheck()

        MD2OFF()

    End Sub
    Private Sub MoveSpeedCheck()

        'Check a motor speed.
        'This sub used by ButtonTextMove_Click

        Dim x As String = ""
        Dim t1 As Single = 0
        Dim t2 As Single = 0
        Dim speed As Single = 0
        Dim Secs As Integer = 2     'Approx time for each move

        MD2LIMITF(1) = 10000000
        MD2POSITION(1) = 0
        MD2MAXSPEED(1) = MD2MINSPEED(1)
        MD2SLOPE(1) = 0
        MD2MOVETYPE = "R"
        MD2TARGET(1) = Int(MD2MINSPEED(1) * Secs)
        If MD2TARGET(1) < 2 Then MD2TARGET(1) = 2

        'Wait until edge of time change.
        t1 = Microsoft.VisualBasic.DateAndTime.Timer
        Do Until t1 <> Microsoft.VisualBasic.DateAndTime.Timer
        Loop

        'Time move
        t1 = Microsoft.VisualBasic.DateAndTime.Timer
        MD2MOVE()
        t2 = Microsoft.VisualBasic.DateAndTime.Timer

        speed = (MD2TARGET(1) / (t2 - t1))

        x += "Status: " & MD2STATUS & vbCrLf
        x += "Steps: " & MD2TARGET(1) & vbCrLf
        x += "Time: " & t2 - t1 & vbCrLf
        x += "Desired Speed: " & MD2MINSPEED(1) & vbCrLf
        x += "True Speed: " & speed & vbCrLf
        x += "Speed error: " & (Int((Math.Abs(MD2MINSPEED(1) - speed) / MD2MINSPEED(1)) * 1000)) / 10 & "%" & vbCrLf & vbCrLf

        TextBoxUtilities.Text = TextBoxUtilities.Text & x
        Application.DoEvents()

    End Sub
    Private Sub ButtonTweak_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonTweak.Click

        'Experimental tweaking of calibration array elements.
        'Does not save values to cal file.

        'Tweak velocity array.
        Dim i As Integer
        Dim t1 As Single
        Dim t2 As Single
        Dim speed As Double
        Dim speederror As Double

        MD2MOTOR = 1
        MD2ON()

        TextBoxUtilities.Text = "Tweaking...... "
        Application.DoEvents()

        For i = 0 To 62

            'Only tweak values in this range.
            If MD2VELOCITY(i) > 0.1 And MD2VELOCITY(i) < 12000 Then

                MD2MINSPEED(1) = MD2VELOCITY(i)
                MD2TARGET(1) = MD2VELOCITY(i) * 2  'Do 2 seconds of movement.
                If MD2TARGET(1) < 2 Then MD2TARGET(1) = 2

                MD2MAXSPEED(1) = MD2MINSPEED(1)
                MD2LIMITF(1) = 10000000
                MD2POSITION(1) = 0
                MD2SLOPE(1) = 0
                MD2MOVETYPE = "R"

                'Wait until edge of time change.
                t1 = Microsoft.VisualBasic.DateAndTime.Timer
                Do Until t1 <> Microsoft.VisualBasic.DateAndTime.Timer
                Loop

                'Time move
                t1 = Microsoft.VisualBasic.DateAndTime.Timer
                MD2MOVE()
                t2 = Microsoft.VisualBasic.DateAndTime.Timer
                speed = ((MD2TARGET(1) / (t2 - t1)))

                speederror = speed / MD2VELOCITY(i)

                MD2VELOCITY(i) = MD2VELOCITY(i) * speederror

            End If
        Next

        TextBoxUtilities.Text = "Tweaking done." & MD2STATUS
        Beep()

        MD2OFF()

    End Sub
    Private Sub CheckBoxTeachMode_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBoxTeachMode.CheckedChanged

        'If teach mode, turn label to green.
        If CheckBoxTeachMode.Checked Then
            CheckBoxTeachMode.ForeColor = Color.Green
        Else
            CheckBoxTeachMode.ForeColor = Color.Black
        End If

    End Sub
    Private Sub ButtonProgramEdit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonProgramEdit.Click

        'Select Program Tab.
        Me.Tabs.SelectedIndex = Me.Tabs.TabPages.IndexOf(Me.TabProgram)

    End Sub
    Private Sub ButtonIOHelp_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonIOHelp.Click

        FormHelp.DoHelp("io")

    End Sub
    Private Sub ButtonControlHelp_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonControlHelp.Click

        FormHelp.DoHelp("control")

    End Sub
    Private Sub ButtonParametersHelp_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonParametersHelp.Click

        FormHelp.DoHelp("parameters")

    End Sub
    Private Sub ButtonControlCalibrate_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonControlCalibrate.Click

        'Disable all MD2 systems.
        CheckBoxEnabled12.Checked = False
        CheckBoxEnabled34.Checked = False
        CheckBoxEnabled56.Checked = False

        'HourGlass Cursor.
        Me.Cursor = Cursors.WaitCursor

        'Message.
        ShowStatus("Please wait 15 seconds while calibrating motor speeds.  Motors will not move . . . . .")

        'Make sure all events are taken care of before starting.
        Application.DoEvents()

        'Calibrate........
        md2calibrate()

        'Message.
        ShowStatus("Calibration Done")

        'Normal Cursor.
        Me.Cursor = Cursors.Default

        'Update forms.
        SetForms()

        Beep()

    End Sub
    Private Sub TextBoxMotorNameM1_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TextBoxMotorNameM1.TextChanged, TextBoxMotorNameM2.TextChanged, TextBoxMotorNameM3.TextChanged, TextBoxMotorNameM4.TextChanged, TextBoxMotorNameM5.TextChanged, TextBoxMotorNameM6.TextChanged, TextBoxUnitNameM1.TextChanged, TextBoxUnitNameM2.TextChanged, TextBoxUnitNameM3.TextChanged, TextBoxUnitNameM4.TextChanged, TextBoxUnitNameM5.TextChanged, TextBoxUnitNameM6.TextChanged, TextBoxUnitValueM1.TextChanged, TextBoxUnitValueM2.TextChanged, TextBoxUnitValueM3.TextChanged, TextBoxUnitValueM4.TextChanged, TextBoxUnitValueM5.TextChanged, TextBoxUnitValueM6.TextChanged, CheckBoxHomeDirM1.CheckStateChanged, CheckBoxHomeDirM2.CheckStateChanged, CheckBoxHomeDirM3.CheckStateChanged, CheckBoxHomeDirM4.CheckStateChanged, CheckBoxHomeDirM5.CheckStateChanged, CheckBoxHomeDirM6.CheckStateChanged, TextBoxHomeOffsetM1.TextChanged, TextBoxHomeOffsetM2.TextChanged, TextBoxHomeOffsetM3.TextChanged, TextBoxHomeOffsetM4.TextChanged, TextBoxHomeOffsetM5.TextChanged, TextBoxHomeOffsetM6.TextChanged, TextBoxLimitFM1.TextChanged, TextBoxLimitFM2.TextChanged, TextBoxLimitFM3.TextChanged, TextBoxLimitFM4.TextChanged, TextBoxLimitFM5.TextChanged, TextBoxLimitFM6.TextChanged, TextBoxLimitRM1.TextChanged, TextBoxLimitRM2.TextChanged, TextBoxLimitRM3.TextChanged, TextBoxLimitRM4.TextChanged, TextBoxLimitRM5.TextChanged, TextBoxLimitRM6.TextChanged, TextBoxMinSpeedM1.TextChanged, TextBoxMinSpeedM2.TextChanged, TextBoxMinSpeedM3.TextChanged, TextBoxMinSpeedM4.TextChanged, TextBoxMinSpeedM5.TextChanged, TextBoxMinSpeedM6.TextChanged, TextBoxMaxSpeedM1.TextChanged, TextBoxMaxSpeedM2.TextChanged, TextBoxMaxSpeedM3.TextChanged, TextBoxMaxSpeedM4.TextChanged, TextBoxMaxSpeedM5.TextChanged, TextBoxMaxSpeedM6.TextChanged, TextBoxSlopeM1.TextChanged, TextBoxSlopeM2.TextChanged, TextBoxSlopeM3.TextChanged, TextBoxSlopeM4.TextChanged, TextBoxSlopeM5.TextChanged, TextBoxSlopeM6.TextChanged, TextBoxBacklashM1.TextChanged, TextBoxBacklashM2.TextChanged, TextBoxBacklashM3.TextChanged, TextBoxBacklashM4.TextChanged, TextBoxBacklashM5.TextChanged, TextBoxBacklashM6.TextChanged, CheckBoxHold.CheckStateChanged, RadioButtonAbsolute.CheckedChanged, RadioButtonRelative.CheckedChanged, RadioButtonHalf.CheckedChanged, RadioButtonSingle.CheckedChanged, RadioButtonDouble.CheckedChanged, TextBoxDistanceM1.TextChanged, TextBoxDistanceM2.TextChanged, TextBoxDistanceM3.TextChanged, TextBoxDistanceM4.TextChanged, TextBoxDistanceM5.TextChanged, TextBoxDistanceM6.TextChanged

        'Handles changes to all parameters except TextBoxPositionPM1.TextChanged, TextBoxPositionPM2.TextChanged, TextBoxPositionPM3.TextChanged, TextBoxPositionPM4.TextChanged, TextBoxPositionPM5.TextChanged, TextBoxPositionPM6.TextChanged,

        'If any parameter changed then set flag.
        ParametersUnsaved = True

        'Teach mode records in teach mode.
        If CheckBoxTeachMode.Checked Then

            'Hold  -  Code example:  MD2HOLD=-1
            If sender.name = "CheckBoxHold" Then
                If CheckBoxHold.Checked Then
                    TextBoxSequence.Text = TextBoxSequence.Text + "MD2HOLD=-1" & vbCrLf
                Else
                    TextBoxSequence.Text = TextBoxSequence.Text + "MD2HOLD=0" & vbCrLf
                End If
            End If

            'Move Type  -  Code example:  MD2MOVETYPE="A"
            If sender.name = "RadioButtonAbsolute" Then
                If RadioButtonAbsolute.Checked Then
                    TextBoxSequence.Text = TextBoxSequence.Text + "MD2MOVETYPE=" & Chr(34) & "A" & Chr(34) & vbCrLf
                End If
            End If
            If sender.name = "RadioButtonRelative" Then
                If RadioButtonRelative.Checked Then
                    TextBoxSequence.Text = TextBoxSequence.Text + "MD2MOVETYPE=" & Chr(34) & "R" & Chr(34) & vbCrLf
                End If
            End If

            'MinSpeed.
            If sender.name = "TextBoxMinSpeedM1" Then TextBoxSequence.Text += "MD2MINSPEED(1)=" & TextBoxMinSpeedM1.Text & vbCrLf
            If sender.name = "TextBoxMinSpeedM2" Then TextBoxSequence.Text += "MD2MINSPEED(2)=" & TextBoxMinSpeedM2.Text & vbCrLf
            If sender.name = "TextBoxMinSpeedM3" Then TextBoxSequence.Text += "MD2MINSPEED(3)=" & TextBoxMinSpeedM3.Text & vbCrLf
            If sender.name = "TextBoxMinSpeedM4" Then TextBoxSequence.Text += "MD2MINSPEED(4)=" & TextBoxMinSpeedM4.Text & vbCrLf
            If sender.name = "TextBoxMinSpeedM5" Then TextBoxSequence.Text += "MD2MINSPEED(5)=" & TextBoxMinSpeedM5.Text & vbCrLf
            If sender.name = "TextBoxMinSpeedM6" Then TextBoxSequence.Text += "MD2MINSPEED(6)=" & TextBoxMinSpeedM6.Text & vbCrLf

            'MaxSpeed.
            If sender.name = "TextBoxMaxSpeedM1" Then TextBoxSequence.Text += "MD2MAXSPEED(1)=" & TextBoxMaxSpeedM1.Text & vbCrLf
            If sender.name = "TextBoxMaxSpeedM2" Then TextBoxSequence.Text += "MD2MAXSPEED(2)=" & TextBoxMaxSpeedM2.Text & vbCrLf
            If sender.name = "TextBoxMaxSpeedM3" Then TextBoxSequence.Text += "MD2MAXSPEED(3)=" & TextBoxMaxSpeedM3.Text & vbCrLf
            If sender.name = "TextBoxMaxSpeedM4" Then TextBoxSequence.Text += "MD2MAXSPEED(4)=" & TextBoxMaxSpeedM4.Text & vbCrLf
            If sender.name = "TextBoxMaxSpeedM5" Then TextBoxSequence.Text += "MD2MAXSPEED(5)=" & TextBoxMaxSpeedM5.Text & vbCrLf
            If sender.name = "TextBoxMaxSpeedM6" Then TextBoxSequence.Text += "MD2MAXSPEED(6)=" & TextBoxMaxSpeedM6.Text & vbCrLf

            'Slope.
            If sender.name = "TextBoxSlopeM1" Then TextBoxSequence.Text += "MD2SLOPE(1)=" & TextBoxSlopeM1.Text & vbCrLf
            If sender.name = "TextBoxSlopeM2" Then TextBoxSequence.Text += "MD2SLOPE(2)=" & TextBoxSlopeM2.Text & vbCrLf
            If sender.name = "TextBoxSlopeM3" Then TextBoxSequence.Text += "MD2SLOPE(3)=" & TextBoxSlopeM3.Text & vbCrLf
            If sender.name = "TextBoxSlopeM4" Then TextBoxSequence.Text += "MD2SLOPE(4)=" & TextBoxSlopeM4.Text & vbCrLf
            If sender.name = "TextBoxSlopeM5" Then TextBoxSequence.Text += "MD2SLOPE(5)=" & TextBoxSlopeM5.Text & vbCrLf
            If sender.name = "TextBoxSlopeM6" Then TextBoxSequence.Text += "MD2SLOPE(6)=" & TextBoxSlopeM6.Text & vbCrLf

            'Home Offset.
            If sender.name = "TextBoxHomeOffsetM1" Then TextBoxSequence.Text += "MD2HOMEOFFSET(1)=" & TextBoxHomeOffsetM1.Text & vbCrLf
            If sender.name = "TextBoxHomeOffsetM2" Then TextBoxSequence.Text += "MD2HOMEOFFSET(2)=" & TextBoxHomeOffsetM2.Text & vbCrLf
            If sender.name = "TextBoxHomeOffsetM3" Then TextBoxSequence.Text += "MD2HOMEOFFSET(3)=" & TextBoxHomeOffsetM3.Text & vbCrLf
            If sender.name = "TextBoxHomeOffsetM4" Then TextBoxSequence.Text += "MD2HOMEOFFSET(4)=" & TextBoxHomeOffsetM4.Text & vbCrLf
            If sender.name = "TextBoxHomeOffsetM5" Then TextBoxSequence.Text += "MD2HOMEOFFSET(5)=" & TextBoxHomeOffsetM5.Text & vbCrLf
            If sender.name = "TextBoxHomeOffsetM6" Then TextBoxSequence.Text += "MD2HOMEOFFSET(6)=" & TextBoxHomeOffsetM6.Text & vbCrLf

            'Could respond to changes in other parameters too but they don't commonly need changing during programs.

        End If

    End Sub
    Private Sub TextBoxSequence_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TextBoxSequence.TextChanged

        'If Sequence changed then set flag.
        SequenceUnsaved = True
        ButtonSaveSequence.BackColor = Color.Coral

    End Sub
    Sub FindPorts()

        'Attempts to locate parallel printer port base addresses with Windows WMI and
        'puts them in PortAddress(0),(1), and (2).  0=no port
        'wmi9x.exe must be run on Windows 95/98 machines.

        Dim msgtxt As String
        Dim portn(3) As String      'Port Name.  Last element is used for sorting.
        Dim porti(3) As String      'Device ID.
        Dim portc As Integer        'Port count.

        'Clean variables
        For portc = 0 To 2
            portn(portc) = ""
            porti(portc) = ""
            PortAddress(portc) = 0
        Next

        Try     'Catch WMI errors

            'Locate Parallel Port names and Device ID.
            'TextBoxUtilities.Text += "-Win32_ParallelPort------------------------------------------" & vbCrLf
            Dim Query1 As New ObjectQuery("SELECT * FROM Win32_ParallelPort")
            Dim Search1 As New ManagementObjectSearcher(Query1)
            Dim info1 As ManagementObject
            portc = 0   'Initialize port counter.
            For Each info1 In Search1.Get()
                portn(portc) = info1("Name").ToString
                porti(portc) = info1("PnPDeviceID").ToString().Replace("\", "\\")
                'TextBoxUtilities.Text += portn(portc) & " = " & porti(portc) & vbCrLf
                'TextBoxUtilities.Text += info1.GetText(TextFormat.Mof).Replace(Chr(10), vbCrLf)
                If portc = 2 Then Exit For Else portc = portc + 1
            Next

            'Locate starting addresses based on DeviceID.
            'Only use the first address of the first entry with a matching ID.
            'TextBoxUtilities.Text += vbCrLf & vbCrLf & "-Win32_PnPAllocatedResource----------------------------------" & vbCrLf
            Dim Query2 As New ObjectQuery("SELECT * From Win32_PnPAllocatedResource")
            Dim Search2 As New ManagementObjectSearcher(Query2)
            Dim info2 As ManagementObject
            For portc = 0 To 2
                If porti(portc) <> "" Then   'Dont search if ID is blank.
                    For Each info2 In Search2.Get()
                        If InStr(info2("Dependent"), porti(portc)) Then    'If ID inside of result Then ...
                            If InStr(info2("Antecedent"), "StartingAddress") Then    'If StartingAddress Then ...
                                'Result looks like this:  \ROGER05\root\cimv2:Win32_PortResource.StartingAddress="56728"
                                'PortAddress(portc) = Val(info2("Antecedent"))
                                'zz = InStr(info2("Antecedent").ToString, "=")  'Find location of =.
                                'z = info2("Antecedent").Substring(zz)          'Get everything after =.
                                'z = z.Replace(Chr(34), "")                     'Remove double quotes.
                                PortAddress(portc) = Val(info2("Antecedent").Substring(InStr(info2("Antecedent").ToString, "=")).Replace(Chr(34), ""))
                                'TextBoxUtilities.Text += PortAddress(portc) & vbCrLf
                                Exit For   'Only get first address.
                            End If
                        End If
                    Next
                End If
            Next

            'WMI errors go here.
        Catch ex As Exception

            'Error Message.
            msgtxt = "There was an error finding LPT ports." & vbCrLf & vbCrLf
            msgtxt += "This could be caused by a missing WMI component." & vbCrLf
            msgtxt += "If using Windows 98, run wmi9x.exe from the CD to load WMI." & vbCrLf
            msgtxt += "Or, locate ports manually using device manager." & vbCrLf
            msgtxt += "See Help for details." & vbCrLf & vbCrLf
            msgtxt += "Exception: " & ex.Message & vbCrLf
            MessageBox.Show(msgtxt, "Error Finding Ports - ", MessageBoxButtons.OK, MessageBoxIcon.Warning)

            'Bail out.
            Exit Sub

        End Try

        'Sort ports.  Put lowest non-zero port at (0), then (1), then (2)

        'Convert zeros to large numbers so they will sort correctly.
        If PortAddress(0) = 0 Then PortAddress(0) = 9999999
        If PortAddress(1) = 0 Then PortAddress(1) = 9999999
        If PortAddress(2) = 0 Then PortAddress(2) = 9999999

        'If (2) < (1) then swap (2) and (1)
        If PortAddress(2) < PortAddress(1) Then
            PortAddress(3) = PortAddress(1)
            portn(3) = portn(1)
            porti(3) = porti(1)
            PortAddress(1) = PortAddress(2)
            portn(1) = portn(2)
            porti(1) = porti(2)
            PortAddress(2) = PortAddress(3)
            portn(2) = portn(3)
            porti(2) = porti(3)
        End If

        'If (1) < (0) then swap (0) and (1)
        If PortAddress(1) < PortAddress(0) Then
            PortAddress(3) = PortAddress(0)
            portn(3) = portn(0)
            porti(3) = porti(0)
            PortAddress(0) = PortAddress(1)
            portn(0) = portn(1)
            porti(0) = porti(1)
            PortAddress(1) = PortAddress(3)
            portn(1) = portn(3)
            porti(1) = porti(3)
        End If

        'If (2) < (1) then swap (2) and (1)
        If PortAddress(2) < PortAddress(1) Then
            PortAddress(3) = PortAddress(1)
            portn(3) = portn(1)
            porti(3) = porti(1)
            PortAddress(1) = PortAddress(2)
            portn(1) = portn(2)
            porti(1) = porti(2)
            PortAddress(2) = PortAddress(3)
            portn(2) = portn(3)
            porti(2) = porti(3)
        End If

        'Convert back to zeros.
        If PortAddress(0) = 9999999 Then PortAddress(0) = 0
        If PortAddress(1) = 9999999 Then PortAddress(1) = 0
        If PortAddress(2) = 9999999 Then PortAddress(2) = 0
        'Ports now sorted from loest to highest address in (0),(1), (2).  Zeros at end.

        'Display Results on Utility screen.
        TextBoxUtilities.Text = "LPT Ports" & vbCrLf & vbCrLf
        For portc = 0 To 2
            TextBoxUtilities.Text += "Name: " & portn(portc) & vbCrLf
            TextBoxUtilities.Text += "Addr: " & PortAddress(portc) & "  (" & Hex(PortAddress(portc)) & ")" & vbCrLf
            TextBoxUtilities.Text += "ID: " & porti(portc) & vbCrLf & vbCrLf
        Next

    End Sub
    Private Sub MD2xp_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing

        'Clean up only once if clicked [X] or Exit.
        If Not CleanedUp Then
            CleanUp()               'Alert user to unsaved files, confirm Exit.
            e.Cancel = True         'Prevent this form closing if user selects No.
        End If

    End Sub
    Private Sub CleanUp()

        'Alert user about unsaved files and enabled MD2s, Confirm Exit.

        Dim m As String = ""     'Message

        'Construct message if parameters unsaved, sequence unsaved, or motors enabled.
        If ParametersUnsaved Then m = m & "Parameters have been changed and are unsaved." & vbCrLf
        If SequenceUnsaved Then m = m & "The Sequence has changed and is unsaved." & vbCrLf
        If MD2ENABLED12 Then m = m & "MD2 #1 is still enabled." & vbCrLf
        If MD2ENABLED34 Then m = m & "MD2 #2 is still enabled." & vbCrLf
        If MD2ENABLED56 Then m = m & "MD2 #3 is still enabled." & vbCrLf

        'If needed, show a message and let user confirm.
        If m <> "" Then
            m = m & vbCrLf & "Are you sure you want to Exit?"
            If (MessageBox.Show(m, "Exit?", MessageBoxButtons.YesNo, MessageBoxIcon.Exclamation)) = Windows.Forms.DialogResult.Yes Then
                m = ""      'User confirmed Exit in spite of unsaved stuff.
            End If
        End If

        'Ok, end already.
        If m = "" Then
            CleanedUp = True        'Prevent formclose cleaning up too.
            Application.Exit()
        End If

    End Sub
    Private Sub ButtonInfo_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonInfo.Click

        'Info Button on Utilities tab.
        TextBoxUtilities.Text += "Company Name: " & Application.CompanyName & vbCrLf
        TextBoxUtilities.Text += "Product Name: " & Application.ProductName & vbCrLf
        TextBoxUtilities.Text += "Product Version: " & Application.ProductVersion & vbCrLf
        TextBoxUtilities.Text += "UserAppDataPath: " & Application.UserAppDataPath & vbCrLf
        TextBoxUtilities.Text += "LocalUserAppDataPath: " & Application.LocalUserAppDataPath & vbCrLf
        TextBoxUtilities.Text += "ExecutablePath: " & Application.ExecutablePath & vbCrLf
        TextBoxUtilities.Text += "CommonAppDataPath: " & Application.CommonAppDataPath & vbCrLf
        TextBoxUtilities.Text += "StartupPath: " & Application.StartupPath & vbCrLf
        TextBoxUtilities.Text += "ExecutablePath: " & Application.ExecutablePath & vbCrLf
        TextBoxUtilities.Text += "Computer Name: " & My.Computer.Name & vbCrLf
        TextBoxUtilities.Text += "Physical Memory: " & My.Computer.Info.AvailablePhysicalMemory & vbCrLf
        TextBoxUtilities.Text += "OS Full Name: " & My.Computer.Info.OSFullName & vbCrLf
        TextBoxUtilities.Text += "OS Platform: " & My.Computer.Info.OSPlatform & vbCrLf
        TextBoxUtilities.Text += "OS Version: " & My.Computer.Info.OSVersion & vbCrLf

    End Sub
    Private Sub LabelSequenceFile_MouseDoubleClick(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles LabelSequenceFile.MouseClick

        'Capture the Sequence file name and path into the clipboard for pasting elsewhere.
        Clipboard.SetText(LabelSequenceFile.Text)

    End Sub
    Private Sub LabelParameterFile_MouseDoubleClick(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles LabelParameterFile.MouseDoubleClick

        'Capture the Parameter file name and path into the clipboard for pasting elsewhere.
        Clipboard.SetText(LabelParameterFile.Text)

    End Sub
    Private Sub ButtonQuickRun1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonQuickRun1.Click
        QuickRun("1")
    End Sub
    Private Sub ButtonQuickRun2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonQuickRun2.Click
        QuickRun("2")
    End Sub
    Private Sub ButtonQuickRun3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonQuickRun3.Click
        QuickRun("3")
    End Sub
    Private Sub ButtonQuickRun4_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonQuickRun4.Click
        QuickRun("4")
    End Sub
    Private Sub ButtonQuickRun5_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonQuickRun5.Click
        QuickRun("5")
    End Sub
    Private Sub ButtonQuickRun6_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonQuickRun6.Click
        QuickRun("6")
    End Sub
    Private Sub ButtonQuickRun7_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonQuickRun7.Click
        QuickRun("7")
    End Sub
    Private Sub ButtonQuickRun8_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonQuickRun8.Click
        QuickRun("8")
    End Sub
    Private Sub ButtonQuickRun9_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonQuickRun9.Click
        QuickRun("9")
    End Sub
    Private Sub ButtonQuickRun10_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonQuickRun10.Click
        QuickRun("10")
    End Sub
    Private Sub ButtonQuickRun11_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonQuickRun11.Click
        QuickRun("11")
    End Sub
    Sub QuickRun(ByVal QRFN As String)

        'Load and run a sequence named md2xp1.bas, where '1' is passed.

        'Overwrite unsaved sequence?
        If SequenceUnsaved Then
            If SequenceUnsavedMessage() = Windows.Forms.DialogResult.No Then Exit Sub
        End If

        'Check for existence of sequence file first.
        If (Dir("md2xp" & QRFN & ".bas") = "") Then

            'If Sequence file doesn't exist then give message.
            MessageBox.Show("Sequence file md2xp" & QRFN & ".bas Doesn't Exist" & vbCrLf & _
                "The file can be created in the Sequence Editor using Save-As" _
                , "Sequence File Doesn't Exist" _
                , MessageBoxButtons.OK _
                , MessageBoxIcon.Error _
            )

        Else
            'Sequence file exists.

            'Load it
            MD2SEQFILE = Application.StartupPath & "\MD2xp" & QRFN & ".bas"
            MD2SEQLOAD()

            'Give message if load error.
            If MD2STATUS <> "O" Then
                MessageBox.Show("Error Loading file md2xp" & QRFN & ".bas" _
                    , "Sequence File Load Error" _
                    , MessageBoxButtons.OK _
                    , MessageBoxIcon.Error _
                )
            Else
                HighlightSequenceButton(QRFN)           'Highlight the sequence button.
                LabelSequenceFile.Text = MD2SEQFILE     'Sequence file name.
                Me.Cursor = Cursors.WaitCursor          'HourGlass Cursor.
                TimerIOScan.Enabled = True              'Turn on I/O Scanner.
                TextBoxSequence.Text = MD2SEQUENCE      'Set editor text.
                Application.DoEvents()                  'Make sure text shows before moving.
                SequenceUnsaved = False
                MD2SEQUENCE = TextBoxSequence.Text      'Set text.
                MD2POINTER = 1                          'Start running sequence at beginning
                TextBoxSequence.SelectionStart = 0      'Cursor at beginning.
                ButtonSaveSequence.BackColor = Color.Transparent
                Application.DoEvents()                  'Finish up events.
                MD2SEQRUN()                             'Run the sequence
                ShowStatus(MD2STATUS)

                If MD2STATUS <> "O" Then
                    MessageBox.Show("Sequence Aborted" & vbCrLf & _
                        LabelStatus.Text & vbCrLf & _
                        "Location: " & CStr(MD2POINTER) & vbCrLf & _
                        "Command: " & MD2COMMAND _
                        , "Sequence Aborted" _
                        , MessageBoxButtons.OK _
                        , MessageBoxIcon.Exclamation _
                    )
                    TextBoxSequence.SelectionStart = MD2POINTER     'Set cursor position to where abort occured.
                End If

                'Normal Cursor.
                Me.Cursor = Cursors.Default

            End If
        End If
    End Sub
    Private Sub HighlightSequenceButton(ByVal I As Integer)

        'Highlights the QuickRun Sequence button provided.

        'Unhighlight all buttons.
        ButtonQuickRun1.BackColor = Color.Transparent
        ButtonQuickRun2.BackColor = Color.Transparent
        ButtonQuickRun3.BackColor = Color.Transparent
        ButtonQuickRun4.BackColor = Color.Transparent
        ButtonQuickRun5.BackColor = Color.Transparent
        ButtonQuickRun6.BackColor = Color.Transparent
        ButtonQuickRun7.BackColor = Color.Transparent
        ButtonQuickRun8.BackColor = Color.Transparent
        ButtonQuickRun9.BackColor = Color.Transparent
        ButtonQuickRun10.BackColor = Color.Transparent
        ButtonQuickRun11.BackColor = Color.Transparent

        'Highlight the button.
        If I = 1 Then ButtonQuickRun1.BackColor = Color.SkyBlue
        If I = 2 Then ButtonQuickRun2.BackColor = Color.SkyBlue
        If I = 3 Then ButtonQuickRun3.BackColor = Color.SkyBlue
        If I = 4 Then ButtonQuickRun4.BackColor = Color.SkyBlue
        If I = 5 Then ButtonQuickRun5.BackColor = Color.SkyBlue
        If I = 6 Then ButtonQuickRun6.BackColor = Color.SkyBlue
        If I = 7 Then ButtonQuickRun7.BackColor = Color.SkyBlue
        If I = 8 Then ButtonQuickRun8.BackColor = Color.SkyBlue
        If I = 9 Then ButtonQuickRun9.BackColor = Color.SkyBlue
        If I = 10 Then ButtonQuickRun10.BackColor = Color.SkyBlue
        If I = 11 Then ButtonQuickRun11.BackColor = Color.SkyBlue

    End Sub
    Function SequenceUnsavedMessage() As DialogResult

        SequenceUnsavedMessage = MessageBox.Show( _
        "The current sequence in the editor " & vbCrLf & _
        "has been changed and is unsaved." & vbCrLf & vbCrLf & _
        "Lose these changes?" _
        , "Sequence Unsaved", MessageBoxButtons.YesNo, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button2 _
        )

    End Function
    Private Sub ButtonHotKeyHelp_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonHotKeyHelp.Click

        FormHelp.DoHelp("hotkeys")

    End Sub
    Private Sub ButtonSequenceHelp_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonSequenceHelp.Click

        FormHelp.DoHelp("sequences")

    End Sub
    Private Sub ButtonQuickStart_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonQuickStart.Click

        FormHelp.DoHelp("quickstart")

    End Sub
    Private Sub Button_Exit(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonExit.Click

        CleanUp()       'Alert user to unsaved files, confirm Exit.

    End Sub
    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles buttonC4.Click

        'TEST CODE
        'C4 Controller Example Program for Visual Basic

        Dim S As String
        Dim fl As Integer
        Dim msg As String = ""
        Dim i As Integer = 0

        Dim C4Port As New IO.Ports.SerialPort       'Object to hold port.
        C4Port.PortName = "COM1"                    'Change this for your COM port.
        C4Port.BaudRate = 9600                      'Set port parameters.
        C4Port.Parity = Parity.None
        C4Port.DataBits = 8
        C4Port.StopBits = 1
        C4Port.Open()                               'Open the port.

        'Clear any bad data in port buffers.
        C4Port.Write(Chr(&H1B))                     'Send Escape.
        Threading.Thread.Sleep(100)                 'Short wait.
        C4Port.DiscardInBuffer()                    'Discard anything received

        'Display firmware version.
        C4Port.Write("!1fv" & vbCr)                 'Firmware Version command.
        S = "C4 Firmware: V" & C4Port.ReadTo(vbCr) & vbCrLf
        MessageBox.Show(S, "C4 Version")            'Show message.

        'Move motor 1 home.
        C4Port.Write("!1h1" & vbCr)                 'Home command.
        Do                                          'Wait for o indicating finished.
            S = Chr(C4Port.ReadByte)
        Loop Until S = "o"

        'Move motor 2 home.
        C4Port.Write("!1h2" & vbCr)                 'Home command.
        Do                                          'Wait for o indicating finished.
            S = Chr(C4Port.ReadByte)
        Loop Until S = "o"

        MessageBox.Show("measure 0")

        For fl = 1 To 5

            'Move motor 1 forward 400 steps, n=notify when done.
            C4Port.Write("!1m1f2000m2f1000n" & vbCr)            'Move command.
            S = Chr(C4Port.ReadByte)                    'Wait for a indicating started.
            S = Chr(C4Port.ReadByte)                    'Wait for character indicating done.

            C4Port.Write("!1m1r2000m2r1000n" & vbCr)            'Move command.
            S = Chr(C4Port.ReadByte)                    'Wait for a indicating started.
            S = Chr(C4Port.ReadByte)                    'Wait for character indicating done.

            C4Port.Write("!1m1f202n" & vbCr)            'Move command.
            S = Chr(C4Port.ReadByte)                    'Wait for a indicating started.
            S = Chr(C4Port.ReadByte)                    'Wait for character indicating done.

            C4Port.Write("!1m2f103n" & vbCr)            'Move command.
            S = Chr(C4Port.ReadByte)                    'Wait for a indicating started.
            S = Chr(C4Port.ReadByte)                    'Wait for character indicating done.

            C4Port.Write("!1m1r202n" & vbCr)            'Move command.
            S = Chr(C4Port.ReadByte)                    'Wait for a indicating started.
            S = Chr(C4Port.ReadByte)                    'Wait for character indicating done.

            C4Port.Write("!1m2r103n" & vbCr)            'Move command.
            S = Chr(C4Port.ReadByte)                    'Wait for a indicating started.
            S = Chr(C4Port.ReadByte)                    'Wait for character indicating done.

        Next

        MessageBox.Show("Done")             'Done message.

        Exit Sub


        'Show C4 form
        FormC4.Show()
        FormC4.Focus()
        Exit Sub


        MD2INPUTS()
        msg = MD2INPUT(11) & "  " & MD2INPUT(12)
        MsgBox(msg)
        Exit Sub





        If MD2C4COM12.IsOpen Then msg += "C4COM12 Open" & vbCrLf Else msg += "C4COM12 Closed" & vbCrLf
        If MD2C4COM34.IsOpen Then msg += "C4COM34 Open" & vbCrLf Else msg += "C4COM34 Closed" & vbCrLf
        If MD2C4COM56.IsOpen Then msg += "C4COM56 Open" & vbCrLf Else msg += "C4COM56 Closed" & vbCrLf
        MsgBox(msg)
        Exit Sub



        LabelStatus.Text = "Testing C4"

        '        For isp As Integer = 0 To My.Computer.Ports.SerialPortNames.Count - 1
        ' LabelStatus.Text += My.Computer.Ports.SerialPortNames(isp) & ", "
        ' Next


        C4Port.PortName = "COM4"
        C4Port.BaudRate = 9600
        C4Port.Parity = Parity.None
        C4Port.DataBits = 8
        C4Port.StopBits = 1
        C4Port.Open()

        'Clear serial buffer
        C4Port.Write("!1a" & vbCr)     'Send CR.
        Threading.Thread.Sleep(100)
        C4Port.DiscardInBuffer()   'discard anything received

        'Display Product Data
        C4Port.Write("!1fp" & vbCr)            'Product
        msg = "Product: " & C4Port.ReadTo(vbCr) & vbCrLf
        C4Port.Write("!1fd" & vbCr)            'Description
        msg += "Description: " & C4Port.ReadTo(vbCr) & vbCrLf
        C4Port.Write("!1fv" & vbCr)            'Version
        msg += "Firmware: V" & C4Port.ReadTo(vbCr) & vbCrLf
        '        MessageBox.Show(msg, "Product Information", MessageBoxButtons.OK, MessageBoxIcon.Information)

        'Home 1
        LabelStatus.Text = ""
        C4Port.Write("!1h1" & vbCr)

        Do
            Application.DoEvents()
            If C4Port.BytesToRead > 0 Then
                msg = Chr(C4Port.ReadChar.ToString)
                If msg = "1" Then LabelStatus.Text = "Seeking Home Switch"
                If msg = "2" Then LabelStatus.Text = "Moving Off Home Switch"
                If msg = "3" Then LabelStatus.Text = "Moving to Home Offset"
                If msg = "o" Then Exit Do
            End If
        Loop
        LabelStatus.Text = "Home"

        'rs = read move state

        C4Port.Close()

    End Sub
    Private Sub ButtonPorts_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles LabelPortMD212.Click, LabelPortMD234.Click, LabelPortMD256.Click

        'Show Ports Form.
        FormPorts.Show()
        FormPorts.Focus()

    End Sub
End Class