Public Class FormPorts

    Private Sub FormPorts_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        'Load COM ports
        For i As Integer = 0 To _
           My.Computer.Ports.SerialPortNames.Count - 1
            ComboBoxComPortMD212.Items.Add(My.Computer.Ports.SerialPortNames(i))
            ComboBoxComPortMD234.Items.Add(My.Computer.Ports.SerialPortNames(i))
            ComboBoxComPortMD256.Items.Add(My.Computer.Ports.SerialPortNames(i))
        Next
        ComboBoxComPortMD212.SelectedIndex = 0
        ComboBoxComPortMD234.SelectedIndex = 0
        ComboBoxComPortMD256.SelectedIndex = 0

        'Load C4 IDs
        For i As Integer = 1 To 9
            ComboBoxIDMD212.Items.Add(i)
            ComboBoxIDMD234.Items.Add(i)
            ComboBoxIDMD256.Items.Add(i)
        Next
        ComboBoxIDMD212.SelectedIndex = 0
        ComboBoxIDMD234.SelectedIndex = 0
        ComboBoxIDMD256.SelectedIndex = 0

        'Load C4 Motors Ports
        ComboBoxMotorsMD212.Items.Add("1 & 2")
        ComboBoxMotorsMD212.Items.Add("3 & 4")
        ComboBoxMotorsMD212.SelectedIndex = 0
        ComboBoxMotorsMD234.Items.Add("1 & 2")
        ComboBoxMotorsMD234.Items.Add("3 & 4")
        ComboBoxMotorsMD234.SelectedIndex = 0
        ComboBoxMotorsMD256.Items.Add("1 & 2")
        ComboBoxMotorsMD256.Items.Add("3 & 4")
        ComboBoxMotorsMD256.SelectedIndex = 0

        'Select none port.
        RadioButtonPortMD212none.Checked = True
        RadioButtonPortMD234none.Checked = True
        RadioButtonPortMD256none.Checked = True

        'Sets options based on port type, and HINT.
        PortType1_CheckedChanged(sender, e)
        PortType2_CheckedChanged(sender, e)
        PortType3_CheckedChanged(sender, e)

        'Set form controls based on variables
        SetForm()

    End Sub
    Private Sub SetForm()

        'Set form controls based on variables

        'Motors 1 & 2
        'If parallel port <> 0 then use parallel port
        If MD2PORT12 <> 0 Then
            RadioButtonPortMD212pp.Checked = True
            TextBoxPortAddressMD212.Text = Hex(Val(MD2PORT12))
        Else
            'Not parallel port, check for C4
            If MD2C4PORT12 <> "" Then
                RadioButtonPortMD212c4.Checked = True
                ComboBoxComPortMD212.Text = MD2C4PORT12
                ComboBoxIDMD212.Text = MD2C4ID12
                If MD2C4CONNECTOR12 = "a" Then ComboBoxMotorsMD212.Text = "1 & 2" Else ComboBoxMotorsMD212.Text = "3 & 4"
            Else
                'No Port
                RadioButtonPortMD212none.Checked = True
            End If
        End If

        'Motors 3 & 4
        'If parallel port <> 0 then use parallel port
        If MD2PORT34 <> 0 Then
            RadioButtonPortMD234pp.Checked = True
            TextBoxPortAddressMD234.Text = Hex(Val(MD2PORT34))
        Else
            'Not parallel port, check for C4
            If MD2C4PORT34 <> "" Then
                RadioButtonPortMD234c4.Checked = True
                ComboBoxComPortMD234.Text = MD2C4PORT34
                ComboBoxIDMD234.Text = MD2C4ID34
                If MD2C4CONNECTOR34 = "a" Then ComboBoxMotorsMD234.Text = "1 & 2" Else ComboBoxMotorsMD234.Text = "3 & 4"
            Else
                'No Port
                RadioButtonPortMD234none.Checked = True
            End If
        End If

        'Motors 5 & 6
        'If parallel port <> 0 then use parallel port
        If MD2PORT56 <> 0 Then
            RadioButtonPortMD256pp.Checked = True
            TextBoxPortAddressMD256.Text = Hex(Val(MD2PORT56))
        Else
            'Not parallel port, check for C4
            If MD2C4PORT56 <> "" Then
                RadioButtonPortMD256c4.Checked = True
                ComboBoxComPortMD256.Text = MD2C4PORT56
                ComboBoxIDMD256.Text = MD2C4ID56
                If MD2C4CONNECTOR56 = "a" Then ComboBoxMotorsMD256.Text = "1 & 2" Else ComboBoxMotorsMD256.Text = "3 & 4"
            Else
                'No Port
                RadioButtonPortMD256none.Checked = True
            End If
        End If

    End Sub
    Private Sub PortType1_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButtonPortMD212pp.CheckedChanged, RadioButtonPortMD212c4.CheckedChanged, RadioButtonPortMD212none.CheckedChanged

        'Fires when user selects a connection type.

        'Set options for each MD2 based on selected port.

        If RadioButtonPortMD212c4.Checked Then
            'C4 selected ------------------------------
            ButtonPortsTestMD212.Visible = True
            ShowHintC4()
            LabelParametersMD212.Text = "Serial Port to C4"
            LabelPortMD21.Text = "COM Port"
            TextBoxPortAddressMD212.Visible = False
            LabelIDMD21.Visible = True
            LabelMotorsMD21.Visible = True
            ComboBoxComPortMD212.Visible = True
            ComboBoxIDMD212.Visible = True
            ComboBoxMotorsMD212.Visible = True
        End If

        If RadioButtonPortMD212pp.Checked Then
            'Parallel Port selected -------------------
            ButtonPortsTestMD212.Visible = False
            ShowHintPP()
            LabelParametersMD212.Text = "Parallel Port to MD2"
            LabelPortMD21.Text = "Address"
            TextBoxPortAddressMD212.Visible = True
            LabelIDMD21.Visible = False
            LabelMotorsMD21.Visible = False
            ComboBoxComPortMD212.Visible = False
            ComboBoxIDMD212.Visible = False
            ComboBoxMotorsMD212.Visible = False
        End If

        If RadioButtonPortMD212none.Checked Then
            'No Port selected -------------------
            ButtonPortsTestMD212.Visible = False
            ShowHintNone()
            LabelParametersMD212.Text = ""
            LabelPortMD21.Text = ""
            TextBoxPortAddressMD212.Visible = False
            LabelIDMD21.Visible = False
            LabelMotorsMD21.Visible = False
            ComboBoxComPortMD212.Visible = False
            ComboBoxIDMD212.Visible = False
            ComboBoxMotorsMD212.Visible = False
        End If

    End Sub
    Private Sub PortType2_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButtonPortMD234pp.CheckedChanged, RadioButtonPortMD234c4.CheckedChanged, RadioButtonPortMD234none.CheckedChanged

        'Fires when user selects a connection type.

        'Set options for each MD2 based on selected port.

        If RadioButtonPortMD234c4.Checked Then
            'C4 selected ------------------------------
            ButtonPortsTestMD234.Visible = True
            ShowHintC4()
            LabelParametersMD234.Text = "Serial Port to C4"
            LabelPortMD22.Text = "COM Port"
            TextBoxPortAddressMD234.Visible = False
            LabelIDMD22.Visible = True
            LabelMotorsMD22.Visible = True
            ComboBoxComPortMD234.Visible = True
            ComboBoxIDMD234.Visible = True
            ComboBoxMotorsMD234.Visible = True
        End If

        If RadioButtonPortMD234pp.Checked Then
            'Parallel Port selected -------------------
            ButtonPortsTestMD234.Visible = False
            ShowHintPP()
            LabelParametersMD234.Text = "Parallel Port to MD2"
            LabelPortMD22.Text = "Address"
            TextBoxPortAddressMD234.Visible = True
            LabelIDMD22.Visible = False
            LabelMotorsMD22.Visible = False
            ComboBoxComPortMD234.Visible = False
            ComboBoxIDMD234.Visible = False
            ComboBoxMotorsMD234.Visible = False
        End If

        If RadioButtonPortMD234none.Checked Then
            'No Port selected -------------------
            ButtonPortsTestMD234.Visible = False
            ShowHintNone()
            LabelParametersMD234.Text = ""
            LabelPortMD22.Text = ""
            TextBoxPortAddressMD234.Visible = False
            LabelIDMD22.Visible = False
            LabelMotorsMD22.Visible = False
            ComboBoxComPortMD234.Visible = False
            ComboBoxIDMD234.Visible = False
            ComboBoxMotorsMD234.Visible = False
        End If

    End Sub
    Private Sub PortType3_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButtonPortMD256pp.CheckedChanged, RadioButtonPortMD256c4.CheckedChanged, RadioButtonPortMD256none.CheckedChanged

        'Fires when user selects a connection type.

        'Set options for each MD2 based on selected port.

        If RadioButtonPortMD256c4.Checked Then
            'C4 selected ------------------------------
            ButtonPortsTestMD256.Visible = True
            ShowHintC4()
            LabelParametersMD256.Text = "Serial Port to C4"
            LabelPortMD23.Text = "COM Port"
            TextBoxPortAddressMD256.Visible = False
            LabelIDMD23.Visible = True
            LabelMotorsMD23.Visible = True
            ComboBoxComPortMD256.Visible = True
            ComboBoxIDMD256.Visible = True
            ComboBoxMotorsMD256.Visible = True
        End If

        If RadioButtonPortMD256pp.Checked Then
            'Parallel Port selected -------------------
            ButtonPortsTestMD256.Visible = False
            ShowHintPP()
            LabelParametersMD256.Text = "Parallel Port to MD2"
            LabelPortMD23.Text = "Address"
            TextBoxPortAddressMD256.Visible = True
            LabelIDMD23.Visible = False
            LabelMotorsMD23.Visible = False
            ComboBoxComPortMD256.Visible = False
            ComboBoxIDMD256.Visible = False
            ComboBoxMotorsMD256.Visible = False
        End If

        If RadioButtonPortMD256none.Checked Then
            'No Port selected -------------------
            ButtonPortsTestMD256.Visible = False
            ShowHintNone()
            LabelParametersMD256.Text = ""
            LabelPortMD23.Text = ""
            TextBoxPortAddressMD256.Visible = False
            LabelIDMD23.Visible = False
            LabelMotorsMD23.Visible = False
            ComboBoxComPortMD256.Visible = False
            ComboBoxIDMD256.Visible = False
            ComboBoxMotorsMD256.Visible = False
        End If

    End Sub
    Private Sub ShowHintPP()

        LabelPortsHint1.Visible = True
        LabelPortsHint.Text = _
        "Enter the parallel printer (LPT) port address in hexadecimal." & vbCrLf & _
        "Common addresses are 378, 278, 3bc" & vbCrLf & _
        "Click the Search button to automatically search for available ports."

    End Sub
    Private Sub ShowHintC4()

        LabelPortsHint1.Visible = True
        LabelPortsHint.Text = _
        "Select the serial COM port name the C4 Controller is connected to." & vbCrLf & _
        "Set ID to 1 unless multiple C4 Controllers are sharing a COM port." & vbCrLf & _
        "Select which Motors port on the C4 Controller the MD2 will be connected to."

    End Sub
    Private Sub ShowHintNone()

        LabelPortsHint1.Visible = False
        LabelPortsHint.Text = _
        "Select the connection type for each MD2 (pair of motors)." & vbCrLf & _
        "MD2 motor drivers can be connected directly to a parallel printer port (LPT)," & vbCrLf & _
        "or through a C4 controller connected to a serial port (COM)  - or USB with a converter cable."

    End Sub
    Private Sub ButtonPortHelp_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonPortHelp.Click

        FormHelp.DoHelp("Ports")

    End Sub
    Private Sub ButtonPortsFind_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonPortsFind.Click

        'Find ports, display message.

        Dim msgtxt As String

        'HourGlass Cursor.
        Me.Cursor = Cursors.WaitCursor

        'Find ports, put in PortAddress(0,1,2)
        MD2xp.FindPorts()

        'Normal Cursor.
        Me.Cursor = Cursors.Default

        'If no ports found then show message and bail out, else show them .
        If MD2xp.PortAddress(0) = 0 And MD2xp.PortAddress(1) = 0 And MD2xp.PortAddress(2) = 0 Then
            'None found.
            msgtxt = "No LPT ports were automatically found through the operating system." & vbCrLf
            msgtxt += "This may not mean that none exist." & vbCrLf
            msgtxt += "See Help to manually find addresses."
            MessageBox.Show(msgtxt, "Port Addresses", MessageBoxButtons.OK, MessageBoxIcon.Warning)
        Else
            'Found addresses message.
            msgtxt = "These LPT port address(es) were found:" & vbCrLf & vbCrLf
            If MD2xp.PortAddress(0) <> 0 Then msgtxt += "             " & Hex(MD2xp.PortAddress(0)) & vbCrLf
            If MD2xp.PortAddress(1) <> 0 Then msgtxt += "             " & Hex(MD2xp.PortAddress(1)) & vbCrLf
            If MD2xp.PortAddress(2) <> 0 Then msgtxt += "             " & Hex(MD2xp.PortAddress(2)) & vbCrLf
            msgtxt += vbCrLf
            msgtxt += "They might be candidates to control the MD2." & vbCrLf & vbCrLf
            msgtxt += "See Help for details." & vbCrLf & vbCrLf
            msgtxt += "Don't forget to save parameters after setting." & vbCrLf & vbCrLf
            msgtxt += "Incorrect addresses may cause computer lock-up." & vbCrLf & vbCrLf
            MessageBox.Show(msgtxt, "Port Addresses", MessageBoxButtons.OK, MessageBoxIcon.Information)
        End If

    End Sub
    Private Sub ButtonPortsC4_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonPortsC4.Click

        'Show C4 form
        FormC4.Show()
        FormC4.Focus()

    End Sub
    Private Sub ButtonPortsTest1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonPortsTestMD212.Click

        'DISABLE ALL MD2S.
        MD2MOTOR = 1
        MD2OFF()
        MD2MOTOR = 3
        MD2OFF()
        MD2MOTOR = 5
        MD2OFF()

        'TEST PORT.
        TestC4Port(ComboBoxComPortMD212.SelectedItem, ComboBoxIDMD212.SelectedItem)

    End Sub
    Private Sub ButtonPortsTest2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonPortsTestMD234.Click

        'DISABLE ALL MD2S.
        MD2MOTOR = 1
        MD2OFF()
        MD2MOTOR = 3
        MD2OFF()
        MD2MOTOR = 5
        MD2OFF()

        'TEST PORT.
        TestC4Port(ComboBoxComPortMD234.SelectedItem, ComboBoxIDMD234.SelectedItem)

    End Sub
    Private Sub ButtonPortsTest3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonPortsTestMD256.Click

        'DISABLE ALL MD2S.
        MD2MOTOR = 1
        MD2OFF()
        MD2MOTOR = 3
        MD2OFF()
        MD2MOTOR = 5
        MD2OFF()

        'TEST PORT.
        TestC4Port(ComboBoxComPortMD256.SelectedItem, ComboBoxIDMD256.SelectedItem)

    End Sub
    Private Sub ButtonPortsOK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonPortsOK.Click

        'Close form.
        Me.Close()
        Me.Dispose()

    End Sub
    Private Sub FormPorts_Deactivate(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Deactivate

        'Close serial port if open
        CloseComPort()

        'Set parameters according to form controls

        'Set Ports for MD2 #1 - No port selected.
        If RadioButtonPortMD212none.Checked Then
            'MD2xp.LabelPortMD212.Text = "None"
            MD2PORT12 = 0
            MD2C4PORT12 = ""
            MD2C4ID12 = ""
            MD2C4CONNECTOR12 = ""
        End If

        'Set Ports for MD2 #1 - Parallel port selected.
        If RadioButtonPortMD212pp.Checked Then
            'MD2xp.LabelPortMD212.Text = TextBoxPortAddressMD212.Text
            Try
                MD2PORT12 = Convert.ToInt32(TextBoxPortAddressMD212.Text, 16)
            Catch
                MD2PORT12 = 0
            End Try
            MD2C4PORT12 = ""
            MD2C4ID12 = ""
            MD2C4CONNECTOR12 = ""
        End If

        'Set Ports for MD2 #1 - C4 selected.
        If RadioButtonPortMD212c4.Checked Then
            'MD2xp.LabelPortMD212.Text = "C4," & ComboBoxComPortMD212.SelectedItem & "," & ComboBoxIDMD212.SelectedItem & "," & ComboBoxMotorsMD212.Text.Replace(" & ", "&&")
            MD2PORT12 = 0
            MD2C4PORT12 = ComboBoxComPortMD212.SelectedItem
            MD2C4ID12 = ComboBoxIDMD212.SelectedItem
            MD2C4BAUD12 = 9600
            If ComboBoxMotorsMD212.Text.Contains("1") Then MD2C4CONNECTOR12 = "a" Else MD2C4CONNECTOR12 = "b"
        End If

        '---------

        'Set Ports for MD2 #2 - No port selected.
        If RadioButtonPortMD234none.Checked Then
            'MD2xp.LabelPortMD234.Text = "None"
            MD2PORT34 = 0
            MD2C4PORT34 = ""
            MD2C4ID34 = ""
            MD2C4CONNECTOR34 = ""
        End If

        'Set Ports for MD2 #2 - Parallel port selected.
        If RadioButtonPortMD234pp.Checked Then
            'MD2xp.LabelPortMD234.Text = TextBoxPortAddressMD234.Text
            Try
                MD2PORT34 = Convert.ToInt32(TextBoxPortAddressMD234.Text, 16)
            Catch
                MD2PORT34 = 0
            End Try
            MD2C4PORT34 = ""
            MD2C4ID34 = ""
            MD2C4CONNECTOR34 = ""
        End If

        'Set Ports for MD2 #2 - C4 selected.
        If RadioButtonPortMD234c4.Checked Then
            'MD2xp.LabelPortMD234.Text = "C4," & ComboBoxComPortMD234.SelectedItem & "," & ComboBoxIDMD234.SelectedItem & "," & ComboBoxMotorsMD234.Text.Replace(" & ", "&&")
            MD2PORT34 = 0
            MD2C4PORT34 = ComboBoxComPortMD234.SelectedItem
            MD2C4ID34 = ComboBoxIDMD234.SelectedItem
            MD2C4BAUD34 = 9600
            If ComboBoxMotorsMD234.Text.Contains("1") Then MD2C4CONNECTOR34 = "a" Else MD2C4CONNECTOR34 = "b"
        End If

        '---------

        'Set Ports for MD2 #3 - No port selected.
        If RadioButtonPortMD256none.Checked Then
            'MD2xp.LabelPortMD256.Text = "None"
            MD2PORT56 = 0
            MD2C4PORT56 = ""
            MD2C4ID56 = ""
            MD2C4CONNECTOR56 = ""
        End If

        'Set Ports for MD2 #3 - Parallel port selected.
        If RadioButtonPortMD256pp.Checked Then
            'MD2xp.LabelPortMD256.Text = TextBoxPortAddressMD256.Text
            Try
                MD2PORT56 = Convert.ToInt32(TextBoxPortAddressMD256.Text, 16)
            Catch
                MD2PORT56 = 0
            End Try
            MD2C4PORT56 = ""
            MD2C4ID56 = ""
            MD2C4CONNECTOR56 = ""
        End If

        'Set Ports for MD2 #3 - C4 selected.
        If RadioButtonPortMD256c4.Checked Then
            'MD2xp.LabelPortMD256.Text = "C4," & ComboBoxComPortMD256.SelectedItem & "," & ComboBoxIDMD256.SelectedItem & "," & ComboBoxMotorsMD256.Text.Replace(" & ", "&&")
            MD2PORT56 = 0
            MD2C4PORT56 = ComboBoxComPortMD256.SelectedItem
            MD2C4ID56 = ComboBoxIDMD256.SelectedItem
            MD2C4BAUD56 = 9600
            If ComboBoxMotorsMD256.Text.Contains("1") Then MD2C4CONNECTOR56 = "a" Else MD2C4CONNECTOR56 = "b"
        End If

        'Update parameter form
        MD2xp.SetForms()

    End Sub
    Public Sub TestC4Port(ByVal Port As String, ByVal ID As Integer)

        'Test the connection of the selected C4

        'Check C4 communications by getting product/version data.

        Dim msg As String

        'Open com port
        If OpenComPort(Port, False) Then  'Don't have it display the standard error msg.

            'Test if any response
            MD2xp.C4Port.DiscardInBuffer()       'Clear buffer.
            MD2xp.C4Port.Write("!" & ID & vbCr)       'Send CR.
            Threading.Thread.Sleep(100)
            If MD2xp.C4Port.BytesToRead = 0 Then GoTo checkfailed 'If no response then fail.

            'Get Product code, check for 'C4'.
            MD2xp.C4Port.DiscardInBuffer()       'Clear out ? response.
            MD2xp.C4Port.Write("!" & ID & "fp" & vbCr) 'Ask for product
            Threading.Thread.Sleep(100)     'Gotta have this.
            If MD2xp.C4Port.BytesToRead = 0 Then GoTo checkfailed 'No bytes, fail.
            msg = Chr(MD2xp.C4Port.ReadChar())            'Get 1st char of product
            If msg <> "C" Then GoTo checkfailed 'Not C, failed?
            If MD2xp.C4Port.BytesToRead = 0 Then GoTo checkfailed 'No bytes, fail.
            msg = Chr(MD2xp.C4Port.ReadChar())            'Get 2nd char
            If msg <> "4" Then GoTo checkfailed 'Not 4, failed?

            'Collect information and build message.
            MD2xp.C4Port.DiscardInBuffer()       'Clear out buffer.
            msg = "C4 Connection Working" & vbCrLf & vbCrLf
            MD2xp.C4Port.Write("!" & ID & "fp" & vbCr)            'Product
            'Delay not needed because usint ReadTo(vbCr)
            msg += "Product: " & MD2xp.C4Port.ReadTo(vbCr) & vbCrLf
            MD2xp.C4Port.Write("!" & ID & "fd" & vbCr)            'Description
            msg += "Description: " & MD2xp.C4Port.ReadTo(vbCr) & vbCrLf
            MD2xp.C4Port.Write("!" & ID & "fv" & vbCr)            'Version
            msg += "Firmware: V" & MD2xp.C4Port.ReadTo(vbCr) & vbCrLf
            MessageBox.Show(msg, "C4 Connection Test", MessageBoxButtons.OK, MessageBoxIcon.Information)
            Exit Sub

Checkfailed:
            'Opened but no response, or not correct
            msg = "Connection not made." & vbCrLf & vbCrLf
            msg += Port & " was opened successfully," & vbCrLf
            msg += "but C4 did not respond using ID " & ID & "." & vbCrLf
            msg += "Check cables and try another COM port or ID"
            MessageBox.Show(msg, "C4 Connection Test", MessageBoxButtons.OK, MessageBoxIcon.Warning)
            Exit Sub

        Else

            'Couldn't open COM port
            msg = "Connection not made." & vbCrLf & vbCrLf
            msg += Port & " could not be opened." & vbCrLf
            msg += "Possibly it does not exist or is opened by another program." & vbCrLf
            msg += "Try another COM port."
            MessageBox.Show(msg, "C4 Connection Test", MessageBoxButtons.OK, MessageBoxIcon.Warning)

        End If

    End Sub
    Public Function OpenComPort(ByVal Port As String, ByVal ErrorFlag As Boolean) As Boolean

        'Open com port - return true if success, false and give error message otherwise.

        'If port is open and same com port, do nothing
        'If port is open and different com port, then close and open
        'If port is closed, open it.

        'If port is open, and correct com port, do nothing
        If MD2xp.C4Port.IsOpen Then
            If MD2xp.C4Port.PortName = Port Then
                Return True
            Else
                Try
                    MD2xp.C4Port.Close()
                Catch ex As Exception
                    'should be able to close.
                End Try
                'Fall through to open.
            End If
        End If

        'Open COM port.
        Try
            MD2xp.C4Port.PortName = Port
            MD2xp.C4Port.BaudRate = 9600
            MD2xp.C4Port.Parity = IO.Ports.Parity.None
            MD2xp.C4Port.DataBits = 8
            MD2xp.C4Port.StopBits = 1
            MD2xp.C4Port.Open()

            'Clear serial buffer on host and C4
            MD2xp.C4Port.Write("!!a" & vbCr)       'Send abort to C4.
            Threading.Thread.Sleep(100)
            MD2xp.C4Port.DiscardInBuffer()       'Discard anything received.

        Catch ex As Exception

            'Display error message if flag set.
            If ErrorFlag Then
                MessageBox.Show("Unable to Open COM Port " & Port, "Error", MessageBoxButtons.OK, MessageBoxIcon.Warning)
            End If

            Return False

        End Try

        Return True

    End Function
    Public Function CloseComPort() As Boolean

        'Close serial port if open, display error if one.
        Try

            If MD2xp.C4Port.IsOpen Then MD2xp.C4Port.Close()

        Catch ex As Exception

            'Error, shouldn't ever get here.
            MessageBox.Show("Error closing COM Port", "Error", MessageBoxButtons.OK, MessageBoxIcon.Warning)

            Return False

        End Try

        Return True

    End Function

End Class