Option Explicit On 
Option Strict Off

Imports System.Math
Imports System.IO

Module ModuleMD2

    '---------------------------------------------------------------------
    'NAME:      MD2VN2S.VB - Beta test, needs some clean up.
    'DESC:      MD-2 LEVEL 2 MOTION CONTROL SUBROUTINES for VISUAL-BASIC.net 2005
    'USAGE:     USE TO CREATE COMPLEX MOTION CONTROL PROGRAMS.
    '           REQUIRES INPOUT32.DLL - SEE BELOW.
    '           USE LEVEL 1 LIBRARY WHEN CREATING SIMPLE PROGRAMS.
    '
    '           FEATURES:
    '               DUAL MOTOR MOVES.
    '               RELATIVE/ABSOLUTE MOVES.
    '               ADJUSTABLE ACCELERATION/DECELERATION.
    '               2-AXIS LINEAR INTERPOLATION.
    '               2-AXIS CIRCULAR INTERPOLATION.
    '               2-AXIS ARC AND ELLIPSE MOVES.
    '               2-AXIS GRID MOVES.
    '               USER DEFINED UNITS.
    '               BACKLASH COMPENSATION.
    '               SOFT LIMITS.
    '               SPEED GIVEN IN UNITS PER SECOND.
    '               PARAMETER SAVE & LOAD.
    '               MOTION SEQUENCE PROGRAM INTERPRETER.
    '               INPUT/OUTPUT PORT CONTROL.
    '
    '           ALL MOTOR PARAMETERS ARE PASSED TO SUBROUTINES VIA
    '           GLOBAL VARIABLES.  ALL VARIABLES AND SUBS BEGIN WITH
    '           MD2 TO AVOID CONFLICTS.
    '           SEE .TXT FILE FOR COMPLETE DESCRIPTION.
    'BY:        COPYRIGHT (C) ARRICK ROBOTICS, ROGER ARRICK.
    'DATE:      7/10/2009
    'EDIT:      71
    '
    'PUBLIC SUBROUTINES ---------------------------------------------------
    '
    '    NAME           DESCRIPTION
    '    ----           -----------
    '    MD2SETUP       Used once at the beginning of a program to initialize
    '                   motor parameters to their default values and checks
    '                   for parallel port availability. Loads calibration file.
    '    MD2CALIBRATE   Calibrates motor speeds with computer speeds and saves
    '                   to disk.  Use this SUB once on your cpu before moving.
    '    MD2ON          Turns on an MD-2 system. Use before any moves.
    '                   For ports set to C4, open serial port.
    '    MD2OFF         Turns off an MD-2 system. Use at end of program.
    '                   For ports set to C4, close serial port.
    '    MD2HOME        Moves a motor to the Home position by watching the
    '                   home switch.  Current position is set to zero.
    '    MD2MOVE        Moves a motor to the desired target position using
    '                   the various motor parameters.  Also moves two motors
    '                   together providing linear interpolation.
    '    MD2CIRCLE      Performs 2-axis circular, arc and ellipise moves.
    '    MD2GRID        Moves 2 motors using grid coordinates.
    '    MD2OUTPUTS     Turns on and off output pins to control tools.
    '    MD2INPUTS      Reads condition of input pins and home switches.
    '    MD2STANDBYON   Puts MD-2 into standby mode which reduces motor current
    '                   and heat while maintaining some holding torque.
    '    MD2STANDBYOFF  Turns off standby mode giving full current to motors.
    '    MD2PARLOAD     Loads motor parameters from a disk file.
    '    MD2PARSAVE     Saves motor parameters to a disk file.
    '    MD2SEQLOAD     Loads a sequence of motion commands from a disk file.
    '    MD2SEQSAVE     Saves a sequence of motion commands to a disk file.
    '    MD2SEQRUN      Runs a sequence of motion commands.
    '
    '
    'PUBLIC MOTOR PARAMETERS AND VARIABLES ----------------------------------
    '
    '    (M) indicates motor # 1,2,3,4,5 or 6.
    '
    '    NAME            TYPE    DESCRIPTION
    '    ----            ----    -----------
    '
    '    MD2BACKLASH(M)  SINGLE  Backlash compensation in units.  Adds this
    '                            amount to every move that changes direction.
    '                            Uses MD2LASTDIR(M).
    '                            Value is in Units.
    '    MD2ENABLED12    INTEGER Port for motors 1 & 2 has been enabled
    '                            by the MD2ON sub. 0=not enabled, -1=enabled.
    '    MD2ENABLED34    INTEGER Port for motors 3 & 4 has been enabled
    '                            by the MD2ON sub. 0=not enabled, -1=enabled.
    '    MD2ENABLED56    INTEGER Port for motors 5 & 6 has been enabled
    '                            by the MD2ON sub. 0=not enabled, -1=enabled.
    '    MD2HOLD         INTEGER -1=Leaves the motor energized after a move
    '                            to cause the motor to hold its position.
    '                            0 causes the motor to turn off after a move
    '                            which conserves power and reduces heat.
    '    MD2HOMEOFFSET(M)SINGLE  Distance from home switch to call home.
    '                            Value is in units.
    '    MD2HOMEDIR(M)   INTEGER Direction to home switch, 0=rev, -1=fwd.
    '                            Reverses meaning of forward and reverse
    '                            target directions.  All directions are reversed.
    '    MD2INTERRUPTS   INTEGER 0=turns COM port interrupts off during moves
    '                            which prevents mouse & modem interference.
    '                            This can be important under WINDOWS.
    '                            -1 leaves interrupts enabled.
    '                            Not used for XP.
    '    MD2LIMITF(M)    SINGLE  Forward soft limit in units.  Prevents moves
    '                            beyond this value in the forward direction.
    '                            Value is in Units.
    '    MD2LIMITR(M)    SINGLE  Reverse soft limit in units.  Prevents moves
    '                            beyond this value in the reverse direction
    '                            Value is in Units.
    '    MD2MOTOR        INTEGER The selected motor to act upon. 1,2,3,4,5 or 6.
    '                            Set to 12, 34, 56 for dual motor moves.
    '    MD2MOTORNAME(M) STRING  User definable motor name.
    '    MD2MAXSPEED(M)  SINGLE  Motor fastest speed after accelerating.
    '                            In Units per Second.
    '    MD2MINSPEED(M)  SINGLE  Motor speed at the beginning and end of ramping.
    '                            In Units per Second.
    '    MD2MOVETYPE     STRING  Tells the MD2MOVE sub what type of move.
    '                            R=relative, A=absolute. Affects all motors.
    '                            With relative moves, the MD2TARGET parameter
    '                            tells how many steps to move from the current
    '                            position. Negative numbers are reverse, positive
    '                            numbers are forward.
    '                            With absolute moves, the MD2TARGET parameter
    '                            tells what position to move to.  The number of
    '                            steps and direction are determined by the
    '                            current position. Negative numbers are reverse
    '                            from home and positive numbers are forward.
    '                            negative then reverse, positive then forward.
    '    MD2PORT12       INTEGER Port Address for motors 1 & 2 (MD2 #1).
    '    MD2PORT34       INTEGER Port Address for motors 3 & 4 (MD2 #1).
    '    MD2PORT56       INTEGER Port Address for motors 5 & 6 (MD2 #1).
    '    MD2POSITION(M)  SINGLE  Current motor position for each motor (M=motor #)
    '                            relative to home. Negative = reverse from home
    '                            and positive = forward from home.
    '                            Value is in units.
    '    MD2SLOPE(M)     SINGLE  The slope of the ramp (acceleration/deceleration)
    '                            in number Units.  A 2 would mean that the
    '                            motor would accelerate from the MD2MINSPEED to
    '                            the MD2MAXSPEED in 2 units.
    '    MD2STATUS       STRING  Completion status.
    '                            O=motion completed OK,
    '                            K=a keypress stopped the motion,
    '                            B=bad parameter,
    '                            L=soft limit was exceeded.
    '                            E=MD-2 not enabled.
    '                            P=Port not available.
    '                            F=file error.
    '    MD2STEPTYPE     STRING  H=Half step, D=Double phase full step,
    '                            S=Single phase full step.
    '                            Affects all motors.
    '    MD2TARGET(M)    SINGLE  The number of units to move in relative moves,
    '                            the position to move to in absolute moves.
    '                            Value is in units which is converted to steps.
    '    MD2UNITS(M)     LONG    Converts user definable units to steps
    '                            for MD2MOVE subroutine.
    '                            This is number of steps in each unit.
    '    MD2UNITNAME(M)  STRING  This is the name of the units such as
    '                            steps, inches, degrees, etc.
    '
    'PUBLIC INPUT/OUTPUT PORT PARAMETERS----------------------------------
    '
    '    MD2OUTPUTCODE   INTEGER Tells the MD2OUTPUTS sub which MD-2, which
    '                            output pin and on/off action.
    '    MD2INPUT(CODE)  INTEGER Contains status of input pins and home switches
    '                            after using MD2INPUTS sub.
    '
    'PUBLIC PARAMETER & SEQUENCE FILE VARIABLES---------------------------
    '
    '    MD2COMMAND      STRING  Single command to execute.
    '    MD2SEQUENCE     STRING  Contains a motion sequence.
    '    MD2SEQFILE      STRING  Sequence file name.
    '    MD2PARFILE      STRING  Parameter file name.
    '    MD2POINTER      INTEGER Sequence file pointer.
    '    MD2LOOPCOUNT1-9 INTEGER Loop counts.
    '    MD2SEQSTACK(99) INTEGER Stack for gosubs and loops.
    '    MD2SEQSTACKPOINTER INTEGER Stackpointer.
    '    MD2SEQLOC(99)   INTEGER Locations name to pointer array for goto,gosub,loops
    '
    'PUBLIC GRID MOVE PARAMETERS-------------------------------------------
    '
    '    MD2GRIDBEGINX   SINGLE  Grid X start position in units.
    '    MD2GRIDBEGINY   SINGLE  Grid Y start position in units.
    '    MD2GRIDSPACEX   SINGLE  Grid X spacing in units.
    '    MD2GRIDSPACEY   SINGLE  Grid Y spacing in units.
    '    MD2GRIDTARGETX  INTEGER Grid X target.
    '    MD2GRIDTARGETY  INTEGER Grid Y target.
    '
    'PUBLIC CIRCLE/ARC MOVE PARAMETERS------------------------------------
    '
    '    MD2CIRCLERADIUSX   SINGLE  Circle X radius in units.
    '    MD2CIRCLERADIUSY   SINGLE  Circle Y radius in units.
    '    MD2CIRCLECENTERX   SINGLE  Circle X center in units.
    '    MD2CIRCLECENTERY   SINGLE  Circle Y center in units.
    '    MD2CIRCLESTART     INTEGER Circle start angle in degrees.
    '    MD2CIRCLEARC       INTEGER Circle arc angle in degrees. -=CW,+=CCW.
    '    MD2CIRCLECHORD     INTEGER Circle chord angle in degrees.
    '
    'PUBLIC MOTOR SPEED CALIBRATION PARAMETERS--------------------------------
    '
    '    MD2VELOCITY(24)    SINGLE  Motor speed in steps/sec. (24)=fastest
    '    MD2DELAY(24)       LONG    Delay loop counts.
    '    MD2CALFILE         STRING  Calibration file name.
    '    MD2CALIBRATED      INTEGER Calibrated status, 0=false, -1=true.
    '
    '---------------------------------------------------------------------

    'Inpout32.dll - Inp and Out declarations for port I/O. 
    'Put input32.dll in directory with VB executable
    Public Declare Function Inp Lib "inpout32.dll" Alias "Inp32" (ByVal PortAddress As Integer) As Integer
    Public Declare Sub Out Lib "inpout32.dll" Alias "Out32" (ByVal PortAddress As Integer, ByVal Value As Integer)

    'Used to read keypress to stop motion
    Private Declare Function GetAsyncKeyState Lib "user32" (ByVal vKey As Long) As Integer

    'GLOBAL MOTION CONTROL VARIABLES USED BY ALL MODULES.
    Public MD2BACKLASH(6) As Single             'BACKLASH COMPENSATION IN UNITS.
    Public MD2ENABLED12 As Integer              '-1/true= MD-2 #1 ENABLED, 0=NOT/false.
    Public MD2ENABLED34 As Integer              '-1/true= MD-2 #2 ENABLED, 0=NOT/false.
    Public MD2ENABLED56 As Integer              '-1/true= MD-2 #3 ENABLED, 0=NOT/false.
    Public MD2HOLD As Integer                   'HOLD MOTOR AFTER MOVES 0=NO/false,-1=YES/true.
    Public MD2HOMEOFFSET(6) As Single           'HOME OFFSET (OVER TRAVEL).
    Public MD2HOMEDIR(6) As Integer             'DIRECTION OF HOME, 1=FWD, -1=REV.
    Public MD2INPUT(35) As Integer              'MD-2 INPUTS, 0=OFF/false,-1=ACTIVE/true.
    Public MD2INTERRUPTS As Integer             'INTERRUPTS DURING MOVES, 0=OFF/false,-1=ON/true. Not used.
    Public MD2LIMITF(6) As Single               'FORWARD SOFT LIMIT IN UNITS.
    Public MD2LIMITR(6) As Single               'REVERSE SOFT LIMIT IN UNITS.
    Public MD2MAXSPEED(6) As Single             'FAST TOP RAMP SPEED.
    Public MD2MINSPEED(6) As Single             'SLOW STARTING RAMP SPEED.
    Public MD2MOTOR As Integer                  'SELECTED MOTOR,1-6,12,34 OR 56.
    Public MD2MOVETYPE As String                'MOVE TYPE R=RELATIVE,A=ABSOLUTE.
    Public MD2MOTORNAME(6) As String            'USER DEFINABLE MOTOR NAME.
    Public MD2OUTPUTCODE As Integer             'OUTPUT PIN CONTROL ACTION CODE.
    Public MD2POSITION(6) As Single             'MOTOR POSITION IN UNITS.
    Public MD2SLOPE(6) As Single                '# OF UNITS TO ACHEIVE ACCEL/DECEL.
    Public MD2STATUS As String                  'RETURN STATUS, O=OK,B=BAD PARM,ETC.
    Public MD2STEPTYPE As String                'H=HALF,D=DOUBLE FULL,S=SINGLE FULL.
    Public MD2TARGET(6) As Single               'TARGET POSITION OR DISTANCE IN UNITS.
    Public MD2UNITS(6) As Long                  '# OF STEPS PER UNIT.
    Public MD2UNITNAME(6) As String             'NAME OF UNIT.

    'GLOBAL SEQUENCE FILE AND PARAMETER FILE VARIABLES USED BY ALL MODULES.
    Public MD2COMMAND As String                 'SINGLE COMMAND USED BY MD2SEQRUN.
    Public MD2SEQUENCE As String                'COMMAND SEQUENCE USED BY MD2SEQRUN.
    Public MD2PARFILE As String                 'MOTOR PARAMETER FILE NAME.
    Public MD2SEQFILE As String                 'SEQUENCE FILE NAME.
    Public MD2POINTER As Integer                'SEQUENCE POINTER USED BY MD2SEQRUN.
    Public MD2NUMBER As String                  'VALID NUMBER CHECK.
    Public MD2CMD As String                     'WORKING COMMAND.
    Public MD2CHAR As String                    'CURRENT CHARACTER.
    Dim MD2PTR As Integer                       'COMMAND POINTER.
    Dim MD2TIMETEMP As Single                   'TIMER STORAGE.
    Dim MD2OPENP As Integer                     'OPEN PAREN LOCATION.
    Dim MD2CLOSEDP As Integer                   'CLOSED PAREN LOCATION.
    Dim MD2EQUAL As Integer                     'EQUAL SIGN LOCATION.
    Dim MD2VALUE As String                      'VALID VALUE.
    Dim MD2SUBSCRIPT As String                  'VALID SUBSCRIPT.
    Dim MD2VALIDCHAR As Integer                 'VALID CHARACTER COUNTER.
    Dim MD2LOOPCOUNT1 As Integer                'LOOP COUNTER.
    Dim MD2LOOPCOUNT2 As Integer                'LOOP COUNTER.
    Dim MD2LOOPCOUNT3 As Integer                'LOOP COUNTER.
    Dim MD2LOOPCOUNT4 As Integer                'LOOP COUNTER.
    Dim MD2LOOPCOUNT5 As Integer                'LOOP COUNTER.
    Dim MD2LOOPCOUNT6 As Integer                'LOOP COUNTER.
    Dim MD2LOOPCOUNT7 As Integer                'LOOP COUNTER.
    Dim MD2LOOPCOUNT8 As Integer                'LOOP COUNTER.
    Dim MD2LOOPCOUNT9 As Integer                'LOOP COUNTER.
    Dim MD2SEQSTACK(99) As Integer              'STACK.
    Dim MD2SEQSTACKPOINTER As Integer           'STACK POINTER
    Dim MD2SEQLOC(99) As Integer                'LOCATION ARRAY FOR JUMPS, GOTOS, LOOPS.

    'GLOBAL GRID PARAMETERS USED BY ALL MODULES.
    Public MD2GRIDBEGINX As Single              'GRID X BEGIN POSITION IN UNITS.
    Public MD2GRIDBEGINY As Single              'GRID Y BEGIN POSITION IN UNITS.
    Public MD2GRIDSPACEX As Single              'GRID X SPACING IN UNITS.
    Public MD2GRIDSPACEY As Single              'GRID Y SPACING IN UNITS.
    Public MD2GRIDTARGETX As Integer            'GRID X TARGET.
    Public MD2GRIDTARGETY As Integer            'GRID Y TARGET.

    'GLOBAL CIRCLE PARAMETERS USED BY MD2CIRCLE.
    Public MD2CIRCLERADIUSX As Single           'CIRCLE X RADIUS IN UNITS.
    Public MD2CIRCLERADIUSY As Single           'CIRCLE Y RADIUS IN UNITS.
    Public MD2CIRCLECENTERX As Single           'CENTER X COORDINATE IN UNITS.
    Public MD2CIRCLECENTERY As Single           'CENTER Y COORDINATE IN UNITS.
    Public MD2CIRCLESTART As Integer            'START ANGLE IN DEGREES.
    Public MD2CIRCLEARC As Integer              'ARC ANGLE IN DEGREES. 360=CIRCLE.
    Public MD2CIRCLECHORD As Integer            'CHORD ANGLE IN DEGREES.

    'GLOBAL CALIBRATION PARAMETERS.
    Public MD2CALFILE As String                 'CALIBRATION FILE NAME.
    Public MD2DELAY(64) As Long                 'DELAY/VELOCITY CONVERSION ARRAY.
    Public MD2VELOCITY(64) As Double            'DELAY/VELOCITY CONVERSION ARRAY(SPS).
    Public MD2CALIBRATED As Boolean             'CALIBRATED STATUS, -1=TRUE, 0=FALSE.

    'PORT PARAMETERS.
    'If parallel port address = 0 then look to C4 parameters.
    Public MD2PORT12 As Integer                 'Parallel Port Address for Motors 1 & 2.
    Public MD2PORT34 As Integer                 'Parallel Port Address for Motors 3 & 4.
    Public MD2PORT56 As Integer                 'Parallel Port Address for Motors 5 & 6.

    Public MD2C4PORT12 As String                'C4 Port name for Motors 1 & 2.
    Public MD2C4PORT34 As String                'C4 Port name for Motors 3 & 4.
    Public MD2C4PORT56 As String                'C4 Port name for Motors 5 & 6.

    Public MD2C4ID12 As String                  'C4 Port ID for Motors 1 & 2.
    Public MD2C4ID34 As String                  'C4 Port ID for Motors 3 & 4.
    Public MD2C4ID56 As String                  'C4 Port ID for Motors 5 & 6.

    Public MD2C4CONNECTOR12 As String           'C4 connector a=1&2, b=3&4 for Motors 1 & 2.
    Public MD2C4CONNECTOR34 As String           'C4 connector a=1&2, b=3&4 for Motors 3 & 4.
    Public MD2C4CONNECTOR56 As String           'C4 connector a=1&2, b=3&4 for Motors 5 & 6.

    Public MD2C4BAUD12 As String                'C4 Baud rate for Motors 1 & 2.
    Public MD2C4BAUD34 As String                'C4 Baud rate for Motors 3 & 4.
    Public MD2C4BAUD56 As String                'C4 Baud rate for Motors 5 & 6.

    Public MD2C4COM12 As New IO.Ports.SerialPort    'C4 serial port.
    Public MD2C4COM34 As New IO.Ports.SerialPort    'C4 serial port.
    Public MD2C4COM56 As New IO.Ports.SerialPort    'C4 serial port.

    'PRIVATE VARIABLES NEEDED ONLY BY THIS MODULE
    Dim MD2STPPAT(7) As Integer                 'STEP PATTERN ARRAY.
    Dim MD2PATPTR(6) As Integer                 'STEP PATTERN POINTERS.
    Dim MD2LASTDIR(6) As Integer                'LAST DIRECTION -1=REV,1=FWD.
    Dim MD2CALMODE As Boolean                   'CALIBRATION MODE. 0=OFF/false,-1=ON/true.

    Public Sub md2calibrate()

        '---------------------------------------------------------------------
        'NAME:      MD2CALIBRATE
        'DESC:      THIS PROCEDURE CALIBRATES MOTOR SPEEDS ON THIS PARTICULAR
        '           COMPUTER.  THE CALIBRATION INFORMATION IS STORED IN THE
        '           ARRAYS MD2VELOCITY(24) AND MD2DELAY(24) THEN SAVED TO DISK
        '           IN THE FILE NAME STORED IN MD2CALFILE.  CALIBRATION
        '           INFORMATION IS READ BY THE MD2SETUP SUB AT THE BEGINNING
        '           OF EACH MOTION PROGRAM AND IS USED WHEN MOVING MOTORS.
        '           THIS IS TRANSPARENT TO THE USER AND PROGRAMMER.
        '           WITHOUT CALIBRATION, MOTOR SPEEDS WOULD VARY DEPENDING ON
        '           COMPUTER SPEED AND OTHER FACTORS.
        '           IT IS ONLY NECESSARY TO CALIBRATE ON A PARTICULAR COMPUTER
        '           ONCE.  MD2SETUP MUST BE USED FIRST.
        '           MD2VELOCITY(1)=FASTEST POSSIBLE SPEED IN STEPS PER SECOND.
        '           MD2VELOCITY(24)=SLOWEST POSSIBLE SPEED IN STEPS PER SECOND
        '           Takes about 15 seconds.  Most value accuracy 5%.
        'USAGE:     SIMPLY CALL.
        'INPUTS:    MD2CALFILE = CALIBRATION FILE NAME USUALLY "MD2.CAL"
        'OUTPUTS:   FILE CONTAINING CALIBRATION PARAMETERS,ARRAYS,MD2STATUS.
        '---------------------------------------------------------------------

        'LOCAL VARIABLES.
        Dim MD2ELEMENT As Integer       'ELEMENT COUNTER.
        Dim MD2STIME As Single          'BEGINNING TIME.
        Dim MD2ETIME As Single          'ENDING TIME.
        Dim MD2LOOPCOUNT As Long
        Dim MD2FILENUM As Integer       'FREE FILE NUMBER.
        Dim MD2TMPMOTOR As Integer      'TEMP VARIABLE STORAGE.
        Dim MD2TMPMOVETYPE As String
        Dim MD2TMPSLOPE As Single
        Dim MD2TMPBACKLASH As Single
        Dim MD2TMPUNITS As Long
        Dim MD2TMPLIMITF As Single
        Dim MD2TMPLIMITR As Single
        Dim MD2TMPTARGET As Single
        Dim MD2TMPPOSITION As Single
        Dim MD2TMPMAXSPEED As Single

        Dim MD2VEL As Double            'TEMP FOR VELOCITY.
        Dim MD2LCSAVE As Long
        Dim MD2VSAVE As Double
        Dim MD2ESAVE As Integer

        'SET CALIBRATION FILE NAME IF USER DIDNT.
        If MD2CALFILE = "" Then MD2CALFILE = "MD2xp.cal"

        'PREPAIR FOR FAKE MOVE OF MOTOR 1 TO DETERMINE SPEEDS.

        'SAVE PARAMETERS FOR MOTOR 1.
        MD2TMPMOTOR = MD2MOTOR
        MD2TMPMOVETYPE = MD2MOVETYPE
        MD2TMPSLOPE = MD2SLOPE(1)
        MD2TMPBACKLASH = MD2BACKLASH(1)
        MD2TMPUNITS = MD2UNITS(1)
        MD2TMPLIMITF = MD2LIMITF(1)
        MD2TMPLIMITR = MD2LIMITR(1)
        MD2TMPTARGET = MD2TARGET(1)
        MD2TMPPOSITION = MD2POSITION(1)
        MD2TMPMAXSPEED = MD2MAXSPEED(1)

        'INITIALIZE MOTOR PARAMETERS AND VARIABLES.
        MD2MOTOR = 1
        MD2MOVETYPE = "R"
        MD2SLOPE(1) = 0
        MD2TARGET(1) = 100
        MD2BACKLASH(1) = 0
        MD2UNITS(1) = 1
        MD2LIMITF(1) = 2000000000
        MD2LIMITR(1) = -2000000000
        MD2CALMODE = -1
        MD2STATUS = "O"
        MD2OFF()

        'SCROLL THROUGH EACH DELAY LOOP COUNT: 1,2,4,8,16......TO 2^62
        For MD2ELEMENT = 0 To 62

            'SETUP FOR MOVE
            MD2POSITION(1) = 0
            MD2LOOPCOUNT = 2 ^ MD2ELEMENT                               '1,2,4,8,16.....
            MD2MAXSPEED(1) = MD2LOOPCOUNT   'MD2MOVE WILL USE MAXSPEED AS A LOOP COUNT IF IN CAL MODE.

            'Wait for edge of timer change to improve accuracy.  54.925 milliseconds each, 18.2/sec.
            MD2STIME = Microsoft.VisualBasic.DateAndTime.Timer
            Do Until MD2STIME <> Microsoft.VisualBasic.DateAndTime.Timer
            Loop

            'TIME THE MOVE
            MD2STIME = Microsoft.VisualBasic.DateAndTime.Timer          'Start time.
            MD2MOVE()
            MD2ETIME = Microsoft.VisualBasic.DateAndTime.Timer          'End time.

            'CALCULATE THE VELOCITY
            If MD2ETIME <> MD2STIME Then
                MD2VEL = MD2TARGET(1) / (MD2ETIME - MD2STIME)            'Calculate velocity.
            End If

            If (MD2ETIME - MD2STIME) >= 4 Then Exit For 'DONE IF GOT A LONG ENOUGH SAMPLE.

        Next MD2ELEMENT

        'MD2LOOPCOUNT now is delay required for 4 sec worth of steps, MD2ELEMENT is where that should go

        'Save 1sps element # and loopcount for fill.
        MD2VEL = MD2VEL * 4                 'ADJUST FOR 4 SECONDS OF TESTING.
        MD2LOOPCOUNT = MD2LOOPCOUNT / 4     'ADJUST FOR 4 SECONDS OF TESTING.
        MD2ELEMENT = MD2ELEMENT - 2         'ADJUST FOR 4 SECONDS OF TESTING.
        MD2LCSAVE = MD2LOOPCOUNT
        MD2ESAVE = MD2ELEMENT
        MD2VSAVE = MD2VEL

        'Fill in array below (faster) than that.
        Do
            'Fill in array.
            MD2DELAY(MD2ELEMENT) = MD2LOOPCOUNT
            MD2VELOCITY(MD2ELEMENT) = MD2VEL

            'If first element then done.
            If MD2ELEMENT = 0 Then Exit Do

            'Next element
            MD2ELEMENT -= 1
            MD2LOOPCOUNT = MD2LOOPCOUNT / 2
            MD2VEL = MD2VEL * 2
        Loop

        'Restore 1sps element # and loopcount.
        MD2LOOPCOUNT = MD2LCSAVE
        MD2ELEMENT = MD2ESAVE
        MD2VEL = MD2VSAVE

        'Fill in array above (slower) than that.
        Do
            'If last element then done.
            If MD2ELEMENT = 62 Then Exit Do

            'Next element
            MD2ELEMENT += 1
            MD2LOOPCOUNT = MD2LOOPCOUNT * 2
            MD2VEL = MD2VEL / 2

            'Fill in array.
            MD2DELAY(MD2ELEMENT) = MD2LOOPCOUNT
            MD2VELOCITY(MD2ELEMENT) = MD2VEL
        Loop

        'SAVE CALIBRATION PARAMETERS IF NO FAILURE.
        On Error GoTo MD2CALIBRATEERROR   'ERROR HANDLER.
        MD2FILENUM = FreeFile()
        FileOpen(MD2FILENUM, MD2CALFILE, OpenMode.Output)

        For MD2ELEMENT = 0 To 62    'CYCLE THROUGH ARRAY AND SAVE IN FILE.
            Print(MD2FILENUM, MD2DELAY(MD2ELEMENT) & "," & MD2VELOCITY(MD2ELEMENT) & vbCrLf)
        Next MD2ELEMENT

        FileClose(MD2FILENUM)
        On Error GoTo 0             'TURN OFF ERROR HANDLER.

        'FINISH, SET STATUS, RESTORE PARAMETERS, ETC.
        MD2CALMODE = 0
        If MD2STATUS <> "O" Then MD2CALIBRATED = False Else MD2CALIBRATED = True
        MD2MOVETYPE = MD2TMPMOVETYPE
        MD2MOTOR = MD2TMPMOTOR
        MD2SLOPE(1) = MD2TMPSLOPE
        MD2BACKLASH(1) = MD2TMPBACKLASH
        MD2UNITS(1) = MD2TMPUNITS
        MD2LIMITF(1) = MD2TMPLIMITF
        MD2LIMITR(1) = MD2TMPLIMITR
        MD2TARGET(1) = MD2TMPTARGET
        MD2POSITION(1) = MD2TMPPOSITION
        MD2MAXSPEED(1) = MD2TMPMAXSPEED
        Exit Sub

        'FILE ERROR HANDLER.
MD2CALIBRATEERROR:
        MD2STATUS = "F"
        Resume Next

    End Sub

    Public Sub MD2CIRCLE()

        '---------------------------------------------------------------------
        'NAME:      MD2CIRCLE
        'DESC:      THE MD2CIRCLE WILL MOVE 2 MOTORS WHICH ARE ATTACHED TO AN
        '           XY POSITIONING TABLE IN A CIRCULAR, ARC OR ELLIPSE PATTERN.
        '           THE 2 MOTORS MUST BE 1 & 2, 3 & 4 OR 5 & 6.
        '           THE USER CAN SET THE CHORD ANGLE IN DEGREES WHICH DETERMINES
        '           THE RESOLUTION OF THE CIRCLE.  A CHORD ANGLE OF 45 WILL
        '           PRODUCE AN OCTAGON.  A CHORD ANGLE OF 1 DEGREE WILL PRODUCE
        '           A CIRCLE WITH 360 SIDES.
        '           VARIOUS ARC ANGLES CAN ALSO BE GIVEN WHICH WILL PRODUCE
        '           PARTS OF A CIRCLE. AN ARC ANGLE OF 90 WILL PRODUCE AN ARC
        '           OF 90 DEGREES.  360 WILL PRODUCE A COMPLETE CIRCLE.
        '           X & Y RADIUS VALUES ARE PROVIDED TO PRODUCE AN ELLIPSE.
        '           IF BOTH X & Y RADIUS VALUES ARE THE SAME, A CIRCLE WILL
        '           RESULT.
        '           POSITIVE ARC ANGLES WILL PRODUCE COUNTER-CLOCKWISE ROTATION,
        '           NEGATIVE VALUES CLOCKWISE.
        '           MOVES ARE PERFORMED AT THE MINIMUM SPEED WITH NO RAMPING.
        '           TO MAKE A CIRCLE OR ARC AT AN ABSOLUTE POSITION, SET THE
        '           CENTERX,Y PARAMETERS TO THE ABSOLUTE CENTER POSITIONS AND
        '           SET MD2MOVETYPE TO "A".
        '           TO MAKE A CIRCLE OR ARC RELATIVE TO THE CURRENT POSITION,
        '           SET CENTERX,Y TO OFFSETS FROM CURRENT MOTOR POSITIONS AND
        '           SET MD2MOVETYPE TO "R".
        '           RAMPING IS DISABLED.  MOTORS WILL MOVE AT MINIMUM SPEED.
        '
        '              PARAMETER            DESCRIPTION
        '           ----------------    -----------------------
        '           MD2CIRCLERADIUSX    X-AXIS RADIUS IN UNITS.
        '           MD2CIRCLERADIUSY    Y-AXIS RADIUS IN UNITS.
        '           MD2CIRCLECENTERX    X-AXIS CENTER IN UNITS, REL OR ABS.
        '           MD2CIRCLECENTERY    Y-AXIS CENTER IN UNITS, REL OR ABS.
        '           MD2CIRCLESTART      STARTING ANGLE IN DEGREES.
        '           MD2CIRCLEARC        ARC ANGLE IN DEGREES. 360=CIRCLE.
        '                               +=CCW, -=CW ROTATION DIRECTION.
        '           MD2CIRCLECHORD      CHORD ANGLE IN DEGREES.
        '           MD2MOTOR            12, 34 OR 45.
        '           MD2MOVETYPE         "A"=ABSOLUTE, "R"=RELATIVE.
        '
        'USAGE:     SET CIRCLE PARAMETERS AND MOTOR PARAMETERS THEN CALL.
        'INPUTS:    ALL MOTOR PARAMETERS, CIRCLE PARAMETERS.
        'OUTPUTS:   MD2STATUS, MD2TARGET(M), MD2POSITION(M)
        '---------------------------------------------------------------------

        'LOCAL VARIABLES.
        Dim MD2ENDANGLE As Integer      'END ANGLE.
        Dim MD2ANGLE As Integer         'CURRENT ANGLE.
        Dim MD2ANGLER As Single         'CURRENT ANGLE IN RADIANS.
        Dim MD2MOTOR1 As Integer        '1ST MOTOR #.
        Dim MD2MOTOR2 As Integer        '2ND MOTOR #.
        Dim MD2TMPMOVETYPE As String    'SAVE MOVETYPE
        Dim MD2TMPSLOPE1 As Single      'SAVE SLOPE 1.
        Dim MD2TMPSLOPE2 As Single      'SAVE SLOPE 2.
        Dim MD2TMPSPEED1 As Single      'SAVE MAX SPEED 1.
        Dim MD2TMPSPEED2 As Single      'SAVE MAX SPEED 2.
        Dim MD2TMPHOLD As Integer       'SAVE HOLD.
        Dim MD2CNTRX As Single          'CENTER X.
        Dim MD2CNTRY As Single          'CENTER Y.

        'CHECK FOR BAD PARAMETERS.
        MD2STATUS = "B"
        If MD2MOTOR <> 12 And MD2MOTOR <> 34 And MD2MOTOR <> 56 Then Exit Sub
        If MD2CIRCLEARC = 0 Or Abs(MD2CIRCLEARC) > 360 Then Exit Sub
        If MD2CIRCLECHORD <= 0 Or MD2CIRCLECHORD > 180 Then Exit Sub
        If MD2CIRCLESTART > 360 Or MD2CIRCLESTART < 0 Then Exit Sub
        MD2MOVETYPE = UCase$(MD2MOVETYPE)
        If MD2MOVETYPE <> "A" And MD2MOVETYPE <> "R" Then Exit Sub
        MD2STATUS = "O"

        'INITIALIZE VARIABLES.
        If MD2MOTOR = 12 Then MD2MOTOR1 = 1 : MD2MOTOR2 = 2
        If MD2MOTOR = 34 Then MD2MOTOR1 = 3 : MD2MOTOR2 = 4
        If MD2MOTOR = 56 Then MD2MOTOR1 = 5 : MD2MOTOR2 = 6

        'SAVE PARAMETERS.
        MD2TMPMOVETYPE = MD2MOVETYPE
        MD2TMPSLOPE1 = MD2SLOPE(MD2MOTOR1)
        MD2TMPSLOPE2 = MD2SLOPE(MD2MOTOR2)
        MD2TMPSPEED1 = MD2MAXSPEED(MD2MOTOR1)
        MD2TMPSPEED2 = MD2MAXSPEED(MD2MOTOR2)
        MD2TMPHOLD = MD2HOLD

        'SETUP MOTOR PARAMETERS.
        If MD2MOVETYPE = "R" Then
            'RELATIVE CENTER POSITIONS.
            MD2CNTRX = MD2POSITION(MD2MOTOR1) + MD2CIRCLECENTERX
            MD2CNTRY = MD2POSITION(MD2MOTOR2) + MD2CIRCLECENTERY
        Else
            'ABSOLUTE CENTER POSITIONS.
            MD2CNTRX = MD2CIRCLECENTERX
            MD2CNTRY = MD2CIRCLECENTERY
        End If
        MD2MOVETYPE = "A"
        MD2SLOPE(MD2MOTOR1) = 0
        MD2SLOPE(MD2MOTOR2) = 0
        MD2MAXSPEED(MD2MOTOR1) = MD2MINSPEED(MD2MOTOR1)
        MD2MAXSPEED(MD2MOTOR2) = MD2MINSPEED(MD2MOTOR2)
        MD2HOLD = True

        'SET ANGLE AND END ANGLE.
        MD2ENDANGLE = MD2CIRCLESTART + MD2CIRCLEARC
        MD2ANGLE = MD2CIRCLESTART

        'PLOT BASED ON DIRECTION.
        If MD2CIRCLEARC > 0 Then
            'CCW PLOT LOOP.
            Do
                MD2CIRCLEDO(MD2ANGLER, MD2ANGLE, MD2MOTOR1, MD2MOTOR2, MD2CNTRX, MD2CNTRY)
                If MD2STATUS <> "O" Then Exit Do
                MD2ANGLE = MD2ANGLE + MD2CIRCLECHORD
            Loop Until MD2ANGLE >= MD2ENDANGLE
        Else
            'CW PLOT LOOP.
            Do
                MD2CIRCLEDO(MD2ANGLER, MD2ANGLE, MD2MOTOR1, MD2MOTOR2, MD2CNTRX, MD2CNTRY)
                If MD2STATUS <> "O" Then Exit Do
                MD2ANGLE = MD2ANGLE - MD2CIRCLECHORD
            Loop Until MD2ANGLE <= MD2ENDANGLE
        End If

        'PLOT LAST ANGLE UNLESS PREVIOUS ERROR.
        If MD2STATUS = "O" Then
            MD2ANGLE = MD2ENDANGLE
            MD2CIRCLEDO(MD2ANGLER, MD2ANGLE, MD2MOTOR1, MD2MOTOR2, MD2CNTRX, MD2CNTRY)
        End If

        'RESTORE PARAMETERS.
        MD2MOVETYPE = MD2TMPMOVETYPE
        MD2SLOPE(MD2MOTOR1) = MD2TMPSLOPE1
        MD2SLOPE(MD2MOTOR2) = MD2TMPSLOPE2
        MD2MAXSPEED(MD2MOTOR1) = MD2TMPSPEED1
        MD2MAXSPEED(MD2MOTOR2) = MD2TMPSPEED2
        MD2HOLD = MD2TMPHOLD

        'POWER OFF MOTOR IF DESIRED.
        If Not MD2HOLD Then
            If MD2MOTOR = 12 And MD2PORT12 <> 0 Then Out(MD2PORT12, &HFF)
            If MD2MOTOR = 34 And MD2PORT34 <> 0 Then Out(MD2PORT34, &HFF)
            If MD2MOTOR = 56 And MD2PORT56 <> 0 Then Out(MD2PORT56, &HFF)
        End If

    End Sub

    Public Sub MD2CIRCLEDO(ByRef MD2ANGLER As Single, ByRef MD2ANGLE As Integer, ByRef MD2MOTOR1 As Integer, ByRef MD2MOTOR2 As Integer, ByRef MD2CNTRX As Single, ByRef MD2CNTRY As Single)
        'MOVE TO ANGLE DESIRED ANGLE.

        'CONVERT TO RADIANS.
        MD2ANGLER = MD2ANGLE * (3.1416 / 180)

        'CALCULATE X & Y AND MOVE.
        MD2TARGET(MD2MOTOR1) = (MD2CIRCLERADIUSX * Cos(MD2ANGLER)) + MD2CNTRX
        MD2TARGET(MD2MOTOR2) = (MD2CIRCLERADIUSY * Sin(MD2ANGLER)) + MD2CNTRY

        'MOVE THE MOTORS.
        MD2MOVE()

        'DEBUG CODE.
        'LINE -((MD2TARGET(MD2MOTOR1) * 30) + 160, ABS((MD2TARGET(MD2MOTOR2) * 30) - 199) - 99)
        'PRESET ((MD2TARGET(MD2MOTOR1) * 30) + 160, ABS((MD2TARGET(MD2MOTOR2) * 30) - 199) - 99)
        'PRINT MD2TARGET(MD2MOTOR1), MD2TARGET(MD2MOTOR2): INPUT "", A$
        'DO: LOOP WHILE INKEY$ = ""

    End Sub

    Public Sub MD2GRID()

        '---------------------------------------------------------------------
        'NAME:      MD2GRID
        'DESC:      THE MD2GRID PROCEDURE IS USED TO MOVE MOTORS TO A LOCATION
        '           OF A GRID.  A GRID IS AN X Y MATRIX OF LOCATIONS LIKE
        '           A CHECKER BOARD.  THIS ALLOWS A PROGRAMMER TO MOVE TO
        '           A ROW & COLUMN OF A GRID INSTEAD OF MOVING BY PASSING
        '           MD2GRID WORKS WITH ABSOLUTE TARGET POSITIONS ONLY.
        '           THE SPECIFIC TARGET LOCATION IN STEPS OR INCHES, ETC.
        '           THE FOLLOWING PARAMETERS DEFINE THE GRID.
        '
        '               PARAMETER       DESCRIPTION
        '               ---------       -----------
        '               MD2GRIDBEGINX   X BEGIN ABSOLUTE POSITION IN UNITS
        '               MD2GRIDBEGINY   Y BEGIN ABSOLUTE POSITION IN UNITS
        '               MD2GRIDSPACEX   X SPACING IN UNITS.
        '               MD2GRIDSPACEY   Y SPACING IN UNITS.
        '               MD2GRIDTARGETX  X TARGET, ABSOLUTE.
        '               MD2GRIDTARGETY  Y TARGET, ABSOLUTE.
        '
        'USAGE:     SET GRID PARAMETERS TO DEFINE THE GRID, SET MD2MOTOR
        '           TO A VALID MOTOR PAIR (12,34 OR 56), SET MOTOR PARAMETERS
        '           THEN CALL.
        'INPUTS:    ALL GRID AND MOTOR PARAMETERS.
        'OUTPUTS:   MD2STATUS,MD2TARGET(M),MD2POSITION(M).
        '---------------------------------------------------------------------

        'LOCAL VARIABLES.
        Dim MD2X As Integer        'X MOTOR #.
        Dim MD2Y As Integer        'Y MOTOR #.
        Dim MD2MT As String        'MOVETYPE STORAGE.

        'CHECK FOR BAD PARAMETERS.
        MD2STATUS = "B"
        If MD2MOTOR <> 12 And MD2MOTOR <> 34 And MD2MOTOR <> 56 Then Exit Sub
        MD2STATUS = "O"

        'SET MOTOR #.
        If MD2MOTOR = 12 Then MD2X = 1 : MD2Y = 2
        If MD2MOTOR = 34 Then MD2X = 3 : MD2Y = 4
        If MD2MOTOR = 56 Then MD2X = 5 : MD2Y = 6

        'SET TARGET POSITIONS.
        MD2TARGET(MD2X) = MD2GRIDBEGINX + ((MD2GRIDTARGETX - 1) * MD2GRIDSPACEX)
        MD2TARGET(MD2Y) = MD2GRIDBEGINY + ((MD2GRIDTARGETY - 1) * MD2GRIDSPACEY)

        'GRID MOVE.
        MD2MT = MD2MOVETYPE     'SAVE MOVETYPE.
        MD2MOVETYPE = "A"       'ABSOLUTE MOVES.
        MD2MOVE()               'MOVE TO THE GRID COORDINATES.
        MD2MOVETYPE = MD2MT     'RESTORE MOVETYPE.

    End Sub

    Public Sub MD2HOME()

        '---------------------------------------------------------------------
        'NAME:      MD2HOME
        'DESC:      THE MD2HOME PROCEDURE IS USED TO MOVE THE STEPPER MOTOR
        '           TO A KNOWN HOME POSITION.  ALL OTHER MOVES ARE RELATIVE
        '           TO THIS HOME (ZERO) POSITION.  THE SELECTED MOTOR IS
        '           MOVED REVERSE UNTIL THE SWITCH IS ACTIVATED, THEN FORWARD
        '           UNTIL DEACTIVATED, THEN MOVED FORWARD ACCORDING TO THE
        '           MD2HOMEOFFSET(M) PARAMETER. THE CURRENT POSITION IS THEN
        '           SET TO ZERO - THIS IS THE HOME POSITION.  THE MD2MINSPEED
        '           PARAMETER IS USED FOR THE MOTOR SPEED - NO RAMPING IS DONE.
        '           ONLY 1 MOTOR (1-6) CAN BE HOME'D AT A TIME.
        'USAGE:     SET THE DESIRED MOTOR #, MOTOR PARAMETERS AND CALL.
        'INPUTS:    MOTOR # AND MOTOR PARAMETERS.
        'OUTPUTS:   CURRENT POSITION SET TO ZERO, MD2STATUS.
        '---------------------------------------------------------------------

        Dim MSG As String

        'CHECK FOR ENABLED MD-2.
        MD2STATUS = "E"
        If (MD2MOTOR = 1 Or MD2MOTOR = 2) And Not MD2ENABLED12 Then Exit Sub
        If (MD2MOTOR = 3 Or MD2MOTOR = 4) And Not MD2ENABLED34 Then Exit Sub
        If (MD2MOTOR = 5 Or MD2MOTOR = 6) And Not MD2ENABLED56 Then Exit Sub

        'CHECK FOR VALID MOTOR #.
        MD2STATUS = "B"
        If MD2MOTOR = 1 Or MD2MOTOR = 2 Or MD2MOTOR = 3 Then MD2STATUS = "O"
        If MD2MOTOR = 4 Or MD2MOTOR = 5 Or MD2MOTOR = 6 Then MD2STATUS = "O"
        If MD2STATUS <> "O" Then Exit Sub

        'ACT BASED ON MOTOR SPECIFIED AND PORT.

        'MOTOR 1 OR 2.
        If MD2MOTOR = 1 Or MD2MOTOR = 2 Then

            'IF PARALLEL PORT ADDRESS EXISTS, HOME WITH PARALLEL PORT.
            If MD2PORT12 <> 0 Then GoTo MD2HOMEPP

            'If C4 PORT IS SET THEN DEAL WITH IT.
            If MD2C4PORT12 <> "" Then

                Try
                    'HOME THE MOTOR.
                    If MD2C4CONNECTOR12 = "a" Then      'ADJUST FOR CONNECTORS
                        MD2C4COM12.Write("!" & MD2C4ID12 & "h" & MD2MOTOR & vbCr)
                    Else
                        MD2C4COM12.Write("!" & MD2C4ID12 & "h" & MD2MOTOR + 2 & vbCr)
                    End If

                    Do                'LOOP AWAITING MOTION STOPPED OR KEYPRESS, RETURN STATUS.
                        'STOP IF CTRL KEY PRESSED.
                        If GetAsyncKeyState(17) Then
                            MD2STATUS = "K"
                            MD2C4COM12.Write("a")    'STOP MOTOR
                            Exit Sub
                        End If

                        'WAIT UNTIL RECEIVE o.
                        If MD2C4COM12.BytesToRead > 0 Then
                            MSG = Chr(MD2C4COM12.ReadByte)
                            If MSG = "o" Then Exit Do
                        End If
                    Loop

                    MD2STATUS = "O"
                Catch ex As Exception
                    MD2STATUS = "P"
                End Try

                'SET LAST DIRECTION ACCORDING TO HOMEDIR.
                If MD2HOMEDIR(MD2MOTOR) = 0 Then
                    MD2LASTDIR(MD2MOTOR) = 1    'HOMEDIR=REV, SET LASTDIR TO FORWARD.
                Else
                    MD2LASTDIR(MD2MOTOR) = -1   'HOMEDIR=FWD, SET LASTDIR TO REVERSE.
                End If

                'SET POSITION TO 0.
                MD2POSITION(MD2MOTOR) = 0

                Exit Sub
            End If
        End If

        'MOTOR 3 OR 4.
        If MD2MOTOR = 3 Or MD2MOTOR = 4 Then

            'IF PARALLEL PORT ADDRESS EXISTS, HOME WITH PARALLEL PORT.
            If MD2PORT34 <> 0 Then GoTo MD2HOMEPP

            'If C4 PORT IS SET THEN DEAL WITH IT.
            If MD2C4PORT34 <> "" Then

                Try
                    'HOME THE MOTOR.
                    If MD2C4CONNECTOR34 = "a" Then      'ADJUST FOR CONNECTORS
                        MD2C4COM34.Write("!" & MD2C4ID34 & "h" & MD2MOTOR - 2 & vbCr)
                    Else
                        MD2C4COM34.Write("!" & MD2C4ID34 & "h" & MD2MOTOR & vbCr)
                    End If

                    Do                'LOOP AWAITING MOTION STOPPED OR KEYPRESS, RETURN STATUS.
                        'STOP IF CTRL KEY PRESSED.
                        If GetAsyncKeyState(17) Then
                            MD2STATUS = "K"
                            MD2C4COM34.Write("a")    'STOP MOTOR
                            Exit Sub
                        End If

                        'WAIT UNTIL RECEIVE o.
                        If MD2C4COM34.BytesToRead > 0 Then
                            MSG = Chr(MD2C4COM34.ReadByte)
                            If MSG = "o" Then Exit Do
                        End If
                    Loop

                    MD2STATUS = "O"
                Catch ex As Exception
                    MD2STATUS = "P"
                End Try

                'SET LAST DIRECTION ACCORDING TO HOMEDIR.
                If MD2HOMEDIR(MD2MOTOR) = 0 Then
                    MD2LASTDIR(MD2MOTOR) = 1    'HOMEDIR=REV, SET LASTDIR TO FORWARD.
                Else
                    MD2LASTDIR(MD2MOTOR) = -1   'HOMEDIR=FWD, SET LASTDIR TO REVERSE.
                End If

                'SET POSITION TO 0.
                MD2POSITION(MD2MOTOR) = 0

                Exit Sub
            End If
        End If

        'MOTOR 5 OR 6.
        If MD2MOTOR = 5 Or MD2MOTOR = 6 Then

            'IF PARALLEL PORT ADDRESS EXISTS, HOME WITH PARALLEL PORT.
            If MD2PORT56 <> 0 Then GoTo MD2HOMEPP

            'If C4 PORT IS SET THEN DEAL WITH IT.
            If MD2C4PORT56 <> "" Then

                Try
                    'HOME THE MOTOR.
                    If MD2C4CONNECTOR56 = "a" Then      'ADJUST FOR CONNECTORS
                        MD2C4COM56.Write("!" & MD2C4ID56 & "h" & MD2MOTOR - 4 & vbCr)
                    Else
                        MD2C4COM56.Write("!" & MD2C4ID56 & "h" & MD2MOTOR - 2 & vbCr)
                    End If
                    Do                'LOOP AWAITING MOTION STOPPED OR KEYPRESS, RETURN STATUS.
                        'STOP IF CTRL KEY PRESSED.
                        If GetAsyncKeyState(17) Then
                            MD2STATUS = "K"
                            MD2C4COM56.Write("a")    'STOP MOTOR
                            Exit Sub
                        End If

                        'WAIT UNTIL RECEIVE o.
                        If MD2C4COM56.BytesToRead > 0 Then
                            MSG = Chr(MD2C4COM56.ReadByte)
                            If MSG = "o" Then Exit Do
                        End If
                    Loop

                    MD2STATUS = "O"
                Catch ex As Exception
                    MD2STATUS = "P"
                End Try

                'SET LAST DIRECTION ACCORDING TO HOMEDIR.
                If MD2HOMEDIR(MD2MOTOR) = 0 Then
                    MD2LASTDIR(MD2MOTOR) = 1    'HOMEDIR=REV, SET LASTDIR TO FORWARD.
                Else
                    MD2LASTDIR(MD2MOTOR) = -1   'HOMEDIR=FWD, SET LASTDIR TO REVERSE.
                End If

                'SET POSITION TO 0.
                MD2POSITION(MD2MOTOR) = 0

                Exit Sub
            End If
        End If

        'BAD MOTOR PARAMETER.
        MD2STATUS = "B"
        Exit Sub

        'Move as parallel port.
MD2HOMEPP:

        'LOCAL VARIABLES.
        Dim MD2DELAYLOOP As Long    'DELAY COUNTER BETWEEN STEPS.
        Dim MD2DIR As Integer       'DIRECTION. -1=REV, 1=FWD.
        Dim MD2PORT As Integer      'MOTOR PORT ADDRESS.
        Dim MD2PATS As Integer      'CALCULATED STEP PATTERN.
        Dim MD2PMASK As Integer     'SELECTED STEP PATTERN MASK.
        Dim MD2OMASK As Integer     'OTHER MOTOR PATTERN MASK.
        Dim MD2SMASK As Integer     'SWITCH MASK.
        'Dim MD2INTREG As Integer    'INTERRUPT REGISTER.
        Dim MD2I As Long            'TEMPORARY.
        Dim MD2WAY As Single        'TEMP FOR VELOCITY INTEROLATION.
        Dim MD2MINDELAY As Long     'CALCULATED DELAY COUNTER.
        'Dim MD2KEYIN As Integer     'KEYBOARD ENTRY.

        'CHECK FOR PORT AVAILABILITY.
        MD2STATUS = "P"
        If (MD2MOTOR = 1 Or MD2MOTOR = 2) And MD2PORT12 = 0 Then Exit Sub
        If (MD2MOTOR = 3 Or MD2MOTOR = 4) And MD2PORT34 = 0 Then Exit Sub
        If (MD2MOTOR = 5 Or MD2MOTOR = 6) And MD2PORT56 = 0 Then Exit Sub

        'CHECK FOR CALIBRATION.
        If Not MD2CALIBRATED Then MD2STATUS = "C" : Exit Sub

        'CHECK FOR VALID STEP TYPE.
        MD2STEPTYPE = UCase$(MD2STEPTYPE)
        If MD2STEPTYPE <> "H" And MD2STEPTYPE <> "D" And MD2STEPTYPE <> "S" Then MD2STATUS = "B" : Exit Sub

        'INITIALIZE STATUS.
        MD2STATUS = "O"

        'SET STEP PATTERNS.
        Select Case MD2STEPTYPE
            Case "H"
                MD2STPPAT(0) = &H66 : MD2STPPAT(1) = &H77
                MD2STPPAT(2) = &H33 : MD2STPPAT(3) = &HBB
                MD2STPPAT(4) = &H99 : MD2STPPAT(5) = &HDD
                MD2STPPAT(6) = &HCC : MD2STPPAT(7) = &HEE
            Case "S"
                MD2STPPAT(0) = &H77 : MD2STPPAT(1) = &HBB
                MD2STPPAT(2) = &HDD : MD2STPPAT(3) = &HEE
                MD2STPPAT(4) = &H77 : MD2STPPAT(5) = &HBB
                MD2STPPAT(6) = &HDD : MD2STPPAT(7) = &HEE
            Case "D"
                MD2STPPAT(0) = &H66 : MD2STPPAT(1) = &H33
                MD2STPPAT(2) = &H99 : MD2STPPAT(3) = &HCC
                MD2STPPAT(4) = &H66 : MD2STPPAT(5) = &H33
                MD2STPPAT(6) = &H99 : MD2STPPAT(7) = &HCC
        End Select

        'SET UP ADDRESS.
        If MD2MOTOR = 1 Or MD2MOTOR = 2 Then MD2PORT = MD2PORT12
        If MD2MOTOR = 3 Or MD2MOTOR = 4 Then MD2PORT = MD2PORT34
        If MD2MOTOR = 5 Or MD2MOTOR = 6 Then MD2PORT = MD2PORT56

        'SET UP PATTERN MASK, OTHER MOTOR'S MASK AND SWITCH MASK.
        If MD2MOTOR = 1 Or MD2MOTOR = 3 Or MD2MOTOR = 5 Then
            MD2PMASK = &HF
            MD2OMASK = &HF0
            MD2SMASK = &H20
        Else
            MD2PMASK = &HF0
            MD2OMASK = &HF
            MD2SMASK = &H10
        End If

        'CONVERT MINSPEED VELOCITY TO DELAY COUNTS.
        For MD2I = 1 To 64     'SEARCH FOR CORRECT ARRAY ELEMENTS.
            If (MD2MINSPEED(MD2MOTOR) * MD2UNITS(MD2MOTOR)) >= MD2VELOCITY(MD2I) Then Exit For
        Next MD2I
        'INTERPOLATE VELOCITY.
        MD2WAY = ((MD2MINSPEED(MD2MOTOR) * MD2UNITS(MD2MOTOR)) - MD2VELOCITY(MD2I - 1)) / (MD2VELOCITY(MD2I) - MD2VELOCITY(MD2I - 1))
        MD2MINDELAY = Int((((MD2DELAY(MD2I) - MD2DELAY(MD2I - 1)) * MD2WAY) + MD2DELAY(MD2I - 1)) + 0.5)

        'SELECT DIRECTION TO HOME.
        If MD2HOMEDIR(MD2MOTOR) = 0 Then MD2DIR = -1 Else MD2DIR = 1

        'CLEAR OUT KEY BUFFER.
        If GetAsyncKeyState(17) Then
        End If

        '---------------------------------------------
        'MOVE MOTOR REVERSE UNTIL SWITCH ACTIVATED.
        '---------------------------------------------

        'LOOP UNTIL SWITCH IS ACTIVATED.
        Do Until (Inp(MD2PORT + 1) And MD2SMASK) = 0

            'STOP IF CTRL KEY PRESSED.
            If GetAsyncKeyState(17) Then
                MD2STATUS = "K"
                Exit Do
            End If

            'POINT TO THE NEXT STEP PATTERN.
            MD2PATPTR(MD2MOTOR) = (MD2PATPTR(MD2MOTOR) + MD2DIR) And &H7

            'GET STEP PATTERN AND MASK OFF UNNEEDED BITS.
            MD2PATS = MD2STPPAT(MD2PATPTR(MD2MOTOR)) And MD2PMASK

            'DON'T DISTURB OTHER MOTORS BITS.
            MD2PATS = MD2PATS Or (Inp(MD2PORT) And MD2OMASK)

            'OUTPUT THE STEP PATTERN TO MOVE THE MOTOR.
            Out(MD2PORT, MD2PATS)

            'DELAY BETWEEN STEPS.
            For MD2DELAYLOOP = 1 To MD2MINDELAY : Next MD2DELAYLOOP

        Loop

        '----------------------------------------------
        'MOVE MOTOR FORWARD UNTIL SWITCH DEACTIVATED.
        '----------------------------------------------

        'LOOP UNTIL SWITCH IS DEACTIVATED.
        Do Until (Inp(MD2PORT + 1) And MD2SMASK) <> 0

            'STOP IF CTRL KEY PRESSED.
            If GetAsyncKeyState(17) Then
                MD2STATUS = "K"
                Exit Do
            End If

            'POINT TO THE NEXT STEP PATTERN.
            MD2PATPTR(MD2MOTOR) = (MD2PATPTR(MD2MOTOR) - MD2DIR) And &H7

            'GET STEP PATTERN AND MASK OFF UNNEEDED BITS.
            MD2PATS = MD2STPPAT(MD2PATPTR(MD2MOTOR)) And MD2PMASK

            'DON'T DISTURB OTHER MOTORS BITS.
            MD2PATS = MD2PATS Or (Inp(MD2PORT) And MD2OMASK)

            'OUTPUT THE STEP PATTERN TO MOVE THE MOTOR.
            Out(MD2PORT, MD2PATS)

            'DELAY BETWEEN STEPS.
            For MD2DELAYLOOP = 1 To MD2MINDELAY : Next MD2DELAYLOOP

        Loop

        '-----------------------------------------------
        'OVER STEP HOME POSITION USING MD2HOMEOFFSET(M).
        '-----------------------------------------------

        'STEP UNTIL COUNT DEPLETED.
        MD2I = Int(MD2HOMEOFFSET(MD2MOTOR) * MD2UNITS(MD2MOTOR))
        Do Until MD2I = 0

            'STOP IF CTRL KEY PRESSED.
            If GetAsyncKeyState(17) Then
                MD2STATUS = "K"
                Exit Do
            End If

            'POINT TO THE NEXT STEP PATTERN.
            MD2PATPTR(MD2MOTOR) = (MD2PATPTR(MD2MOTOR) - MD2DIR) And &H7

            'GET STEP PATTERN AND MASK OFF UNNEEDED BITS.
            MD2PATS = MD2STPPAT(MD2PATPTR(MD2MOTOR)) And MD2PMASK

            'DON'T DISTURB OTHER MOTORS BITS.
            MD2PATS = MD2PATS Or (Inp(MD2PORT) And MD2OMASK)

            'OUTPUT THE STEP PATTERN TO MOVE THE MOTOR.
            Out(MD2PORT, MD2PATS)

            'DELAY BETWEEN STEPS.
            For MD2DELAYLOOP = 1 To MD2MINDELAY : Next MD2DELAYLOOP

            'UPDATE STEP COUNT.
            MD2I = MD2I - 1

        Loop

        'SET LAST DIRECTION ACCORDING TO HOMEDIR.
        If MD2HOMEDIR(MD2MOTOR) = 0 Then
            MD2LASTDIR(MD2MOTOR) = 1    'HOMEDIR=REV, SET LASTDIR TO FORWARD.
        Else
            MD2LASTDIR(MD2MOTOR) = -1   'HOMEDIR=FWD, SET LASTDIR TO REVERSE.
        End If

        'SET POSITION TO 0.
        MD2POSITION(MD2MOTOR) = 0

        'POWER OFF MOTOR IF DESIRED.
        If Not MD2HOLD Then Out(MD2PORT, &HFF)

    End Sub

    Public Sub MD2INPUTS()

        '---------------------------------------------------------------------
        'NAME:      MD2INPUTS
        'DESC:      THE MD2INPUTS PROCEDURE READS ALL INPUTS FROM ALL MD-2
        '           SYSTEMS INCLUDING HOME SWITCHES AND GENERAL PURPOSE INPUTS
        '           AND SETS VARIABLES ACCORDINGLY.  VARIABLES FOR PORTS THAT
        '           ARE NOT CONNECTED TO MD-2 SYSTEMS WILL CONTAIN USELESS
        '           INFORMATION.  EACH MD-2 SYSTEM HAS 2 HOME SWITCHES (ONE
        '           ASSOCIATED WITH EACH MOTOR) WHICH ARE INPUTS AND SOME
        '           MD-2 SYSTEMS HAVE 3 GENERAL PURPOSE INPUTS WHICH ARE
        '           USER DEFINED.  CHECK YOUR MANUAL TO SEE IF YOU HAVE
        '           GENERAL PURPOSE INPUTS.
        'USAGE:     USE TO READ THE CONDITION OF HOME SWITCHES, SENSORS
        '           AND OTHER INPUTS.
        'INPUTS:    NONE.
        'OUTPUTS:   INPUT VARIABLES -1=ACTIVE(LOGIC 0), 0=NOT ACTIVE(LOGIC 1).
        '
        '           VARIABLES  MD-2 PORT  INPUT           CONDITION
        '           ---------  ---------  -----           ---------
        '           MD2INPUT(11)  #1      HOME SWITCH #1  -1=SWITCH ACTIVE (LOW).
        '           MD2INPUT(12)  #1      HOME SWITCH #2  -1=SWITCH ACTIVE (LOW).
        '           MD2INPUT(13)  #1      GEN PURP IN #1  -1=INPUT ACTIVE (LOW).
        '           MD2INPUT(14)  #1      GEN PURP IN #2  -1=INPUT ACTIVE (LOW).
        '           MD2INPUT(15)  #1      GEN PURP IN #3  -1=INPUT ACTIVE (LOW).
        '
        '           MD2INPUT(21)  #2      HOME SWITCH #1  -1=SWITCH ACTIVE (LOW).
        '           MD2INPUT(22)  #2      HOME SWITCH #2  -1=SWITCH ACTIVE (LOW).
        '           MD2INPUT(23)  #2      GEN PURP IN #1  -1=INPUT ACTIVE (LOW).
        '           MD2INPUT(24)  #2      GEN PURP IN #2  -1=INPUT ACTIVE (LOW).
        '           MD2INPUT(25)  #2      GEN PURP IN #3  -1=INPUT ACTIVE (LOW).
        '
        '           MD2INPUT(31)  #3      HOME SWITCH #1  -1=SWITCH ACTIVE (LOW).
        '           MD2INPUT(32)  #3      HOME SWITCH #2  -1=SWITCH ACTIVE (LOW).
        '           MD2INPUT(33)  #3      GEN PURP IN #1  -1=INPUT ACTIVE (LOW).
        '           MD2INPUT(34)  #3      GEN PURP IN #2  -1=INPUT ACTIVE (LOW).
        '           MD2INPUT(35)  #3      GEN PURP IN #3  -1=INPUT ACTIVE (LOW).
        '---------------------------------------------------------------------

        Dim I As String

        'FIRST CLEAR ALL VARIABLES.
        MD2INPUT(11) = False
        MD2INPUT(12) = False
        MD2INPUT(13) = False
        MD2INPUT(14) = False
        MD2INPUT(15) = False
        MD2INPUT(21) = False
        MD2INPUT(22) = False
        MD2INPUT(23) = False
        MD2INPUT(24) = False
        MD2INPUT(25) = False
        MD2INPUT(31) = False
        MD2INPUT(32) = False
        MD2INPUT(33) = False
        MD2INPUT(34) = False
        MD2INPUT(35) = False

        'READ INPUTS AND SET VARIABLES IF INPUTS ARE ACTIVE (LOGIC ZERO).

        'PARALLEL PORT.
        If MD2PORT12 <> 0 Then
            If (Inp(MD2PORT12 + 1) And &H20) = 0 Then MD2INPUT(11) = True
            If (Inp(MD2PORT12 + 1) And &H10) = 0 Then MD2INPUT(12) = True
            If (Inp(MD2PORT12 + 1) And &H80) <> 0 Then MD2INPUT(13) = True
            If (Inp(MD2PORT12 + 1) And &H40) <> 0 Then MD2INPUT(14) = True
            If (Inp(MD2PORT12 + 1) And &H8) <> 0 Then MD2INPUT(15) = True
        End If

        If MD2PORT34 <> 0 Then
            If (Inp(MD2PORT34 + 1) And &H20) = 0 Then MD2INPUT(21) = True
            If (Inp(MD2PORT34 + 1) And &H10) = 0 Then MD2INPUT(22) = True
            If (Inp(MD2PORT34 + 1) And &H80) <> 0 Then MD2INPUT(23) = True
            If (Inp(MD2PORT34 + 1) And &H40) <> 0 Then MD2INPUT(24) = True
            If (Inp(MD2PORT34 + 1) And &H8) <> 0 Then MD2INPUT(25) = True
        End If

        If MD2PORT56 <> 0 Then
            If (Inp(MD2PORT56 + 1) And &H20) = 0 Then MD2INPUT(31) = True
            If (Inp(MD2PORT56 + 1) And &H10) = 0 Then MD2INPUT(32) = True
            If (Inp(MD2PORT56 + 1) And &H80) <> 0 Then MD2INPUT(33) = True
            If (Inp(MD2PORT56 + 1) And &H40) <> 0 Then MD2INPUT(34) = True
            If (Inp(MD2PORT56 + 1) And &H8) <> 0 Then MD2INPUT(35) = True
        End If


        'If C4 PORT IS SET THEN DEAL WITH IT.
        If MD2C4PORT12 <> "" Then
            Try
                'CAN READ HOME SW AND INPUTS ON FIRST MD2 PORT, BUT ONLY HOME SW ON 2ND.
                If MD2C4CONNECTOR12 = "a" Then
                    MD2C4COM12.Write("!" & MD2C4ID12 & "i" & vbCr)
                    I = MD2C4COM12.ReadTo(vbCr)
                    If I.Chars(0) = "1" Then MD2INPUT(11) = True Else MD2INPUT(11) = False
                    If I.Chars(1) = "1" Then MD2INPUT(12) = True Else MD2INPUT(12) = False
                    If I.Chars(4) = "1" Then MD2INPUT(13) = True Else MD2INPUT(13) = False
                    If I.Chars(5) = "1" Then MD2INPUT(14) = True Else MD2INPUT(14) = False
                    If I.Chars(6) = "1" Then MD2INPUT(15) = True Else MD2INPUT(15) = False
                Else
                    MD2C4COM12.Write("!" & MD2C4ID12 & "i" & vbCr)
                    I = MD2C4COM12.ReadTo(vbCr)
                    If I.Chars(2) = "1" Then MD2INPUT(11) = True Else MD2INPUT(11) = False
                    If I.Chars(3) = "1" Then MD2INPUT(12) = True Else MD2INPUT(12) = False
                End If
            Catch ex As Exception
                'IGNORE ERROR, LEAVE RESULTS FALSE.
            End Try
        End If


        'If C4 PORT IS SET THEN DEAL WITH IT.
        If MD2C4PORT34 <> "" Then
            Try
                'CAN READ HOME SW AND INPUTS ON FIRST MD2 PORT, BUT ONLY HOME SW ON 2ND.
                If MD2C4CONNECTOR34 = "a" Then
                    MD2C4COM34.Write("!" & MD2C4ID34 & "i" & vbCr)
                    I = MD2C4COM34.ReadTo(vbCr)
                    If I.Chars(0) = "1" Then MD2INPUT(21) = True Else MD2INPUT(21) = False
                    If I.Chars(1) = "1" Then MD2INPUT(22) = True Else MD2INPUT(22) = False
                    If I.Chars(4) = "1" Then MD2INPUT(23) = True Else MD2INPUT(23) = False
                    If I.Chars(5) = "1" Then MD2INPUT(24) = True Else MD2INPUT(24) = False
                    If I.Chars(6) = "1" Then MD2INPUT(25) = True Else MD2INPUT(25) = False
                Else
                    MD2C4COM34.Write("!" & MD2C4ID34 & "i" & vbCr)
                    I = MD2C4COM34.ReadTo(vbCr)
                    If I.Chars(2) = "1" Then MD2INPUT(21) = True Else MD2INPUT(21) = False
                    If I.Chars(3) = "1" Then MD2INPUT(22) = True Else MD2INPUT(22) = False
                End If
            Catch ex As Exception
                'IGNORE ERROR, LEAVE RESULTS FALSE.
            End Try
        End If


        'If C4 PORT IS SET THEN DEAL WITH IT.
        If MD2C4PORT56 <> "" Then
            Try
                'CAN READ HOME SW AND INPUTS ON FIRST MD2 PORT, BUT ONLY HOME SW ON 2ND.
                If MD2C4CONNECTOR56 = "a" Then
                    MD2C4COM56.Write("!" & MD2C4ID56 & "i" & vbCr)
                    I = MD2C4COM56.ReadTo(vbCr)
                    If I.Chars(0) = "1" Then MD2INPUT(31) = True Else MD2INPUT(31) = False
                    If I.Chars(1) = "1" Then MD2INPUT(32) = True Else MD2INPUT(32) = False
                    If I.Chars(4) = "1" Then MD2INPUT(33) = True Else MD2INPUT(33) = False
                    If I.Chars(5) = "1" Then MD2INPUT(34) = True Else MD2INPUT(34) = False
                    If I.Chars(6) = "1" Then MD2INPUT(35) = True Else MD2INPUT(35) = False
                Else
                    MD2C4COM56.Write("!" & MD2C4ID56 & "i" & vbCr)
                    I = MD2C4COM56.ReadTo(vbCr)
                    If I.Chars(2) = "1" Then MD2INPUT(31) = True Else MD2INPUT(31) = False
                    If I.Chars(3) = "1" Then MD2INPUT(32) = True Else MD2INPUT(32) = False
                End If
            Catch ex As Exception
                'IGNORE ERROR, LEAVE RESULTS FALSE.
            End Try
        End If

    End Sub

    Public Sub MD2MOVE()

        '---------------------------------------------------------------------
        'NAME:      MD2MOVE
        'DESC:      THIS PROCEDURE IS USED TO MOVE MOTORS.
        '           SET MD2MOTOR TO 1,2,3,4,5 OR 6 FOR SINGLE MOTOR MOVES OR
        '           TO 12, 34 OR 56 FOR DUAL MOTOR MOVES.
        '           WHEN MOVING 2 MOTORS, BOTH MOTORS START AND STOP AT THE
        '           SAME TIME RESULTING IN STRAIGHT LINE MOTION ALSO KNOWN
        '           AS LINEAR INTERPOLATION.
        '           SPEED AND RAMPING OF THE MOTOR WITH THE LONGEST
        '           TRAVEL WILL BE USED.
        '           SOFT LIMIT VALUES WILL PREVENT OVERTRAVEL.
        '           THE HOME SWITCH IS IGNORED.
        '           IF SLOPE=0 THEN THE MOTOR WILL MOVE AT MD2MAXSPEED
        '           IF KEY PRESSED DURING MOVE, MOVE IS COMPLETED AND MD2STATUS=K
        'USAGE:     SET MOTOR #, MOTOR PARAMETERS AND CALL.
        'INPUTS:    MOTOR # (1-6,12,34 OR 56) AND MOTOR PARAMETERS.
        'OUTPUTS:   CURRENT POSITION, MD2STATUS.
        '---------------------------------------------------------------------

        'LOCAL VARIABLES.
        Dim MD2PORT As Integer      'MOTOR PORT ADDRESS.
        Dim MD2PATS As Integer      'CALCULATED STEP PATTERN.
        'Dim MD2INTREG As Integer    'INTERRUPT REGISTER.
        'Dim MD2KEYIN As Integer     'KEYBOARD VALUE.
        Dim MSG As String

        'RAMPING VARIABLES.
        Dim MD2DELAYTMP As Long     'TEMPORARY DELAY LOOP COUNTER.
        Dim MD2DELAYCUR As Long     'CURRENT SPEED DELAY COUNT.
        Dim MD2DELAYFLAG As Long    'FLAG INDICATING DELAY ADJUSTMENT.
        Dim MD2DELAYEACH As Long    'DELAY ADJUSTMENT EACH STEP.
        Dim MD2DELAYCHANGE As Long  'AMOUNT OF CHANGE IN DELAY.
        Dim MD2DELAYCHANGE2 As Long 'DELAYCHANGE * 2.
        Dim MD2DECEL As Long        'STEP COUNT TO BEGIN DECELERATION MODE.
        Dim MD2DELAYSLOPE As Long   'SLOPE.
        Dim MD2DELAYSLOPE2 As Long  'SLOPE * 2.
        Dim MD2MODE As Integer      'SPEED MODE. 1=DECEL,0=CONSTANT,-1=ACCEL.
        Dim MD2MINDELAY As Long     'MINIMUM SPEED DELAY COUNT.
        Dim MD2MAXDELAY As Long     'MAXIMUM SPEED DELAY COUNT.
        Dim MD2WAY As Single        'TEMP FOR VELOCITY INTEROLATION.
        Dim MD2I As Integer         'ARRAY ELEMENT COUNTER.

        'LINEAR INTERPOLATION VARIABLES.
        Dim MD2LIERROR As Long      'ERROR VALUE FOR LINEAR INTERPOLATION.
        Dim MD2MOTORL As Integer    'MOTOR # TRAVELING THE LONGEST.
        Dim MD2MOTORS As Integer    'MOTOR # TRAVELING THE SHORTEST.
        Dim MD2MOTORAL As Integer    'MOTOR # TRAVELING THE LONGEST - ADJUSTED FOR C4 CONNECTOR A OR B.
        Dim MD2MOTORAS As Integer    'MOTOR # TRAVELING THE SHORTEST - ADJUSTED FOR C4 CONNECTOR A OR B..
        Dim MD2DIRL As Integer      'LONG MOTOR DIRECTION. -1=REV,1=FWD.
        Dim MD2DIRS As Integer      'SHORT MOTOR DIRECTION.
        Dim MD2MASKL As Integer     'LONG MOTOR PATTERN MASK.
        Dim MD2MASKS As Integer     'SHORT MOTOR PATTERN MASK.
        Dim MD2STEPSL As Long       '# OF STEPS FOR LONG MOTOR.
        Dim MD2STEPSS As Long       '# OF STEPS FOR SHORT MOTOR.
        Dim MD2STEPSL2 As Long      'MD2STEPSL * 2.
        Dim MD2STEPSS2 As Long      'MD2STEPSS * 2.
        Dim MD2SWAPL As Long        'SWAP TEMPORARY VARIABLE.

        'If C4 PORT IS SET THEN DEAL WITH IT FIRST 
        'IF CALMODE, IGNORE C4 SECTION.
        If MD2CALMODE Then GoTo MD2MOVEPP

        'IF C4 PORT PARAMETERS MISSING THEN IGNORE C4 SECTION.
        If (MD2MOTOR = 1 Or MD2MOTOR = 2 Or MD2MOTOR = 12) And MD2C4PORT12 = "" Then GoTo MD2MOVEPP
        If (MD2MOTOR = 3 Or MD2MOTOR = 4 Or MD2MOTOR = 34) And MD2C4PORT34 = "" Then GoTo MD2MOVEPP
        If (MD2MOTOR = 5 Or MD2MOTOR = 6 Or MD2MOTOR = 56) And MD2C4PORT56 = "" Then GoTo MD2MOVEPP

        'C4 ----------------------------

        'CHECK FOR VALID MOTOR #.
        MD2STATUS = "B"
        If MD2MOTOR = 1 Or MD2MOTOR = 2 Or MD2MOTOR = 3 Then MD2STATUS = "O"
        If MD2MOTOR = 4 Or MD2MOTOR = 5 Or MD2MOTOR = 6 Then MD2STATUS = "O"
        If MD2MOTOR = 12 Or MD2MOTOR = 34 Or MD2MOTOR = 56 Then MD2STATUS = "O"
        If MD2STATUS <> "O" Then Exit Sub

        'CHECK FOR ENABLED MD-2.
        MD2STATUS = "E"
        If (MD2MOTOR = 1 Or MD2MOTOR = 2 Or MD2MOTOR = 12) And Not MD2ENABLED12 Then Exit Sub
        If (MD2MOTOR = 3 Or MD2MOTOR = 4 Or MD2MOTOR = 34) And Not MD2ENABLED34 Then Exit Sub
        If (MD2MOTOR = 5 Or MD2MOTOR = 6 Or MD2MOTOR = 56) And Not MD2ENABLED56 Then Exit Sub

        'CHECK FOR VALID MOVE TYPE.
        MD2MOVETYPE = UCase$(MD2MOVETYPE)
        MD2STATUS = "B"
        If MD2MOVETYPE <> "A" And MD2MOVETYPE <> "R" Then Exit Sub

        'SET MOTOR NUMBERS
        If (MD2MOTOR = 1) Then MD2MOTORL = 1 : MD2MOTORS = 0
        If (MD2MOTOR = 2) Then MD2MOTORL = 2 : MD2MOTORS = 0
        If (MD2MOTOR = 12) Then MD2MOTORL = 1 : MD2MOTORS = 2
        If (MD2MOTOR = 3) Then MD2MOTORL = 3 : MD2MOTORS = 0
        If (MD2MOTOR = 4) Then MD2MOTORL = 4 : MD2MOTORS = 0
        If (MD2MOTOR = 34) Then MD2MOTORL = 3 : MD2MOTORS = 4
        If (MD2MOTOR = 5) Then MD2MOTORL = 5 : MD2MOTORS = 0
        If (MD2MOTOR = 6) Then MD2MOTORL = 6 : MD2MOTORS = 0
        If (MD2MOTOR = 56) Then MD2MOTORL = 5 : MD2MOTORS = 6

        'FIX VARIABLES FOR 0.
        MD2TARGET(0) = 0    'MOTOR 0 IS NO MOTOR, NO STEPS, ETC.
        MD2POSITION(0) = 0
        MD2UNITS(0) = 1

        'REL MOVE - SET STEP AND DIRECTION.
        If MD2MOVETYPE = "R" Then
            'IF LIMITS EXCEEDED THEN QUIT.
            If (MD2TARGET(MD2MOTORL) + MD2POSITION(MD2MOTORL)) > MD2LIMITF(MD2MOTORL) Then MD2STATUS = "L"
            If (MD2TARGET(MD2MOTORL) + MD2POSITION(MD2MOTORL)) < MD2LIMITR(MD2MOTORL) Then MD2STATUS = "L"
            If (MD2TARGET(MD2MOTORS) + MD2POSITION(MD2MOTORS)) > MD2LIMITF(MD2MOTORS) Then MD2STATUS = "L"
            If (MD2TARGET(MD2MOTORS) + MD2POSITION(MD2MOTORS)) < MD2LIMITR(MD2MOTORS) Then MD2STATUS = "L"
            If MD2STATUS = "L" Then Exit Sub
            'SET THE # OF STEPS.
            MD2STEPSL = Int((MD2TARGET(MD2MOTORL) * MD2UNITS(MD2MOTORL)) + 0.5)
            MD2STEPSS = Int((MD2TARGET(MD2MOTORS) * MD2UNITS(MD2MOTORS)) + 0.5)
            'SET THE DIRECTION.
            If MD2STEPSL < 0 Then MD2DIRL = -1 Else MD2DIRL = 1
            If MD2STEPSS < 0 Then MD2DIRS = -1 Else MD2DIRS = 1
            'MAKE STEP COUNTS POSITIVE.
            MD2STEPSL = Abs(MD2STEPSL)
            MD2STEPSS = Abs(MD2STEPSS)
            'SET COMPLETED POSITIONS AND ROUND.
            MD2POSITION(MD2MOTORL) = MD2POSITION(MD2MOTORL) + ((MD2STEPSL * (1 / MD2UNITS(MD2MOTORL))) * MD2DIRL)
            MD2POSITION(MD2MOTORL) = Int((MD2POSITION(MD2MOTORL) * MD2UNITS(MD2MOTORL)) + 0.5)
            MD2POSITION(MD2MOTORL) = MD2POSITION(MD2MOTORL) / MD2UNITS(MD2MOTORL)
            MD2POSITION(MD2MOTORS) = MD2POSITION(MD2MOTORS) + ((MD2STEPSS * (1 / MD2UNITS(MD2MOTORS))) * MD2DIRS)
            MD2POSITION(MD2MOTORS) = Int((MD2POSITION(MD2MOTORS) * MD2UNITS(MD2MOTORS)) + 0.5)
            MD2POSITION(MD2MOTORS) = MD2POSITION(MD2MOTORS) / MD2UNITS(MD2MOTORS)

        End If

        'ABS MOVE - SET STEPS AND DIRECTION BASED CURRENT POSITION.
        If MD2MOVETYPE = "A" Then
            'IF LIMITS EXCEEDED THEN QUIT.
            If MD2TARGET(MD2MOTORL) > MD2LIMITF(MD2MOTORL) Then MD2STATUS = "L"
            If MD2TARGET(MD2MOTORL) < MD2LIMITR(MD2MOTORL) Then MD2STATUS = "L"
            If MD2TARGET(MD2MOTORS) > MD2LIMITF(MD2MOTORS) Then MD2STATUS = "L"
            If MD2TARGET(MD2MOTORS) < MD2LIMITR(MD2MOTORS) Then MD2STATUS = "L"
            If MD2STATUS = "L" Then Exit Sub
            'SET THE # OF STEPS.
            MD2STEPSL = Int(((MD2TARGET(MD2MOTORL) - MD2POSITION(MD2MOTORL)) * MD2UNITS(MD2MOTORL)) + 0.5)
            MD2STEPSS = Int(((MD2TARGET(MD2MOTORS) - MD2POSITION(MD2MOTORS)) * MD2UNITS(MD2MOTORS)) + 0.5)
            'SET THE DIRECTION.
            If MD2STEPSL < 0 Then MD2DIRL = -1 Else MD2DIRL = 1
            If MD2STEPSS < 0 Then MD2DIRS = -1 Else MD2DIRS = 1
            'MAKE STEP COUNTS POSITIVE.
            MD2STEPSL = Abs(MD2STEPSL)
            MD2STEPSS = Abs(MD2STEPSS)
            'SET COMPLETED POSITIONS AND ROUND.
            MD2POSITION(MD2MOTORL) = MD2TARGET(MD2MOTORL)
            MD2POSITION(MD2MOTORL) = Int((MD2POSITION(MD2MOTORL) * MD2UNITS(MD2MOTORL)) + 0.5)
            MD2POSITION(MD2MOTORL) = MD2POSITION(MD2MOTORL) / MD2UNITS(MD2MOTORL)
            MD2POSITION(MD2MOTORS) = MD2TARGET(MD2MOTORS)
            MD2POSITION(MD2MOTORS) = Int((MD2POSITION(MD2MOTORS) * MD2UNITS(MD2MOTORS)) + 0.5)
            MD2POSITION(MD2MOTORS) = MD2POSITION(MD2MOTORS) / MD2UNITS(MD2MOTORS)
        End If

        'SWAP DIRECTIONS BASED ON HOMEDIR PARAMETER. - C4 DOES THIS INTERNALLY.
        'If MD2HOMEDIR(MD2MOTORL) = -1 Then MD2DIRL = MD2DIRL * -1
        'If MD2HOMEDIR(MD2MOTORS) = -1 Then MD2DIRS = MD2DIRS * -1

        'BACKLASH COMPENSATION, ADJUST STEP COUNTS.
        If MD2DIRL <> MD2LASTDIR(MD2MOTORL) Then
            MD2STEPSL = MD2STEPSL + Int((MD2BACKLASH(MD2MOTORL) * MD2UNITS(MD2MOTORL)) + 0.5)
            MD2LASTDIR(MD2MOTORL) = MD2DIRL
        End If
        If MD2DIRS <> MD2LASTDIR(MD2MOTORS) Then
            MD2STEPSS = MD2STEPSS + Int((MD2BACKLASH(MD2MOTORS) * MD2UNITS(MD2MOTORS)) + 0.5)
            MD2LASTDIR(MD2MOTORS) = MD2DIRS
        End If

        'SWAP PARAMETERS DEPENDING ON LONGEST/SHORTEST STEP COUNT.
        If MD2STEPSL < MD2STEPSS Then
            MD2SWAPL = MD2STEPSL : MD2STEPSL = MD2STEPSS : MD2STEPSS = MD2SWAPL
            MD2SWAPL = MD2MOTORL : MD2MOTORL = MD2MOTORS : MD2MOTORS = MD2SWAPL
            MD2SWAPL = MD2DIRL : MD2DIRL = MD2DIRS : MD2DIRS = MD2SWAPL
        End If

        'ADJUST MOTOR # FOR CONNECTOR.
        If MD2MOTORL = 1 Then If MD2C4CONNECTOR12 = "a" Then MD2MOTORAL = 1 Else MD2MOTORAL = 3
        If MD2MOTORL = 2 Then If MD2C4CONNECTOR12 = "a" Then MD2MOTORAL = 2 Else MD2MOTORAL = 4
        If MD2MOTORS = 1 Then If MD2C4CONNECTOR12 = "a" Then MD2MOTORAS = 1 Else MD2MOTORAS = 3
        If MD2MOTORS = 2 Then If MD2C4CONNECTOR12 = "a" Then MD2MOTORAS = 2 Else MD2MOTORAS = 4

        If MD2MOTORL = 3 Then If MD2C4CONNECTOR34 = "a" Then MD2MOTORAL = 1 Else MD2MOTORAL = 3
        If MD2MOTORL = 4 Then If MD2C4CONNECTOR34 = "a" Then MD2MOTORAL = 2 Else MD2MOTORAL = 4
        If MD2MOTORS = 3 Then If MD2C4CONNECTOR34 = "a" Then MD2MOTORAS = 1 Else MD2MOTORAS = 3
        If MD2MOTORS = 4 Then If MD2C4CONNECTOR34 = "a" Then MD2MOTORAS = 2 Else MD2MOTORAS = 4

        If MD2MOTORL = 5 Then If MD2C4CONNECTOR56 = "a" Then MD2MOTORAL = 1 Else MD2MOTORAL = 3
        If MD2MOTORL = 6 Then If MD2C4CONNECTOR56 = "a" Then MD2MOTORAL = 2 Else MD2MOTORAL = 4
        If MD2MOTORS = 5 Then If MD2C4CONNECTOR56 = "a" Then MD2MOTORAS = 1 Else MD2MOTORAS = 3
        If MD2MOTORS = 6 Then If MD2C4CONNECTOR56 = "a" Then MD2MOTORAS = 2 Else MD2MOTORAS = 4

        'MOVE C4 MOTOR(S).
        Try
            'CONSTRUCT MOVE COMMAND.  !1m1f400M2R3000n
            MSG = "!"       'PREFIX.

            If MD2MOTORL = 1 Or MD2MOTORL = 2 Then MSG += MD2C4ID12 'ID.
            If MD2MOTORL = 3 Or MD2MOTORL = 4 Then MSG += MD2C4ID34 'ID.
            If MD2MOTORL = 5 Or MD2MOTORL = 6 Then MSG += MD2C4ID56 'ID.
            MSG += "m" & MD2MOTORAL     'MOVE COMMAND AND MOTOR NUMBER.
            If MD2DIRL = 1 Then MSG += "f" Else MSG += "r" 'DIRECTION.
            MSG += MD2STEPSL.ToString   'STEPS.
            'MOTOR 2?
            If MD2MOTORS > 0 Then
                MSG += "m" & MD2MOTORAS      'MOVE COMMAND AND MOTOR NUMBER.
                If MD2DIRS = 1 Then MSG += "f" Else MSG += "r" 'DIRECTION.
                MSG += MD2STEPSS.ToString   'STEPS.
            End If
            MSG += "n" & vbCr     'n=NOTIFY WHEN DONE, FINAL CR.

            'SEND MOVE COMMAND.
            If MD2MOTORL = 1 Or MD2MOTORL = 2 Then
                MD2C4COM12.Write(MSG)   'SEND MOVE.
                MD2C4COM12.ReadTo("a")  'AWAIT a.
                Do                'LOOP AWAITING MOTION STOPPED OR KEYPRESS, RETURN STATUS.
                    'STOP IF CTRL KEY PRESSED.
                    If GetAsyncKeyState(17) Then
                        MD2STATUS = "K"
                        MD2C4COM12.Write("!" & MD2C4ID12 & "a" & vbCr)    'STOP MOTOR
                        Exit Sub
                    End If

                    'CHECK MOVE STATE.
                    'MD2C4COM34.Write("!" & MD2C4ID34 & "rs" & vbCr)
                    'Do      'WAIT FOR CHARACTER
                    'Loop While MD2C4COM34.BytesToRead = 0
                    'MSG = MD2C4COM34.ReadExisting
                    'If MSG.Contains("0") Then Exit Do

                    'WAIT FOR o INDICATING DONE OR l INDICATING LIMIT SWITCH.
                    If MD2C4COM12.BytesToRead <> 0 Then
                        MSG = MD2C4COM12.ReadExisting
                        If MSG.Contains("o") Then Exit Do
                        If MSG.Contains("l") Then
                            MD2STATUS = "L"
                            Exit Sub
                        End If
                    End If

                Loop

            End If

            If MD2MOTORL = 3 Or MD2MOTORL = 4 Then
                MD2C4COM34.Write(MSG)   'SEND MOVE.
                MD2C4COM34.ReadTo("a")  'AWAIT a.
                Do                'LOOP AWAITING MOTION STOPPED OR KEYPRESS, RETURN STATUS.
                    'STOP IF CTRL KEY PRESSED.
                    If GetAsyncKeyState(17) Then
                        MD2STATUS = "K"
                        MD2C4COM34.Write("!" & MD2C4ID34 & "a" & vbCr)    'STOP MOTOR
                        Exit Sub
                    End If

                    'WAIT FOR o INDICATING DONE.
                    If MD2C4COM34.BytesToRead <> 0 Then
                        MSG = MD2C4COM34.ReadExisting
                        If MSG.Contains("o") Then Exit Do
                        If MSG.Contains("l") Then
                            MD2STATUS = "L"
                            Exit Sub
                        End If
                    End If
                Loop

            End If

            If MD2MOTORL = 5 Or MD2MOTORL = 6 Then
                MD2C4COM56.Write(MSG)   'SEND MOVE.
                MD2C4COM56.ReadTo("a")  'AWAIT a.
                Do                'LOOP AWAITING MOTION STOPPED OR KEYPRESS, RETURN STATUS.
                    'STOP IF CTRL KEY PRESSED.
                    If GetAsyncKeyState(17) Then
                        MD2STATUS = "K"
                        MD2C4COM56.Write("!" & MD2C4ID56 & "a" & vbCr)    'STOP MOTOR
                        Exit Sub
                    End If

                    'WAIT FOR o INDICATING DONE.
                    If MD2C4COM56.BytesToRead <> 0 Then
                        MSG = MD2C4COM56.ReadExisting
                        If MSG.Contains("o") Then Exit Do
                        If MSG.Contains("l") Then
                            MD2STATUS = "L"
                            Exit Sub
                        End If
                    End If
                Loop

            End If

            MD2STATUS = "O"

        Catch ex As Exception
            MD2STATUS = "P"
        End Try

        'END OF C4.
        Exit Sub


        'PARALLEL PORT ----------
MD2MOVEPP:
        'IGNORE SOME CHECKS IF IN CALIBRATION MODE.
        If Not MD2CALMODE Then

            'CHECK FOR PORT AVAILABILITY.
            MD2STATUS = "P"
            If (MD2MOTOR = 1 Or MD2MOTOR = 2 Or MD2MOTOR = 12) And MD2PORT12 = 0 Then Exit Sub
            If (MD2MOTOR = 3 Or MD2MOTOR = 4 Or MD2MOTOR = 34) And MD2PORT34 = 0 Then Exit Sub
            If (MD2MOTOR = 5 Or MD2MOTOR = 6 Or MD2MOTOR = 56) And MD2PORT56 = 0 Then Exit Sub

            'CHECK FOR CALIBRATION.
            If Not MD2CALIBRATED Then MD2STATUS = "C" : Exit Sub

            'CHECK FOR ENABLED MD-2.
            MD2STATUS = "E"
            If (MD2MOTOR = 1 Or MD2MOTOR = 2 Or MD2MOTOR = 12) And Not MD2ENABLED12 Then Exit Sub
            If (MD2MOTOR = 3 Or MD2MOTOR = 4 Or MD2MOTOR = 34) And Not MD2ENABLED34 Then Exit Sub
            If (MD2MOTOR = 5 Or MD2MOTOR = 6 Or MD2MOTOR = 56) And Not MD2ENABLED56 Then Exit Sub

        End If

        'CHECK FOR VALID MOTOR #.
        MD2STATUS = "B"
        If MD2MOTOR = 1 Or MD2MOTOR = 2 Or MD2MOTOR = 3 Then MD2STATUS = "O"
        If MD2MOTOR = 4 Or MD2MOTOR = 5 Or MD2MOTOR = 6 Then MD2STATUS = "O"
        If MD2MOTOR = 12 Or MD2MOTOR = 34 Or MD2MOTOR = 56 Then MD2STATUS = "O"
        If MD2STATUS <> "O" Then Exit Sub

        'CHECK FOR VALID STEP TYPE.
        MD2STEPTYPE = UCase$(MD2STEPTYPE)
        If MD2STEPTYPE <> "H" And MD2STEPTYPE <> "D" And MD2STEPTYPE <> "S" Then MD2STATUS = "B" : Exit Sub

        'CHECK FOR VALID MOVE TYPE.
        MD2MOVETYPE = UCase$(MD2MOVETYPE)
        If MD2MOVETYPE <> "A" And MD2MOVETYPE <> "R" Then MD2STATUS = "B" : Exit Sub

        'SET PORT ADDRESSES AND MOTOR NUMBERS.
        Select Case MD2MOTOR
            Case 1
                MD2PORT = MD2PORT12
                MD2MOTORL = 1
                MD2MOTORS = 0
            Case 2
                MD2PORT = MD2PORT12
                MD2MOTORL = 2
                MD2MOTORS = 0
            Case 3
                MD2PORT = MD2PORT34
                MD2MOTORL = 3
                MD2MOTORS = 0
            Case 4
                MD2PORT = MD2PORT34
                MD2MOTORL = 4
                MD2MOTORS = 0
            Case 5
                MD2PORT = MD2PORT56
                MD2MOTORL = 5
                MD2MOTORS = 0
            Case 6
                MD2PORT = MD2PORT56
                MD2MOTORL = 6
                MD2MOTORS = 0
            Case 12
                MD2PORT = MD2PORT12
                MD2MOTORL = 1
                MD2MOTORS = 2
            Case 34
                MD2PORT = MD2PORT34
                MD2MOTORL = 3
                MD2MOTORS = 4
            Case 56
                MD2PORT = MD2PORT56
                MD2MOTORL = 5
                MD2MOTORS = 6
        End Select

        'SET STEP PATTERNS.
        Select Case MD2STEPTYPE
            Case "H"
                MD2STPPAT(0) = &H66 : MD2STPPAT(1) = &H77 'HALF STEP MODE.
                MD2STPPAT(2) = &H33 : MD2STPPAT(3) = &HBB
                MD2STPPAT(4) = &H99 : MD2STPPAT(5) = &HDD
                MD2STPPAT(6) = &HCC : MD2STPPAT(7) = &HEE
            Case "S"
                MD2STPPAT(0) = &H77 : MD2STPPAT(1) = &HBB 'SINGLE PHASE FULL STEP MODE.
                MD2STPPAT(2) = &HDD : MD2STPPAT(3) = &HEE
                MD2STPPAT(4) = &H77 : MD2STPPAT(5) = &HBB
                MD2STPPAT(6) = &HDD : MD2STPPAT(7) = &HEE
            Case "D"
                MD2STPPAT(0) = &H66 : MD2STPPAT(1) = &H33 'DOUBLE PHASE FULL STEP MODE.
                MD2STPPAT(2) = &H99 : MD2STPPAT(3) = &HCC
                MD2STPPAT(4) = &H66 : MD2STPPAT(5) = &H33
                MD2STPPAT(6) = &H99 : MD2STPPAT(7) = &HCC
        End Select

        'FIX VARIABLES FOR 0.
        MD2TARGET(0) = 0    'MOTOR 0 IS NO MOTOR, NO STEPS, ETC.
        MD2POSITION(0) = 0
        MD2UNITS(0) = 1

        'SET STEP COUNT AND DIRECTION FOR RELATIVE MOVES.
        If MD2MOVETYPE = "R" Then   'RELATIVE MOVE?
            'IF LIMITS EXCEEDED THEN QUIT.
            If (MD2TARGET(MD2MOTORL) + MD2POSITION(MD2MOTORL)) > MD2LIMITF(MD2MOTORL) Then MD2STATUS = "L"
            If (MD2TARGET(MD2MOTORL) + MD2POSITION(MD2MOTORL)) < MD2LIMITR(MD2MOTORL) Then MD2STATUS = "L"
            If (MD2TARGET(MD2MOTORS) + MD2POSITION(MD2MOTORS)) > MD2LIMITF(MD2MOTORS) Then MD2STATUS = "L"
            If (MD2TARGET(MD2MOTORS) + MD2POSITION(MD2MOTORS)) < MD2LIMITR(MD2MOTORS) Then MD2STATUS = "L"
            If MD2STATUS = "L" Then Exit Sub
            'SET THE # OF STEPS.
            MD2STEPSL = Int((MD2TARGET(MD2MOTORL) * MD2UNITS(MD2MOTORL)) + 0.5)
            MD2STEPSS = Int((MD2TARGET(MD2MOTORS) * MD2UNITS(MD2MOTORS)) + 0.5)
            'SET THE DIRECTION.
            If MD2STEPSL < 0 Then MD2DIRL = -1 Else MD2DIRL = 1
            If MD2STEPSS < 0 Then MD2DIRS = -1 Else MD2DIRS = 1
            'MAKE STEP COUNTS POSITIVE.
            MD2STEPSL = Abs(MD2STEPSL)
            MD2STEPSS = Abs(MD2STEPSS)
            'SET COMPLETED POSITIONS AND ROUND.
            MD2POSITION(MD2MOTORL) = MD2POSITION(MD2MOTORL) + ((MD2STEPSL * (1 / MD2UNITS(MD2MOTORL))) * MD2DIRL)
            MD2POSITION(MD2MOTORL) = Int((MD2POSITION(MD2MOTORL) * MD2UNITS(MD2MOTORL)) + 0.5)
            MD2POSITION(MD2MOTORL) = MD2POSITION(MD2MOTORL) / MD2UNITS(MD2MOTORL)

            MD2POSITION(MD2MOTORS) = MD2POSITION(MD2MOTORS) + ((MD2STEPSS * (1 / MD2UNITS(MD2MOTORS))) * MD2DIRS)
            MD2POSITION(MD2MOTORS) = Int((MD2POSITION(MD2MOTORS) * MD2UNITS(MD2MOTORS)) + 0.5)
            MD2POSITION(MD2MOTORS) = MD2POSITION(MD2MOTORS) / MD2UNITS(MD2MOTORS)
        End If

        'SET STEP COUNT AND DIRECTION FOR ABSOLUTE MOVES.
        If MD2MOVETYPE = "A" Then   'ABSOLUTE MOVE?
            'IF LIMITS EXCEEDED THEN QUIT.
            If MD2TARGET(MD2MOTORL) > MD2LIMITF(MD2MOTORL) Then MD2STATUS = "L"
            If MD2TARGET(MD2MOTORL) < MD2LIMITR(MD2MOTORL) Then MD2STATUS = "L"
            If MD2TARGET(MD2MOTORS) > MD2LIMITF(MD2MOTORS) Then MD2STATUS = "L"
            If MD2TARGET(MD2MOTORS) < MD2LIMITR(MD2MOTORS) Then MD2STATUS = "L"
            If MD2STATUS = "L" Then Exit Sub
            'SET THE # OF STEPS.
            MD2STEPSL = Int(((MD2TARGET(MD2MOTORL) - MD2POSITION(MD2MOTORL)) * MD2UNITS(MD2MOTORL)) + 0.5)
            MD2STEPSS = Int(((MD2TARGET(MD2MOTORS) - MD2POSITION(MD2MOTORS)) * MD2UNITS(MD2MOTORS)) + 0.5)
            'SET THE DIRECTION.
            If MD2STEPSL < 0 Then MD2DIRL = -1 Else MD2DIRL = 1
            If MD2STEPSS < 0 Then MD2DIRS = -1 Else MD2DIRS = 1
            'MAKE STEP COUNTS POSITIVE.
            MD2STEPSL = Abs(MD2STEPSL)
            MD2STEPSS = Abs(MD2STEPSS)
            'SET COMPLETED POSITIONS AND ROUND.
            MD2POSITION(MD2MOTORL) = MD2TARGET(MD2MOTORL)
            MD2POSITION(MD2MOTORL) = Int((MD2POSITION(MD2MOTORL) * MD2UNITS(MD2MOTORL)) + 0.5)
            MD2POSITION(MD2MOTORL) = MD2POSITION(MD2MOTORL) / MD2UNITS(MD2MOTORL)
            MD2POSITION(MD2MOTORS) = MD2TARGET(MD2MOTORS)
            MD2POSITION(MD2MOTORS) = Int((MD2POSITION(MD2MOTORS) * MD2UNITS(MD2MOTORS)) + 0.5)
            MD2POSITION(MD2MOTORS) = MD2POSITION(MD2MOTORS) / MD2UNITS(MD2MOTORS)
        End If

        'SWAP DIRECTIONS BASED ON HOMEDIR PARAMETER.
        If MD2HOMEDIR(MD2MOTORL) = -1 Then MD2DIRL = MD2DIRL * -1
        If MD2HOMEDIR(MD2MOTORS) = -1 Then MD2DIRS = MD2DIRS * -1

        'BACKLASH COMPENSATION, ADJUST STEP COUNTS.
        If MD2DIRL <> MD2LASTDIR(MD2MOTORL) Then
            MD2STEPSL = MD2STEPSL + Int((MD2BACKLASH(MD2MOTORL) * MD2UNITS(MD2MOTORL)) + 0.5)
            MD2LASTDIR(MD2MOTORL) = MD2DIRL
        End If
        If MD2DIRS <> MD2LASTDIR(MD2MOTORS) Then
            MD2STEPSS = MD2STEPSS + Int((MD2BACKLASH(MD2MOTORS) * MD2UNITS(MD2MOTORS)) + 0.5)
            MD2LASTDIR(MD2MOTORS) = MD2DIRS
        End If

        'SWAP PARAMETERS DEPENDING ON LONGEST/SHORTEST STEP COUNT.
        If MD2STEPSL < MD2STEPSS Then
            MD2SWAPL = MD2STEPSL : MD2STEPSL = MD2STEPSS : MD2STEPSS = MD2SWAPL
            MD2SWAPL = MD2MOTORL : MD2MOTORL = MD2MOTORS : MD2MOTORS = MD2SWAPL
            MD2SWAPL = MD2DIRL : MD2DIRL = MD2DIRS : MD2DIRS = MD2SWAPL
        End If

        'INITIALIZE ERROR ACCUMULATOR AND PRECALCULATE VARS FOR INTERPOLATION.
        MD2STEPSL2 = MD2STEPSL + MD2STEPSL
        MD2STEPSS2 = MD2STEPSS + MD2STEPSS
        MD2LIERROR = MD2STEPSS2 - MD2STEPSL

        'SET UP PATTERN MASKS.
        If MD2MOTORL = 1 Or MD2MOTORL = 3 Or MD2MOTORL = 5 Then
            MD2MASKL = &HF
            MD2MASKS = &HF0
        Else
            MD2MASKL = &HF0
            MD2MASKS = &HF
        End If

        'SETUP RAMPING----------------.

        'IF IN CALIBRATION MODE SET RAMPING TO MAXSPEED OTHERWISE
        'SET RAMPING PARAMETERS NORMALLY.
        If MD2CALMODE Then
            MD2MODE = 0     'CONSTANT SPEED.
            MD2DECEL = 0    'NEVER BEGIN DECELERATION.
            MD2DELAYCUR = MD2MAXSPEED(MD2MOTORL)
        Else
            'NORMAL RAMPING.
            'FIND MINDELAY AND MAXDELAY BY SEARCHING VELOCITY ARRAY AND
            'INTERPOLATING BETWEEN ELEMENTS.
            'SETUP DELAY COUNT ADJUSTMENTS TO LINEARIZE RAMP WHILE STEPPING.

            'CONVERT MINSPEED VELOCITY TO DELAY COUNTS.
            For MD2I = 0 To 62     'SEARCH FOR CORRECT ARRAY ELEMENTS.
                If (MD2MINSPEED(MD2MOTORL) * MD2UNITS(MD2MOTORL)) >= MD2VELOCITY(MD2I) Then Exit For
            Next MD2I
            'INTERPOLATE BETWEEN ELEMENTS.
            MD2WAY = ((MD2MINSPEED(MD2MOTORL) * MD2UNITS(MD2MOTORL)) - MD2VELOCITY(MD2I - 1)) / (MD2VELOCITY(MD2I) - MD2VELOCITY(MD2I - 1))
            MD2MINDELAY = Int((((MD2DELAY(MD2I) - MD2DELAY(MD2I - 1)) * MD2WAY) + MD2DELAY(MD2I - 1)) + 0.5)

            'CONVERT MAXSPEED VELOCITY TO DELAY COUNTS.
            For MD2I = 0 To 62     'SEARCH FOR CORRECT ARRAY ELEMENTS.
                If (MD2MAXSPEED(MD2MOTORL) * MD2UNITS(MD2MOTORL)) >= MD2VELOCITY(MD2I) Then Exit For
            Next MD2I
            'INTERPOLATE BETWEEN ELEMENTS.
            MD2WAY = ((MD2MAXSPEED(MD2MOTORL) * MD2UNITS(MD2MOTORL)) - MD2VELOCITY(MD2I - 1)) / (MD2VELOCITY(MD2I) - MD2VELOCITY(MD2I - 1))
            MD2MAXDELAY = Int((((MD2DELAY(MD2I) - MD2DELAY(MD2I - 1)) * MD2WAY) + MD2DELAY(MD2I - 1)) + 0.5)

            'SET UP RAMPING PARAMETERS.
            If (MD2SLOPE(MD2MOTORL) <= 0) Or (MD2MINDELAY <= MD2MAXDELAY) Then

                'CONSTANT SPEED MODE----------------.

                'CONSTANT SPEED MODE.
                MD2MODE = 2

                'CURRENT SPEED.
                MD2DELAYCUR = MD2MAXDELAY
            Else
                'RAMPING MOVE-----------------.

                'ACCELERATION MODE.
                MD2MODE = -1

                'CURRENT STARTING SPEED.
                MD2DELAYCUR = MD2MINDELAY

                'SET STEP COUNT TO BEGIN DECELERATION.
                If MD2STEPSL < ((MD2SLOPE(MD2MOTORL) * MD2UNITS(MD2MOTORL)) * 2) Then
                    'MOVE TOO SHORT TO REACH MAX SPEED.
                    MD2DECEL = Int((MD2STEPSL / 2) + 0.5)
                Else
                    'MOVE LONG ENOUGH TO REACH MAX SPEED.
                    MD2DECEL = Int(MD2SLOPE(MD2MOTORL) * MD2UNITS(MD2MOTORL))
                End If

                'SET SLOPES.
                MD2DELAYSLOPE = Int(MD2SLOPE(MD2MOTORL) * MD2UNITS(MD2MOTORL))
                MD2DELAYSLOPE2 = MD2DELAYSLOPE + MD2DELAYSLOPE

                'SET AMOUNT OF CHANGE IN DELAY COUNT.
                MD2DELAYCHANGE = MD2MINDELAY - MD2MAXDELAY

                'DIFFERENT CALCULATIONS FOR SLOPE <=1 AND >1.
                If MD2DELAYCHANGE > MD2DELAYSLOPE Then
                    'SLOPE > 1.
                    'SET DELAY ADJUSTMENT THAT OCCURS EVERY STEP.
                    MD2DELAYEACH = Int(MD2DELAYCHANGE / MD2DELAYSLOPE)
                    'RESET DELAYCHANGE ACCORDING TO PREVIOUS CALC.
                    MD2DELAYCHANGE = MD2DELAYCHANGE - (MD2DELAYSLOPE * MD2DELAYEACH)
                Else
                    'SLOPE <= 1.
                    'DON'T ADJUST EVERY STEP.
                    MD2DELAYEACH = 0
                End If

                'PRECALCULATE THIS.
                MD2DELAYCHANGE2 = MD2DELAYCHANGE + MD2DELAYCHANGE

                'PRESET ADJUSTMENT FLAG.
                MD2DELAYFLAG = MD2DELAYCHANGE2 - MD2DELAYSLOPE
            End If
        End If

        'CLEAR OUT KEY BUFFER.
        If GetAsyncKeyState(17) Then
        End If

        'INITIALIZE STATUS.
        MD2STATUS = "O"

        'MOVE LOOP.
        Do Until MD2STEPSL = 0

            'STOP IF CTRL KEY PRESSED.
            If GetAsyncKeyState(17) Then
                MD2STATUS = "K"
                Exit Do
            End If

            'MOVE LONG MOTOR.

            'POINT TO THE NEXT STEP PATTERN.
            MD2PATPTR(MD2MOTORL) = (MD2PATPTR(MD2MOTORL) + MD2DIRL) And &H7

            'GET STEP PATTERN AND MASK OFF UNNEEDED BITS.
            MD2PATS = MD2STPPAT(MD2PATPTR(MD2MOTORL)) And MD2MASKL

            'MOVE SHORT MOTOR IF NEEDED.
            If MD2LIERROR >= 0 Then

                'POINT TO THE NEXT STEP PATTERN.
                MD2PATPTR(MD2MOTORS) = (MD2PATPTR(MD2MOTORS) + MD2DIRS) And &H7

                'OR IN SHORT MOTOR PATTERN.
                MD2PATS = MD2PATS Or (MD2STPPAT(MD2PATPTR(MD2MOTORS)) And MD2MASKS)

                'UPDATE ERROR FOR LINEAR INTERPOLATION.
                MD2LIERROR = MD2LIERROR - MD2STEPSL2
            Else
                'DON'T MOVE SHORT.
                MD2PATS = MD2PATS Or (Inp(MD2PORT) And MD2MASKS)
            End If

            'UPDATE ERROR FOR LINEAR INTERPOLATION.
            MD2LIERROR = MD2LIERROR + MD2STEPSS2

            'OUTPUT THE STEP PATTERN TO MOVE THE MOTOR.
            Out(MD2PORT, MD2PATS)

            'DELAY BETWEEN STEPS.
            For MD2DELAYTMP = 1 To MD2DELAYCUR : Next MD2DELAYTMP

            'DECREMENT STEP COUNT.
            MD2STEPSL = MD2STEPSL - 1

            'CALCULATE NEW SPEED.

            If MD2MODE = 1 Then   'DECELERATION.
                'BEGIN CONSTANT IF REACHED MIN SPEED.
                If MD2DELAYCUR >= MD2MINDELAY Then MD2MODE = 2

                'DECREASE CURRENT SPEED.
                MD2DELAYCUR = MD2DELAYCUR + MD2DELAYEACH
                If MD2DELAYFLAG >= 0 Then
                    MD2DELAYCUR = MD2DELAYCUR + 1
                    MD2DELAYFLAG = MD2DELAYFLAG - MD2DELAYSLOPE2
                End If
                MD2DELAYFLAG = MD2DELAYFLAG + MD2DELAYCHANGE2
            End If

            If MD2MODE = 0 Then   'CONSTANT THEN DECELERATION.
                'BEGIN DECELERATION BASED ON STEPS REMAINING.
                If MD2STEPSL <= MD2DECEL Then MD2MODE = 1
            End If

            If MD2MODE = -1 Then  'ACCELERATION.
                'INCREASE CURRENT SPEED.
                MD2DELAYCUR = MD2DELAYCUR - MD2DELAYEACH
                If MD2DELAYFLAG >= 0 Then
                    MD2DELAYCUR = MD2DELAYCUR - 1
                    MD2DELAYFLAG = MD2DELAYFLAG - MD2DELAYSLOPE2
                End If
                MD2DELAYFLAG = MD2DELAYFLAG + MD2DELAYCHANGE2

                'BEGIN DECELERATION BASED ON STEPS REMAINING.
                If MD2STEPSL <= MD2DECEL Then MD2MODE = 1

                'BEGIN CONSTANT SPEED IF REACHED MAX SPEED.
                If MD2DELAYCUR <= MD2MAXDELAY Then MD2MODE = 0
            End If
        Loop

        'POWER OFF MOTOR IF DESIRED.
        If Not MD2HOLD Then
            Out(MD2PORT, &HFF)
            'DELAY TO ALLOW STEP TO TAKE.
            For MD2DELAYTMP = 1 To MD2MINDELAY : Next MD2DELAYTMP
        End If

    End Sub

    Public Sub MD2OFF()

        '---------------------------------------------------------------------
        'NAME:      MD2OFF
        'DESC:      THE MD2OFF PROCEDURE RETURNS A PARALLEL PRINTER PORT
        '           REFERENCED BY THE MOTOR # TO ITS PREVIOUS STATE READY
        '           FOR USE WITH A PRINTER AND DISABLES THE MD-2.
        '           FOR C4, CLOSES SERIAL PORT(S) IF OPEN.
        'USAGE:     USE AT THE END OF A MOTION CONTROL PROGRAM.
        'INPUTS:    MOTOR # DETERMINES PORT.
        'OUTPUTS:   NONE.
        '---------------------------------------------------------------------

        'LOCAL VARIABLES.
        Dim MD2TIMER As Single

        'ACT BASED ON SELECTED MOTOR AND PORT DATA

        'MD2 FOR MOTORS 1 & 2.
        If MD2MOTOR = 1 Or MD2MOTOR = 2 Or MD2MOTOR = 12 Then

            'NO PORT PARAMETERS?
            If MD2PORT12 = 0 And MD2C4PORT12 = "" Then
                MD2STATUS = "B"
                Exit Sub
            End If

            'PARALLEL PORT?
            If MD2PORT12 <> 0 Then
                '-STROBE PIN HIGH, -ALF PIN HIGH, -INIT PIN LOW, -SELIN PIN LOW, IRQ OFF.
                Out(MD2PORT12 + 2, &H4)
                'DELAY FOR .2 SECONDS.
                MD2TIMER = Microsoft.VisualBasic.DateAndTime.Timer + 0.2
                Do
                Loop Until (Microsoft.VisualBasic.DateAndTime.Timer > MD2TIMER)
                'TURN -INIT PIN HIGH.
                Out(MD2PORT12 + 2, &HC)
                MD2STATUS = "O"
            End If

            'SERIAL PORT FOR C4.
            'IF ANOTHER MD2 SHARING PORT AND IT'S ENABLED THEN DON'T CLOSE.
            If MD2C4PORT12 <> "" Then

                'De-energize motors
                Try
                    If MD2C4CONNECTOR12 = "a" Then
                        MD2C4COM12.Write("!1we10" & vbCr)
                        MD2C4COM12.ReadTo("a")      'GET RETURNED 'a'.
                        MD2C4COM12.Write("!1we20" & vbCr)
                        MD2C4COM12.ReadTo("a")      'GET RETURNED 'a'.
                    End If
                    If MD2C4CONNECTOR12 = "b" Then
                        MD2C4COM12.Write("!1we30" & vbCr)
                        MD2C4COM12.ReadTo("a")      'GET RETURNED 'a'.
                        MD2C4COM12.Write("!1we40" & vbCr)
                        MD2C4COM12.ReadTo("a")      'GET RETURNED 'a'.
                    End If
                Catch ex As Exception
                    'IGNORE ERROR.
                End Try

                MD2ENABLED12 = False            'ENABLED FLAG.
                MD2STATUS = "O"                 'RETURN STATUS DEFAULT.

                'SHARING WITH 34.
                If MD2C4PORT12 = MD2C4PORT34 Then
                    If Not MD2ENABLED34 Then
                        Try
                            MD2C4COM12.Close()
                        Catch ex As Exception
                            'IGNORE ERROR.
                        End Try
                        MD2C4COM34 = Nothing
                        MD2C4COM34 = New IO.Ports.SerialPort     'CLEARS SHARING OF PORT OBJECT.
                    End If
                    MD2C4COM12 = Nothing
                    MD2C4COM12 = New IO.Ports.SerialPort
                    Exit Sub
                End If

                'SHARING WITH 56.
                If MD2C4PORT12 = MD2C4PORT56 Then
                    If Not MD2ENABLED56 Then
                        Try
                            MD2C4COM12.Close()
                        Catch ex As Exception
                            'IGNORE ERROR.
                        End Try
                        MD2C4COM56 = Nothing
                        MD2C4COM56 = New IO.Ports.SerialPort    'CLEARS SHARING OF PORT OBJECT.
                    End If
                    MD2C4COM56 = Nothing
                    MD2C4COM56 = New IO.Ports.SerialPort
                    Exit Sub
                End If

                'NOT SHARING.
                Try
                    MD2C4COM12.Close()
                Catch ex As Exception
                    'IGNORE ERROR.
                End Try
                MD2C4COM12 = Nothing
                MD2C4COM12 = New IO.Ports.SerialPort
                Exit Sub

            End If

        End If

        'MD2 FOR MOTORS 3 & 4.
        If MD2MOTOR = 3 Or MD2MOTOR = 4 Or MD2MOTOR = 34 Then

            'NO PORT PARAMETERS?
            If MD2PORT34 = 0 And MD2C4PORT34 = "" Then
                MD2STATUS = "B"
                Exit Sub
            End If

            'PARALLEL PORT?
            If MD2PORT34 <> 0 Then
                '-STROBE PIN HIGH, -ALF PIN HIGH, -INIT PIN LOW, -SELIN PIN LOW, IRQ OFF.
                Out(MD2PORT34 + 2, &H4)
                'DELAY FOR .2 SECONDS.
                MD2TIMER = Microsoft.VisualBasic.DateAndTime.Timer + 0.2
                Do
                Loop Until (Microsoft.VisualBasic.DateAndTime.Timer > MD2TIMER)
                'TURN -INIT PIN HIGH.
                Out(MD2PORT34 + 2, &HC)
                MD2STATUS = "O"
            End If

            'SERIAL PORT FOR C4.
            'IF ANOTHER MD2 SHARING PORT AND IT'S ENABLED THEN DON'T CLOSE.
            If MD2C4PORT34 <> "" Then

                'De-energize motors
                Try
                    If MD2C4CONNECTOR34 = "a" Then
                        MD2C4COM34.Write("!1we10" & vbCr)
                        MD2C4COM34.ReadTo("a")      'GET RETURNED 'a'.
                        MD2C4COM34.Write("!1we20" & vbCr)
                        MD2C4COM34.ReadTo("a")      'GET RETURNED 'a'.
                    End If
                    If MD2C4CONNECTOR34 = "b" Then
                        MD2C4COM34.Write("!1we30" & vbCr)
                        MD2C4COM34.ReadTo("a")      'GET RETURNED 'a'.
                        MD2C4COM34.Write("!1we40" & vbCr)
                        MD2C4COM34.ReadTo("a")      'GET RETURNED 'a'.
                    End If
                Catch ex As Exception
                    'IGNORE ERROR.
                End Try

                MD2ENABLED34 = False            'ENABLED FLAG.
                MD2STATUS = "O"                 'RETURN STATUS DEFAULT.

                'SHARING WITH 12.
                If MD2C4PORT34 = MD2C4PORT12 Then
                    If Not MD2ENABLED12 Then
                        Try
                            MD2C4COM34.Close()
                        Catch ex As Exception
                            'IGNORE ERROR.
                        End Try
                        MD2C4COM12 = Nothing
                        MD2C4COM12 = New IO.Ports.SerialPort    'CLEARS SHARING OF PORT OBJECT.
                    End If
                    MD2C4COM34 = Nothing
                    MD2C4COM34 = New IO.Ports.SerialPort
                    Exit Sub
                End If

                'SHARING WITH 56.
                If MD2C4PORT34 = MD2C4PORT56 Then
                    If Not MD2ENABLED56 Then
                        Try
                            MD2C4COM34.Close()
                        Catch ex As Exception
                            'IGNORE ERROR.
                        End Try
                        MD2C4COM56 = Nothing
                        MD2C4COM56 = New IO.Ports.SerialPort    'CLEARS SHARING OF PORT OBJECT.
                    End If
                    MD2C4COM34 = Nothing
                    MD2C4COM34 = New IO.Ports.SerialPort
                    Exit Sub
                End If

                'NOT SHARING.
                Try
                    MD2C4COM34.Close()
                Catch ex As Exception
                    'IGNORE ERROR.
                End Try
                MD2C4COM34 = Nothing
                MD2C4COM34 = New IO.Ports.SerialPort
                Exit Sub

            End If

        End If

        'MD2 FOR MOTORS 5 & 6.
        If MD2MOTOR = 5 Or MD2MOTOR = 6 Or MD2MOTOR = 56 Then

            'NO PORT PARAMETERS?
            If MD2PORT56 = 0 And MD2C4PORT56 = "" Then
                MD2STATUS = "B"
                Exit Sub
            End If

            'PARALLEL PORT?
            If MD2PORT56 <> 0 Then
                '-STROBE PIN HIGH, -ALF PIN HIGH, -INIT PIN LOW, -SELIN PIN LOW, IRQ OFF.
                Out(MD2PORT56 + 2, &H4)
                'DELAY FOR .2 SECONDS.
                MD2TIMER = Microsoft.VisualBasic.DateAndTime.Timer + 0.2
                Do
                Loop Until (Microsoft.VisualBasic.DateAndTime.Timer > MD2TIMER)
                'TURN -INIT PIN HIGH.
                Out(MD2PORT56 + 2, &HC)
                MD2STATUS = "O"
            End If

            'SERIAL PORT FOR C4.
            'IF ANOTHER MD2 SHARING PORT AND IT'S ENABLED THEN DON'T CLOSE.
            If MD2C4PORT56 <> "" Then

                'De-energize motors
                Try
                    If MD2C4CONNECTOR56 = "a" Then
                        MD2C4COM56.Write("!1we10" & vbCr)
                        MD2C4COM56.ReadTo("a")      'GET RETURNED 'a'.
                        MD2C4COM56.Write("!1we20" & vbCr)
                        MD2C4COM56.ReadTo("a")      'GET RETURNED 'a'.
                    End If
                    If MD2C4CONNECTOR56 = "b" Then
                        MD2C4COM56.Write("!1we30" & vbCr)
                        MD2C4COM56.ReadTo("a")      'GET RETURNED 'a'.
                        MD2C4COM56.Write("!1we40" & vbCr)
                        MD2C4COM56.ReadTo("a")      'GET RETURNED 'a'.
                    End If
                Catch ex As Exception
                    'IGNORE ERROR.
                End Try

                MD2ENABLED56 = False            'ENABLED FLAG.
                MD2STATUS = "O"                 'RETURN STATUS DEFAULT.

                'SHARING WITH 12.
                If MD2C4PORT56 = MD2C4PORT12 Then
                    If Not MD2ENABLED12 Then
                        Try
                            MD2C4COM56.Close()
                        Catch ex As Exception
                            'IGNORE ERROR.
                        End Try
                        MD2C4COM12 = Nothing
                        MD2C4COM12 = New IO.Ports.SerialPort    'CLEARS SHARING OF PORT OBJECT.
                    End If
                    MD2C4COM56 = Nothing
                    MD2C4COM56 = New IO.Ports.SerialPort
                    Exit Sub
                End If

                'SHARING WITH 34.
                If MD2C4PORT56 = MD2C4PORT34 Then
                    If Not MD2ENABLED34 Then
                        Try
                            MD2C4COM56.Close()
                        Catch ex As Exception
                            'IGNORE ERROR.
                        End Try
                        MD2C4COM34 = Nothing
                        MD2C4COM34 = New IO.Ports.SerialPort    'CLEARS SHARING OF PORT OBJECT.
                    End If
                    MD2C4COM56 = Nothing
                    MD2C4COM56 = New IO.Ports.SerialPort
                    Exit Sub
                End If

                'NOT SHARING.
                Try
                    MD2C4COM56.Close()
                Catch ex As Exception
                    'IGNORE ERROR.
                End Try
                MD2C4COM56 = Nothing
                MD2C4COM56 = New IO.Ports.SerialPort
                Exit Sub

            End If

        End If

        'BAD MOTOR #
        MD2STATUS = "B"

    End Sub

    Public Sub MD2ON()

        '---------------------------------------------------------------------
        'NAME:      MD2ON
        'DESC:      THE MD2ON PROCEDURE INITIALIZES A PARALLEL PRINTER PORT
        '           AND TURNS ON AN MD-2.
        '           ALSO OPENS COM PORT(S) FOR C4.
        'USAGE:     USE AT THE BEGINNING OF A MOTION CONTROL PROGRAM BUT
        '           AFTER THE MD2SETUP SUBROUTINE.
        'INPUTS:    MOTOR # DETERMINES PORT.
        'OUTPUTS:   NONE.
        '---------------------------------------------------------------------

        Dim I As Integer
        Dim MSG As String

        'ACT BASED ON SELECTED MOTOR AND PORT DATA

        'MD2 FOR MOTORS 1 & 2.
        If MD2MOTOR = 1 Or MD2MOTOR = 2 Or MD2MOTOR = 12 Then

            'NO PORT PARAMETERS?
            If MD2PORT12 = 0 And MD2C4PORT12 = "" Then
                MD2STATUS = "B"
                Exit Sub
            End If

            MD2STATUS = "P"     'DEFAULT RETURN STATUS PORT NOT AVAILABLE.

            'PARALLEL PORT?
            If MD2PORT12 <> 0 Then
                Out(MD2PORT12, &HFF)
                Out(MD2PORT12 + 2, &H5)
                MD2ENABLED12 = True
                MD2STATUS = "O"
            End If

            'If C4 PORT IS SET THEN DEAL WITH IT.
            If MD2C4PORT12 <> "" Then

                'IF PORT IS SAME AS ANOTHER THAT IS ALREADY OPEN THEN...
                If MD2C4PORT12 = MD2C4PORT34 And MD2C4COM34.IsOpen Then
                    MD2C4COM12 = MD2C4COM34     'SET IT TO THE SAME OBJECT.
                    MD2ENABLED12 = True         'ENABLED FLAG.
                    MD2STATUS = "O"             'GOOD RETURN STATUS.
                    Exit Sub
                End If

                'IF PORT IS SAME AS ANOTHER THAT IS ALREADY OPEN THEN...
                If MD2C4PORT12 = MD2C4PORT56 And MD2C4COM56.IsOpen Then
                    MD2C4COM12 = MD2C4COM56     'SET IT TO THE SAME OBJECT.
                    MD2ENABLED12 = True         'ENABLED FLAG.
                    MD2STATUS = "0"             'GOOD RETURN STATUS.
                    Exit Sub
                End If

                'SO, PORT IS NOT THE SAME AS ANOTHER THAT'S OPENED, SO OPEN IT.
                Try
                    If Not MD2C4COM12.IsOpen Then
                        MD2C4COM12.PortName = MD2C4PORT12
                        MD2C4COM12.BaudRate = Val(MD2C4BAUD12)
                        MD2C4COM12.Parity = Ports.Parity.None
                        MD2C4COM12.DataBits = 8
                        MD2C4COM12.StopBits = 1
                        MD2C4COM12.Open()
                        MD2C4COM12.ReadTimeout = 300
                        MD2C4COM12.WriteTimeout = 300
                        'Don't know if in bootloader during C4 power, or in app code.
                        'If in bootloader, ESC will activate bootloader.
                        'If in app code, ESC just clears command buffer.
                        'If in bootloader, E will exit to app code.
                        'If in app code, E by itself does nothing.
                        'So, sending ESC E ESC finishes out in app code either way
                        'MD2C4COM12.Write(Chr(&H1B) & "E" & Chr(&H1B))
                        'Instead, just send a bunch of backspaces to clear command buffer.
                        For I = 1 To 20
                            MD2C4COM12.Write(Chr(&H8))
                        Next I
                        MD2C4COM12.ReadExisting()       'Clear input buffer.
                    End If
                Catch ex As Exception
                    MD2STATUS = "P"
                    Exit Sub
                End Try
                MD2ENABLED12 = True             'ENABLED FLAG.
                MD2STATUS = "O"                 'GOOD RETURN STATUS.

            End If    'C4 PORT PROVIDED.
            Exit Sub
        End If        'MOTOR 1,2,12


        'MD2 FOR MOTORS 3 & 4.
        If MD2MOTOR = 3 Or MD2MOTOR = 4 Or MD2MOTOR = 34 Then

            'NO PORT PARAMETERS?
            If MD2PORT34 = 0 And MD2C4PORT34 = "" Then
                MD2STATUS = "B"
                Exit Sub
            End If

            MD2STATUS = "P"     'DEFAULT RETURN STATUS PORT NOT AVAILABLE.

            'PARALLEL PORT?
            If MD2PORT34 <> 0 Then
                Out(MD2PORT34, &HFF)
                Out(MD2PORT34 + 2, &H5)
                MD2ENABLED34 = True
                MD2STATUS = "O"
            End If

            'If C4 PORT IS SET THEN DEAL WITH IT.
            If MD2C4PORT34 <> "" Then

                'IF PORT IS SAME AS ANOTHER THAT IS ALREADY OPEN THEN...
                If MD2C4PORT34 = MD2C4PORT12 And MD2C4COM12.IsOpen Then
                    MD2C4COM34 = MD2C4COM12     'SET IT TO THE SAME OBJECT.
                    MD2ENABLED34 = True         'ENABLED FLAG.
                    MD2STATUS = "O"             'GOOD RETURN STATUS.
                    Exit Sub
                End If

                'IF PORT IS SAME AS ANOTHER THAT IS ALREADY OPEN THEN...
                If MD2C4PORT34 = MD2C4PORT56 And MD2C4COM56.IsOpen Then
                    MD2C4COM34 = MD2C4COM56     'SET IT TO THE SAME OBJECT.
                    MD2ENABLED34 = True         'ENABLED FLAG.
                    MD2STATUS = "O"             'GOOD RETURN STATUS.
                    Exit Sub
                End If

                'SO, PORT IS NOT THE SAME AS ANOTHER THAT'S OPENED, SO OPEN IT.
                Try
                    If Not MD2C4COM34.IsOpen Then
                        MD2C4COM34.PortName = MD2C4PORT34
                        MD2C4COM34.BaudRate = Val(MD2C4BAUD34)
                        MD2C4COM34.Parity = Ports.Parity.None
                        MD2C4COM34.DataBits = 8
                        MD2C4COM34.StopBits = 1
                        MD2C4COM34.Open()
                        MD2C4COM34.ReadTimeout = 300
                        MD2C4COM34.WriteTimeout = 300
                        'Don't know if in bootloader during C4 power, or in app code.
                        'If in bootloader, ESC will activate bootloader.
                        'If in app code, ESC just clears command buffer.
                        'If in bootloader, E will exit to app code.
                        'If in app code, E by itself does nothing.
                        'So, sending ESC E ESC finishes out in app code either way
                        'MD2C4COM34.Write(Chr(&H1B) & "E" & Chr(&H1B))            'Send Escape.
                        'Instead, just send a bunch of backspaces to clear command buffer.
                        For I = 1 To 20
                            MD2C4COM34.Write(Chr(&H8))
                        Next I
                        MD2C4COM34.ReadExisting()       'Clear input buffer.
                    End If
                Catch ex As Exception
                    MD2STATUS = "P"
                    Exit Sub
                End Try
                MD2ENABLED34 = True             'ENABLED FLAG.
                MD2STATUS = "O"                 'GOOD RETURN STATUS.

            End If    'C4 PORT PROVIDED.
            Exit Sub
        End If        'MOTOR 3,4,34

        'MD2 FOR MOTORS 5 & 6.
        If MD2MOTOR = 5 Or MD2MOTOR = 6 Or MD2MOTOR = 56 Then

            'NO PORT PARAMETERS?
            If MD2PORT56 = 0 And MD2C4PORT56 = "" Then
                MD2STATUS = "B"
                Exit Sub
            End If

            MD2STATUS = "P"     'DEFAULT RETURN STATUS PORT NOT AVAILABLE.

            'PARALLEL PORT?
            If MD2PORT56 <> 0 Then
                Out(MD2PORT56, &HFF)
                Out(MD2PORT56 + 2, &H5)
                MD2ENABLED56 = True
                MD2STATUS = "O"
            End If

            'If C4 PORT IS SET THEN DEAL WITH IT.
            If MD2C4PORT56 <> "" Then

                'IF PORT IS SAME AS ANOTHER THAT IS ALREADY OPEN THEN...
                If MD2C4PORT56 = MD2C4PORT12 And MD2C4COM12.IsOpen Then
                    MD2C4COM56 = MD2C4COM12     'SET IT TO THE SAME OBJECT.
                    MD2ENABLED56 = True         'ENABLED FLAG.
                    MD2STATUS = "O"             'GOOD RETURN STATUS.
                    Exit Sub
                End If

                'IF PORT IS SAME AS ANOTHER THAT IS ALREADY OPEN THEN...
                If MD2C4PORT56 = MD2C4PORT34 And MD2C4COM34.IsOpen Then
                    MD2C4COM56 = MD2C4COM34     'SET IT TO THE SAME OBJECT.
                    MD2ENABLED56 = True         'ENABLED FLAG.
                    MD2STATUS = "O"             'GOOD RETURN STATUS.
                    Exit Sub
                End If

                'SO, PORT IS NOT THE SAME AS ANOTHER THAT'S OPENED, SO OPEN IT.
                Try
                    If Not MD2C4COM56.IsOpen Then
                        MD2C4COM56.PortName = MD2C4PORT56
                        MD2C4COM56.BaudRate = Val(MD2C4BAUD56)
                        MD2C4COM56.Parity = Ports.Parity.None
                        MD2C4COM56.DataBits = 8
                        MD2C4COM56.StopBits = 1
                        MD2C4COM56.Open()
                        MD2C4COM56.ReadTimeout = 300
                        MD2C4COM56.WriteTimeout = 300
                        'Don't know if in bootloader during C4 power, or in app code.
                        'If in bootloader, ESC will activate bootloader.
                        'If in app code, ESC just clears command buffer.
                        'If in bootloader, E will exit to app code.
                        'If in app code, E by itself does nothing.
                        'So, sending ESC E ESC finishes out in app code either way.
                        'This will backfire if final ESC is caught only by powering up C4.
                        'MD2C4COM56.Write(Chr(&H1B) & "E" & Chr(&H1B))            'Send Escape.
                        'Instead, just send a bunch of backspaces to clear command buffer.
                        For I = 1 To 20
                            MD2C4COM56.Write(Chr(&H8))
                        Next I
                        MD2C4COM56.ReadExisting()       'Clear input buffer.
                    End If
                Catch ex As Exception
                    MD2STATUS = "P"
                    Exit Sub
                End Try
                MD2ENABLED56 = True             'ENABLED FLAG.
                MD2STATUS = "O"                 'GOOD RETURN STATUS.

            End If    'C4 PORT PROVIDED.
            Exit Sub
        End If        'MOTOR 5,6,56

        'Bad
        MD2STATUS = "B"

    End Sub

    Public Sub MD2OUTPUTS()

        '---------------------------------------------------------------------
        'NAME:      MD2OUTPUTS
        'DESC:      THE MD2OUTPUTS PROCEDURE TURNS OUTPUT PINS ON AND OFF.
        '           THE INPUT/OUTPUT PORT ON THE BACK OF THE MD-2 SYSTEM
        '           HAS 2 OUTPUTS AND 3 INPUTS.  SOME MD-2 SYSTEMS DO NOT
        '           HAVE THIS I/O PORT.  CHECK YOUR MANUAL FOR MORE INFORMATION.
        '           WHEN TURNED ON, THE OUTPUT PIN WILL BE DRIVEN TO GROUND
        '           TO TURN ON SINKING LOADS SUCH AS RELAYS WHICH CAN CONTROL
        '           LARGER LOADS.  WHEN TURNED OFF, THEN OUTPUT PIN WILL
        '           RETURN TO A LOGIC 1 WHICH IS 5 VOLTS DC.
        '           MAKE SURE NOT TO EXCEED MAXIMUM CURRENT DRAW ON OUTPUT PINS.
        '           THE MD2OUTPUTCODE DETERMINES WHICH MD-2, PIN AND ON/OFF.
        '           USE THE FOLLOWING CHART TO DETERMINE WHICH CODE TO USE.
        '           NOTICE THE FIRST DIGIT OF THE CODE SELECTS WHICH MD-2 SYSTEM,
        '           THE SECOND DIGIT SELECTS THE PIN, AND THE THIRD SELECTS
        '           ON OR OFF (1 OR 0).
        '
        '           MD2OUTPUTCODE    MD-2 PORT    OUTPUT  ACTION
        '           -------------    ---------    ------  ------
        '               110             #1          #1      OFF
        '               111             #1          #1      ON
        '               120             #1          #2      OFF
        '               121             #1          #2      ON
        '
        '               210             #2          #1      OFF
        '               211             #2          #1      ON
        '               220             #2          #2      OFF
        '               221             #2          #2      ON
        '
        '               310             #3          #1      OFF
        '               311             #3          #1      ON
        '               320             #3          #2      OFF
        '               321             #3          #2      ON
        '
        'USAGE:     SET THE MD2OUTPUTCODE PARAMETER AND CALL.  USE TO CONTROL
        '           TOOLING SUCH AS DRILLS AND DISPENSERS.
        'INPUTS:    MD2OUTPUTCODE DETERMINES WHICH, MD-2, WHICH PIN, ON/OFF.
        'OUTPUTS:   NONE.
        '---------------------------------------------------------------------

        'Initialize return status.
        MD2STATUS = "O"

        'MD2 #1 ---------------------------------------------

        'MD2 #1, OUTPUT #1, OFF
        If MD2OUTPUTCODE = 110 Then

            'CHECK FOR ENABLED MD2.
            If MD2ENABLED12 = False Then
                MD2STATUS = "E"
                Exit Sub
            End If

            'IF PARALLEL PORT THEN DEAL WITH IT.
            If MD2PORT12 <> 0 Then
                Out(MD2PORT12 + 2, Inp(MD2PORT12 + 2) And &HF7)
            End If

            'If C4 PORT IS SET THEN DEAL WITH IT.
            If MD2C4PORT12 <> "" Then
                Try
                    'CAN WRITE OUTPUTS ON FIRST MD2 PORT, BUT NOT 2ND.
                    If MD2C4CONNECTOR12 = "a" Then
                        MD2C4COM12.Write("!" & MD2C4ID12 & "o1,0" & vbCr)
                        MD2C4COM12.ReadTo("a")      'GET RETURNED 'a'.
                    Else
                        MD2STATUS = "P"
                        Exit Sub
                    End If
                Catch ex As Exception
                End Try
            End If
            Exit Sub
        End If

        'MD2 #1, OUTPUT #1, ON
        If MD2OUTPUTCODE = 111 Then

            'CHECK FOR ENABLED MD2.
            If MD2ENABLED12 = False Then
                MD2STATUS = "E"
                Exit Sub
            End If

            'IF PARALLEL PORT THEN DEAL WITH IT.
            If MD2PORT12 <> 0 Then
                Out(MD2PORT12 + 2, Inp(MD2PORT12 + 2) Or &H8)
            End If

            'If C4 PORT IS SET THEN DEAL WITH IT.
            If MD2C4PORT12 <> "" Then
                Try
                    'CAN WRITE OUTPUTS ON FIRST MD2 PORT, BUT NOT 2ND.
                    If MD2C4CONNECTOR12 = "a" Then
                        MD2C4COM12.Write("!" & MD2C4ID12 & "o1,1" & vbCr)
                        MD2C4COM12.ReadTo("a")      'GET RETURNED 'a'.
                    Else
                        MD2STATUS = "P"
                        Exit Sub
                    End If
                Catch ex As Exception
                End Try
            End If
            Exit Sub
        End If

        'MD2 #1, OUTPUT #2, OFF
        If MD2OUTPUTCODE = 120 Then

            'CHECK FOR ENABLED MD2.
            If MD2ENABLED12 = False Then
                MD2STATUS = "E"
                Exit Sub
            End If

            'IF PARALLEL PORT THEN DEAL WITH IT.
            If MD2PORT12 <> 0 Then
                Out(MD2PORT12 + 2, Inp(MD2PORT12 + 2) And &HFD)
            End If

            'If C4 PORT IS SET THEN DEAL WITH IT.
            If MD2C4PORT12 <> "" Then
                Try
                    'CAN WRITE OUTPUTS ON FIRST MD2 PORT, BUT NOT 2ND.
                    If MD2C4CONNECTOR12 = "a" Then
                        MD2C4COM12.Write("!" & MD2C4ID12 & "o2,0" & vbCr)
                        MD2C4COM12.ReadTo("a")      'GET RETURNED 'a'.
                    Else
                        MD2STATUS = "P"
                        Exit Sub
                    End If
                Catch ex As Exception
                End Try
            End If
            Exit Sub

        End If

        'MD2 #1, OUTPUT #2, ON
        If MD2OUTPUTCODE = 121 Then

            'CHECK FOR ENABLED MD2.
            If MD2ENABLED12 = False Then
                MD2STATUS = "E"
                Exit Sub
            End If

            'IF PARALLEL PORT THEN DEAL WITH IT.
            If MD2PORT12 <> 0 Then
                Out(MD2PORT12 + 2, Inp(MD2PORT12 + 2) Or &H2)
            End If

            'If C4 PORT IS SET THEN DEAL WITH IT.
            If MD2C4PORT12 <> "" Then
                Try
                    'CAN WRITE OUTPUTS ON FIRST MD2 PORT, BUT NOT 2ND.
                    If MD2C4CONNECTOR12 = "a" Then
                        MD2C4COM12.Write("!" & MD2C4ID12 & "o2,1" & vbCr)
                        MD2C4COM12.ReadTo("a")      'GET RETURNED 'a'.
                    Else
                        MD2STATUS = "P"
                        Exit Sub
                    End If
                Catch ex As Exception
                End Try
            End If
            Exit Sub
        End If

        'MD2 #2 ---------------------------------------------

        'MD2 #2, OUTPUT #1, OFF
        If MD2OUTPUTCODE = 210 Then

            'CHECK FOR ENABLED MD2.
            If MD2ENABLED34 = False Then
                MD2STATUS = "E"
                Exit Sub
            End If

            'IF PARALLEL PORT THEN DEAL WITH IT.
            If MD2PORT34 <> 0 Then
                Out(MD2PORT34 + 2, Inp(MD2PORT34 + 2) And &HF7)
            End If

            'If C4 PORT IS SET THEN DEAL WITH IT.
            If MD2C4PORT34 <> "" Then
                Try
                    'CAN WRITE OUTPUTS ON FIRST MD2 PORT, BUT NOT 2ND.
                    If MD2C4CONNECTOR34 = "a" Then
                        MD2C4COM34.Write("!" & MD2C4ID34 & "o1,0" & vbCr)
                        MD2C4COM34.ReadTo("a")      'GET RETURNED 'a'.
                    Else
                        MD2STATUS = "P"
                        Exit Sub
                    End If
                Catch ex As Exception
                End Try
            End If
            Exit Sub
        End If

        'MD2 #2, OUTPUT #1, ON
        If MD2OUTPUTCODE = 211 Then

            'CHECK FOR ENABLED MD2.
            If MD2ENABLED34 = False Then
                MD2STATUS = "E"
                Exit Sub
            End If

            'IF PARALLEL PORT THEN DEAL WITH IT.
            If MD2PORT34 <> 0 Then
                Out(MD2PORT34 + 2, Inp(MD2PORT34 + 2) Or &H8)
            End If

            'If C4 PORT IS SET THEN DEAL WITH IT.
            If MD2C4PORT34 <> "" Then
                Try
                    'CAN WRITE OUTPUTS ON FIRST MD2 PORT, BUT NOT 2ND.
                    If MD2C4CONNECTOR34 = "a" Then
                        MD2C4COM34.Write("!" & MD2C4ID34 & "o1,1" & vbCr)
                        MD2C4COM34.ReadTo("a")      'GET RETURNED 'a'.
                    Else
                        MD2STATUS = "P"
                        Exit Sub
                    End If
                Catch ex As Exception
                End Try
            End If
            Exit Sub
        End If

        'MD2 #2, OUTPUT #2, OFF
        If MD2OUTPUTCODE = 220 Then

            'CHECK FOR ENABLED MD2.
            If MD2ENABLED34 = False Then
                MD2STATUS = "E"
                Exit Sub
            End If

            'IF PARALLEL PORT THEN DEAL WITH IT.
            If MD2PORT34 <> 0 Then
                Out(MD2PORT34 + 2, Inp(MD2PORT34 + 2) And &HFD)
            End If

            'If C4 PORT IS SET THEN DEAL WITH IT.
            If MD2C4PORT34 <> "" Then
                Try
                    'CAN WRITE OUTPUTS ON FIRST MD2 PORT, BUT NOT 2ND.
                    If MD2C4CONNECTOR34 = "a" Then
                        MD2C4COM34.Write("!" & MD2C4ID34 & "o2,0" & vbCr)
                        MD2C4COM34.ReadTo("a")      'GET RETURNED 'a'.
                    Else
                        MD2STATUS = "P"
                        Exit Sub
                    End If
                Catch ex As Exception
                End Try
            End If
            Exit Sub

        End If

        'MD2 #2, OUTPUT #2, ON
        If MD2OUTPUTCODE = 221 Then

            'CHECK FOR ENABLED MD2.
            If MD2ENABLED34 = False Then
                MD2STATUS = "E"
                Exit Sub
            End If

            'IF PARALLEL PORT THEN DEAL WITH IT.
            If MD2PORT34 <> 0 Then
                Out(MD2PORT34 + 2, Inp(MD2PORT34 + 2) Or &H2)
            End If

            'If C4 PORT IS SET THEN DEAL WITH IT.
            If MD2C4PORT34 <> "" Then
                Try
                    'CAN WRITE OUTPUTS ON FIRST MD2 PORT, BUT NOT 2ND.
                    If MD2C4CONNECTOR34 = "a" Then
                        MD2C4COM34.Write("!" & MD2C4ID34 & "o2,1" & vbCr)
                        MD2C4COM34.ReadTo("a")      'GET RETURNED 'a'.
                    Else
                        MD2STATUS = "P"
                        Exit Sub
                    End If
                Catch ex As Exception
                End Try
            End If
            Exit Sub
        End If

        'MD2 #3 ---------------------------------------------

        'MD2 #3, OUTPUT #1, OFF
        If MD2OUTPUTCODE = 310 Then

            'CHECK FOR ENABLED MD2.
            If MD2ENABLED56 = False Then
                MD2STATUS = "E"
                Exit Sub
            End If

            'IF PARALLEL PORT THEN DEAL WITH IT.
            If MD2PORT56 <> 0 Then
                Out(MD2PORT56 + 2, Inp(MD2PORT56 + 2) And &HF7)
            End If

            'If C4 PORT IS SET THEN DEAL WITH IT.
            If MD2C4PORT56 <> "" Then
                Try
                    'CAN WRITE OUTPUTS ON FIRST MD2 PORT, BUT NOT 2ND.
                    If MD2C4CONNECTOR56 = "a" Then
                        MD2C4COM56.Write("!" & MD2C4ID56 & "o1,0" & vbCr)
                        MD2C4COM56.ReadTo("a")      'GET RETURNED 'a'.
                    Else
                        MD2STATUS = "P"
                        Exit Sub
                    End If
                Catch ex As Exception
                End Try
            End If
            Exit Sub
        End If

        'MD2 #3, OUTPUT #1, ON
        If MD2OUTPUTCODE = 311 Then

            'CHECK FOR ENABLED MD2.
            If MD2ENABLED56 = False Then
                MD2STATUS = "E"
                Exit Sub
            End If

            'IF PARALLEL PORT THEN DEAL WITH IT.
            If MD2PORT56 <> 0 Then
                Out(MD2PORT56 + 2, Inp(MD2PORT56 + 2) Or &H8)
            End If

            'If C4 PORT IS SET THEN DEAL WITH IT.
            If MD2C4PORT56 <> "" Then
                Try
                    'CAN WRITE OUTPUTS ON FIRST MD2 PORT, BUT NOT 2ND.
                    If MD2C4CONNECTOR56 = "a" Then
                        MD2C4COM56.Write("!" & MD2C4ID56 & "o1,1" & vbCr)
                        MD2C4COM56.ReadTo("a")      'GET RETURNED 'a'.
                    Else
                        MD2STATUS = "P"
                        Exit Sub
                    End If
                Catch ex As Exception
                End Try
            End If
            Exit Sub
        End If

        'MD2 #3, OUTPUT #2, OFF
        If MD2OUTPUTCODE = 320 Then

            'CHECK FOR ENABLED MD2.
            If MD2ENABLED56 = False Then
                MD2STATUS = "E"
                Exit Sub
            End If

            'IF PARALLEL PORT THEN DEAL WITH IT.
            If MD2PORT56 <> 0 Then
                Out(MD2PORT56 + 2, Inp(MD2PORT56 + 2) And &HFD)
            End If

            'If C4 PORT IS SET THEN DEAL WITH IT.
            If MD2C4PORT56 <> "" Then
                Try
                    'CAN WRITE OUTPUTS ON FIRST MD2 PORT, BUT NOT 2ND.
                    If MD2C4CONNECTOR56 = "a" Then
                        MD2C4COM56.Write("!" & MD2C4ID56 & "o2,0" & vbCr)
                        MD2C4COM56.ReadTo("a")      'GET RETURNED 'a'.
                    Else
                        MD2STATUS = "P"
                        Exit Sub
                    End If
                Catch ex As Exception
                End Try
            End If
            Exit Sub
        End If

        'MD2 #3, OUTPUT #2, ON
        If MD2OUTPUTCODE = 321 Then

            'CHECK FOR ENABLED MD2.
            If MD2ENABLED56 = False Then
                MD2STATUS = "E"
                Exit Sub
            End If

            'IF PARALLEL PORT THEN DEAL WITH IT.
            If MD2PORT56 <> 0 Then
                Out(MD2PORT56 + 2, Inp(MD2PORT56 + 2) Or &H2)
            End If

            'If C4 PORT IS SET THEN DEAL WITH IT.
            If MD2C4PORT56 <> "" Then
                Try
                    'CAN WRITE OUTPUTS ON FIRST MD2 PORT, BUT NOT 2ND.
                    If MD2C4CONNECTOR56 = "a" Then
                        MD2C4COM56.Write("!" & MD2C4ID56 & "o2,1" & vbCr)
                        MD2C4COM56.ReadTo("a")      'GET RETURNED 'a'.
                    Else
                        MD2STATUS = "P"
                        Exit Sub
                    End If
                Catch ex As Exception
                End Try
            End If
            Exit Sub
        End If

    End Sub

    Public Sub MD2PARLOAD()

        '---------------------------------------------------------------------
        'NAME:      MD2PARLOAD
        'DESC:      THIS PROCEDURE IS USED TO LOAD ALL MOTOR PARAMETERS
        '           FROM A DISK FILE.  WHEN USED WITH THE MD2PARSAVE PROCEDURE,
        '           A PROGRAM CAN BE CREATED WHICH SAVES ITS STATUS BEFORE
        '           POWERING DOWN AND RESTORES WHEN COMMING BACK ON ELIMINATING
        '           THE NEED FOR THE USER TO SET MOTOR PARAMETERS.
        'USAGE:     SET THE DESIRED FILE NAME IN MD2PARFILE AND CALL.
        'INPUTS:    FILE NAME AND ALL MOTOR PARAMETERS.
        'OUTPUTS:   STATUS = O FOR OK OR E FOR ERROR.
        '---------------------------------------------------------------------

        'LOCAL VARIABLES.
        Dim MD2MTR As Integer      'MOTOR COUNTER.
        Dim MD2XS As String = ""   'DUMMY STRING VARIABLE.
        Dim MD2XI As Integer       'DUMMY INTEGER VARIABLE.
        Dim MD2FILENUM As Integer  'FREE FILE NUMBER.

        'DEFAULT RETURN STATUS TO OK.
        MD2STATUS = "O"

        'LOAD PARAMETERS.
        On Error GoTo MD2PARLOADERROR
        MD2FILENUM = FreeFile()
        'Dim pstream As FileStream = File.Open(MD2PARFILE, FileMode.Open)
        FileOpen(MD2FILENUM, MD2PARFILE, OpenMode.Input)

        'MOTOR PARAMETERS.
        Input(MD2FILENUM, MD2XS)     'FILE NAME
        Input(MD2FILENUM, MD2HOLD)
        Input(MD2FILENUM, MD2INTERRUPTS)
        Input(MD2FILENUM, MD2MOTOR)
        Input(MD2FILENUM, MD2MOVETYPE)
        Input(MD2FILENUM, MD2STEPTYPE)

        'CHECK FOR ERRORS INDICATING CORRUPT PARAMETER FILE.
        'If MD2HOLD <> 0 And MD2HOLD <> -1 Then MD2STATUS = "F"
        If MD2HOLD <> False And MD2HOLD <> True Then MD2STATUS = "F"
        If MD2MOVETYPE <> "A" And MD2MOVETYPE <> "R" Then MD2STATUS = "F"

        'MOTOR PARAMETER ARRAYS.
        For MD2MTR = 1 To 6
            If MD2STATUS <> "O" Then Exit For
            Input(MD2FILENUM, MD2XI)
            Input(MD2FILENUM, MD2BACKLASH(MD2MTR))
            Input(MD2FILENUM, MD2HOMEDIR(MD2MTR))
            Input(MD2FILENUM, MD2HOMEOFFSET(MD2MTR))
            Input(MD2FILENUM, MD2LIMITF(MD2MTR))
            Input(MD2FILENUM, MD2LIMITR(MD2MTR))
            Input(MD2FILENUM, MD2MAXSPEED(MD2MTR))
            If MD2MAXSPEED(MD2MTR) < 0 Then MD2STATUS = "F"
            Input(MD2FILENUM, MD2MINSPEED(MD2MTR))
            If MD2MINSPEED(MD2MTR) < 0 Then MD2STATUS = "F"
            Input(MD2FILENUM, MD2MOTORNAME(MD2MTR))
            Input(MD2FILENUM, MD2POSITION(MD2MTR))
            Input(MD2FILENUM, MD2SLOPE(MD2MTR))
            If MD2SLOPE(MD2MTR) < 0 Then MD2STATUS = "F"
            Input(MD2FILENUM, MD2TARGET(MD2MTR))
            Input(MD2FILENUM, MD2UNITS(MD2MTR))
            If MD2UNITS(MD2MTR) < 0 Then MD2STATUS = "F"
            Input(MD2FILENUM, MD2UNITNAME(MD2MTR))
            Input(MD2FILENUM, MD2PATPTR(MD2MTR))
            Input(MD2FILENUM, MD2LASTDIR(MD2MTR))
        Next MD2MTR

        'GRID PARAMETERS.
        Input(MD2FILENUM, MD2GRIDBEGINX)
        Input(MD2FILENUM, MD2GRIDBEGINY)
        Input(MD2FILENUM, MD2GRIDSPACEX)
        Input(MD2FILENUM, MD2GRIDSPACEY)
        Input(MD2FILENUM, MD2GRIDTARGETX)
        Input(MD2FILENUM, MD2GRIDTARGETY)

        'CIRCLE PARAMETERS.
        Input(MD2FILENUM, MD2CIRCLERADIUSX)
        Input(MD2FILENUM, MD2CIRCLERADIUSY)
        Input(MD2FILENUM, MD2CIRCLECENTERX)
        Input(MD2FILENUM, MD2CIRCLECENTERY)
        Input(MD2FILENUM, MD2CIRCLESTART)
        Input(MD2FILENUM, MD2CIRCLEARC)
        Input(MD2FILENUM, MD2CIRCLECHORD)

        Input(MD2FILENUM, MD2PORT12)
        Input(MD2FILENUM, MD2PORT34)
        Input(MD2FILENUM, MD2PORT56)

        Input(MD2FILENUM, MD2C4PORT12)
        Input(MD2FILENUM, MD2C4PORT34)
        Input(MD2FILENUM, MD2C4PORT56)

        Input(MD2FILENUM, MD2C4ID12)
        Input(MD2FILENUM, MD2C4ID34)
        Input(MD2FILENUM, MD2C4ID56)

        Input(MD2FILENUM, MD2C4CONNECTOR12)
        Input(MD2FILENUM, MD2C4CONNECTOR34)
        Input(MD2FILENUM, MD2C4CONNECTOR56)

        Input(MD2FILENUM, MD2C4BAUD12)
        Input(MD2FILENUM, MD2C4BAUD34)
        Input(MD2FILENUM, MD2C4BAUD56)

        'FINISH UP.
        FileClose(MD2FILENUM)
        On Error GoTo 0
        Exit Sub

        'FILE ERROR HANDLER.
MD2PARLOADERROR:
        MD2STATUS = "F"
        Resume Next

    End Sub

    Public Sub MD2PARSAVE()

        '---------------------------------------------------------------------
        'NAME:      MD2PARSAVE
        'DESC:      THIS PROCEDURE IS USED TO SAVE ALL MOTOR PARAMETERS
        '           TO A DISK FILE.  WHEN USED WITH THE MD2PARLOAD PROCEDURE,
        '           A PROGRAM CAN BE CREATED WHICH SAVES ITS STATUS BEFORE
        '           POWERING DOWN AND RESTORES WHEN COMMING BACK ON ELIMINATING
        '           THE NEED FOR THE USER TO RE-ENTER ALL MOTOR PARAMETERS.
        'USAGE:     SET THE DESIRED FILE NAME IN MD2PARFILE AND CALL.
        'INPUTS:    FILE NAME AND ALL MOTOR PARAMETERS.
        'OUTPUTS:   STATUS = O FOR OK OR E FOR ERROR.
        '---------------------------------------------------------------------

        'LOCAL VARIABLES.
        Dim MD2MTR As Integer           'MOTOR COUNTER.
        Dim MD2FILENUM As Integer       'FREE FILE NUMBER.

        'DEFAULT RETURN STATUS TO OK.
        MD2STATUS = "O"

        'SAVE PARAMETERS.
        On Error GoTo MD2PARSAVEERROR
        MD2FILENUM = FreeFile()
        FileOpen(MD2FILENUM, MD2PARFILE, OpenMode.Output)

        'MOTOR PARAMETERS.
        'Write(MD2FILENUM, MD2PARFILE)
        'Write(MD2FILENUM, MD2HOLD, MD2INTERRUPTS, MD2MOTOR, MD2MOVETYPE, MD2STEPTYPE)
        Print(MD2FILENUM, Chr(34) & MD2PARFILE & Chr(34) & ",")
        Print(MD2FILENUM, MD2HOLD & ",")
        Print(MD2FILENUM, MD2INTERRUPTS & ",")
        Print(MD2FILENUM, MD2MOTOR & ",")
        Print(MD2FILENUM, MD2MOVETYPE & ",")
        Print(MD2FILENUM, MD2STEPTYPE & vbCrLf)

        'MOTOR PARAMETER ARRAYS.
        For MD2MTR = 1 To 6
            If MD2STATUS = "F" Then Exit For
            Print(MD2FILENUM, MD2MTR & ",")
            Print(MD2FILENUM, MD2BACKLASH(MD2MTR) & ",")
            Print(MD2FILENUM, MD2HOMEDIR(MD2MTR) & ",")
            Print(MD2FILENUM, MD2HOMEOFFSET(MD2MTR) & ",")
            Print(MD2FILENUM, MD2LIMITF(MD2MTR) & ",")
            Print(MD2FILENUM, MD2LIMITR(MD2MTR) & ",")
            Print(MD2FILENUM, MD2MAXSPEED(MD2MTR) & ",")
            Print(MD2FILENUM, MD2MINSPEED(MD2MTR) & ",")
            Print(MD2FILENUM, Chr(34) & MD2MOTORNAME(MD2MTR) & Chr(34) & ",")
            Print(MD2FILENUM, MD2POSITION(MD2MTR) & ",")
            Print(MD2FILENUM, MD2SLOPE(MD2MTR) & ",")
            Print(MD2FILENUM, MD2TARGET(MD2MTR) & ",")
            Print(MD2FILENUM, MD2UNITS(MD2MTR) & ",")
            Print(MD2FILENUM, Chr(34) & MD2UNITNAME(MD2MTR) & Chr(34) & ",")
            Print(MD2FILENUM, MD2PATPTR(MD2MTR) & ",")
            Print(MD2FILENUM, MD2LASTDIR(MD2MTR) & vbCrLf)
        Next MD2MTR

        'GRID PARAMETERS.
        Print(MD2FILENUM, MD2GRIDBEGINX & ",")
        Print(MD2FILENUM, MD2GRIDBEGINY & ",")
        Print(MD2FILENUM, MD2GRIDSPACEX & ",")
        Print(MD2FILENUM, MD2GRIDSPACEY & ",")
        Print(MD2FILENUM, MD2GRIDTARGETX & ",")
        Print(MD2FILENUM, MD2GRIDTARGETY & vbCrLf)

        'CIRCLE PARAMETERS.
        Print(MD2FILENUM, MD2CIRCLERADIUSX & ",")
        Print(MD2FILENUM, MD2CIRCLERADIUSY & ",")
        Print(MD2FILENUM, MD2CIRCLECENTERX & ",")
        Print(MD2FILENUM, MD2CIRCLECENTERY & ",")
        Print(MD2FILENUM, MD2CIRCLESTART & ",")
        Print(MD2FILENUM, MD2CIRCLEARC & ",")
        Print(MD2FILENUM, MD2CIRCLECHORD & vbCrLf)

        'SAVE PORT ADDRESSES
        Print(MD2FILENUM, MD2PORT12 & ",")
        Print(MD2FILENUM, MD2PORT34 & ",")
        Print(MD2FILENUM, MD2PORT56 & vbCrLf)

        Print(MD2FILENUM, MD2C4PORT12 & ",")
        Print(MD2FILENUM, MD2C4PORT34 & ",")
        Print(MD2FILENUM, MD2C4PORT56 & vbCrLf)

        Print(MD2FILENUM, MD2C4ID12 & ",")
        Print(MD2FILENUM, MD2C4ID34 & ",")
        Print(MD2FILENUM, MD2C4ID56 & vbCrLf)

        Print(MD2FILENUM, MD2C4CONNECTOR12 & ",")
        Print(MD2FILENUM, MD2C4CONNECTOR34 & ",")
        Print(MD2FILENUM, MD2C4CONNECTOR56 & vbCrLf)

        Print(MD2FILENUM, MD2C4BAUD12 & ",")
        Print(MD2FILENUM, MD2C4BAUD34 & ",")
        Print(MD2FILENUM, MD2C4BAUD56 & vbCrLf)

        'FINISH UP.
        FileClose(MD2FILENUM)
        On Error GoTo 0
        Exit Sub

        'FILE ERROR HANDLER.
MD2PARSAVEERROR:
        MD2STATUS = "F"
        Resume Next

    End Sub

    Public Sub MD2SEQLOAD()

        '---------------------------------------------------------------------
        'NAME:      MD2SEQLOAD
        'DESC:      THIS PROCEDURE IS USED TO LOAD A MOTION SEQUENCE
        '           FROM A DISK FILE AND STORES IN MD2SEQUENCE STRING.
        '           THIS SEQUENCE FILE CAN BE EXECUTED USING THE MD2SEQRUN
        '           SUBROUTINE.
        'USAGE:     SET THE DESIRED FILE NAME IN MD2SEQFILE AND CALL.
        'INPUTS:    FILE NAME AND ALL MOTOR PARAMETERS.
        'OUTPUTS:   STATUS = O FOR OK OR E FOR ERROR.
        '---------------------------------------------------------------------

        'LOCAL VARIABLES.
        Dim MD2FILENUM As Integer       'FREE FILE NUMBER.
        Dim LineOfText As String

        'INITIALIZE VARIABLES.
        MD2STATUS = "O"                 'DEFAULT RETURN STATUS TO OK.
        MD2SEQUENCE = ""                'CLEAR COMMANDS.

        'LOAD SEQUENCE FILE.
        On Error GoTo MD2SEQLOADERROR
        MD2FILENUM = FreeFile()
        FileOpen(MD2FILENUM, MD2SEQFILE, OpenMode.Input)
        'MD2SEQUENCE = Input(MD2FILENUM, LOF(MD2FILENUM))
        Do Until EOF(1)
            LineOfText = LineInput(MD2FILENUM)
            MD2SEQUENCE = MD2SEQUENCE & LineOfText & vbCrLf
        Loop

        'FINISH UP.
        FileClose(MD2FILENUM)
        On Error GoTo 0
        Exit Sub

        'FILE ERROR HANDLER.
MD2SEQLOADERROR:
        MD2STATUS = "F"
        Exit Sub

    End Sub

    Public Sub MD2SEQSAVE()

        '---------------------------------------------------------------------
        'NAME:      MD2SEQSAVE
        'DESC:      THIS PROCEDURE IS USED TO SAVE A MOTION SEQUENCE
        '           TO A DISK FILE FROM MD2SEQUENCE STRING.
        'USAGE:     SET THE DESIRED FILE NAME IN MD2SEQFILE AND CALL.
        'INPUTS:    FILE NAME, MD2SEQUENCE.
        'OUTPUTS:   STATUS = O FOR OK OR E FOR ERROR.
        '---------------------------------------------------------------------

        'LOCAL VARIABLES.
        Dim MD2FILENUM As Integer      'FREE FILE NUMBER.

        'DEFAULT RETURN STATUS TO OK.
        MD2STATUS = "O"

        'SAVE PARAMETERS.
        On Error GoTo MD2SEQSAVEERROR
        MD2FILENUM = FreeFile()
        FileOpen(MD2FILENUM, MD2SEQFILE, OpenMode.Output)
        Print(MD2FILENUM, MD2SEQUENCE)

        'FINISH UP.
        FileClose(MD2FILENUM)
        On Error GoTo 0
        Exit Sub

        'FILE ERROR HANDLER.
MD2SEQSAVEERROR:
        MD2STATUS = "F"
        Resume Next

    End Sub

    Public Sub MD2SETUP()

        '---------------------------------------------------------------------
        'NAME:      MD2SETUP
        'DESC:      THE MD2SETUP PROCEDURE SETS DEFAULT MD-2 SYSTEM
        '           PARAMETERS AND LOADS CALIBRATION FILE.
        'USAGE:     USE AT THE BEGINNING OF A MOTION CONTROL PROGRAM.
        '           MUST BE USED -BEFORE- ANY OTHER MOTION CONTROL SUBROUTINE.
        'INPUTS:    NONE.
        'OUTPUTS:   DEFAULT MOTOR PARAMETERS, PORT AVAILABLE VARIABLES, 
        '           CALIBRATION FILE, RETURN STATUS.
        '---------------------------------------------------------------------

        'LOCAL VARIABLES.
        Dim MD2ELEMENT As Integer           'ARRAY ELEMENT COUNTER.
        Dim MD2FILENUM As Integer           'FREE FILE NUMBER.

        'SETUP MOTOR PARAMETER DEFAULTS.
        For MD2MOTOR = 1 To 6
            MD2MOTORNAME(MD2MOTOR) = "#" + Str$(MD2MOTOR)    'NAME OF MOTOR.
            MD2BACKLASH(MD2MOTOR) = 0       'BACKLASH COMPENSATION.
            MD2HOMEOFFSET(MD2MOTOR) = 0     'HOME OFFSET.
            MD2HOMEDIR(MD2MOTOR) = 0        'HOME DIRECTION.
            MD2LIMITF(MD2MOTOR) = 1000000   'FORWARD LIMIT.
            MD2LIMITR(MD2MOTOR) = 0         'REVERSE LIMIT.
            MD2LASTDIR(MD2MOTOR) = 1        'LAST DIRECTION - FORWARD.
            MD2POSITION(MD2MOTOR) = 0       'POSITIONS = 0.
            MD2PATPTR(MD2MOTOR) = 0         'STEP PATTERN POINTERS.
            MD2TARGET(MD2MOTOR) = 400       'TARGET POSITION,STEPS.
            MD2MINSPEED(MD2MOTOR) = 200     'MINIMUM SPEED.
            MD2MAXSPEED(MD2MOTOR) = 800     'MAXIMUM SPEED.
            MD2SLOPE(MD2MOTOR) = 200        'RAMPING SLOPE IN UNITS.
            MD2UNITS(MD2MOTOR) = 1          '1 UNIT (STEPS) PER STEP.
            MD2UNITNAME(MD2MOTOR) = "Steps"
        Next MD2MOTOR
        MD2MOTOR = 1                'MOTOR NUMBER.
        MD2MOVETYPE = "R"           'RELATIVE MOVES.
        MD2STEPTYPE = "H"           'HALF STEP MODE.
        MD2STATUS = "O"             'STATUS=OK.
        MD2HOLD = False             'DONT HOLD MOTORS.
        MD2INTERRUPTS = True        'INTERRUPTS ON DURING MOVES.
        If MD2PARFILE = "" Then MD2PARFILE = "MD2xp.par" 'DEFAULT MOTOR PARAMETERS.
        MD2SEQFILE = ""             'SEQUENCE FILE.
        If MD2CALFILE = "" Then MD2CALFILE = "MD2xp.cal" 'CALIBRATION FILE.
        MD2CALMODE = False          'CALIBRATION MODE-OFF.

        'GRID DEFAULT PARAMETERS.
        MD2GRIDBEGINX = 0           'COLUMN BEGIN.
        MD2GRIDBEGINY = 0           'ROW BEGIN.
        MD2GRIDSPACEX = 1           'COLUMN SPACING.
        MD2GRIDSPACEY = 1           'ROW SPACING.
        MD2GRIDTARGETX = 0          'COLUMN TARGET.
        MD2GRIDTARGETY = 0          'ROW TARGET.

        'CIRCLE DEFAULT PARAMETERS.
        MD2CIRCLERADIUSX = 1        'RADIUS X.
        MD2CIRCLERADIUSY = 1        'RADIUS Y.
        MD2CIRCLECENTERX = 1        'CENTER X.
        MD2CIRCLECENTERY = 1        'CENTER Y.
        MD2CIRCLESTART = 0          'START ANGLE.
        MD2CIRCLEARC = 360          'ARC ANGLE (360=CIRCLE).
        MD2CIRCLECHORD = 1          'CHORD ANGLE.

        'PORT ADDRESSES.
        '0=NO PORT IDENTIFIED YET.
        'MUST BE SET BY USER AND SAVED IN PARAMETER FILE.
        'BAD PORT ADDRESSES MIGHT CAUSE COMPUTER LOCKUP.
        MD2PORT12 = 0
        MD2PORT34 = 0
        MD2PORT56 = 0

        'C4 Parameters
        MD2C4PORT12 = ""
        MD2C4PORT34 = ""
        MD2C4PORT56 = ""
        MD2C4ID12 = ""
        MD2C4ID34 = ""
        MD2C4ID56 = ""
        MD2C4CONNECTOR12 = ""
        MD2C4CONNECTOR34 = ""
        MD2C4CONNECTOR56 = ""
        MD2C4BAUD12 = "9600"
        MD2C4BAUD34 = "9600"
        MD2C4BAUD56 = "9600"

        'LOAD SPEED CALIBRATION FILE.
        MD2STATUS = "O"
        On Error GoTo MD2SETUPERROR
        MD2FILENUM = FreeFile()
        If File.Exists(MD2CALFILE) = True Then
            FileOpen(MD2FILENUM, MD2CALFILE, OpenMode.Input)
            For MD2ELEMENT = 0 To 62
                If MD2STATUS <> "O" Then Exit For
                Input(MD2FILENUM, MD2DELAY(MD2ELEMENT))
                Input(MD2FILENUM, MD2VELOCITY(MD2ELEMENT))
                If MD2DELAY(MD2ELEMENT) <= 0 Then MD2STATUS = "C"
                If MD2VELOCITY(MD2ELEMENT) <= 0.0 Then MD2STATUS = "C"
            Next MD2ELEMENT
        Else
            MD2STATUS = "C"
        End If

        'CLEAR CALIBRATION ARRAYS IF FILE ERROR.
        If MD2STATUS <> "O" Then
            For MD2ELEMENT = 0 To 63
                MD2DELAY(MD2ELEMENT) = 0
                MD2VELOCITY(MD2ELEMENT) = 0
            Next MD2ELEMENT
            MD2CALIBRATED = False
        Else
            FileClose(MD2FILENUM)
            MD2CALIBRATED = True
        End If

        On Error GoTo 0     'RESET ERROR HANDLER.
        Exit Sub

        'FILE ERROR HANDLER.
MD2SETUPERROR:
        MD2STATUS = "C"
        Resume Next

    End Sub

    Public Sub MD2STANDBYOFF()

        '---------------------------------------------------------------------
        'NAME:      MD2STANDBYOFF
        'DESC:      THE MD2STANDBYOFF PROCEDURE RETURNS AN MD-2 TO FULL
        '           CURRENT MODE.
        '           THE MD-2 IS SELECTED BY THE MD2MOTOR PARAMETER.
        '           BOTH MOTORS ON THE MD-2 IS AFFECTED
        '           SOME MD-2 SYSTEMS DO NOT HAVE THIS FEATURE, CHECK WITH
        '           YOUR MANUAL FOR MORE INFORMATION.
        'USAGE:     USE TO RETURN AN MD-2 TO FULL CURRENT MODE BEFORE MOVING
        '           THEM FOR MAXIMUM PERFORMANCE.
        'INPUTS:    MOTOR # DETERMINES MD-2.
        'OUTPUTS:   NONE.
        '---------------------------------------------------------------------

        'CHECK FOR VALID MOTOR #.
        MD2STATUS = "B"
        If MD2MOTOR = 1 Or MD2MOTOR = 2 Or MD2MOTOR = 3 Then MD2STATUS = "O"
        If MD2MOTOR = 4 Or MD2MOTOR = 5 Or MD2MOTOR = 6 Then MD2STATUS = "O"
        If MD2MOTOR = 12 Or MD2MOTOR = 34 Or MD2MOTOR = 56 Then MD2STATUS = "O"
        If MD2STATUS <> "O" Then Exit Sub

        'CHECK FOR ENABLED MD-2.
        MD2STATUS = "E"
        If (MD2MOTOR = 1 Or MD2MOTOR = 2 Or MD2MOTOR = 12) And Not MD2ENABLED12 Then Exit Sub
        If (MD2MOTOR = 3 Or MD2MOTOR = 4 Or MD2MOTOR = 34) And Not MD2ENABLED34 Then Exit Sub
        If (MD2MOTOR = 5 Or MD2MOTOR = 6 Or MD2MOTOR = 56) And Not MD2ENABLED56 Then Exit Sub

        MD2STATUS = "O"

        'PARALLEL PORT
        If (MD2MOTOR = 1 Or MD2MOTOR = 2 Or MD2MOTOR = 12) And MD2PORT12 <> 0 Then
            Out(MD2PORT12 + 2, Inp(MD2PORT12 + 2) Or &H4) 'STANDBY OFF.
            Exit Sub
        End If
        If (MD2MOTOR = 3 Or MD2MOTOR = 4 Or MD2MOTOR = 34) And MD2PORT34 <> 0 Then
            Out(MD2PORT34 + 2, Inp(MD2PORT34 + 2) Or &H4) 'STANDBY OFF.
            Exit Sub
        End If
        If (MD2MOTOR = 5 Or MD2MOTOR = 6 Or MD2MOTOR = 56) And MD2PORT56 <> 0 Then
            Out(MD2PORT56 + 2, Inp(MD2PORT56 + 2) Or &H4) 'STANDBY OFF.
            Exit Sub
        End If

        'C4.
        If MD2C4PORT12 <> "" Then
            Try
                MD2C4COM12.Write("!" & MD2C4ID12 & "wy0" & vbCr) 'STANDBY ON.
                MD2C4COM12.ReadTo("a")      'GET RETURNED 'a'.
            Catch ex As Exception
                MD2STATUS = "P"
            End Try
            Exit Sub
        End If
        If MD2C4PORT34 <> "" Then
            Try
                MD2C4COM34.Write("!" & MD2C4ID34 & "wy0" & vbCr) 'STANDBY ON.
                MD2C4COM34.ReadTo("a")      'GET RETURNED 'a'.
            Catch ex As Exception
                MD2STATUS = "P"
            End Try
            Exit Sub
        End If
        If MD2C4PORT56 <> "" Then
            Try
                MD2C4COM56.Write("!" & MD2C4ID56 & "wy0" & vbCr) 'STANDBY ON.
                MD2C4COM56.ReadTo("a")      'GET RETURNED 'a'.
            Catch ex As Exception
                MD2STATUS = "P"
            End Try
            Exit Sub
        End If

        MD2STATUS = "P"

    End Sub

    Public Sub MD2STANDBYON()

        '---------------------------------------------------------------------
        'NAME:      MD2STANDBYON
        'DESC:      THE MD2STANDBYON PROCEDURE PUTS AN MD-2 INTO STANDBY MODE
        '           WHICH REDUCES THE MOTOR CURRENT BY 50%.  THIS RESULTS
        '           IN LOWER HEAT DISSIPATION DURING STANDSTILL WITHOUT
        '           LOSSING ALL HOLDING TORQUE.
        '           THE MD-2 SYSTEM IS SELECTED BY THE MD2MOTOR PARAMETER.
        '           BOTH MOTORS ON AN MD-2 ARE AFFECTED.
        '           MAKE SURE THAT MOTORS ARE ENERGIZED BY FIRST MOVING WITH
        '           MD2HOLD=-1 OR STANDBY WILL NOT WORK.
        '           SOME MD-2 SYSTEMS DO NOT HAVE THIS FEATURE, CHECK WITH
        '           YOUR MANUAL FOR MORE INFORMATION.
        'USAGE:     USE AFTER A MOTION TO MAINTAIN SOME HOLDING TORQUE WHILE
        '           REDUCING HEAT.
        'INPUTS:    MOTOR # DETERMINES MD-2.
        'OUTPUTS:   NONE
        '---------------------------------------------------------------------

        'CHECK FOR VALID MOTOR #.
        MD2STATUS = "B"
        If MD2MOTOR = 1 Or MD2MOTOR = 2 Or MD2MOTOR = 3 Then MD2STATUS = "O"
        If MD2MOTOR = 4 Or MD2MOTOR = 5 Or MD2MOTOR = 6 Then MD2STATUS = "O"
        If MD2MOTOR = 12 Or MD2MOTOR = 34 Or MD2MOTOR = 56 Then MD2STATUS = "O"
        If MD2STATUS <> "O" Then Exit Sub

        'CHECK FOR ENABLED MD-2.
        MD2STATUS = "E"
        If (MD2MOTOR = 1 Or MD2MOTOR = 2 Or MD2MOTOR = 12) And Not MD2ENABLED12 Then Exit Sub
        If (MD2MOTOR = 3 Or MD2MOTOR = 4 Or MD2MOTOR = 34) And Not MD2ENABLED34 Then Exit Sub
        If (MD2MOTOR = 5 Or MD2MOTOR = 6 Or MD2MOTOR = 56) And Not MD2ENABLED56 Then Exit Sub

        MD2STATUS = "O"

        'PARALLEL PORT.
        If (MD2MOTOR = 1 Or MD2MOTOR = 2 Or MD2MOTOR = 12) And MD2PORT12 <> 0 Then
            Out(MD2PORT12 + 2, Inp(MD2PORT12 + 2) And &HFB) 'STANDBY ON.
            Exit Sub
        End If
        If (MD2MOTOR = 3 Or MD2MOTOR = 4 Or MD2MOTOR = 34) And MD2PORT34 <> 0 Then
            Out(MD2PORT34 + 2, Inp(MD2PORT34 + 2) And &HFB) 'STANDBY ON.
            Exit Sub
        End If
        If (MD2MOTOR = 5 Or MD2MOTOR = 6 Or MD2MOTOR = 56) And MD2PORT56 <> 0 Then
            Out(MD2PORT56 + 2, Inp(MD2PORT56 + 2) And &HFB) 'STANDBY ON.
            Exit Sub
        End If

        'C4.
        If MD2C4PORT12 <> "" Then
            Try
                MD2C4COM12.Write("!" & MD2C4ID12 & "wy1" & vbCr) 'STANDBY ON.
                MD2C4COM12.ReadTo("a")      'GET RETURNED 'a'.
            Catch ex As Exception
                MD2STATUS = "P"
            End Try
            Exit Sub
        End If
        If MD2C4PORT34 <> "" Then
            Try
                MD2C4COM34.Write("!" & MD2C4ID34 & "wy1" & vbCr) 'STANDBY ON.
                MD2C4COM34.ReadTo("a")      'GET RETURNED 'a'.
            Catch ex As Exception
                MD2STATUS = "P"
            End Try
            Exit Sub
        End If
        If MD2C4PORT56 <> "" Then
            Try
                MD2C4COM56.Write("!" & MD2C4ID56 & "wy1" & vbCr) 'STANDBY ON.
                MD2C4COM56.ReadTo("a")      'GET RETURNED 'a'.
            Catch ex As Exception
                MD2STATUS = "P"
            End Try
            Exit Sub
        End If

        MD2STATUS = "P"

    End Sub
    Sub MD2SEQRUN()

        '---------------------------------------------------------------------
        'NAME:      MD2SEQRUN
        'DESC:      THIS PROCEDURE WILL EXECUTE A SEQUENCE OF COMMANDS
        '           WHICH ARE STORED IN THE MD2SEQUENCE VARIABLE.
        '           THE LENGTH OF THE SEQUENCE IS LIMITED TO 32,766.
        '           COMMANDS ARE LIKE BASIC LANGUAGE COMMANDS SUCH AS
        '           MD2POSITION(2)=1000 OR SIMPLY MD2MOVE.  ALLOWS
        '           MOTOR PARAMETERS TO BE SET AND MD-2 SUBROUTINES
        '           TO BE RUN SUCH AS MD2MOVE, MD2HOME, MD2PARLOAD, ETC.
        '           EACH INDIVIDUAL COMMAND IS EXTRACTED FROM THE MD2SEQUENCE
        '           VARIABLE AND PASSED TO MD2SEQRUNDO FOR EXECUTION.
        '           EXECUTION BEGINS WITH MD2POINTER.
        'USAGE:     LOAD MD2SEQUENCE, SET MD2POINTER, THEN CALL MD2SEQRUN.
        'INPUTS:    MD2SEQUENCE,MD2POINTER AND ALL MOTOR PARAMETERS.
        'OUTPUTS:   ALL MOTOR PARAMETERS, MD2STATUS, MD2POINTER.
        '           DISTROYS MD2COMMAND.
        '           WHEN DONE, MD2POINTER POINTS TO THE BEGINNING OF THE
        '           COMMAND AFTER THE LAST ONE EXECUTED.
        '           IF AN ERROR OCCURED (MD2STATUS<>"O") THEN MD2COMMAND
        '           CONTAINS THE COMMAND WITH THE ERROR.
        '---------------------------------------------------------------------

        'INITIALIZE.
        MD2COMMAND = ""                 'CLEAR COMMAND.
        MD2STATUS = "B"                 'BAD COMMAND.

        'CHECK FOR EMPTY SEQUENCE AND INVALID POINTER.
        If MD2SEQUENCE = "" Then Exit Sub
        If MD2POINTER = 0 Then MD2POINTER = 1
        If MD2POINTER > Len(MD2SEQUENCE) Then Exit Sub

        'SCAN ENTIRE SEQUENCE AND BUILD ARRAY OF LOCATION NAMES.
        MD2SEQSCAN()

MD2SEQRUNEXTRACT:

        'EXTRACT COMMANDS AND SEND TO MD2SEQRUNDO.

        'GET THE CURRENT CHARACTER.
        MD2CHAR = Mid$(MD2SEQUENCE, MD2POINTER, 1)

        'POINT TO NEXT CHARACTER.
        MD2POINTER = MD2POINTER + 1

        'IF COMMENT THEN IGNORE REST OF LINE.
        'IF $ IGNORE REST OF LINE.
        'POINTER = NEXT CHARACTER WHEN DONE.
        If MD2CHAR = "'" Or MD2CHAR = "$" Then
            Do
                'END OF SEQUENCE?
                If MD2POINTER > Len(MD2SEQUENCE) Then Exit Do

                'GET CHARACTER.
                MD2CHAR = Mid$(MD2SEQUENCE, MD2POINTER, 1)

                'POINT TO NEXT CHARACTER.
                MD2POINTER = MD2POINTER + 1

                'DONE WITH COMMENT IF CR, LF, FF.
                If MD2CHAR = Chr(10) Then Exit Do
                If MD2CHAR = Chr(12) Then Exit Do
                If MD2CHAR = Chr(13) Then Exit Do
            Loop
        End If

        'END-OF-COMMAND CHARACTER?
        If MD2CHAR = Chr(10) Then GoTo MD2SEQRUNSEND
        If MD2CHAR = Chr(12) Then GoTo MD2SEQRUNSEND
        If MD2CHAR = Chr(13) Then GoTo MD2SEQRUNSEND
        If MD2CHAR = ":" Then GoTo MD2SEQRUNSEND

        'ADD CHARACTER.
        MD2COMMAND = MD2COMMAND + MD2CHAR

        'END OF SEQUENCE?
        If MD2POINTER > Len(MD2SEQUENCE) Then GoTo MD2SEQRUNSEND

        GoTo MD2SEQRUNEXTRACT

MD2SEQRUNSEND:

        'DO THE COMMAND, CHECK FOR ERRORS, END AND SETUP FOR NEXT ONE.

        'DO THE COMMAND.
        MD2SEQRUNDO()

        'CHECK FOR ERRORS.
        If MD2STATUS <> "O" Then Exit Sub

        'END?
        If MD2COMMAND = "END" Then Exit Sub

        'END OF SEQUENCE?
        If MD2POINTER > Len(MD2SEQUENCE) Then Exit Sub

        'SETUP FOR NEXT COMMAND.
        MD2COMMAND = ""
        GoTo MD2SEQRUNEXTRACT

    End Sub
    Sub MD2SEQSCAN()

        'SCAN THROUGH ENTIRE SEQUENCE AND RECORD LOCATION NAMES IN MD2LOC() ARRAY.
        'NAMES START WITH $ FOLLOWED BY 2 DIGITS - $04, $99

        Dim I As Integer

        'CLEAR ARRAY.
        'SETTING TO LAST CHARACTER IN SEQUENCE WILL CAUSE END IF GOTO UNUSED LABEL.
        For I = 0 To 99
            MD2SEQLOC(I) = Len(MD2SEQUENCE)
        Next I
        I = 0

        'SCAN SEQUENCE.
        For I = 1 To Len(MD2SEQUENCE)
            'SEARCH FOR $.
            If Mid$(MD2SEQUENCE, I, 1) = "$" Then
                'COLLECT 2 DIGITS AFTER $ AND USE AS INDEX INTO ARRAY. STORE I THERE.
                MD2SEQLOC(Val(Mid$(MD2SEQUENCE, I + 1, 2))) = I
                I += 2  'POINT TO NEXT.
            End If
        Next

    End Sub
    Function MD2SEQGETLOCATION(ByVal L As String) As Integer

        'RETURN SEQUENCE POINTER FROM A LOCATION NAME.
        MD2SEQGETLOCATION = MD2SEQLOC(Trim(Val(L.Replace("$", ""))))

    End Function
    Sub MD2SEQRUNPARS()

        'PARSE EQUATION----------------------------------------------------
        'RETURN MD2SUBSCRIPT INSIDE (), IF NOT AVAILABLE OR NOT 1-6 THEN = "".
        'RETURN MD2VALUE AFTER =, IF NOT AVAILABLE OR VALID THEN = "".

        'INITIALIZE VARIABLES.
        MD2VALUE = ""
        MD2SUBSCRIPT = ""

        'GET CHARACTERS AFTER =. CHECK FOR VALIDITY AND EMPTYNESS.
        MD2EQUAL = InStr(MD2CMD, "=")
        If MD2EQUAL <> 0 Then
            MD2NUMBER = Right$(MD2CMD, Len(MD2CMD) - MD2EQUAL)
            MD2SEQRUNVALID()
            If MD2NUMBER <> "" Then MD2VALUE = MD2NUMBER
        End If

        'GET CHARACTERS INSIDE ().

        'IF NO ( THEN DONE.
        MD2OPENP = InStr(MD2CMD, "(")
        If MD2OPENP = 0 Then Return

        'IF NO ) THEN ERROR. IF ) BEFORE ( THEN ERROR, IF EMPTY THEN ERROR.
        MD2CLOSEDP = InStr(MD2CMD, ")")
        If MD2CLOSEDP = 0 Then Return
        If MD2CLOSEDP < MD2OPENP Then Return
        If MD2CLOSEDP = MD2OPENP + 1 Then Return

        'EXTRACT THE SUBSCRIPT.
        MD2NUMBER = Mid$(MD2CMD, MD2OPENP + 1, (MD2CLOSEDP - MD2OPENP) - 1)

        'CHECK FOR VALID NUMBER.
        MD2SEQRUNVALID()
        If MD2NUMBER = "" Then Return

        'IF NOT AN INTEGER THEN ERROR.
        If Val(MD2NUMBER) <> Int(Val(MD2NUMBER)) Then Return

        'IF NOT 1-6 THEN ERROR.     - DONT CHECK THIS ANYMORE SO MULTI-DIGIT SUBSCRIPTS WILL PASS
        'If Val(MD2NUMBER) < 1 Or Val(MD2NUMBER) > 6 Then Return

        MD2SUBSCRIPT = MD2NUMBER

    End Sub
    Sub MD2SEQRUNVALID()

        'VALID NUMBER?----------------------------------------------
        'RETURN MD2NUMBER,  IF NOT VALID THEN MD2NUMBER=""

        If MD2NUMBER = "" Then Return
        For MD2VALIDCHAR = 1 To Len(MD2NUMBER)
            'GREATER THAN 57 ISN'T NUMBERS.
            If Asc(Mid$(MD2NUMBER, MD2VALIDCHAR, 1)) > 57 Then
                MD2NUMBER = ""
                Exit For
            End If
            'LESS THAN 45 ISN'T NUMBERS BUT LEAVES - AND .
            If Asc(Mid$(MD2NUMBER, MD2VALIDCHAR, 1)) < 45 Then
                MD2NUMBER = ""
                Exit For
            End If
            'IS IT A / ?
            If Asc(Mid$(MD2NUMBER, MD2VALIDCHAR, 1)) = 47 Then
                MD2NUMBER = ""
                Exit For
            End If
        Next MD2VALIDCHAR

    End Sub
    Sub MD2SEQPUSH(ByVal d As Integer)

        'PUSH AN INTEGER ONTO STACK.
        MD2SEQSTACK(MD2SEQSTACKPOINTER) = d

        'INCREMENT STACK.
        MD2SEQSTACKPOINTER += 1
        If MD2SEQSTACKPOINTER > 99 Then MD2SEQSTACKPOINTER = 0

    End Sub
    Function MD2SEQPOP() As Integer

        'DECREMENT STACK.
        MD2SEQSTACKPOINTER -= 1
        If MD2SEQSTACKPOINTER < 0 Then MD2SEQSTACKPOINTER = 99

        'POP AN INTEGER OFF STACK.
        MD2SEQPOP = MD2SEQSTACK(MD2SEQSTACKPOINTER)

    End Function
    Sub MD2SEQRUNDO()

        '-----------------------------------------------------------------------
        'CLEAN COMMAND, AND EXECUTE.

        Dim P As String

        'DEFAULT TO BAD PARAMETER.
        MD2STATUS = "B"

        'CHECK FOR EMPTY COMMAND.
        If MD2COMMAND = "" Then MD2STATUS = "O" : Return

        'REMOVE WHITE SPACES AND DOUBLE QUOTES.
        MD2CMD = ""
        For MD2PTR = 1 To Len(MD2COMMAND)

            'GET CURRENT CHARACTER AND CONVERT TO UPPER CASE.
            MD2CHAR = UCase$(Mid$(MD2COMMAND, MD2PTR, 1))

            'IGNORE CONTROL CHARS, QUOTES, GRAPHICS.
            If Asc(MD2CHAR) > 34 And Asc(MD2CHAR) < 128 Then
                MD2CMD = MD2CMD + MD2CHAR
            End If
            'But allow "!"
            If Asc(MD2CHAR) = 33 Then
                MD2CMD = MD2CMD + MD2CHAR
            End If


        Next MD2PTR

        'EXTRACT NUMBER AFTER = AND SUBSCRIPT IF AVAILABLE.
        MD2SEQRUNPARS()

        'SUBROUTINES ---------------------------------------------------

        If MD2CMD = "" Then MD2STATUS = "O" : Return
        If MD2CMD = "MD2MOVE" Then MD2MOVE() : Return
        If MD2CMD = "MD2HOME" Then MD2HOME() : Return
        If MD2CMD = "MD2ON" Then MD2ON() : Return
        If MD2CMD = "MD2OFF" Then MD2OFF() : Return
        If MD2CMD = "MD2SETUP" Then MD2SETUP() : Return
        If MD2CMD = "MD2PARLOAD" Then MD2PARLOAD() : Return
        If MD2CMD = "MD2PARSAVE" Then MD2PARSAVE() : Return
        If MD2CMD = "MD2OUTPUTS" Then MD2OUTPUTS() : Return
        If MD2CMD = "MD2CIRCLE" Then MD2CIRCLE() : Return
        If MD2CMD = "MD2GRID" Then MD2GRID() : Return
        If MD2CMD = "MD2STANDBYON" Then MD2STANDBYON() : Return
        If MD2CMD = "MD2STANDBYOFF" Then MD2STANDBYOFF() : Return

        'COMMANDS -------------------------------------------------------

        'END.
        If MD2CMD = "END" Then
            MD2POINTER = Len(MD2SEQUENCE)
            MD2STATUS = "O"
            Return
        End If

        'SENDC4 text to C4
        If Left$(MD2CMD, 8) = "SENDC412" Then
            P = Right$(MD2CMD, Len(MD2CMD) - 8)
            P = P.Trim(" ")  'Remove spaces front and back
            Try
                MD2C4COM12.Write(P & vbCr) 'Send command
                MD2C4COM12.ReadExisting()      'READ and discard anything.
            Catch ex As Exception
                MD2STATUS = "P"
                Return
            End Try
            MD2STATUS = "O"
            Return
        End If
        'SENDC4 text to C4
        If Left$(MD2CMD, 8) = "SENDC434" Then
            P = Right$(MD2CMD, Len(MD2CMD) - 8)
            P = P.Trim(" ")  'Remove spaces front and back
            Try
                MD2C4COM34.Write(P & vbCr) 'Send command
                MD2C4COM34.ReadExisting()      'READ and discard anything.
            Catch ex As Exception
                MD2STATUS = "P"
                Return
            End Try
            MD2STATUS = "O"
            Return
        End If
        'SENDC4 text to C4
        If Left$(MD2CMD, 8) = "SENDC456" Then
            P = Right$(MD2CMD, Len(MD2CMD) - 8)
            P = P.Trim(" ")  'Remove spaces front and back
            Try
                MD2C4COM56.Write(P & vbCr) 'Send command
                MD2C4COM56.ReadExisting()      'READ and discard anything.
            Catch ex As Exception
                MD2STATUS = "P"
                Return
            End Try
            MD2STATUS = "O"
            Return
        End If

        'GOTO.
        If Left$(MD2CMD, 4) = "GOTO" Then
            MD2POINTER = MD2SEQGETLOCATION(Val(Right$(MD2CMD, Len(MD2CMD) - 4)))
            MD2STATUS = "O" : Return
        End If

        'GOSUB.  PUSH POINTER ONTO STACK, GOTO
        If Left$(MD2CMD, 5) = "GOSUB" Then
            MD2SEQPUSH(MD2POINTER)
            MD2POINTER = MD2SEQGETLOCATION(Val(Right$(MD2CMD, Len(MD2CMD) - 5)))
            MD2STATUS = "O" : Return
        End If

        'RETURN.  POP POINTER OFF STACK, GOTO
        If Left$(MD2CMD, 6) = "RETURN" Then
            MD2POINTER = MD2SEQPOP()
            MD2STATUS = "O" : Return
        End If

        'LOOP.  IF DONE, CLEAR STACK & FALL THROUGH, ELSE DECREMENT COUNTER & JUMP BACK.
        If Left$(MD2CMD, 8) = "MD2LOOP1" Then
            If MD2LOOPCOUNT1 <= 1 Then
                MD2SEQSTACKPOINTER -= 1                 'DECREMENT STACK.
                If MD2SEQSTACKPOINTER < 0 Then MD2SEQSTACKPOINTER = 99
            Else
                MD2LOOPCOUNT1 -= 1                      'DECREMENT LOOP COUNTER.
                MD2POINTER = MD2SEQSTACK(MD2SEQSTACKPOINTER - 1)       'LOOP BACK.
            End If
            MD2STATUS = "O"
            Return
        End If
        If Left$(MD2CMD, 8) = "MD2LOOP2" Then
            If MD2LOOPCOUNT2 <= 1 Then
                MD2SEQSTACKPOINTER -= 1                 'DECREMENT STACK.
                If MD2SEQSTACKPOINTER < 0 Then MD2SEQSTACKPOINTER = 99
            Else
                MD2LOOPCOUNT2 -= 1                      'DECREMENT LOOP COUNTER.
                MD2POINTER = MD2SEQSTACK(MD2SEQSTACKPOINTER - 1)       'LOOP BACK.
            End If
            MD2STATUS = "O"
            Return
        End If
        If Left$(MD2CMD, 8) = "MD2LOOP3" Then
            If MD2LOOPCOUNT3 <= 1 Then
                MD2SEQSTACKPOINTER -= 1                 'DECREMENT STACK.
                If MD2SEQSTACKPOINTER < 0 Then MD2SEQSTACKPOINTER = 99
            Else
                MD2LOOPCOUNT3 -= 1                      'DECREMENT LOOP COUNTER.
                MD2POINTER = MD2SEQSTACK(MD2SEQSTACKPOINTER - 1)       'LOOP BACK.
            End If
            MD2STATUS = "O"
            Return
        End If
        If Left$(MD2CMD, 8) = "MD2LOOP4" Then
            If MD2LOOPCOUNT4 <= 1 Then
                MD2SEQSTACKPOINTER -= 1                 'DECREMENT STACK.
                If MD2SEQSTACKPOINTER < 0 Then MD2SEQSTACKPOINTER = 99
            Else
                MD2LOOPCOUNT4 -= 1                      'DECREMENT LOOP COUNTER.
                MD2POINTER = MD2SEQSTACK(MD2SEQSTACKPOINTER - 1)       'LOOP BACK.
            End If
            MD2STATUS = "O"
            Return
        End If
        If Left$(MD2CMD, 8) = "MD2LOOP5" Then
            If MD2LOOPCOUNT5 <= 1 Then
                MD2SEQSTACKPOINTER -= 1                 'DECREMENT STACK.
                If MD2SEQSTACKPOINTER < 0 Then MD2SEQSTACKPOINTER = 99
            Else
                MD2LOOPCOUNT5 -= 1                      'DECREMENT LOOP COUNTER.
                MD2POINTER = MD2SEQSTACK(MD2SEQSTACKPOINTER - 1)       'LOOP BACK.
            End If
            MD2STATUS = "O"
            Return
        End If
        If Left$(MD2CMD, 8) = "MD2LOOP6" Then
            If MD2LOOPCOUNT6 <= 1 Then
                MD2SEQSTACKPOINTER -= 1                 'DECREMENT STACK.
                If MD2SEQSTACKPOINTER < 0 Then MD2SEQSTACKPOINTER = 99
            Else
                MD2LOOPCOUNT6 -= 1                      'DECREMENT LOOP COUNTER.
                MD2POINTER = MD2SEQSTACK(MD2SEQSTACKPOINTER - 1)       'LOOP BACK.
            End If
            MD2STATUS = "O"
            Return
        End If
        If Left$(MD2CMD, 8) = "MD2LOOP7" Then
            If MD2LOOPCOUNT7 <= 1 Then
                MD2SEQSTACKPOINTER -= 1                 'DECREMENT STACK.
                If MD2SEQSTACKPOINTER < 0 Then MD2SEQSTACKPOINTER = 99
            Else
                MD2LOOPCOUNT7 -= 1                      'DECREMENT LOOP COUNTER.
                MD2POINTER = MD2SEQSTACK(MD2SEQSTACKPOINTER - 1)       'LOOP BACK.
            End If
            MD2STATUS = "O"
            Return
        End If
        If Left$(MD2CMD, 8) = "MD2LOOP8" Then
            If MD2LOOPCOUNT8 <= 1 Then
                MD2SEQSTACKPOINTER -= 1                 'DECREMENT STACK.
                If MD2SEQSTACKPOINTER < 0 Then MD2SEQSTACKPOINTER = 99
            Else
                MD2LOOPCOUNT8 -= 1                      'DECREMENT LOOP COUNTER.
                MD2POINTER = MD2SEQSTACK(MD2SEQSTACKPOINTER - 1)       'LOOP BACK.
            End If
            MD2STATUS = "O"
            Return
        End If
        If Left$(MD2CMD, 8) = "MD2LOOP9" Then
            If MD2LOOPCOUNT9 <= 1 Then
                MD2SEQSTACKPOINTER -= 1                 'DECREMENT STACK.
                If MD2SEQSTACKPOINTER < 0 Then MD2SEQSTACKPOINTER = 99
            Else
                MD2LOOPCOUNT9 -= 1                      'DECREMENT LOOP COUNTER.
                MD2POINTER = MD2SEQSTACK(MD2SEQSTACKPOINTER - 1)       'LOOP BACK.
            End If
            MD2STATUS = "O"
            Return
        End If

        'RESTART PROGRAM.
        If MD2CMD = "RESTART" Then
            MD2STATUS = "O"
            MD2POINTER = 1
            Return
        End If

        'WAIT FOR INPUT.
        If Left$(MD2CMD, 14) = "MD2WAIT4INPUT(" Then
            If MD2SUBSCRIPT = "" Then Return
            Do
                MD2INPUTS()
                If MD2INPUT(Val(MD2SUBSCRIPT)) = -1 Then Exit Do
            Loop
            MD2STATUS = "O" : Return
        End If

        'SLEEP.
        If Left$(MD2CMD, 5) = "SLEEP" Then
            If Val(Right$(MD2CMD, Len(MD2CMD) - 5)) = 0 Then
                'Wait for Keypress (Sleep 0).
                Do
                Loop Until GetAsyncKeyState(17)
                Do
                Loop While GetAsyncKeyState(17)
            Else
                'Wait second(s).
                MD2TIMETEMP = Microsoft.VisualBasic.DateAndTime.Timer
                Do
                Loop Until Microsoft.VisualBasic.DateAndTime.Timer > MD2TIMETEMP + Val(Right$(MD2CMD, Len(MD2CMD) - 5))
            End If
            MD2STATUS = "O" : Return
        End If

        'BEEP.
        If Left$(MD2CMD, 4) = "BEEP" Then
            Beep()
            MD2STATUS = "O" : Return
        End If

        'SET NON-ARRAY PARAMETERS ----------------------------------------

        'SET LOOP COUNT AND PUSH LOOP LOCATION
        If Left$(MD2CMD, 14) = "MD2LOOPCOUNT1=" Then
            If MD2VALUE = "" Then Return
            MD2LOOPCOUNT1 = Val(MD2VALUE)
            MD2SEQPUSH(MD2POINTER)
            MD2STATUS = "O"
            Return
        End If
        If Left$(MD2CMD, 14) = "MD2LOOPCOUNT2=" Then
            If MD2VALUE = "" Then Return
            MD2LOOPCOUNT2 = Val(MD2VALUE)
            MD2SEQPUSH(MD2POINTER)
            MD2STATUS = "O"
            Return
        End If
        If Left$(MD2CMD, 14) = "MD2LOOPCOUNT3=" Then
            If MD2VALUE = "" Then Return
            MD2LOOPCOUNT3 = Val(MD2VALUE)
            MD2SEQPUSH(MD2POINTER)
            MD2STATUS = "O"
            Return
        End If
        If Left$(MD2CMD, 14) = "MD2LOOPCOUNT4=" Then
            If MD2VALUE = "" Then Return
            MD2LOOPCOUNT4 = Val(MD2VALUE)
            MD2SEQPUSH(MD2POINTER)
            MD2STATUS = "O"
            Return
        End If
        If Left$(MD2CMD, 14) = "MD2LOOPCOUNT5=" Then
            If MD2VALUE = "" Then Return
            MD2LOOPCOUNT5 = Val(MD2VALUE)
            MD2SEQPUSH(MD2POINTER)
            MD2STATUS = "O"
            Return
        End If
        If Left$(MD2CMD, 14) = "MD2LOOPCOUNT6=" Then
            If MD2VALUE = "" Then Return
            MD2LOOPCOUNT6 = Val(MD2VALUE)
            MD2SEQPUSH(MD2POINTER)
            MD2STATUS = "O"
            Return
        End If
        If Left$(MD2CMD, 14) = "MD2LOOPCOUNT7=" Then
            If MD2VALUE = "" Then Return
            MD2LOOPCOUNT7 = Val(MD2VALUE)
            MD2SEQPUSH(MD2POINTER)
            MD2STATUS = "O"
            Return
        End If
        If Left$(MD2CMD, 14) = "MD2LOOPCOUNT8=" Then
            If MD2VALUE = "" Then Return
            MD2LOOPCOUNT8 = Val(MD2VALUE)
            MD2SEQPUSH(MD2POINTER)
            MD2STATUS = "O"
            Return
        End If
        If Left$(MD2CMD, 14) = "MD2LOOPCOUNT9=" Then
            If MD2VALUE = "" Then Return
            MD2LOOPCOUNT9 = Val(MD2VALUE)
            MD2SEQPUSH(MD2POINTER)
            MD2STATUS = "O"
            Return
        End If

        'MOTOR.
        If Left$(MD2CMD, 9) = "MD2MOTOR=" Then
            If MD2VALUE = "" Then Return
            MD2MOTOR = Val(MD2VALUE)
            MD2STATUS = "O"
            Return
        End If

        'INTERRUPTS.
        If Left$(MD2CMD, 14) = "MD2INTERRUPTS=" Then
            If MD2VALUE = "" Then Return
            MD2INTERRUPTS = Val(MD2VALUE)
            MD2STATUS = "O"
            Return
        End If

        'HOLD.
        If Left$(MD2CMD, 8) = "MD2HOLD=" Then
            If MD2VALUE = "" Then Return
            MD2HOLD = Val(MD2VALUE)
            MD2STATUS = "O"

            Try
                If MD2HOLD = 0 Then
                    'Don't hold motors
                    If MD2C4PORT12 <> "" Then
                        MD2C4COM12.Write("!1wk0,5" & vbCr)  'SEND COMMAND.
                        MD2C4COM12.ReadTo("a")              'WAIT FOR a
                    End If
                    If MD2C4PORT34 <> "" Then
                        MD2C4COM34.Write("!1wk0,5" & vbCr)  'SEND COMMAND.
                        MD2C4COM34.ReadTo("a")              'WAIT FOR a
                    End If
                    If MD2C4PORT56 <> "" Then
                        MD2C4COM56.Write("!1wk0,5" & vbCr)  'SEND COMMAND.
                        MD2C4COM56.ReadTo("a")              'WAIT FOR a
                    End If
                Else
                    'MD2HOLD = -1  hold motors
                    If MD2C4PORT12 <> "" Then
                        MD2C4COM12.Write("!1wk1,5" & vbCr)  'SEND COMMAND.
                        MD2C4COM12.ReadTo("a")              'WAIT FOR a
                    End If
                    If MD2C4PORT34 <> "" Then
                        MD2C4COM34.Write("!1wk1,5" & vbCr)  'SEND COMMAND.
                        MD2C4COM34.ReadTo("a")              'WAIT FOR a
                    End If
                    If MD2C4PORT56 <> "" Then
                        MD2C4COM56.Write("!1wk1,5" & vbCr)  'SEND COMMAND.
                        MD2C4COM56.ReadTo("a")              'WAIT FOR a
                    End If
                End If

            Catch
                'NO ERROR RESPONSE.
            End Try


            Return
        End If

        'MOVE TYPE.
        If Left$(MD2CMD, 12) = "MD2MOVETYPE=" Then
            MD2MOVETYPE = Right$(MD2CMD, Len(MD2CMD) - 12)
            MD2STATUS = "O"
            Return
        End If

        'STEP TYPE.
        If Left$(MD2CMD, 12) = "MD2STEPTYPE=" Then
            MD2STEPTYPE = Right$(MD2CMD, Len(MD2CMD) - 12)
            MD2STATUS = "O"
            Return
        End If

        'OUTPUT CODE.
        If Left$(MD2CMD, 14) = "MD2OUTPUTCODE=" Then
            If MD2VALUE = "" Then Return
            MD2OUTPUTCODE = Val(MD2VALUE)
            MD2STATUS = "O"
            Return
        End If

        'MD2PARFILE.
        If Left$(MD2CMD, 11) = "MD2PARFILE=" Then
            MD2PARFILE = Right$(MD2CMD, Len(MD2CMD) - 11)
            MD2STATUS = "O"
            Return
        End If

        'MD2CALFILE.
        If Left$(MD2CMD, 11) = "MD2CALFILE=" Then
            MD2CALFILE = Right$(MD2CMD, Len(MD2CMD) - 11)
            MD2STATUS = "O"
            Return
        End If

        'MD2CIRCLERADIUSX.
        If Left$(MD2CMD, 17) = "MD2CIRCLERADIUSX=" Then
            If MD2VALUE = "" Then Return
            MD2CIRCLERADIUSX = Val(MD2VALUE)
            MD2STATUS = "O"
            Return
        End If

        'MD2CIRCLERADIUSY.
        If Left$(MD2CMD, 17) = "MD2CIRCLERADIUSY=" Then
            If MD2VALUE = "" Then Return
            MD2CIRCLERADIUSY = Val(MD2VALUE)
            MD2STATUS = "O"
            Return
        End If

        'MD2CIRCLECENTERX.
        If Left$(MD2CMD, 17) = "MD2CIRCLECENTERX=" Then
            If MD2VALUE = "" Then Return
            MD2CIRCLECENTERX = Val(MD2VALUE)
            MD2STATUS = "O"
            Return
        End If

        'MD2CIRCLECENTERY.
        If Left$(MD2CMD, 17) = "MD2CIRCLECENTERY=" Then
            If MD2VALUE = "" Then Return
            MD2CIRCLECENTERY = Val(MD2VALUE)
            MD2STATUS = "O"
            Return
        End If

        'MD2CIRCLESTART.
        If Left$(MD2CMD, 15) = "MD2CIRCLESTART=" Then
            If MD2VALUE = "" Then Return
            MD2CIRCLESTART = Val(MD2VALUE)
            MD2STATUS = "O"
            Return
        End If

        'MD2CIRCLEARC.
        If Left$(MD2CMD, 13) = "MD2CIRCLEARC=" Then
            If MD2VALUE = "" Then Return
            MD2CIRCLEARC = Val(MD2VALUE)
            MD2STATUS = "O"
            Return
        End If

        'MD2CIRCLECHORD.
        If Left$(MD2CMD, 15) = "MD2CIRCLECHORD=" Then
            If MD2VALUE = "" Then Return
            MD2CIRCLECHORD = Val(MD2VALUE)
            MD2STATUS = "O"
            Return
        End If

        'MD2GRIDBEGINX.
        If Left$(MD2CMD, 14) = "MD2GRIDBEGINX=" Then
            If MD2VALUE = "" Then Return
            MD2GRIDBEGINX = Val(MD2VALUE)
            MD2STATUS = "O"
            Return
        End If

        'MD2GRIDBEGINY.
        If Left$(MD2CMD, 14) = "MD2GRIDBEGINY=" Then
            If MD2VALUE = "" Then Return
            MD2GRIDBEGINY = Val(MD2VALUE)
            MD2STATUS = "O"
            Return
        End If

        'MD2GRIDSPACEX.
        If Left$(MD2CMD, 14) = "MD2GRIDSPACEX=" Then
            If MD2VALUE = "" Then Return
            MD2GRIDSPACEX = Val(MD2VALUE)
            MD2STATUS = "O"
            Return
        End If

        'MD2GRIDSPACEY.
        If Left$(MD2CMD, 14) = "MD2GRIDSPACEY=" Then
            If MD2VALUE = "" Then Return
            MD2GRIDSPACEY = Val(MD2VALUE)
            MD2STATUS = "O"
            Return
        End If

        'MD2GRIDTARGETX.
        If Left$(MD2CMD, 15) = "MD2GRIDTARGETX=" Then
            If MD2VALUE = "" Then Return
            MD2GRIDTARGETX = Val(MD2VALUE)
            MD2STATUS = "O"
            Return
        End If

        'MD2GRIDTARGETY.
        If Left$(MD2CMD, 15) = "MD2GRIDTARGETY=" Then
            If MD2VALUE = "" Then Return
            MD2GRIDTARGETY = Val(MD2VALUE)
            MD2STATUS = "O"
            Return
        End If

        'SET ARRAY PARAMETERS -----------------------------------------------

        'BACKLASH.
        If Left$(MD2CMD, 12) = "MD2BACKLASH(" Then
            If MD2VALUE = "" Or MD2SUBSCRIPT = "" Then Return
            MD2BACKLASH(Val(MD2SUBSCRIPT)) = Val(MD2VALUE)
            MD2STATUS = "O"
            Return
        End If

        'HOMEDIR.
        If Left$(MD2CMD, 11) = "MD2HOMEDIR(" Then
            If MD2VALUE = "" Or MD2SUBSCRIPT = "" Then Return
            MD2HOMEDIR(Val(MD2SUBSCRIPT)) = Val(MD2VALUE)
            MD2STATUS = "O"
            Return
        End If

        'HOMEOFFSET.
        If Left$(MD2CMD, 14) = "MD2HOMEOFFSET(" Then
            If MD2VALUE = "" Or MD2SUBSCRIPT = "" Then Return
            MD2HOMEOFFSET(Val(MD2SUBSCRIPT)) = Val(MD2VALUE)
            MD2STATUS = "O"
            Return
        End If

        'LIMITF.
        If Left$(MD2CMD, 10) = "MD2LIMITF(" Then
            If MD2VALUE = "" Or MD2SUBSCRIPT = "" Then Return
            MD2LIMITF(Val(MD2SUBSCRIPT)) = Val(MD2VALUE)
            MD2STATUS = "O"
            Return
        End If

        'LIMITR.
        If Left$(MD2CMD, 10) = "MD2LIMITR(" Then
            If MD2VALUE = "" Or MD2SUBSCRIPT = "" Then Return
            MD2LIMITR(Val(MD2SUBSCRIPT)) = Val(MD2VALUE)
            MD2STATUS = "O"
            Return
        End If

        'MAXSPEED.
        If Left$(MD2CMD, 12) = "MD2MAXSPEED(" Then
            If MD2VALUE = "" Or MD2SUBSCRIPT = "" Then Return
            MD2MAXSPEED(Val(MD2SUBSCRIPT)) = Val(MD2VALUE)
            MD2SEQSETVEL(Val(MD2SUBSCRIPT))     'Set C4 velocity parameters.
            MD2STATUS = "O"
            Return
        End If

        'MINSPEED.
        If Left$(MD2CMD, 12) = "MD2MINSPEED(" Then
            If MD2VALUE = "" Or MD2SUBSCRIPT = "" Then Return
            MD2MINSPEED(Val(MD2SUBSCRIPT)) = Val(MD2VALUE)
            MD2SEQSETVEL(Val(MD2SUBSCRIPT))     'Set C4 velocity parameters.
            MD2STATUS = "O"
            Return
        End If

        'MOTORNAME.
        If Left$(MD2CMD, 13) = "MD2MOTORNAME(" Then
            If MD2SUBSCRIPT = "" Then Return
            MD2MOTORNAME(Val(MD2SUBSCRIPT)) = Right$(MD2CMD, Len(MD2CMD) - 16)
            MD2STATUS = "O" : Return
        End If

        'POSITION.
        If Left$(MD2CMD, 12) = "MD2POSITION(" Then
            If MD2VALUE = "" Or MD2SUBSCRIPT = "" Then Return
            MD2POSITION(Val(MD2SUBSCRIPT)) = Val(MD2VALUE)
            MD2STATUS = "O"
            Return
        End If

        'SLOPE.
        If Left$(MD2CMD, 9) = "MD2SLOPE(" Then
            If MD2VALUE = "" Or MD2SUBSCRIPT = "" Then Return
            MD2SLOPE(Val(MD2SUBSCRIPT)) = Val(MD2VALUE)
            MD2SEQSETVEL(Val(MD2SUBSCRIPT))     'Set C4 velocity parameters.
            MD2STATUS = "O"
            Return
        End If

        'TARGET.
        If Left$(MD2CMD, 10) = "MD2TARGET(" Then
            If MD2VALUE = "" Or MD2SUBSCRIPT = "" Then Return
            MD2TARGET(Val(MD2SUBSCRIPT)) = Val(MD2VALUE)
            MD2STATUS = "O"
            Return
        End If

        'UNITS.
        If Left$(MD2CMD, 9) = "MD2UNITS(" Then
            If MD2VALUE = "" Or MD2SUBSCRIPT = "" Then Return
            MD2UNITS(Val(MD2SUBSCRIPT)) = Int(Val(MD2VALUE))
            MD2STATUS = "O"
            Return
        End If

        'UNITNAME.
        If Left$(MD2CMD, 12) = "MD2UNITNAME(" Then
            If MD2SUBSCRIPT = "" Then Return
            MD2UNITNAME(Val(MD2SUBSCRIPT)) = Right$(MD2CMD, Len(MD2CMD) - 15)
            MD2STATUS = "O"
            Return
        End If

        'MUST BE A BAD COMMAND ---------------------------------------------

    End Sub

    Sub MD2SEQSETVEL(ByVal M As Integer)

        Dim Msg As String       'USED TO CONSTRUCT C4 COMMANDS.

        'Set C4 velocity parameters for motor M
        Msg = ""
        Try
            'Motor 1.
            If M = 1 And MD2C4PORT12 <> "" Then
                Msg = "!" & MD2C4ID12 & "wv"    'PREFIX, ID, COMMAND.
                If MD2C4CONNECTOR12 = "a" Then Msg += "1" Else Msg += "3" 'ADJUST FOR CONNECTORS.
                Msg += "," & MD2MINSPEED(M)    'MIN SPEED.
                Msg += "," & MD2MAXSPEED(M)    'MAX SPEED.
                Msg += "," & MD2SLOPE(M)       'SLOPE.
                Msg += vbCr
                MD2C4COM12.Write(Msg)           'SEND COMMAND.
                MD2C4COM12.ReadTo("a")          'WAIT FOR a
            End If

            'Motor 2.
            If M = 2 And MD2C4PORT12 <> "" Then
                Msg = "!" & MD2C4ID12 & "wv"    'PREFIX, ID, COMMAND.
                If MD2C4CONNECTOR12 = "a" Then Msg += "2" Else Msg += "4" 'ADJUST FOR CONNECTORS.
                Msg += "," & MD2MINSPEED(M)    'MIN SPEED.
                Msg += "," & MD2MAXSPEED(M)    'MAX SPEED.
                Msg += "," & MD2SLOPE(M)       'SLOPE.
                Msg += vbCr
                MD2C4COM12.Write(Msg)           'SEND COMMAND.
                MD2C4COM12.ReadTo("a")          'WAIT FOR a
            End If

            'Motor 3.
            If M = 3 And MD2C4PORT34 <> "" Then
                Msg = "!" & MD2C4ID34 & "wv"    'PREFIX, ID, COMMAND.
                If MD2C4CONNECTOR34 = "a" Then Msg += "1" Else Msg += "3" 'ADJUST FOR CONNECTORS.
                Msg += "," & MD2MINSPEED(M)    'MIN SPEED.
                Msg += "," & MD2MAXSPEED(M)    'MAX SPEED.
                Msg += "," & MD2SLOPE(M)       'SLOPE.
                Msg += vbCr
                MD2C4COM34.Write(Msg)           'SEND COMMAND.
                MD2C4COM34.ReadTo("a")          'WAIT FOR a
            End If

            'Motor 4.
            If M = 4 And MD2C4PORT34 <> "" Then
                Msg = "!" & MD2C4ID34 & "wv"    'PREFIX, ID, COMMAND.
                If MD2C4CONNECTOR34 = "a" Then Msg += "2" Else Msg += "4" 'ADJUST FOR CONNECTORS.
                Msg += "," & MD2MINSPEED(M)    'MIN SPEED.
                Msg += "," & MD2MAXSPEED(M)    'MAX SPEED.
                Msg += "," & MD2SLOPE(M)       'SLOPE.
                Msg += vbCr
                MD2C4COM34.Write(Msg)           'SEND COMMAND.
                MD2C4COM34.ReadTo("a")          'WAIT FOR a
            End If

            'Motor 5.
            If M = 5 And MD2C4PORT56 <> "" Then
                Msg = "!" & MD2C4ID56 & "wv"    'PREFIX, ID, COMMAND.
                If MD2C4CONNECTOR56 = "a" Then Msg += "1" Else Msg += "3" 'ADJUST FOR CONNECTORS.
                Msg += "," & MD2MINSPEED(M)    'MIN SPEED.
                Msg += "," & MD2MAXSPEED(M)    'MAX SPEED.
                Msg += "," & MD2SLOPE(M)       'SLOPE.
                Msg += vbCr
                MD2C4COM56.Write(Msg)           'SEND COMMAND.
                MD2C4COM56.ReadTo("a")          'WAIT FOR a
            End If

            'Motor 6.
            If M = 6 And MD2C4PORT56 <> "" Then
                Msg = "!" & MD2C4ID56 & "wv"    'PREFIX, ID, COMMAND.
                If MD2C4CONNECTOR56 = "a" Then Msg += "2" Else Msg += "4" 'ADJUST FOR CONNECTORS.
                Msg += "," & MD2MINSPEED(M)    'MIN SPEED.
                Msg += "," & MD2MAXSPEED(M)    'MAX SPEED.
                Msg += "," & MD2SLOPE(M)       'SLOPE.
                Msg += vbCr
                MD2C4COM56.Write(Msg)           'SEND COMMAND.
                MD2C4COM56.ReadTo("a")          'WAIT FOR a
            End If

        Catch
            'NO ERROR RESPONSE.
        End Try

    End Sub
End Module